/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.cre;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;

public class CRE14
extends RegraLinha {
    public static final String CONTADOR_CRE14 = "verificacao.CRE14.contador";
    public static final String CONTADOR_GERAL_CRE14 = "verificacao.CRE14.contadorGeral";

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        Integer contador = (Integer)contexto.getAtributo(CONTADOR_CRE14);
        Integer contadorGeral = (Integer)contexto.getAtributo(CONTADOR_GERAL_CRE14);
        if (contador == null) {
            contador = 0;
        }
        if (contadorGeral == null) {
            contadorGeral = 0;
        }
        if (evento.getTipoEvento() == 3) {
            String uf = (String)valoresCampos.getValorCampo("uf");
            contadorGeral = contadorGeral + 1;
            contexto.adicionaAtributo(CONTADOR_GERAL_CRE14, contadorGeral);
            if (uf == null || uf.equals("") || uf.length() != 2) {
                contador = contador + 1;
                contexto.adicionaAtributo(CONTADOR_CRE14, contador);
            }
        } else if (evento.getTipoEvento() == 1) {
            Double percentual;
            if (contador > 0 && (percentual = Double.valueOf((double)contador.intValue() * 100.0 / (double)contadorGeral.intValue())) > 0.0) {
                Object[] argumentos = new Object[]{percentual.intValue()};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
            }
            contexto.removeAtributo(CONTADOR_CRE14);
            contexto.removeAtributo(CONTADOR_GERAL_CRE14);
        }
    }
}

