/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.DadosArquivoFactory;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.verificacao.Regra;
import br.gov.rs.tce.pad.util.ResolveStringConstantes;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRegraCampo
implements Regra {
    private String _codigoMensagem;
    protected String[] _codigoMensagemArray;
    private String _substring;
    protected static final Log log = LogFactory.getLog(BaseRegraCampo.class);

    @Override
    public String getCodigoMensagem() {
        return this._codigoMensagem;
    }

    public String getCodigoMensagem(int index) {
        String ret = null;
        if (this._codigoMensagemArray != null) {
            ret = this._codigoMensagemArray[index - 1];
        }
        return ret;
    }

    public final void setCodigoMensagem(String codigoMensagem) {
        if (codigoMensagem == null || codigoMensagem.equals("")) {
            throw new IllegalArgumentException("C\u00f3digo da mensagem \u00e9 obrigat\u00f3rio");
        }
        this._codigoMensagem = codigoMensagem;
        this._codigoMensagemArray = codigoMensagem.split(",");
    }

    public String getSubstring() {
        return this._substring;
    }

    public void setSubstring(String substring) {
        this._substring = substring;
    }

    @Override
    public final void executaRegra(ImportacaoEvento evento) throws VerificacaoException {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        Campo campo = (Campo)contexto.removeAtributo("arquivo.definicao.campo");
        ValoresCampos valoresCampos = (ValoresCampos)contexto.getAtributo("verificacao.arquivo.linhaAtual.valores");
        Long linhaAtual = (Long)contexto.getAtributo("verificacao.arquivoAtual.linhaAtual");
        Integer colunaAtual = (Integer)contexto.getAtributo("verificacao.arquivoAtual.colunaAtual");
        this.executaLogicaVerificacaoCampo(valoresCampos, campo, evento.getSituacaoVerificacao(), evento.getMetadadosArquivoAtual(), linhaAtual, colunaAtual);
    }

    public abstract void executaLogicaVerificacaoCampo(ValoresCampos var1, Campo var2, SituacaoVerificacao var3, MetadadosArquivoContabil var4, Long var5, Integer var6) throws VerificacaoException;

    protected static final Object resolveValorAtributo(Remessa remessa, MetadadosArquivoContabil metaDados, String nomeAtributo, String nomeCampo, int tipoDadoCampoId, boolean inteiro, String formato, ValoresCampos valoresColunas) throws VerificacaoException {
        Object valorRetornado = ResolveStringConstantes.getValorString(nomeAtributo, remessa, metaDados.getCabecalho());
        if (valorRetornado == null) {
            if (valoresColunas.verificaNomeCampo(nomeAtributo)) {
                valorRetornado = valoresColunas.getValorCampo(nomeAtributo);
                if (valorRetornado == null) {
                    throw new VerificacaoException("10009", new Object[]{nomeAtributo});
                }
            } else {
                try {
                    valorRetornado = DadosArquivoFactory.criaValor(nomeAtributo, tipoDadoCampoId, formato, inteiro, false, false);
                }
                catch (FormatoInvalidoException e) {
                    throw new VerificacaoException("N\u00e3o foi possivel resolver o nome do atributo: " + nomeAtributo + " para o campo: " + nomeCampo, new Object[]{nomeAtributo});
                }
            }
        }
        return valorRetornado;
    }

    protected static final Object getValorCampo(ValoresCampos valoresCampo, Campo campo) {
        return valoresCampo.getValorCampo(campo.getNome());
    }

    protected void geraMensagemAssociadaRegra(SituacaoVerificacao situacaoVerificacao, String codigoMensagem, Arquivo arquivo, Long linhaAtual, Integer colunaAtual, Object[] argumentos) {
        MensagemFactory msgFactory = MensagemFactory.getInstancia();
        if (codigoMensagem == null) {
            codigoMensagem = "GEN_01";
            Campo c = arquivo.getFormato().getCampo(colunaAtual - 1);
            argumentos = new Object[]{linhaAtual, c.getLabelOuNome(), arquivo.getNome(), argumentos.length > 0 ? argumentos[1] : ""};
            System.out.println(">>> BaseRegraCampo: codigoMensagem is null: arquivo=" + arquivo + " ; colunaAtual=" + colunaAtual + " ; campo=" + c.getNome() + ";  ; linha=" + linhaAtual + " ; args=" + Arrays.asList(argumentos));
        }
        MensagemInstancia msg = msgFactory.constroiMensagem(codigoMensagem, colunaAtual, linhaAtual, arquivo, argumentos);
        if (!situacaoVerificacao.getRemessa().isRegraDesabilitada(codigoMensagem)) {
            situacaoVerificacao.adicionaMensagem(msg);
        } else {
            log.info((Object)("   [linha=" + linhaAtual + "] regra " + codigoMensagem + " ocorreu mas foi desabilitada por senha"));
        }
    }
}

