/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.relatorio;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.exportacao.ExportacaoDados;
import br.gov.rs.tce.pad.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.pad.modelo.test.ADFContextTestFixture;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ApplicationModule;
import org.junit.After;
import org.junit.Before;

public abstract class RelatorioAbstractTest {
    static final String padModeloSrcDir = "../PAD-Modelo/src/";
    static final String csvXslSrcDir = "../PAD-Modelo/xsl/";
    static final String remessaDir = "remessa/";
    static final String outputDir = "output/test/";
    ADFContextTestFixture fixture1 = new ADFContextTestFixture();
    File diretorioDestino;

    @Before
    public void setUp() throws Exception {
        this.diretorioDestino = new File(outputDir);
        this.diretorioDestino.mkdirs();
        this.fixture1.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fixture1.tearDown();
    }

    public static Remessa getRemessaDataControl(BindingContext binding) {
        return DatacontrolHelper.getRemessaDataControl(binding);
    }

    public void geraXML(String arquivoConsultasXml, String relatorioPdf, String relatorioXml, String relatorioXsl) throws IOException {
        boolean geraXML = true;
        DCDataControl dc = this.fixture1.getBindingContext().findDataControl("ServicoPADDataControl");
        ApplicationModule app = (ApplicationModule)dc.getDataProvider();
        TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(app);
        ChangeListener listenerGeracaoXML = null;
        ExportacaoDados exp = new ExportacaoDados(app, listenerGeracaoXML);
        ConsultasExtracaoList consultas = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File(arquivoConsultasXml), geraXML);
        RelatorioControle relatorio = new RelatorioControle();
        Remessa remessa = RelatorioAbstractTest.getRemessaDataControl(dc.getBindingContext());
        RemessaInfo ri = new RemessaInfo();
        remessa.setRemessaInfo(ri);
        ri.setCodBarrasRve("61301031265428127");
        ri.setCodBarrasDcBp("61308031265428127");
        ri.setCodBarrasDcBo("61309031265428127");
        this.geraRemessaInfo(remessa);
        relatorio.geraDadosXML(listenerGeracaoXML, this.diretorioDestino, relatorioPdf, relatorioXml, relatorioXsl, consultas, remessa, tpBanco, exp);
        System.out.println("xml: " + this.diretorioDestino.getAbsolutePath() + "/" + relatorioXml);
    }

    void geraRemessaInfo(Remessa rem) throws IOException {
        File fout = new File(remessaDir);
        RemessaControle rc = new RemessaControle(rem, fout);
        String remOut = fout.getAbsolutePath() + File.separator + "remessa_info.xml";
        rc.geraXml(rem.getRemessaInfo(), new FileWriter(remOut));
        System.out.println("remessa-info: " + remOut);
    }

    void geraPDF(String relatorioPdf, String relatorioXml, String relatorioXsl) {
        RelatorioAbstractTest.geraPDF(relatorioPdf, relatorioXml, relatorioXsl, this.diretorioDestino);
    }

    public static void geraPDF(String relatorioPdf, String relatorioXml, String relatorioXsl, File diretorioDestino) {
        ChangeListener listenerGeracaoXML = null;
        RelatorioControle relatorio = new RelatorioControle();
        relatorio.transformaPDF(listenerGeracaoXML, diretorioDestino, relatorioPdf, relatorioXml, relatorioXsl, null, null, null, null);
        System.out.println("geraPDF: arquivo saida: " + new File(diretorioDestino + File.separator + relatorioPdf).getAbsolutePath());
    }

    public static void runXslt(File fileIn, File xslFile, File outputFileName) throws FileNotFoundException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource xmlDoc = new StreamSource(fileIn);
        StreamSource xslDoc = new StreamSource(xslFile);
        System.out.println("TransFactory: " + tFactory + "\nxmlDoc: " + xmlDoc.getSystemId() + "\nxslDoc: " + xslDoc.getSystemId());
        FileOutputStream outFile = new FileOutputStream(outputFileName);
        Transformer trasform = tFactory.newTransformer(xslDoc);
        trasform.transform(xmlDoc, new StreamResult(outFile));
        System.out.println("runXslt: arquivo saida: " + outputFileName.getAbsolutePath());
    }
}

