/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.mensagem;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.Mensagens;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MensagemFactory {
    private Mensagens _mensagens = MensagemFactory.carregaMensagens();
    private NumberFormat nf = this.getNumberFormat();
    protected static MensagemFactory _instancia;
    protected static final Log log;
    static final boolean LOG_ERROR_ENABLED;

    private MensagemFactory() {
    }

    public static Mensagens carregaMensagens() {
        Mensagens mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
        return mensagens;
    }

    public static MensagemFactory getInstancia() {
        if (_instancia == null) {
            _instancia = new MensagemFactory();
        }
        return _instancia;
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Integer coluna, Long linha, Arquivo arquivo) {
        return this.constroiMensagem(codigoMensagem, coluna, linha, arquivo, null);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem) {
        return this.constroiMensagem(codigoMensagem, null, null);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Arquivo arquivo) {
        return this.constroiMensagem(codigoMensagem, arquivo, null);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Arquivo arquivo, Object[] argumentos) {
        return this.constroiMensagem(codigoMensagem, null, null, arquivo, argumentos);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Arquivo arquivo, Object[] argumentos, String tipoMensagem) {
        return this.constroiMensagem(codigoMensagem, null, null, arquivo, argumentos, tipoMensagem);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Integer coluna, Long linha, Arquivo arquivo, Object[] argumentos) {
        return this.constroiMensagem(codigoMensagem, coluna, linha, arquivo, argumentos, null);
    }

    public MensagemInstancia constroiMensagem(String codigoMensagem, Integer coluna, Long linha, Arquivo arquivo, Object[] argumentos, String tipoMensagem) {
        Long newLinha = linha == null ? 0L : linha;
        Integer newColuna = coluna == null ? 0 : coluna;
        Mensagem msg = this.getMensagemPorCodigo(codigoMensagem);
        MensagemInstancia msgInstancia = new MensagemInstancia();
        msgInstancia.setTexto(this.geraMensagem(msg.getTexto(), argumentos));
        msgInstancia.setCodigoMensagem(codigoMensagem);
        if (arquivo != null) {
            msgInstancia.setArquivo(arquivo.getNome());
            msgInstancia.setIdArquivo(arquivo.getIdentificador());
        }
        msgInstancia.setColuna(newColuna);
        msgInstancia.setLinha(newLinha);
        msgInstancia.setTipo(msg.getTipo());
        if (tipoMensagem != null) {
            msgInstancia.setTipo(tipoMensagem);
        }
        return msgInstancia;
    }

    private String geraMensagem(String patternMensagem, Object[] argumentos) {
        Object[] newArgumentos = null;
        newArgumentos = this.formataArgumentos(argumentos);
        return MessageFormat.format(patternMensagem, newArgumentos);
    }

    private Object[] formataArgumentos(Object[] argumentos) {
        Object[] newArgumentos = null;
        if (argumentos != null && argumentos.length > 0) {
            newArgumentos = new Object[argumentos.length];
            for (int index = 0; index < argumentos.length; ++index) {
                if (argumentos[index] instanceof Double) {
                    newArgumentos[index] = this.nf.format(argumentos[index]);
                    continue;
                }
                if (argumentos[index] instanceof BigDecimal) {
                    if (((BigDecimal)argumentos[index]).scale() > 0) {
                        newArgumentos[index] = this.nf.format(argumentos[index]);
                        continue;
                    }
                    newArgumentos[index] = String.valueOf(argumentos[index]);
                    continue;
                }
                newArgumentos[index] = argumentos[index] instanceof java.sql.Date || argumentos[index] instanceof Date ? new SimpleDateFormat("dd/MM/yyyy").format(argumentos[index]) : String.valueOf(argumentos[index]).trim();
            }
        }
        return newArgumentos;
    }

    private Mensagem getMensagemPorCodigo(String codigoMensagem) {
        return this._mensagens.getMensagemPorCodigo(codigoMensagem);
    }

    private NumberFormat getNumberFormat() {
        Locale localeBR = new Locale("pt", "BR");
        NumberFormat nf = DecimalFormat.getNumberInstance(localeBR);
        nf.setMinimumFractionDigits(2);
        return nf;
    }

    static {
        log = LogFactory.getLog(MensagemFactory.class);
        LOG_ERROR_ENABLED = log.isErrorEnabled();
    }
}

