/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.Referencia;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.BaseRepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDBImpl;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDerbyDBImpl;
import java.io.File;
import java.util.HashSet;
import junit.framework.TestCase;

public class BaseRepositorioArquivosControleTest
extends TestCase {
    RepositorioArquivosControleDBImpl reposCtlOracle;
    RepositorioArquivosControleDerbyDBImpl reposCtlDerby;

    public BaseRepositorioArquivosControleTest(String sTestName) {
        super(sTestName);
    }

    public void testcriaNomeFK() {
        HashSet<String> nomes = new HashSet<String>();
        Arquivos arquivosList = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", new File("src/arquivos.xml"));
        Arquivo[] arquivos = arquivosList.getTodosArquivos();
        for (int i = 0; i < arquivos.length; ++i) {
            Referencia[] refs = arquivos[i].getTabela().getReferencia();
            for (int n = 0; n < refs.length; ++n) {
                String tabelaOrigem = arquivos[i].getTabela().getNome();
                String tabelaDestino = refs[n].getTabelaDestino();
                String nomeFK = BaseRepositorioArquivosControle.criaNomeFK(tabelaOrigem, tabelaDestino);
                BaseRepositorioArquivosControleTest.assertTrue((String)("Tamanho m\u00e1ximo do nome da FK (" + nomeFK + ") \u00e9 18 letras devido a limitacao do Derby"), (nomeFK.length() <= 18 ? 1 : 0) != 0);
                BaseRepositorioArquivosControleTest.assertTrue((String)("O nome da FK (" + nomeFK + " - " + tabelaOrigem + ":" + tabelaDestino + ") foi gerado duplicado verifique a fun\u00e7\u00e3o"), (boolean)nomes.add(nomeFK));
            }
        }
    }

    public void testmontaSQLCriacaoChaveEstrangeiraSimples() {
        String nomeTabela = "EMPENHOS";
        Referencia ref = new Referencia();
        ref.setTabelaDestino("UNIDADES");
        ref.setColunasDestino("ID_UNIDADE");
        ref.setColunasOrigem("ID_UNIDADE");
        String comandoSQL = BaseRepositorioArquivosControle.montaSQLCriacaoChaveEstrangeira(nomeTabela, ref);
        BaseRepositorioArquivosControleTest.assertTrue((String)"Montagem de FK incorreta", (comandoSQL.startsWith("ALTER TABLE EMPENHOS") && comandoSQL.endsWith("FOREIGN KEY ( ID_UNIDADE ) REFERENCES UNIDADES( ID_UNIDADE )") ? 1 : 0) != 0);
    }

    public void testmontaSQLCriacaoChaveEstrangeiraComposta() {
        String nomeTabela = "PAGAMENTOS";
        Referencia ref = new Referencia();
        ref.setTabelaDestino("AUX_EMPENHOS");
        ref.setColunasDestino("NR_EMPENHO,ANO_EMPENHO");
        ref.setColunasOrigem("NR_EMPENHO,ANO_EMPENHO");
        String comandoSQL = BaseRepositorioArquivosControle.montaSQLCriacaoChaveEstrangeira(nomeTabela, ref);
        BaseRepositorioArquivosControleTest.assertTrue((String)"Montagem de FK incorreta", (comandoSQL.startsWith("ALTER TABLE PAGAMENTOS") && comandoSQL.endsWith("FOREIGN KEY ( NR_EMPENHO, ANO_EMPENHO ) REFERENCES AUX_EMPENHOS( NR_EMPENHO, ANO_EMPENHO )") ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        this.reposCtlOracle = new RepositorioArquivosControleDBImpl();
        this.reposCtlDerby = new RepositorioArquivosControleDerbyDBImpl();
    }

    protected void tearDown() throws Exception {
    }
}

