/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.BaseRepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.derby.catalog.TypeDescriptor;

public final class RepositorioArquivosControleDerbyDBImpl
extends BaseRepositorioArquivosControle
implements RepositorioArquivosControle {
    static final String CODIGO_ERRO_PK_DERBY = "23505";
    static final String CODIGO_ERRO_FK_DERBY = "X0Y45";
    static final String CODIGO_CHAVE_PRIMARIA_NAO_EXISTE = "42X86";
    private static final String SELECT_TABELA_EXISTE = "select char(tableid) id from sys.systables where tablename = ? and tabletype='T'";
    private static final String SELECT_CHAVES_ESTRANGEIRAS = "SELECT ta.tablename, ct.constraintname   FROM sys.sysconstraints ct, sys.SYSFOREIGNKEYS fo, SYS.SYSTABLES ta WHERE ta.tableid = ct.tableid and fo.constraintid = ct.constraintid     and fo.keyconstraintid = ( select c.constraintid \t\tfrom sys.sysconstraints c, \t\t          sys.systables t \t\twhere t.tableid = c.tableid AND t.tablename = ? AND c.type = 'P' )";
    static final String SELECT_CHAVES_ESTRANGEIRAS_TABELA = "select c.CONSTRAINTNAME from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid AND t.tablename = ? AND c.type = 'F'";
    private PreparedStatement _psBuscaFKs;
    ResultSetHandler _handlerBuscaFKs = new ResultSetHandler(){

        public Object handle(ResultSet rs) throws SQLException {
            LinkedList<String> lista = new LinkedList<String>();
            while (rs.next()) {
                lista.add(rs.getString(1) + ":" + rs.getString(2));
            }
            return lista;
        }
    };

    @Override
    public void criaTabelaAuxiliar(Arquivo arquivo) {
        try {
            String sql = this.montaSQLCriacaoTabelaAuxiliar(arquivo);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Criacao tabela auxiliar - " + arquivo.getTabela().getTabelaAuxiliar() + ": " + sql));
            }
            this.executaDDL(sql);
            this.carregaTabelaAuxiliar(arquivo);
            this.criaChavePrimaria(arquivo.getTabela().getTabelaAuxiliar(), arquivo.getTabela().getColunasTabelaAuxiliar(), null, false);
        }
        catch (SQLException ex) {
            throw new PersistenciaException(ex);
        }
    }

    private void carregaTabelaAuxiliar(Arquivo arquivo) throws SQLException {
        long iniTime = System.currentTimeMillis();
        String[] colunas = arquivo.getTabela().getColunasTabelaAuxiliar();
        Object[] colunasRetorno = new Object[arquivo.getTabela().getColunasTabelaAuxiliar().length];
        String sqlInsert = this.montaSQLCargaTabelaAuxiliar(arquivo.getTabela().getTabelaAuxiliar(), colunas);
        List valoresInsert = this.buscaValoresTabelaAuxiliar(arquivo.getTabela().getNome(), colunas);
        PreparedStatement pstmt = null;
        try {
            pstmt = this._conexao.prepareStatement(sqlInsert);
            long contadorInsert = 0L;
            for (Object[] valores : valoresInsert) {
                for (int i = 0; i < valores.length; ++i) {
                    pstmt.setObject(i + 1, valores[i]);
                }
                pstmt.execute();
                if (++contadorInsert < 500L) continue;
                this._conexao.commit();
                contadorInsert = 0L;
            }
        }
        catch (SQLException e) {
            if (this._conexao != null) {
                this._conexao.rollback();
            }
            throw new PersistenciaException(e);
        }
        finally {
            try {
                DbUtils.close((Statement)pstmt);
            }
            catch (SQLException e) {
                throw new PersistenciaException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tempo carga tabela auxiliar " + arquivo.getTabela().getTabelaAuxiliar() + " - " + (System.currentTimeMillis() - iniTime) + " ms."));
        }
    }

    private List buscaValoresTabelaAuxiliar(String tabela, final String[] colunas) {
        final LinkedList retorno = new LinkedList();
        StringBuffer sql = new StringBuffer(" SELECT DISTINCT ");
        for (int i = 0; i < colunas.length; ++i) {
            sql.append(colunas[i]);
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" FROM ").append(tabela);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL Query tabela auxiliar: " + sql.toString()));
        }
        try {
            ResultSetHandler handler = new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        Object[] valores = null;
                        valores = new Object[colunas.length];
                        for (int i = 0; i < colunas.length; ++i) {
                            valores[i] = rs.getObject(i + 1);
                        }
                        retorno.add(valores);
                    }
                    return null;
                }
            };
            this._queryRunner.query(this._conexao, sql.toString(), new Object[0], handler);
        }
        catch (SQLException e) {
            log.error((Object)"N\u00e3o foi possivel buscar os valores para inserir na tabela auxiliar.");
            throw new PersistenciaException(e);
        }
        return retorno;
    }

    private String montaSQLCargaTabelaAuxiliar(String tabela, String[] colunas) {
        int i;
        StringBuffer sql = new StringBuffer(" INSERT INTO ").append(tabela).append(" ( ");
        for (i = 0; i < colunas.length; ++i) {
            sql.append(colunas[i]);
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" ) VALUES (");
        for (i = 0; i < colunas.length; ++i) {
            sql.append(" ?");
            if (i + 1 >= colunas.length) continue;
            sql.append(",");
        }
        sql.append(" )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Carga tabela auxiliar: " + sql.toString()));
        }
        return sql.toString();
    }

    @Override
    protected String montaSQLCriacaoTabelaAuxiliar(Arquivo arquivo) {
        String[] colunas = arquivo.getTabela().getColunasTabelaAuxiliar();
        ArrayList<String> dataTypes = new ArrayList<String>(colunas.length);
        for (int i = 0; i < colunas.length; ++i) {
            dataTypes.add(this.recuperaDataTypeColuna(arquivo.getTabela().getNome(), colunas[i]));
        }
        return this.montaSQLCriacaoTabelaAuxiliar(arquivo, dataTypes);
    }

    private String recuperaDataTypeColuna(String nomeTabela, String nomeColuna) {
        String sqlDataTypes = "SELECT tc.COLUMNDATATYPE FROM SYS.SYSCOLUMNS tc, SYS.SYSTABLES ta WHERE ta.tableid = tc.referenceid AND ta.tablename = ? and tc.COLUMNNAME = ?";
        String dataType = null;
        try {
            dataType = (String)this._queryRunner.query(this._conexao, "SELECT tc.COLUMNDATATYPE FROM SYS.SYSCOLUMNS tc, SYS.SYSTABLES ta WHERE ta.tableid = tc.referenceid AND ta.tablename = ? and tc.COLUMNNAME = ?", new Object[]{nomeTabela, nomeColuna}, new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    String ret = null;
                    while (rs.next()) {
                        Object o = rs.getObject(1);
                        if (o instanceof TypeDescriptor) {
                            TypeDescriptor type = null;
                            type = (TypeDescriptor)o;
                            ret = type.getSQLstring() + " NOT NULL";
                            continue;
                        }
                        ret = o.toString();
                    }
                    return ret;
                }
            });
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
        return dataType;
    }

    private String montaSQLCriacaoTabelaAuxiliar(Arquivo arquivo, List dataTypes) {
        StringBuffer sql = new StringBuffer("CREATE TABLE ").append(arquivo.getTabela().getTabelaAuxiliar()).append(" ( ");
        String[] colunas = arquivo.getTabela().getColunasTabelaAuxiliar();
        for (int i = 0; i < colunas.length; ++i) {
            sql.append(colunas[i]);
            String dataType = (String)dataTypes.get(i);
            sql.append(" ");
            sql.append(dataType);
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" ) ");
        return sql.toString();
    }

    private int[] getDataTypesTabelaAux(Arquivo arquivo, String[] colunas) {
        Campo[] campo = arquivo.getFormato().getCampo();
        int[] retorno = new int[campo.length];
        for (int i = 0; i < colunas.length; ++i) {
            for (int j = 0; j < campo.length; ++j) {
                if (!colunas[i].equals(campo[j].getNome())) continue;
                retorno[i] = campo[i].getTipoDadoId();
            }
        }
        return retorno;
    }

    @Override
    public void limpaTabela(String nomeTabela) {
        long iniTime = System.currentTimeMillis();
        try {
            this._queryRunner.update(this._conexao, "TRUNCATE TABLE " + nomeTabela);
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tempo limpeza tabela: " + nomeTabela + " - " + (System.currentTimeMillis() - iniTime) + " ms."));
        }
    }

    @Override
    public void removeTabela(String nomeTabela) {
        try {
            String id = (String)this._queryRunner.query(this._conexao, SELECT_TABELA_EXISTE, new Object[]{nomeTabela.toUpperCase()}, (ResultSetHandler)new ScalarHandler());
            if (id != null) {
                this.removeChavePrimaria(nomeTabela);
                this.executaDDL(" DROP TABLE " + nomeTabela);
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
    }

    public static synchronized void removeChavesEstrangeirasDaTabela(Connection conexao, String nomeTabela) throws PersistenciaException {
        PreparedStatement psBuscaFKs = null;
        Statement stDropaFKs = null;
        ResultSet rsBuscaFKs = null;
        try {
            if (conexao == null || conexao.isClosed()) {
                throw new PersistenciaException(new Exception("A conexao nao pode ser nula ou estar fechada."));
            }
            psBuscaFKs = conexao.prepareStatement(SELECT_CHAVES_ESTRANGEIRAS_TABELA);
            psBuscaFKs.setString(1, nomeTabela);
            rsBuscaFKs = psBuscaFKs.executeQuery();
            stDropaFKs = conexao.createStatement();
            while (rsBuscaFKs.next()) {
                stDropaFKs.execute(RepositorioArquivosControleDerbyDBImpl.montaSQLRemoveChaveEstrangeira(nomeTabela, rsBuscaFKs.getString(1)));
            }
            conexao.commit();
            if (stDropaFKs != null) {
                stDropaFKs.close();
            }
            if (psBuscaFKs != null) {
                psBuscaFKs.close();
            }
        }
        catch (Exception e) {
            throw new PersistenciaException(e);
        }
    }

    public List buscaChavesEstrangeirasParaTabela(String nomeTabela) {
        List retorno = null;
        try {
            if (this._psBuscaFKs == null) {
                this._psBuscaFKs = this._conexao.prepareStatement(SELECT_CHAVES_ESTRANGEIRAS);
            }
            this._psBuscaFKs.setString(1, nomeTabela);
            ResultSet rs = this._psBuscaFKs.executeQuery();
            try {
                retorno = (List)this._handlerBuscaFKs.handle(rs);
            }
            catch (SQLException e) {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
        return retorno;
    }

    @Override
    protected void verificaExcecaoChavePrimaria(SQLException sqle, String nomeTabela) {
        String errorCode = sqle.getSQLState();
        if (!errorCode.equals(CODIGO_ERRO_PK_DERBY)) {
            throw new PersistenciaException("10013", new Object[]{nomeTabela}, sqle);
        }
    }

    @Override
    protected void verificaExcecaoChaveEstrangeira(SQLException sqle, String nomeTabelaOrigem, String nomeTabelaDestino) {
        String errorCode = sqle.getSQLState();
        if (!errorCode.equals(CODIGO_ERRO_FK_DERBY)) {
            throw new PersistenciaException("10014", new Object[]{nomeTabelaOrigem, nomeTabelaDestino}, sqle);
        }
    }

    @Override
    protected String montaSQLRemoveChavePrimaria(String nomeTabela) {
        String sql = null;
        sql = "ALTER TABLE " + nomeTabela + " DROP PRIMARY KEY";
        return sql;
    }

    @Override
    public void removeChavePrimaria(String nomeTabela) {
        block4: {
            try {
                List chaves = this.buscaChavesEstrangeirasParaTabela(nomeTabela);
                for (int i = 0; i < chaves.size(); ++i) {
                    String[] nomeTabelaConstraint = ((String)chaves.get(i)).split(":");
                    String sql = RepositorioArquivosControleDerbyDBImpl.montaSQLRemoveChaveEstrangeira(nomeTabelaConstraint[0], nomeTabelaConstraint[1]);
                    this.executaDDL(sql);
                }
                RepositorioArquivosControleDerbyDBImpl.removeChavesEstrangeirasDaTabela(this._conexao, nomeTabela);
                String sql = this.montaSQLRemoveChavePrimaria(nomeTabela);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removendo Chave Prim\u00e1ria da Tabela: " + nomeTabela));
                }
                this.executaDDL(sql);
            }
            catch (PersistenciaException e) {
                SQLException sqle = (SQLException)e.getCause();
                String erroCode = sqle.getSQLState();
                if (erroCode.equals(CODIGO_CHAVE_PRIMARIA_NAO_EXISTE)) break block4;
                throw e;
            }
        }
    }

    private static synchronized String montaSQLRemoveChaveEstrangeira(String tabelaOrigem, String nomeConstraint) {
        StringBuffer sql = new StringBuffer(30);
        sql.append("ALTER TABLE ").append(tabelaOrigem).append(" DROP CONSTRAINT ").append(nomeConstraint);
        return sql.toString();
    }

    @Override
    public void finalizaRespositorioControle() throws PersistenciaException {
        super.finalizaRespositorioControle();
        try {
            if (this._psBuscaFKs != null) {
                this._psBuscaFKs.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException("10029", new Object[]{e.getMessage()}, e);
        }
    }
}

