/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.excecao.CNPJInvalidoException;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DadosArquivoFactory {
    private static final String FORMATO_DATA = "ddMMyyyy";
    private static final String FORMATO_DECIMAL = "##,###,###,###.00";
    public static final String CNPJ_DATATYPE = "br.gov.rs.tce.pad.beans.types.CNPJ";
    static DecimalFormat FORMATO_DECIMAL_PADRAO = new DecimalFormat("##,###,###,###.00");
    static SimpleDateFormat FORMATO_DATA_PADRAO = new SimpleDateFormat("ddMMyyyy", new Locale("pt", "BR"));
    static Log log = LogFactory.getLog(DadosArquivoFactory.class);

    public static synchronized Object criaValor(String valor, int tipoDado) throws FormatoInvalidoException, CNPJInvalidoException {
        return DadosArquivoFactory.criaValor(valor, tipoDado, null);
    }

    public static synchronized Object criaValor(String valor, Campo campo) throws FormatoInvalidoException, CNPJInvalidoException {
        return DadosArquivoFactory.criaValor(valor, campo.getTipoDadoId(), campo.getMascara(), campo.isInteiro(), campo.isDataLaniente(), campo.isAceitaDataVazia());
    }

    public static synchronized Object criaValor(String valor, int tipoDado, String formato) throws FormatoInvalidoException, CNPJInvalidoException {
        return DadosArquivoFactory.criaValor(valor, tipoDado, formato, false, false, false);
    }

    public static synchronized Object criaValor(String valor, int tipoDado, String formato, boolean inteiro, boolean dataLaniente, boolean aceitaDataVazia) throws FormatoInvalidoException, CNPJInvalidoException {
        Object valorRetorno = null;
        try {
            switch (tipoDado) {
                case 1: {
                    if (valor != null) {
                        if (valor.length() > 1) {
                            valorRetorno = valor.trim();
                            break;
                        }
                        valorRetorno = valor;
                    }
                    break;
                }
                case 3: {
                    valorRetorno = DadosArquivoFactory.validaInteger(valor);
                    break;
                }
                case 2: {
                    valorRetorno = DadosArquivoFactory.validaBigDecimal(valor, inteiro);
                    break;
                }
                case 5: {
                    valorRetorno = DadosArquivoFactory.validaData(valor, formato, dataLaniente, aceitaDataVazia);
                    break;
                }
                case 4: {
                    valorRetorno = DadosArquivoFactory.validaLong(valor);
                    break;
                }
                case 6: {
                    valorRetorno = DadosArquivoFactory.validaCnpj(valor);
                    break;
                }
                default: {
                    throw new FormatoInvalidoException((Object)valor, tipoDado, new Object[]{valor, Campo.getTipoDado(tipoDado)});
                }
            }
        }
        catch (ParseException e) {
            throw new FormatoInvalidoException((Object)valor, tipoDado, new Object[]{valor, Campo.getTipoDado(tipoDado)}, e);
        }
        catch (NumberFormatException e) {
            throw new FormatoInvalidoException((Object)valor, tipoDado, new Object[]{valor, Campo.getTipoDado(tipoDado)}, e);
        }
        catch (CNPJInvalidoException e) {
            throw new CNPJInvalidoException((Object)valor, new Object[]{valor, Campo.getTipoDado(tipoDado)}, (Exception)((Object)e));
        }
        if (!(valorRetorno != null || tipoDado == 5 && aceitaDataVazia)) {
            throw new FormatoInvalidoException((Object)valor, tipoDado, new Object[]{valor, Campo.getTipoDado(tipoDado)});
        }
        return valorRetorno;
    }

    private static Double validaDouble(String valor, String formato) throws ParseException {
        Number numero;
        int tamanhoValor;
        DecimalFormat formatoDecimal = null;
        StringBuffer novoValor = new StringBuffer(valor);
        if (novoValor.charAt(0) == '+') {
            novoValor.deleteCharAt(0);
        }
        if ((tamanhoValor = novoValor.length()) >= 3) {
            novoValor.insert(tamanhoValor - 2, ".");
        }
        Double valorRetornado = null;
        valorRetornado = formato != null ? ((numero = (formatoDecimal = new DecimalFormat(formato)).parse(novoValor.toString())) instanceof Long ? new Double(numero.doubleValue()) : (Double)numero) : new Double(novoValor.toString());
        return valorRetornado;
    }

    private static java.sql.Date validaData(String valor, String formato, boolean dataLaniente, boolean aceitaDataVazia) throws ParseException {
        SimpleDateFormat formatoData = null;
        Date valorFormatado = null;
        if (formato != null) {
            formatoData = new SimpleDateFormat(formato);
        } else {
            valorFormatado = DadosArquivoFactory.realizaParseData(valor, dataLaniente, aceitaDataVazia);
        }
        return valorFormatado != null ? DadosArquivoFactory.criaSqlData(valorFormatado.getTime()) : null;
    }

    private static java.sql.Date criaSqlData(long time) {
        return new java.sql.Date(time);
    }

    private static Date realizaParseData(String valor, boolean dataLaniente, boolean aceitaDataVazia) throws ParseException {
        SimpleDateFormat formatoData = null;
        Date valorFormatado = null;
        formatoData = FORMATO_DATA_PADRAO;
        formatoData.setLenient(dataLaniente);
        try {
            valorFormatado = formatoData.parse(valor);
        }
        catch (ParseException pe) {
            try {
                if (!aceitaDataVazia || Integer.parseInt(valor) != 0) {
                    throw pe;
                }
            }
            catch (NumberFormatException nfe) {
                throw pe;
            }
        }
        return valorFormatado;
    }

    public static void main(String[] args) {
        try {
            Date data = DadosArquivoFactory.realizaParseData("00000000", false, true);
            System.out.println("data == " + data);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static Integer validaInteger(String valor) throws NumberFormatException {
        Integer valorFormatado = null;
        valorFormatado = Integer.parseInt(valor);
        return valorFormatado;
    }

    private static Long validaLong(String valor) throws FormatoInvalidoException {
        Long valorFormatado = null;
        valorFormatado = new Long(valor);
        return valorFormatado;
    }

    private static String validaCnpj(String valor) throws FormatoInvalidoException, CNPJInvalidoException {
        if (!ValidaCNPJ.validaCnpj(valor)) {
            throw new CNPJInvalidoException((Object)valor, new Object[]{valor});
        }
        return valor;
    }

    private static BigDecimal validaBigDecimal(String valor, boolean inteiro) {
        StringBuffer novoValor = new StringBuffer(valor);
        BigDecimal bigDecimal = null;
        if (!inteiro) {
            int tamanhoValor = novoValor.length();
            if (tamanhoValor >= 3) {
                novoValor.insert(tamanhoValor - 2, ".");
            }
            bigDecimal = new BigDecimal(novoValor.toString()).setScale(2, 6);
        } else {
            bigDecimal = new BigDecimal(novoValor.toString()).setScale(0, 6);
        }
        return bigDecimal;
    }
}

