/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.exportacao;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaExtracao;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.ValidacaoConsulta;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.excecao.ValidacaoException;
import br.gov.rs.tce.pad.util.IndicadorProgresso;
import com.sun.java.util.collections.HashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import oracle.xml.parser.v2.XMLNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExportacaoDados
implements IndicadorProgresso {
    private ApplicationModule _applicationModule;
    private static HashMap mapDefs = new HashMap(0);
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private static final Log log = LogFactory.getLog(ExportacaoDados.class);
    private int _eventHandler;
    private ChangeListener _changeListener;
    private String _situacao;
    private int _progresso;

    public ExportacaoDados(ApplicationModule appModule, ChangeListener listener) {
        this(appModule);
        this._changeListener = listener;
    }

    public ExportacaoDados(ApplicationModule appModule) {
        try {
            this._applicationModule = appModule;
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "oracle.xml.jaxp.JXDocumentBuilderFactory");
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void montaXMLsaida(ConsultasExtracaoList consultas, File arquivo, Remessa remessa, TipoBancoDados tpBanco) {
        this.montaXMLsaida(consultas, arquivo, remessa, tpBanco, false);
    }

    public void montaXMLsaida(ConsultasExtracaoList consultas, File arquivo, Remessa remessa, TipoBancoDados tpBanco, boolean isUTF8) {
        String formatEncoding = "";
        if (consultas == null) {
            throw new IllegalArgumentException("ConsultasExtracaoList n\u00e3o pode ser nulo");
        }
        if (arquivo == null) {
            throw new IllegalArgumentException("O arquivo de destino n\u00e3o pode ser nulo");
        }
        if (tpBanco == null) {
            throw new IllegalArgumentException("O tipo de banco de dados n\u00e3o pode ser nulo");
        }
        formatEncoding = isUTF8 || "remessa.xml".equals(arquivo.getName().toLowerCase()) ? "UTF-8" : "ISO-8859-1";
        BufferedWriter bw = null;
        try {
            this.setSituacao("Preparando para extra\u00e7\u00e3o de informa\u00e7\u00f5es do banco de dados...");
            if (!arquivo.getParentFile().exists()) {
                arquivo.getParentFile().mkdir();
            }
            Document documentoXML = this.builder.newDocument();
            String nomeElementoPai = consultas.getElementoPai();
            Element root = documentoXML.createElement(consultas.getElementoPai());
            List<ConsultaExtracao> listaConsultas = consultas.getConsultasExtracao();
            this.setProgresso(0);
            int qtdElementos = 0;
            for (int i = 0; i < listaConsultas.size(); ++i) {
                ConsultaExtracao consExtracao = listaConsultas.get(i);
                qtdElementos += this.contaElementosAninhados(consExtracao, 0);
                System.gc();
            }
            System.gc();
            int idxAtual = 0;
            for (int i = 0; i < listaConsultas.size(); ++i) {
                ConsultaExtracao consExtracao = listaConsultas.get(i);
                idxAtual += this.montaElementos(consExtracao, documentoXML, root, remessa, tpBanco, idxAtual, qtdElementos);
            }
            System.gc();
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo), formatEncoding));
            bw.write("<?xml version=\"1.0\" encoding=\"" + formatEncoding + "\"?>\n");
            this.setSituacao("Salvando informa\u00e7\u00f5es extra\u00eddas...");
            ((XMLNode)root).print((Writer)bw);
        }
        catch (IOException ioe) {
            throw new PersistenciaException("10033", new Object[]{ioe.getMessage()}, ioe);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
        System.gc();
    }

    protected int montaElementos(ConsultaExtracao consulta, Document documento, Element elementoPai, Remessa remessa, TipoBancoDados tpBanco, int idxAtual, int qtdElementos) throws ValidacaoException, PersistenciaException {
        if (consulta == null) {
            throw new IllegalArgumentException("Consulta n\u00e3o pode ser nulo");
        }
        log.debug((Object)("- consulta '" + consulta.getElemento() + "'"));
        List aninhadas = consulta.getConsultas();
        int qtdAninhadas = aninhadas.size();
        ConsultaSQL consultaSQL = null;
        String nomeElemento = consulta.getElemento();
        if (nomeElemento == null || nomeElemento.length() == 0) {
            throw new IllegalArgumentException("O nome de um elemento n\u00e3o pode ser vazio.");
        }
        try {
            consultaSQL = consulta.recuperaConsultaSQL(remessa, tpBanco);
        }
        catch (IllegalArgumentException e) {
            if (qtdAninhadas == 0) {
                throw e;
            }
        }
        catch (ConfiguracaoException x) {
            log.debug((Object)("  - ConfiguracaoException[" + consulta.getElemento() + "]: " + x.getMessage()));
        }
        catch (Exception x) {
            log.debug((Object)("Erro[" + consulta.getElemento() + "]: " + x.getMessage()), (Throwable)x);
        }
        if (consultaSQL != null) {
            Node nodoDados;
            if (consulta.getClasseValidacao() != null) {
                this.executarValidacaoConsulta(consulta.getClasseValidacao(), consultaSQL);
            }
            if ((nodoDados = this.extraiDadosViaSQL(nomeElemento, consultaSQL)) != null) {
                Node nodoImportado = documento.importNode(nodoDados, true);
                elementoPai.appendChild(nodoImportado);
            }
        } else {
            Element elemento = documento.createElement(nomeElemento);
            elementoPai.appendChild(elemento);
            elementoPai = elemento;
        }
        for (int i = 0; i < qtdAninhadas; ++i) {
            ConsultaExtracao inner = (ConsultaExtracao)aninhadas.get(i);
            idxAtual += this.montaElementos(inner, documento, elementoPai, remessa, tpBanco, idxAtual, qtdElementos);
        }
        if (consulta.hasSqlQuery()) {
            idxAtual = 1;
            double d = (double)idxAtual * 1.0 / (double)qtdElementos * 100.0;
            this.setProgresso((int)Math.round(d));
        }
        return idxAtual;
    }

    protected Node extraiDadosViaSQL(String nomeElemento, ConsultaSQL consultaSql) {
        ViewObject vo = null;
        Node dados = null;
        try {
            vo = this._applicationModule.createViewObjectFromQueryStmt(nomeElemento, consultaSql.getSql());
            Object[] parametros = consultaSql.getValoresParametros();
            for (int i = 0; i < parametros.length; ++i) {
                vo.setWhereClauseParam(i, parametros[i]);
            }
            vo.executeQuery();
            dados = vo.writeXML(0L, mapDefs);
            vo.closeRowSet();
        }
        catch (JboException jboe) {
            log.debug((Object)("Elemento: " + nomeElemento + " - " + jboe.getMessage()));
            throw new ImportacaoException("10033", new Object[]{nomeElemento}, (Exception)((Object)jboe));
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return dados;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangeStateEvent();
    }

    @Override
    public String getSituacao() {
        return this._situacao;
    }

    public void fireChangeStateEvent() {
        if (this._changeListener != null) {
            ChangeEvent change = new ChangeEvent(this);
            this._changeListener.stateChanged(change);
        }
    }

    private void setProgresso(int progresso) {
        this._progresso = progresso;
        this.fireChangeStateEvent();
    }

    @Override
    public int getProgresso() {
        return this._progresso;
    }

    public int contaElementosAninhados(ConsultaExtracao consulta, int count) {
        List aninhadas = consulta.getConsultas();
        if (aninhadas != null) {
            for (int i = 0; i < aninhadas.size(); ++i) {
                ConsultaExtracao inner = (ConsultaExtracao)aninhadas.get(i);
                if (inner.hasSqlQuery()) {
                    ++count;
                    continue;
                }
                count = count + this.contaElementosAninhados(inner, count++);
            }
        }
        return count;
    }

    public void executarValidacaoConsulta(String validacaoClazz, ConsultaSQL consultaSQL) {
        try {
            MensagemInstancia msg;
            Class<?> regraClazz = Class.forName(validacaoClazz);
            ValidacaoConsulta validacaoExecutar = (ValidacaoConsulta)regraClazz.newInstance();
            validacaoExecutar.setApplicationModule(this._applicationModule);
            validacaoExecutar.setConsultaSQL(consultaSQL);
            boolean isValida = validacaoExecutar.validaConsulta();
            if (!isValida && Mensagem.ehMensagemErro((msg = validacaoExecutar.getMensagem()).getTipo())) {
                throw new ValidacaoException(msg.getTexto(), "10033");
            }
        }
        catch (Exception e) {
            throw new PersistenciaException("10033", new Object[]{"Erro ao executar Valida\u00e7\u00e3o de Consulta com a classe " + validacaoClazz + "."}, e);
        }
    }
}

