/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.ajuda;

import br.gov.rs.tce.pad.excecao.PadAjudaException;
import java.awt.Dimension;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PadAjudaHelperDesktop {
    private static final String helpSetName = "PAD.hs";
    private Log log = LogFactory.getLog(PadAjudaHelperDesktop.class);
    private static PadAjudaHelperDesktop _instance;
    private HelpSet helpSet = null;
    private HelpBroker helpBroker = null;

    private PadAjudaHelperDesktop() {
    }

    public static PadAjudaHelperDesktop getInstance() {
        if (_instance == null) {
            _instance = new PadAjudaHelperDesktop();
        }
        return _instance;
    }

    public boolean exibeAjuda(String codigoTela) throws PadAjudaException {
        String codigoReal;
        boolean exibeOK = false;
        if (this.helpSet == null) {
            this.createHelpSet();
            this.helpBroker = this.helpSet.createHelpBroker();
            this.helpBroker.setSize(new Dimension(980, 600));
        }
        if ((codigoReal = this.getRealCodigo(codigoTela)) == null) {
            throw new PadAjudaException("O Id passado para o help \u00e9 inv\u00e1lido ou inexistente!");
        }
        try {
            this.helpBroker.setCurrentID("html." + codigoReal);
            this.helpBroker.setDisplayed(true);
            exibeOK = true;
        }
        catch (Exception ex) {
            throw new PadAjudaException("Ocorreu um erro ao exibir o Help c\u00f3digo: " + codigoReal, ex);
        }
        return exibeOK;
    }

    private String getRealCodigo(String codigo) {
        URL urlArquivo = this.getClass().getResource("/html/" + codigo + ".html");
        String codigoRetorno = null;
        if (urlArquivo != null) {
            codigoRetorno = codigo;
        } else {
            codigo = codigo.substring(0, 5);
            urlArquivo = this.getClass().getResource("/html/" + codigo + ".html");
            if (urlArquivo != null) {
                codigoRetorno = codigo;
            }
        }
        return codigoRetorno;
    }

    private void createHelpSet() throws PadAjudaException {
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)loader, (String)helpSetName);
        if (url == null) {
            throw new PadAjudaException("O sistema n\u00e3o encontrou o arquivo de configura\u00e7\u00e3o do Help");
        }
        try {
            this.helpSet = new HelpSet(loader, url);
        }
        catch (HelpSetException hSE) {
            throw new PadAjudaException(hSE.getMessage(), (Exception)((Object)hSE));
        }
    }
}

