/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.DetalheTotal;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.QuadroAbstrato;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.QuadroTotal;
import br.gov.rs.tce.pad.beans.Quadros;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloEvent;
import br.gov.rs.tce.pad.modelo.action.ActionModeloListener;
import br.gov.rs.tce.pad.modelo.action.PadAbstractModeloAction;
import br.gov.rs.tce.pad.modelo.action.quadros.ActionCarregaDadosQuadro;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import java.util.HashSet;
import oracle.adf.model.BindingContext;
import oracle.jbo.JboException;
import oracle.jbo.ViewObject;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionModeloQuadros
extends PadAbstractModeloAction {
    private static final String SET_NOMES_VIEW_OBJECT_TELAS = "pad.nomesVO.telaQuadros";
    public static final String CONTAS_REMESSA_VIEW_DEF = "br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaView";
    public static final String PARAM_VO_QUADRO_DEF_NAME = "viewobject-def-name-quadro";
    public static final String PARAM_VO_QUADRO_NAME = "viewobject-name-quadro";
    public static final int ID_QTD_CONTAS_INSERCAO = 16;
    public static final int ID_NECESSIDADE_INSERCAO = 17;
    private static Log log = LogFactory.getLog(ActionModeloQuadros.class);
    private static final String CLAUSULA_ORDER_BY = "CLAUSULA_ORDER_BY";

    @Override
    public void limpaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
    }

    @Override
    public void preparaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
        int i;
        ContasModule contasMod = DatacontrolHelper.getContasModuleAppModule(binding);
        Quadros quadros = proxTela.getQuadros();
        QuadroAbstrato[] quadrosAbstratos = quadros.getQuadro();
        Remessa remessa = this.getRemessa(binding);
        TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(contasMod);
        String codigoTela = proxTela.getCodigo();
        IdentificadorConta identificadorConta = proxTela.getIdentificadorConta();
        contasMod.getTransaction().commit();
        log.info((Object)(">> preparaModelo: codigoTela = " + codigoTela));
        for (i = 0; i < quadrosAbstratos.length; ++i) {
            if (!(quadrosAbstratos[i] instanceof QuadroContas)) continue;
            QuadroContas quadro = (QuadroContas)quadrosAbstratos[i];
            QuadroContas qSuperior = quadro.getQuadroContasSuperior();
            if (qSuperior != null) {
                qSuperior.setNome(quadro.getNome() + "Superior");
                qSuperior.setColunasQuadro(quadro.getColunasQuadro());
                this.preparaDadosQuadro(codigoTela, remessa, tpBanco, qSuperior, identificadorConta, binding, contasMod);
            }
            this.preparaDadosQuadro(codigoTela, remessa, tpBanco, quadro, identificadorConta, binding, contasMod);
            QuadroTotal qTotal = quadro.getQuadroTotal();
            this.preparaDadosQuadroTotal(codigoTela, remessa, tpBanco, qTotal, binding, contasMod);
        }
        for (i = 0; i < quadrosAbstratos.length; ++i) {
            if (!(quadrosAbstratos[i] instanceof QuadroTotal)) continue;
            QuadroTotal qTotal = (QuadroTotal)quadrosAbstratos[i];
            this.preparaDadosQuadroTotal(codigoTela, remessa, tpBanco, qTotal, binding, contasMod);
        }
    }

    private void preparaDadosQuadroTotal(String codigoTela, Remessa remessa, TipoBancoDados tpBanco, QuadroTotal quadroTotal, BindingContext binding, ContasModule contasMod) {
        if (quadroTotal != null) {
            String nomeVO = this.criaNomeViewObject(codigoTela, quadroTotal, binding);
            quadroTotal.setNomeViewObject(nomeVO);
            ActionModeloQuadros.criaViewObjectContasRemessaTotal(contasMod, nomeVO, remessa, tpBanco, quadroTotal.recuperaSQLTotal(remessa, tpBanco));
            DetalheTotal detalhe = quadroTotal.getDetalheTotal();
            if (detalhe != null) {
                nomeVO = this.criaNomeViewObject(codigoTela, detalhe, binding);
                detalhe.setNomeViewObject(nomeVO);
                ActionModeloQuadros.criaViewObjectContasRemessaTotal(contasMod, nomeVO, remessa, tpBanco, detalhe.recuperaSQLDetalheTotal(remessa, tpBanco));
            }
        }
    }

    private void preparaDadosQuadro(String codigoTela, Remessa remessa, TipoBancoDados tpBanco, QuadroContas quadro, IdentificadorConta identificadorConta, BindingContext binding, ContasModule contasModule) {
        if (quadro != null) {
            String defVOQuadro = CONTAS_REMESSA_VIEW_DEF;
            Parametro paramDefVOquadro = quadro.getParametroPorNome(PARAM_VO_QUADRO_DEF_NAME);
            if (paramDefVOquadro != null) {
                defVOQuadro = paramDefVOquadro.getValor();
            }
            String nomeVO = null;
            Parametro paramNameVOquadro = quadro.getParametroPorNome(PARAM_VO_QUADRO_NAME);
            if (paramNameVOquadro != null) {
                nomeVO = paramNameVOquadro.getValor();
            }
            if (nomeVO == null) {
                nomeVO = this.criaNomeViewObject(codigoTela, quadro, binding);
            } else {
                this.verificaExistenciaNomeVO(nomeVO, codigoTela, quadro, binding);
            }
            ViewObject voQuadro = this.criaViewObjectContasRemessa(contasModule, nomeVO, defVOQuadro, quadro.getTipoConta(), remessa);
            quadro.setNomeViewObject(nomeVO);
            this.carregaDadosQuadro(codigoTela, remessa, tpBanco, quadro, identificadorConta, binding, contasModule);
        }
    }

    private void carregaDadosQuadro(String codigoTela, Remessa remessa, TipoBancoDados tpBanco, QuadroContas quadro, IdentificadorConta identificadorConta, BindingContext binding, ContasModule contasModule) {
        Class classeCarregaQuadro = ActionCarregaDadosQuadro.class;
        Parametro paramClasse = quadro.getParametroPorNome("classe-carga-quadro");
        if (paramClasse != null) {
            String nomeClasseQuadro = paramClasse.getValor();
            try {
                classeCarregaQuadro = Class.forName(nomeClasseQuadro);
            }
            catch (ClassNotFoundException e) {
                throw new ConfiguracaoException("Classe de carga do Quadro " + quadro.getNome() + " na tela " + codigoTela + " n\u00e3o foi encontrada: " + nomeClasseQuadro);
            }
        }
        ActionCarregaDadosQuadro carregaDados = null;
        try {
            carregaDados = (ActionCarregaDadosQuadro)classeCarregaQuadro.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfiguracaoException("N\u00e3o foi possivel instanciar a classe de carga do Quadro " + quadro.getNome() + " na tela " + codigoTela + ".");
        }
        catch (IllegalAccessException e) {
            throw new ConfiguracaoException("N\u00e3o foi possivel instanciar a classe de carga do Quadro " + quadro.getNome() + " na tela " + codigoTela + ".");
        }
        if (carregaDados == null) {
            carregaDados = new ActionCarregaDadosQuadro();
        }
        ActionModeloListener listener = new ActionModeloListener(){

            @Override
            public void trataEvento(ActionModeloEvent evento) {
                log.info((Object)evento);
                ActionModeloQuadros.this.fireActionModeloEvent(evento);
            }
        };
        carregaDados.carregaDadosQuadro(codigoTela, remessa, tpBanco, quadro, identificadorConta, binding, contasModule, listener);
    }

    public final String criaNomeViewObject(String codigoTela, QuadroAbstrato quadro, BindingContext binding) throws IllegalArgumentException {
        String nomeVO = (codigoTela + quadro.getNome() + "View").replace('-', '_');
        this.verificaExistenciaNomeVO(nomeVO, codigoTela, quadro, binding);
        return nomeVO;
    }

    private final void verificaExistenciaNomeVO(String nomeVO, String codigoTela, QuadroAbstrato quadro, BindingContext binding) {
        HashSet<String> nomesVO = (HashSet<String>)binding.get((Object)SET_NOMES_VIEW_OBJECT_TELAS);
        if (nomesVO == null) {
            nomesVO = new HashSet<String>(2);
            binding.put((Object)SET_NOMES_VIEW_OBJECT_TELAS, nomesVO);
        }
        if (!nomesVO.contains(nomeVO)) {
            nomesVO.add(nomeVO);
        }
    }

    public static final ViewObject criaViewObjectContasRemessaTotal(ContasModule contasModule, String nomeVO, Remessa remessa, TipoBancoDados tpBanco, ConsultaSQL sqlQuadroTotal) {
        ViewObjectImpl contasRemessaTotalVO = null;
        try {
            int i;
            nomeVO = nomeVO.replace('-', '_');
            contasRemessaTotalVO = (ViewObjectImpl)contasModule.findViewObject(nomeVO);
            if (contasRemessaTotalVO == null) {
                contasRemessaTotalVO = (ViewObjectImpl)contasModule.createViewObjectFromQueryStmt(nomeVO, sqlQuadroTotal.getSql());
            } else {
                contasRemessaTotalVO.setQuery(sqlQuadroTotal.getSql());
                contasRemessaTotalVO.clearCache();
            }
            Object[] parametros = sqlQuadroTotal.getValoresParametros(remessa, tpBanco);
            if (parametros == null || parametros.length == 0) {
                parametros = sqlQuadroTotal.getValoresParametros();
            }
            for (i = 0; i < parametros.length; ++i) {
                contasRemessaTotalVO.setWhereClauseParam(i, parametros[i]);
            }
            contasRemessaTotalVO.executeQuery();
            for (i = 0; i < contasRemessaTotalVO.getAttributeCount(); ++i) {
                AttributeDefImpl attr = (AttributeDefImpl)contasRemessaTotalVO.getAttributeDef(i);
                attr.setProperty("FMT_FORMATTER", (Object)"oracle.jbo.format.DefaultNumberFormatter");
                attr.setProperty("FMT_FORMAT", (Object)"###,###,##0.00;-###,###,##0.00");
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Erro ao executar a consulta: " + sqlQuadroTotal.getCodigo()}, (Exception)((Object)e));
        }
        return contasRemessaTotalVO;
    }

    public final ViewObject criaViewObjectContasRemessa(ContasModule contasModule, String nomeVO, String defVOQuadro, Integer codigoTipoConta, Remessa remessa) {
        ViewObject contasRemessaVO = null;
        contasRemessaVO = contasModule.findViewObject(nomeVO);
        if (contasRemessaVO == null) {
            contasRemessaVO = contasModule.createViewObject(nomeVO, defVOQuadro);
        } else {
            contasRemessaVO.setWhereClause(null);
            contasRemessaVO.setWhereClauseParams(null);
            contasRemessaVO.clearCache();
        }
        if (contasRemessaVO.getAttributeIndexOf("Status") > 0) {
            contasRemessaVO.setWhereClause("STATUS='S'");
        }
        if (contasRemessaVO.getAttributeIndexOf("CdEntidade") > 0) {
            if (contasRemessaVO.getAttributeIndexOf("Status") > 0) {
                contasRemessaVO.setWhereClause("STATUS='S' AND CD_ENTIDADE= " + remessa.getCdEntidade());
            } else {
                contasRemessaVO.setWhereClause("CD_ENTIDADE= " + remessa.getCdEntidade());
            }
        }
        contasRemessaVO.setWhereClauseParam(0, (Object)codigoTipoConta);
        String nomeColunaOrdernacao = (String)contasRemessaVO.getProperty(this.getOrderBy());
        if (nomeColunaOrdernacao != null) {
            contasRemessaVO.setOrderByClause(nomeColunaOrdernacao);
        } else if (!(this.getOrderBy() == null && this.getOrderBy().equals("") || this.getOrderBy().equals(CLAUSULA_ORDER_BY))) {
            contasRemessaVO.setOrderByClause(this.getOrderBy());
        }
        return contasRemessaVO;
    }

    public String getOrderBy() {
        return CLAUSULA_ORDER_BY;
    }
}

