/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans.remessa;

import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivoVerificacao;
import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.DCGenericDataControl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemessaDataControlControle
extends DCGenericDataControl {
    static Log log = LogFactory.getLog(RemessaDataControlControle.class);
    public static final String REMESSA_DATA_CONTROL = "$RemessaDataControl";
    private Remessa _remessa;
    public static final String REMESSAS_VIEWOBJECT_NAME = "RemessasDaEntidade";
    public static final String ENTIDADES_VIEWOBJECT_NAME = "EntidadeDaRemessa";
    public static final String JUSTIFICATIVAS_VIEWOBJECT_NAME = "JustificativasDaRemessa";

    public RemessaDataControlControle() {
        super(REMESSA_DATA_CONTROL, Remessa.class.getName(), (Object)new Remessa(), true);
    }

    public void inicializaControle() {
        BindingContext ctx = this.getBindingContext();
        ApplicationModule padModule = (ApplicationModule)ctx.findDataControl("ServicoPADDataControl").getDataProvider();
        if (padModule == null) {
            throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel obter a instancia do ApplicationModule - ServicoPADDataControl");
        }
        this._remessa = this.inicializaRemessa((Remessa)this.getDataProvider(), padModule);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remessa Criada: " + this.getDataProvider().toString()));
        }
    }

    private Remessa inicializaRemessa(Remessa remessa, ApplicationModule padModule) {
        ViewObject remessasView = padModule.findViewObject(REMESSAS_VIEWOBJECT_NAME);
        if (remessasView == null) {
            throw new ConfiguracaoException("N\u00e3o foi poss\u00edvel recuperar o ViewObject de Remessas: RemessasDaEntidade");
        }
        log.debug((Object)("inicializaRemessa =>[" + remessasView.getRowCount() + "] " + remessasView.getQuery()));
        remessasView.executeQuery();
        Row remessaRow = remessasView.first();
        if (remessaRow == null) {
            remessaRow = remessasView.createRow();
            remessaRow.setAttribute("VersaoPad", (Object)"25.0.0.9");
            remessaRow.setAttribute("CdRemessa", (Object)1);
            remessaRow.setAttribute("PeriodoInformacoes", (Object)1);
            remessaRow.setAttribute("Mes", (Object)1);
            remessaRow.setAttribute("RemessaPrincipal", (Object)"S");
            remessaRow.setAttribute("SituacaoCarga", (Object)0);
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(2, -2);
            remessaRow.setAttribute("AnoExercicio", (Object)cal.get(1));
            remessasView.insertRow(remessaRow);
        }
        remessa.setDiretorioOrigem((String)remessaRow.getAttribute("DirArquivos"));
        Integer anoExercicio = (Integer)remessaRow.getAttribute("AnoExercicio");
        if (anoExercicio != null) {
            remessa.setAnoExercicio(anoExercicio);
        }
        String tpEntrega = (String)remessaRow.getAttribute("TpEntrega");
        remessa.setTipoEntrega(tpEntrega);
        Integer peridodo = (Integer)remessaRow.getAttribute("PeriodoInformacoes");
        remessa.setPeriodoInformacoes(peridodo);
        Integer mes = (Integer)remessaRow.getAttribute("Mes");
        if (mes != null) {
            remessa.setMes((int)mes);
        }
        remessa.setCdRemessa(1);
        remessa.setCargaArquivosSelecaoEfetuada((Integer)remessaRow.getAttribute("SituacaoCarga") == 1);
        Row entidadeRow = (Row)remessaRow.getAttribute("EntidadesView");
        if (entidadeRow != null) {
            remessa.setCnpjEntidade((String)entidadeRow.getAttribute("Cnpj"));
            remessa.setTipoSetor((String)entidadeRow.getAttribute("TipoSetorGov"));
            remessa.setCdEntidade((Integer)entidadeRow.getAttribute("CdEntidade"));
        }
        if (remessa.isCargaArquivosSelecaoEfetuada()) {
            this.carregaDadosIntegridadeArquivos(remessa, padModule);
        }
        remessa.setTipoEntrega(tpEntrega);
        this.carregaSituacaoJustificativas(remessa, padModule);
        return remessa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaDadosIntegridadeArquivos(Remessa remessa, ApplicationModule padModule) {
        ViewObject voIntegridade = null;
        try {
            voIntegridade = padModule.createViewObjectFromQueryStmt("voIntegridade", "select IDENTIFICADOR, HASH_DADOS from identificador_arquivo where cd_remessa = ? and cd_entidade = ?");
            voIntegridade.setWhereClauseParam(0, (Object)remessa.getCdRemessa());
            voIntegridade.setWhereClauseParam(1, (Object)remessa.getCdEntidade());
            voIntegridade.executeQuery();
            while (voIntegridade.hasNext()) {
                Row row = voIntegridade.next();
                IdentificadorArquivoVerificacao identVer = new IdentificadorArquivoVerificacao(new IdentificadorArquivo(((BigDecimal)row.getAttribute("IDENTIFICADOR")).intValue()), (String)row.getAttribute("HASH_DADOS"));
                remessa.adicionaIdentificadoresArquivo(identVer);
            }
        }
        finally {
            if (voIntegridade != null) {
                voIntegridade.remove();
            }
        }
    }

    private void carregaSituacaoJustificativas(Remessa remessa, ApplicationModule padModule) {
        ViewObject justificativasView = padModule.findViewObject(JUSTIFICATIVAS_VIEWOBJECT_NAME);
        while (justificativasView.hasNext()) {
            Row linha = justificativasView.next();
            Integer tpPlanilha = (Integer)linha.getAttribute("TipoPlanilha");
            remessa.insereCodigoJustificativa(TipoJustificativa.valueOf(tpPlanilha));
        }
    }

    public void cleanup() {
        this.inicializaControle();
    }

    public Remessa getRemessa() {
        return this._remessa;
    }
}

