/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans.remessa;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivoVerificacao;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.Mensagens;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.Regras;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.excecao.SenhaInvalidaException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.util.Base64Utils;
import br.gov.rs.tce.pad.util.RemessaUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Remessa
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean PAD_MENSAL = true;
    public static final int RVE_MDL9 = 1;
    public static final int RVE_MDL14 = 2;
    public static final int RVE = 3;
    public static final int RVE_MDL9_CONSOLIDADA = 5;
    public static final int RVE_RDI = 7;
    public static final int RVE_MDL9_DC = 11;
    public static final int RVE_MDL9_CONSOLIDADA_DC = 12;
    public static final int RVE_MDL14_DC = 13;
    public static final int RVE_DC = 14;
    public static final int[] GRUPOS_RELATORIO = new int[]{1, 2, 3, 5, 7, 11, 12, 13, 14};
    public static final int[] GRUPOS_RELATORIO_DC = new int[]{11, 12, 13, 14};
    public static final String QUADRIMESTRAL = "Q";
    public static final String SEMESTRAL = "S";
    public static final String SENHA_PADRAO_ROTINAS = "SIAPC2005-PAD";
    public static final String CERTIFICADO_DEFAULT = "D";
    public static final String CERTIFICADO_PROPRIO = "P";
    private int _grupoEntrega = 3;
    private String _tipoEnvioRemessa;
    private String _tipoCertificado;
    private String _tipoEntrega;
    private String _tipoRemessa;
    private int _anoExercicio;
    private int _periodoInformacoes;
    private String _tipoSetor;
    private String _cnpjEntidade;
    private String _diretorioOrigem;
    private int _tipoOperacao;
    private boolean _possuiIndiretas;
    private Integer _cdRemessa;
    private Integer _cdEntidade;
    private boolean _possuiRecursoEducacao;
    private boolean _possuiRecursoSaude;
    private Set<String> _regrasDesabilitadas;
    private boolean _gerarAuditoriaLocal;
    private boolean _consolidarDados;
    private boolean _possuiConsorcioPublico = false;
    static final Log log = LogFactory.getLog(Remessa.class);
    Set<TipoJustificativa> listaJustificativas = new HashSet<TipoJustificativa>();
    boolean _possuiSubstitutosExecutivo;
    boolean _possuiSubstitutosLegislativo;
    private boolean _cargaArquivosSelecaoEfetuada;
    private String _driveConsolidacao;
    private boolean _verificacaoEfetuada;
    private boolean _honrouCompromissos;
    private RemessaInfo _remessaInfo;
    private Map<IdentificadorArquivo, IdentificadorArquivoVerificacao> _identificadoresArquivoVerificacao;
    private String _anoBi;
    private Date dataFinal;
    private List<String> arquivosComplementares;
    private Integer mes;
    private int _tipoResponsaveis;

    public Remessa() {
        this._regrasDesabilitadas = new TreeSet<String>();
        this._identificadoresArquivoVerificacao = new HashMap<IdentificadorArquivo, IdentificadorArquivoVerificacao>();
    }

    public void setAnoExercicio(int anoExercicio) {
        this._anoExercicio = anoExercicio;
    }

    public void desabilitaRegraValidacao(String codigoDesabilitacao) throws SenhaInvalidaException {
        if (codigoDesabilitacao != null) {
            if (this._cdEntidade == null) {
                throw new SenhaInvalidaException("Entidade n\u00e3o localizada. \nVoc\u00ea deve selecionar a entidade na tela de Dados Iniciais.");
            }
            if (codigoDesabilitacao.length() != 32 && codigoDesabilitacao.length() != 44) {
                throw new SenhaInvalidaException("Quantidade de caracteres inv\u00e1lida");
            }
            try {
                codigoDesabilitacao = CriptografiaControle.descriptografaTexto(Base64Utils.base64Decode(codigoDesabilitacao), SENHA_PADRAO_ROTINAS);
            }
            catch (SegurancaException e) {
                throw new SenhaInvalidaException("Senha com formato inv\u00e1lido");
            }
            if (codigoDesabilitacao.length() < 23 || codigoDesabilitacao.length() > 27) {
                throw new SenhaInvalidaException("Quantidade de caracteres inv\u00e1lida ap\u00f3s descriptografia");
            }
            String[] codigos = codigoDesabilitacao.split(";");
            if (codigos.length != 3) {
                throw new SenhaInvalidaException("Senha com formato inv\u00e1lido");
            }
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            try {
                Date data = df.parse(codigos[0]);
                GregorianCalendar dataInformada = new GregorianCalendar();
                dataInformada.setTime(data);
                GregorianCalendar dataAtual = new GregorianCalendar();
                if (dataAtual.get(6) != dataInformada.get(6)) {
                    throw new SenhaInvalidaException("Data inv\u00e1lida, a senha possui dura\u00e7\u00e3o de apenas 1 dia");
                }
            }
            catch (ParseException e) {
                throw new SenhaInvalidaException("Senha com formato inv\u00e1lido");
            }
            try {
                int codEntidade = Integer.parseInt(codigos[1]);
                if (codEntidade != this._cdEntidade) {
                    throw new SenhaInvalidaException("Entidade inv\u00e1lida");
                }
            }
            catch (NumberFormatException e) {
                throw new SenhaInvalidaException("Senha com formato inv\u00e1lido");
            }
            String nomeRegra = codigos[2];
            Regras regras = (Regras)ConfiguracaoControle.carregaDadosArquivoXML("regras");
            try {
                regras.getRegraPorNome(nomeRegra);
            }
            catch (VerificacaoException e) {
                Mensagens mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
                try {
                    Mensagem mensagem = mensagens.getMensagemPorCodigo(nomeRegra);
                }
                catch (PADRuntimeException e2) {
                    throw new SenhaInvalidaException("C\u00f3digo de Rotina n\u00e3o localizado");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rotina desabilitada por senha: " + nomeRegra));
            }
            this._regrasDesabilitadas.add(nomeRegra);
        }
    }

    public static boolean validaRegraValidacao(String codigoDesabilitacao) throws SenhaInvalidaException {
        if (codigoDesabilitacao != null) {
            if (codigoDesabilitacao.length() != 32 && codigoDesabilitacao.length() != 44) {
                log.warn((Object)("Quantidade de caracteres inv\u00e1lida [" + codigoDesabilitacao.length() + "]"));
                return false;
            }
            try {
                codigoDesabilitacao = CriptografiaControle.descriptografaTexto(Base64Utils.base64Decode(codigoDesabilitacao), SENHA_PADRAO_ROTINAS);
            }
            catch (SegurancaException e) {
                log.warn((Object)("Senha com formato inv\u00e1lido [SE]: " + (Object)((Object)e)));
                return false;
            }
            if (codigoDesabilitacao.length() < 23 || codigoDesabilitacao.length() > 27) {
                log.warn((Object)("Quantidade de caracteres inv\u00e1lida ap\u00f3s descriptografia [" + codigoDesabilitacao.length() + "]"));
                return false;
            }
            String[] codigos = codigoDesabilitacao.split(";");
            if (codigos.length != 3) {
                log.warn((Object)("Senha com formato inv\u00e1lido [codigos.length = " + codigos.length + "]"));
                return false;
            }
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            try {
                Date data = df.parse(codigos[0]);
                GregorianCalendar dataInformada = new GregorianCalendar();
                dataInformada.setTime(data);
                GregorianCalendar dataAtual = new GregorianCalendar();
                if (dataAtual.get(6) != dataInformada.get(6)) {
                    log.warn((Object)("Data inv\u00e1lida, a senha possui dura\u00e7\u00e3o de apenas 1 dia [dataAtual = " + dataAtual.get(6) + " ; dataInformada = " + dataInformada.get(6) + "]"));
                    return false;
                }
            }
            catch (ParseException e) {
                log.warn((Object)("Senha com formato inv\u00e1lido [PE]: " + e));
                return false;
            }
            int codEntidade = -1;
            try {
                codEntidade = Integer.parseInt(codigos[1]);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Senha com formato inv\u00e1lido [NFE]: " + e));
                return false;
            }
            String nomeRegra = codigos[2];
            Regras regras = (Regras)ConfiguracaoControle.carregaDadosArquivoXML("regras");
            try {
                regras.getRegraPorNome(nomeRegra);
            }
            catch (VerificacaoException e) {
                Mensagens mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
                try {
                    Mensagem mensagem = mensagens.getMensagemPorCodigo(nomeRegra);
                }
                catch (PADRuntimeException e2) {
                    log.warn((Object)("C\u00f3digo de Rotina n\u00e3o localizado [" + nomeRegra + "]: " + (Object)((Object)e)));
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rotina desabilitada por senha: " + nomeRegra + " [codEntidade = " + codEntidade + "]"));
            }
            return true;
        }
        log.warn((Object)"C\u00f3digo Nulo");
        return false;
    }

    public String getAnoBiGrupoContas() {
        return this._anoBi;
    }

    public void setAnoBiGrupoContas(String anoBi) {
        this._anoBi = anoBi;
    }

    public boolean isExibeTelaJustificativa(TipoJustificativa tipo) {
        return this.listaJustificativas.contains(tipo);
    }

    public void insereCodigoJustificativa(TipoJustificativa tipoJustificativa) {
        this.listaJustificativas.add(tipoJustificativa);
    }

    public void removeCodigoJustificativa(TipoJustificativa tipoJustificativa) {
        this.listaJustificativas.remove(tipoJustificativa);
    }

    public boolean isExibeSubstitutosExecutivo() {
        return this._possuiSubstitutosExecutivo;
    }

    public void setPossuiSubstitutosExecutivo(boolean param) {
        this._possuiSubstitutosExecutivo = param;
    }

    public boolean isExibeSubstitutosLegislativo() {
        return this._possuiSubstitutosLegislativo;
    }

    public void setPossuiSubstitutosLegislativo(boolean param) {
        this._possuiSubstitutosLegislativo = param;
    }

    public boolean isPossuiSubstitutosLegislativo() {
        return this._possuiSubstitutosLegislativo;
    }

    public boolean isRegraDesabilitada(String codigoRegra) {
        return this._regrasDesabilitadas.contains(codigoRegra);
    }

    public int getAnoExercicio() {
        return this._anoExercicio;
    }

    public void setPeriodoInformacoes(int periodoInformacoes) {
        this._periodoInformacoes = periodoInformacoes;
        this.setarGrupoEntrega();
    }

    public int getPeriodoInformacoes() {
        return this._periodoInformacoes;
    }

    public String getTipoSetor() {
        return this._tipoSetor;
    }

    public void setTipoSetor(String tipoSetor) {
        this._tipoSetor = tipoSetor;
        this.setarGrupoEntrega();
    }

    public void setCnpjEntidade(String cnpjEntidade) {
        this._cnpjEntidade = cnpjEntidade;
    }

    public String getCnpjEntidade() {
        return this._cnpjEntidade;
    }

    public void setRemessaInfo(RemessaInfo remessaInfo) {
        this._remessaInfo = remessaInfo;
    }

    public RemessaInfo getRemessaInfo() {
        return this._remessaInfo;
    }

    public void setDiretorioOrigem(String diretorioOrigem) {
        this._diretorioOrigem = diretorioOrigem;
    }

    public String getDiretorioOrigem() {
        return this._diretorioOrigem;
    }

    public void setTipoEntrega(String tipoEntrega) {
        this._tipoEntrega = tipoEntrega;
        this.setarGrupoEntrega();
    }

    public String getTipoEntrega() {
        return this._tipoEntrega;
    }

    public void setTipoRemessa(String tipoRemessa) {
        this._tipoRemessa = tipoRemessa;
    }

    public String getTipoRemessa() {
        return this._tipoRemessa;
    }

    public void setTipoOperacao(int tipoOperacao) {
        this._tipoOperacao = tipoOperacao;
    }

    public int getTipoOperacao() {
        return this._tipoOperacao;
    }

    public void setPossuiIndiretas(boolean possuiIndiretas) {
        this._possuiIndiretas = possuiIndiretas;
        this.setarGrupoEntrega();
    }

    public boolean isPossuiIndiretas() {
        return this._possuiIndiretas;
    }

    public Integer getCdRemessa() {
        return this._cdRemessa;
    }

    public void setCdRemessa(Integer _cdRemessa) {
        this._cdRemessa = _cdRemessa;
    }

    public Integer getCdEntidade() {
        return this._cdEntidade;
    }

    public void setCdEntidade(Integer _cdEntidade) {
        this._cdEntidade = _cdEntidade;
    }

    public void setPossuiRecursoEducacao(boolean possuiRecursoEducacao) {
        this._possuiRecursoEducacao = possuiRecursoEducacao;
    }

    public boolean isPossuiRecursoEducacao() {
        return this._possuiRecursoEducacao;
    }

    public void setPossuiRecursoSaude(boolean possuiRecursoSaude) {
        this._possuiRecursoSaude = possuiRecursoSaude;
    }

    public boolean isPossuiRecursoSaude() {
        return this._possuiRecursoSaude;
    }

    public void setGerarAuditoriaLocal(boolean gerarAuditoriaLocal) {
        this._gerarAuditoriaLocal = gerarAuditoriaLocal;
    }

    public boolean isGerarAuditoriaLocal() {
        return this._gerarAuditoriaLocal;
    }

    public boolean isPossuiCamaraIntegrada() {
        return false;
    }

    public void setPossuiConsorcioPublico(boolean possuiConsorcioPublico) {
        this._possuiConsorcioPublico = possuiConsorcioPublico;
    }

    public boolean isPossuiConsorcioPublico() {
        return this._possuiConsorcioPublico;
    }

    public void setTipoEnvioRemessa(String tipoEnvioRemessa) {
        this._tipoEnvioRemessa = tipoEnvioRemessa;
    }

    public String getTipoEnvioRemessa() {
        return this._tipoEnvioRemessa;
    }

    public Integer getBimestreAnteriorInicial() {
        if (this._periodoInformacoes < 1 || this._periodoInformacoes > 6) {
            throw new IllegalStateException("Este m\u00e9todo n\u00e3o pode ser chamado para o periodo de informacoes atual: " + this._periodoInformacoes);
        }
        int fim = this._periodoInformacoes + 1;
        if (fim == 7) {
            fim = 1;
        }
        return fim;
    }

    public Integer getMesAnteriorInicial() {
        if (this._periodoInformacoes < 1 || this._periodoInformacoes > 6) {
            throw new IllegalStateException("Este m\u00e9todo n\u00e3o pode ser chamado para o periodo de informacoes atual: " + this._periodoInformacoes);
        }
        int fim = (this._periodoInformacoes + 1) * 2 - 1;
        if (fim == 13) {
            fim = 1;
        }
        return fim;
    }

    public Integer getMesFinalInformacoes() {
        Integer mes = this.getMes();
        if (mes != null) {
            return mes - 1;
        }
        if (this._periodoInformacoes < 1 || this._periodoInformacoes > 6) {
            throw new IllegalStateException("Este m\u00e9todo n\u00e3o pode ser chamado para o periodo de informacoes atual: " + this._periodoInformacoes);
        }
        return (this._periodoInformacoes - 1) * 2 + 1;
    }

    public int getGrupoEntrega() {
        return this._grupoEntrega;
    }

    private void setGrupoEntrega(int pGrupoEntrega) {
        this._grupoEntrega = pGrupoEntrega;
    }

    private void setarGrupoEntrega() {
        this.setGrupoEntrega(3);
        if (this.arquivosComplementares != null && this.arquivosComplementares.size() > 0) {
            if (this.arquivosComplementares.size() == 1 && this.arquivosComplementares.contains("PD")) {
                this.setGrupoEntrega(3);
            } else {
                this.setGrupoEntrega(7);
            }
        } else {
            if (this._tipoSetor != null) {
                TipoEntidadesList tipoEnt = TipoEntidadesList.valueOf(this._tipoSetor);
                if (tipoEnt == null) {
                    log.warn((Object)("tipoEnt==null :: _tipoSetor=" + this._tipoSetor));
                } else if ("4320/64" == tipoEnt.getLei() && this.mes != null && RemessaUtil.ehDezembro(this.mes)) {
                    this.setGrupoEntrega(14);
                } else {
                    this.setGrupoEntrega(3);
                }
            }
            if (this._tipoSetor != null && this._tipoEntrega != null && this.mes != null) {
                if (this._tipoSetor.equals(CERTIFICADO_PROPRIO)) {
                    if (RemessaUtil.ehMesEntregaLRF(this.mes, this._tipoEntrega)) {
                        if (RemessaUtil.ehDezembro(this.mes)) {
                            this.setGrupoEntrega(this.isPossuiIndiretas() ? 12 : 11);
                        } else {
                            this.setGrupoEntrega(this.isPossuiIndiretas() ? 5 : 1);
                        }
                    }
                } else if (this._tipoSetor.equals("C") && RemessaUtil.ehMesEntregaLRF(this.mes, this._tipoEntrega)) {
                    if (RemessaUtil.ehDezembro(this.mes)) {
                        this.setGrupoEntrega(13);
                    } else {
                        this.setGrupoEntrega(2);
                    }
                }
            }
        }
    }

    public boolean isCargaArquivosSelecaoEfetuada() {
        return this._cargaArquivosSelecaoEfetuada;
    }

    public void setCargaArquivosSelecaoEfetuada(boolean valor) {
        this._cargaArquivosSelecaoEfetuada = valor;
    }

    public void setDriveConsolidacao(String driveConsolidacao) {
        this._driveConsolidacao = driveConsolidacao;
    }

    public String getDriveConsolidacao() {
        return this._driveConsolidacao;
    }

    public void setVerificacaoEfetuada(boolean verificacaoEfetuada) {
        this._verificacaoEfetuada = verificacaoEfetuada;
    }

    public boolean isVerificacaoEfetuada() {
        return this._verificacaoEfetuada;
    }

    public void setHonrouCompromissos(boolean param) {
        this._honrouCompromissos = param;
    }

    public boolean isHonrouCompromissos() {
        return this._honrouCompromissos;
    }

    public void limpaIdentificadoresIntegridadeArquivos() {
        this._identificadoresArquivoVerificacao.clear();
    }

    public void adicionaIdentificadoresArquivo(IdentificadorArquivoVerificacao identArqVer) {
        this._identificadoresArquivoVerificacao.put(identArqVer.getIdentificadorArquivo(), identArqVer);
    }

    public void adicionaIdentificadoresArquivo(SituacaoVerificacao situacaoVerificacao) {
        Iterator<MetadadosArquivoContabil> it = situacaoVerificacao.getMetadadosArquivoIterator();
        while (it.hasNext()) {
            MetadadosArquivoContabil meta = it.next();
            IdentificadorArquivo identArq = Arquivo.criaIdenficadorArquivo(meta.getArquivo().getNome());
            IdentificadorArquivoVerificacao identVer = new IdentificadorArquivoVerificacao(identArq, meta.getDigestOriginal());
            this._identificadoresArquivoVerificacao.put(identArq, identVer);
        }
    }

    public boolean validaIntegridadeArquivoVerificacao(IdentificadorArquivo identArquivo, byte[] digestArquivo) {
        boolean ok = false;
        IdentificadorArquivoVerificacao identVer = this._identificadoresArquivoVerificacao.get(identArquivo);
        if (identVer != null) {
            ok = identVer.validaIntegridadeArquivo(digestArquivo);
        }
        return ok;
    }

    public Iterator<IdentificadorArquivoVerificacao> getIdentificadoresArquivoIterator() {
        return this._identificadoresArquivoVerificacao.values().iterator();
    }

    public void setConsolidarDados(boolean consolidarDados) {
        this._consolidarDados = consolidarDados;
    }

    public boolean isConsolidarDados() {
        return this._consolidarDados;
    }

    public void adicionaRegraDesabilitada(String codigoRegra) {
        this._regrasDesabilitadas.add(codigoRegra);
    }

    public void setTipoCertificado(String tipo) {
        this._tipoCertificado = tipo;
    }

    public String getTipoCertificado() {
        return this._tipoCertificado;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setArquivosComplementares(List<String> arquivosComplementares) {
        this.arquivosComplementares = arquivosComplementares;
        this.setarGrupoEntrega();
    }

    public List<String> getArquivosComplementares() {
        return this.arquivosComplementares;
    }

    public void setTipoResponsaveis(int tipoResponsaveis) {
        this._tipoResponsaveis = tipoResponsaveis;
    }

    public int getTipoResponsaveis() {
        return this._tipoResponsaveis;
    }

    public Integer getMes() {
        return this.mes;
    }

    public void setMes(Integer mes) {
        this.mes = mes;
    }
}

