/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.sql;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ClausulaWhere {
    private StringBuilder whereClause = new StringBuilder("");
    private String defaultConditional = "AND";
    private String defaultCompare = " = ";
    private TipoBancoDados tipoBase = TipoBancoDados.ORACLE_DB;
    public static final String CONDITIONAL_OR = "OR";
    public static final String CONDITIONAL_AND = "AND";
    public static final String COMPARE_LOWER_THAN = " < ";
    public static final String COMPARE_GREATER_THAN = " > ";
    public static final String COMPARE_LOWER_EQUALS_THAN = " <= ";
    public static final String COMPARE_GREATER_EQUALS_THAN = " >= ";
    public static final String COMPARE_EQUALS_THAN = " = ";

    public ClausulaWhere() {
    }

    public ClausulaWhere(TipoBancoDados tipoBase) {
        this.tipoBase = tipoBase;
    }

    public ClausulaWhere(String clausulaInicial) {
        this.whereClause = new StringBuilder(clausulaInicial);
    }

    public ClausulaWhere(String clausulaInicial, TipoBancoDados tipoBase) {
        this.whereClause = new StringBuilder(clausulaInicial);
        this.tipoBase = tipoBase;
    }

    public ClausulaWhere(String clausulaInicial, String defaultConditional) {
        this.whereClause = new StringBuilder(clausulaInicial);
        this.defaultConditional = defaultConditional;
    }

    public ClausulaWhere(String clausulaInicial, String defaultConditional, String defaultCompare) {
        this.whereClause = new StringBuilder(clausulaInicial);
        this.defaultConditional = defaultConditional;
        this.defaultCompare = defaultCompare;
    }

    public ClausulaWhere(String clausulaInicial, String defaultConditional, TipoBancoDados tipoBase) {
        this.whereClause = new StringBuilder(clausulaInicial);
        this.defaultConditional = defaultConditional;
        this.tipoBase = tipoBase;
    }

    public ClausulaWhere(String clausulaInicial, String defaultConditional, String defaultCompare, TipoBancoDados tipoBase) {
        this.whereClause = new StringBuilder(clausulaInicial);
        this.defaultConditional = defaultConditional;
        this.defaultCompare = defaultCompare;
        this.tipoBase = tipoBase;
    }

    public void addCondicaoNumerica(String nomeColuna, Object value) {
        this.addCondicaoNumerica(nomeColuna, value, this.defaultCompare, this.defaultConditional);
    }

    public void addCondicaoNumerica(String nomeColuna, Object value, String comparacao) {
        this.addCondicaoNumerica(nomeColuna, value, comparacao, this.defaultConditional);
    }

    public void addCondicaoNumerica(String nomeColuna, Object value, String comparacao, String condicional) {
        if (!this.initCondicao(nomeColuna, condicional)) {
            return;
        }
        String strValue = value.toString();
        if (strValue.contains("'") || strValue.contains(";")) {
            throw new IllegalArgumentException("Valores num\u00e9ricos n\u00e3o podem ter ' nem ;");
        }
        this.whereClause.append(nomeColuna).append(comparacao).append(strValue);
    }

    public void addCondicaoString(String nomeColuna, Object value) {
        this.addCondicaoString(nomeColuna, value, this.defaultCompare, this.defaultConditional);
    }

    public void addCondicaoString(String nomeColuna, Object value, String comparacao) {
        this.addCondicaoString(nomeColuna, value, comparacao, this.defaultConditional);
    }

    public void addCondicaoString(String nomeColuna, Object value, String comparacao, String condicional) {
        if (!this.initCondicao(nomeColuna, value, condicional)) {
            return;
        }
        this.whereClause.append(nomeColuna).append(comparacao + "'").append(ClausulaWhere.escapeQuotes(value.toString())).append("'");
    }

    public void addCondicaoStringSemelhante(String nomeColuna, Object value) {
        this.addCondicaoStringSemelhante(nomeColuna, value, this.defaultConditional);
    }

    public void addCondicaoStringSemelhante(String nomeColuna, Object value, String condicional) {
        if (!this.initCondicao(nomeColuna, value, condicional)) {
            return;
        }
        this.whereClause.append("UPPER(").append(nomeColuna).append(") LIKE '%").append(ClausulaWhere.escapeQuotes(value.toString().toUpperCase())).append("%'");
    }

    public void addCondicaoData(String nomeColuna, Date value) {
        this.addCondicaoComparacaoData(nomeColuna, value, this.defaultCompare);
    }

    public void addCondicaoComparacaoData(String nomeColuna, Date value, String comparacao) {
        this.addCondicaoComparacaoData(nomeColuna, value, comparacao, this.defaultConditional);
    }

    public void addCondicaoComparacaoData(String nomeColuna, Date value, String comparacao, String condicional) {
        if (!this.initCondicao(nomeColuna, value, condicional)) {
            return;
        }
        this.whereClause.append(nomeColuna).append(comparacao);
        if (TipoBancoDados.DERBY_DB.equals(this.tipoBase)) {
            this.whereClause.append("DATE('");
            this.whereClause.append(ClausulaWhere.escapeQuotes(this.formatDate(value)));
            this.whereClause.append("')");
        } else {
            this.whereClause.append("TO_DATE('");
            this.whereClause.append(ClausulaWhere.escapeQuotes(this.formatDate(value)));
            this.whereClause.append("','dd/MM/yyyy HH24:mi:ss')");
        }
    }

    private String formatDate(Date dateToFormat) {
        String dataAcaoStr = null;
        SimpleDateFormat df = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToFormat);
        String format = "dd/MM/yyyy HH:mm:ss";
        if (TipoBancoDados.DERBY_DB.equals(this.tipoBase)) {
            format = "MM/dd/yyyy";
            df = new SimpleDateFormat(format);
            dataAcaoStr = df.format(cal.getTime()).toString();
        } else {
            df = new SimpleDateFormat(format);
            dataAcaoStr = df.format(cal.getTime()).toString();
        }
        return dataAcaoStr;
    }

    public void addCondicaoGenerica(String str) {
        this.addCondicaoGenerica(str, this.defaultConditional);
    }

    public void addCondicaoGenerica(String str, String condicional) {
        if (!this.initCondicao(str, condicional)) {
            return;
        }
        this.whereClause.append(str);
    }

    private static String escapeQuotes(String str) {
        return str.replace("'", "''");
    }

    private boolean initCondicao(String coluna, String colunaConditional) {
        if (coluna == null || "".equals(coluna)) {
            return false;
        }
        if (this.whereClause.length() > 0) {
            this.whereClause.append(' ').append(colunaConditional).append(' ');
        }
        return true;
    }

    private boolean initCondicao(String coluna, Object value, String colunaConditional) {
        if (value == null || "".equals(value) || coluna == null || "".equals(coluna)) {
            return false;
        }
        if (this.whereClause.length() > 0) {
            this.whereClause.append(' ').append(colunaConditional).append(' ');
        }
        return true;
    }

    public void addInnerWhereClause(ClausulaWhere innerWhereClause) {
        this.addInnerWhereClause(innerWhereClause, this.defaultConditional);
    }

    public void addInnerWhereClause(ClausulaWhere innerWhereClause, String condicional) {
        if (!this.initCondicao(innerWhereClause == null ? "" : innerWhereClause.toString(), condicional)) {
            return;
        }
        this.whereClause.append("(" + innerWhereClause.toString() + ")");
    }

    public String toString() {
        return this.whereClause.toString();
    }
}

