/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.ldap.test;

import br.gov.rs.tce.commons.ldap.BeanUtils;
import br.gov.rs.tce.commons.ldap.LdapAutenticationException;
import br.gov.rs.tce.commons.ldap.LdapConnector;
import br.gov.rs.tce.commons.ldap.LdapException;
import br.gov.rs.tce.commons.ldap.Mapping;
import br.gov.rs.tce.commons.ldap.test.BeanTest;
import br.gov.rs.tce.util.Encoding;
import br.gov.rs.tce.util.exception.EncodingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TesteLdap {
    public TesteLdap() throws Exception {
        this.testeRevogaCertificado();
    }

    private void testeRevogaCertificado() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            String entidade = "cn=40601";
            BeanTest bean = (BeanTest)ldap.get(entidade);
            System.out.println("Nome no OID: " + bean.getNomeEntidade());
            bean.setOrclisenabled("DISABLED");
            bean.setUserPKCS12(null);
            bean.setUsercertificate(null);
            ldap.set(entidade, bean);
            bean = null;
            bean = (BeanTest)ldap.get(entidade);
            if (bean != null) {
                System.out.println("\n\nSETOU NO OID\n\n\n");
                System.out.println("Nome no OID: " + bean.getNomeEntidade());
                System.out.println("Is enabled? " + bean.getOrclisenabled());
                System.out.println("Certificado privado (userPKCS12):" + bean.getUserPKCS12());
                System.out.println("Certificado publico (usercertificate):" + bean.getUsercertificate());
            }
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeConexao() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeBeanClasseInvalida() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass("br.gov.rs.tce.commons.ldap.test.InvalidBeanTest");
            ldap.closeConnection();
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            System.out.println("Funcionou como esperado ao usar uma classe invalida");
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testePropriedades() {
        BeanUtils beanUtil = new BeanUtils();
        BeanTest bean = new BeanTest();
        System.out.println("ANTES DE ALTERAR ATRIBUTOS");
        bean.setNomeEntidade("Atributo nome da entidade");
        bean.setCn("Atributo CN");
        bean.setAuthpasswordOid("Atributo AuthpasswordOid");
        Map<String, Object> propriedades = beanUtil.getBeanAttributes(bean);
        for (Map.Entry<String, Object> pairs : propriedades.entrySet()) {
            System.out.println(pairs.getKey() + "=" + pairs.getValue());
        }
        System.out.println("\n\n\n\nDEPOIS DE ALTERAR ATRIBUTOS");
        beanUtil.setBeanAttribute(bean, "nomeEntidade", "Novo nome da entidade");
        beanUtil.setBeanAttribute(bean, "cn", "Novo atributo CN");
        beanUtil.setBeanAttribute(bean, "authpasswordOid", "Novo atributo AuthpasswordOid");
        propriedades = beanUtil.getBeanAttributes(bean);
        for (Map.Entry<String, Object> pairs : propriedades.entrySet()) {
            System.out.println(pairs.getKey() + "=" + pairs.getValue());
        }
    }

    private void testeFindBean() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            BeanTest bean = (BeanTest)ldap.get("cn=50000");
            ldap.closeConnection();
            System.out.println("\n\nAp\u00f3s buscar objeto!!");
            System.out.println("Nome:" + bean.getNomeEntidade());
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeGetInvalido() throws Exception {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            BeanTest bean = (BeanTest)ldap.get("cn=999999");
            ldap.closeConnection();
            if (bean != null) {
                throw new Exception("Erro ao executar 'testeGetInvalido'");
            }
            System.out.println("testeGetInvalido ok");
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeGetSet() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            BeanTest bean = (BeanTest)ldap.get("cn=50000");
            System.out.println("Nome no OID: " + bean.getNomeEntidade());
            bean.setNomeEntidade("Entidade teste2");
            ldap.set("cn=teste2", bean);
            bean = null;
            bean = (BeanTest)ldap.get("cn=teste2");
            if (bean != null) {
                System.out.println("Nome no OID: " + bean.getNomeEntidade());
            }
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeRemove() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.set("cn=teste2", null);
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeGetByQuery() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            System.err.println("\n\n");
            List results = ldap.getByQuery("(objectclass=person)");
            Iterator it = results.iterator();
            System.err.flush();
            System.out.flush();
            System.out.println("\n\nEXIBINDO RESULTADOS\n\n");
            while (it.hasNext()) {
                BeanTest bean = (BeanTest)it.next();
                System.out.println("");
                System.out.println("Nome: " + bean.getNomeEntidade());
                System.out.println("Mail: " + bean.getMail());
                System.out.println("UserCertificate: " + bean.getUsercertificate());
            }
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeSearch() {
        try {
            LdapConnector ldap = new LdapConnector();
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            System.err.println("\n");
            List results = ldap.getByQuery("(&(objectclass=*))");
            Iterator it = results.iterator();
            System.err.flush();
            System.out.flush();
            System.out.println("\n\nEXIBINDO RESULTADOS\n\n");
            while (it.hasNext()) {
                BeanTest bean = (BeanTest)it.next();
                System.out.println("");
                System.out.println("Nome: " + bean.getNomeEntidade());
                System.out.println("Mail: " + bean.getMail());
                System.out.println("UserCertificate: " + bean.getUsercertificate());
                System.out.println("ModifyTimeStamp:" + bean.getModifytimestamp());
            }
            ldap.closeConnection();
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeAutenticacaoManual() {
        try {
            LdapConnector ldap = new LdapConnector("cn=50000", "PAD50000");
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            BeanTest bean = (BeanTest)ldap.get("cn=50000");
            ldap.closeConnection();
            System.out.println("\n\nAp\u00f3s buscar objeto!!");
            System.out.println("Nome:" + bean.getNomeEntidade());
        }
        catch (LdapAutenticationException e) {
            System.out.println("N\u00e3o foi poss\u00edvel autenticar o usuario");
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    private void testeDownloadCertificado() {
        try {
            LdapConnector ldap = new LdapConnector("cn=50000", "PAD50000");
            ldap.setBeanClass(BeanTest.class);
            this.configurarMappings(ldap.getMappings());
            BeanTest bean = (BeanTest)ldap.get("cn=50000");
            ldap.closeConnection();
            File f = new File("certificado.cer");
            System.out.println("File:" + f.getAbsolutePath());
            System.out.println("Bytes:" + bean.getUsercertificate());
            TesteLdap.putBytesToFile(f, bean.getUsercertificate());
            f = new File("certificado.pfx");
            System.out.println("File:" + f.getAbsolutePath());
            System.out.println("Bytes:" + bean.getUserPKCS12());
            Encoding encoder = new Encoding();
            TesteLdap.putBytesToFile(f, encoder.encode(bean.getUserPKCS12()));
        }
        catch (LdapAutenticationException e) {
            System.out.println("N\u00e3o foi poss\u00edvel autenticar o usuario");
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EncodingException e) {
            e.printStackTrace();
        }
    }

    private void configurarMappings(Set<Mapping> mappings) {
        mappings.add(new Mapping("givenname", "nomeEntidade"));
        mappings.add(new Mapping("cn", "cn", false, true));
        mappings.add(new Mapping(null, "usercertificateX509", true, true));
        mappings.add(new Mapping("usersmimecertificate", null, true, true));
        mappings.add(new Mapping("authpassword;orclcommonpwd", "authpasswordorclcommonpwd", true, true));
        mappings.add(new Mapping("authpassword;oid", "authpasswordOid", true, true));
        mappings.add(new Mapping("orclsamaccountname", "orclsamaccountname", true, true));
        mappings.add(new Mapping("orcldefaultprofilegroup", null, true, true));
        mappings.add(new Mapping("orcltimezone", null, true, true));
        mappings.add(new Mapping("orclpkcs12hint", null, true, true));
        mappings.add(new Mapping("orclmaidenname", null, true, true));
        mappings.add(new Mapping("departmentnumber", null, true, true));
        mappings.add(new Mapping("orclhiredate", null, true, true));
        mappings.add(new Mapping("orcldateofbirth", null, true, true));
        mappings.add(new Mapping("homepostaladdress", null, true, true));
    }

    public static void putBytesToFile(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        ((OutputStream)os).write(bytes);
        ((OutputStream)os).close();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void main(String[] args) {
        try {
            new TesteLdap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().gc();
    }
}

