/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.ldap;

import br.gov.rs.tce.commons.ldap.LdapConnector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static Log LOG = LogFactory.getLog(LdapConnector.class.getClass());

    public Object createClassInstance(String className) {
        Object instance = null;
        if (className == null) {
            throw new IllegalArgumentException("The className name cannot be null");
        }
        try {
            this.getClass();
            instance = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The given classname '" + className + "' cannot be found: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The given classname '" + className + "' cannot be accessed: " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("The given classname '" + className + "' cannot be instantiated: " + e.getMessage(), e);
        }
        return instance;
    }

    public boolean setBeanAttribute(Object bean, String beanProperty, Object propertyValue) {
        Method method = null;
        Field field = null;
        try {
            String lowerNameMethod = "set" + beanProperty.toLowerCase();
            Method[] methods = bean.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                String name = method.getName().toLowerCase();
                if (!name.equals(lowerNameMethod)) continue;
                method.invoke(bean, propertyValue);
                return true;
            }
            String lowerNameField = beanProperty.toLowerCase();
            Field[] fields = bean.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                field = fields[i];
                String name = field.getName().toLowerCase();
                if (!name.equals(lowerNameField)) continue;
                field.set(bean, propertyValue);
                return true;
            }
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Cannot set attribute '").append(beanProperty).append("' on bean of class '").append(bean.getClass().getName()).append("':").append(e.getMessage()).append("\nGiven type: ").append(propertyValue.getClass().getName()).append("\n");
            if (field != null) {
                msg.append("Expected type: " + field.getType().getName());
            } else if (method != null) {
                Class<?>[] types = method.getParameterTypes();
                msg.append("Expected parameters: \n");
                for (int i = 0; i < types.length; ++i) {
                    msg.append("\t").append(types[i].getName()).append("\n");
                }
                LOG.warn((Object)msg.toString());
            }
            return false;
        }
        LOG.warn((Object)("Cannot set attribute '" + beanProperty + "' on bean of class '" + bean.getClass().getName() + "': field not exists"));
        return false;
    }

    public Map<String, Object> getBeanAttributes(Object bean) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Method[] methods = bean.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (!name.startsWith("get") || name.equals("getClass")) continue;
            name = name.replaceFirst("get", "");
            name = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
            try {
                Object value = method.invoke(bean, (Object[])null);
                attributes.put(name, value);
                continue;
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot obtain property '" + name + "' value from bean (using method '" + bean.getClass().getName() + "." + method.getName() + "()' ):" + e.getMessage()), (Throwable)e);
            }
        }
        return attributes;
    }
}

