/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.modelo.negocio;

import br.gov.rs.tce.adf.excecao.EntidadeJaExisteException;
import br.gov.rs.tce.adf.excecao.ExceptionHelper;
import br.gov.rs.tce.adf.excecao.MensagensErro;
import br.gov.rs.tce.adf.util.ValidacaoCampoHelper;
import java.math.BigDecimal;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;

public class TCEEntityImpl
extends EntityImpl {
    private static final String LOWER = "lower";
    private static final String UPPER = "upper";
    private static final String CASE = "Case";

    protected void setAttributeInternal(int index, Object val) {
        try {
            val = this.foldCaseOfStringIfCasePropertySet(index, val);
            super.setAttributeInternal(index, val);
        }
        catch (JboException ex) {
            if (ExceptionHelper.isOrCausedByDuplicateRow(ex)) {
                EntityDefImpl def = this.getEntityDef();
                Class<MensagensErro> msgBundle = def.getMessageBundleClass();
                throw new EntidadeJaExisteException(msgBundle != null ? msgBundle : MensagensErro.class, def.getFullName(), def.getAttributeDef(index).getName(), val);
            }
            throw ex;
        }
    }

    private Object foldCaseOfStringIfCasePropertySet(int index, Object val) {
        AttributeDef attrDef;
        String caseProp;
        if (val != null && val instanceof String && (caseProp = (String)(attrDef = this.getEntityDef().getAttributeDef(index)).getProperty(CASE)) != null && attrDef.getJavaType().isAssignableFrom(String.class)) {
            if (caseProp.equalsIgnoreCase(LOWER)) {
                val = ((String)val).toLowerCase();
            } else if (caseProp.equalsIgnoreCase(UPPER)) {
                val = ((String)val).toUpperCase();
            }
        }
        return val;
    }

    public boolean validateEmail(String email) {
        return ValidacaoCampoHelper.validateEmail(email);
    }

    public boolean validateCargo(String cargo) {
        return ValidacaoCampoHelper.validateCargo(cargo);
    }

    public boolean validateEndereco(String end) {
        return ValidacaoCampoHelper.validateEndereco(end);
    }

    public boolean validateTelefone(String fone) {
        return ValidacaoCampoHelper.validateTelefone(fone);
    }

    public boolean validateNr(BigDecimal nr) {
        return ValidacaoCampoHelper.validateNr(nr);
    }

    public boolean validateNome(String nome) {
        return ValidacaoCampoHelper.validateNome(nome);
    }

    public boolean validateMinimoSequenciasCaracter(String nome) {
        return ValidacaoCampoHelper.validateMinimoSequenciasCaracter(nome);
    }

    public boolean validateTamanhoMinimo(String tamanho) {
        return tamanho.length() >= 3;
    }
}

