/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.modelo.acessodados;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;

public class PropertyFileBasedLookupViewObjectImpl
extends ViewObjectImpl {
    int rows = -1;
    private Object[] codes = null;
    private Object[] descriptions = null;

    protected void executeQueryForCollection(Object rowset, Object[] params, int noUserParams) {
        this.setFetchPos(rowset, 0);
        super.executeQueryForCollection(rowset, params, noUserParams);
    }

    protected boolean hasNextForCollection(Object rowset) {
        return this.getFetchPos(rowset) < this.rows;
    }

    protected ViewRowImpl createRowFromResultSet(Object rowset, ResultSet resultSet) {
        ViewRowImpl r = this.createNewRowForCollection(rowset);
        int pos = this.getFetchPos(rowset);
        this.populateAttributeForRow(r, 0, this.codes[pos]);
        this.populateAttributeForRow(r, 1, this.descriptions[pos]);
        this.setFetchPos(rowset, pos + 1);
        return r;
    }

    protected void create() {
        super.create();
        this.loadDataFromPropertiesFile();
        this.rows = this.codes != null ? this.codes.length : 0;
        this.getViewDef().setQuery(null);
        this.getViewDef().setSelectClause(null);
        this.setQuery(null);
    }

    private void setFetchPos(Object rowset, int pos) {
        if (pos == this.rows) {
            this.setFetchCompleteForCollection(rowset, true);
        }
        this.setUserDataForCollection(rowset, pos);
    }

    private int getFetchPos(Object rowset) {
        return (Integer)this.getUserDataForCollection(rowset);
    }

    private synchronized void loadDataFromPropertiesFile() {
        String propertyFile = this.getViewDef().getFullName().replace('.', '/') + ".properties";
        ArrayList<String> codesList = new ArrayList<String>(20);
        ArrayList<String> descriptionList = new ArrayList<String>(20);
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFile);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            String line = null;
            while ((line = lnr.readLine()) != null) {
                line.trim();
                int eqPos = line.indexOf(61);
                if (eqPos < 1 || line.charAt(0) == '#') continue;
                codesList.add(line.substring(0, eqPos));
                descriptionList.add(line.substring(eqPos + 1));
            }
        }
        catch (IOException iox) {
            return;
        }
        this.codes = codesList.toArray();
        this.descriptions = descriptionList.toArray();
    }

    public long getQueryHitCount(ViewRowSetImpl viewRowSet) {
        return this.rows;
    }
}

