/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUTableBinding;
import oracle.jbo.uicli.jui.SortedListSelectionModel;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public class JUTableSortModel
extends AbstractTableModel
implements TableModelListener {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$oracle$jbo$domain$Date;
    static /* synthetic */ Class class$oracle$jbo$domain$Number;
    final byte DOMAIN_NUMBER = 0;
    final byte DOMAIN_DATE = 1;
    final byte TYPE_STRING = 2;
    final byte TYPE_DATE = 4;
    final byte TYPE_NUMBER = 8;
    final byte TYPE_BOOLEAN = 16;
    final byte TYPE_OBJECT = 32;
    boolean mAscending = true;
    int mSortColIndex = -1;
    byte mSortColType = (byte)32;
    int mRangeStart;
    int[] mIndices;
    JUTableBinding mModel;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JUTableSortModel() {
        this.mIndices = new int[0];
    }

    public JUTableSortModel(JUTableBinding jUTableBinding) {
        this.setTableBinding(jUTableBinding);
    }

    protected void setTableBinding(JUTableBinding jUTableBinding) {
        this.mModel = jUTableBinding;
        jUTableBinding.addTableModelListener(this);
        this.reallocateIndexes();
    }

    protected void checkModel() {
        if (this.mIndices != null && this.mIndices.length != this.getRangeSize()) {
            this.resetIndices();
        }
    }

    protected int compareRows(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this.mSortColIndex);
        return this.mAscending ? n3 : -n3;
    }

    final int getRangeSize() {
        return this.mModel.getIteratorBinding().getNavigatableRowIterator().getRowCountInRange();
    }

    protected void resetIndices() {
        JUIteratorBinding jUIteratorBinding;
        if (this.mModel != null && (jUIteratorBinding = this.mModel.getIteratorBinding()).isIteratorMadeVisible()) {
            RowSetIterator rowSetIterator = jUIteratorBinding.getRowSetIterator();
            if (jUIteratorBinding.isFindMode() || rowSetIterator != null) {
                int n = this.getRangeSize();
                this.mIndices = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    this.mIndices[n2] = n2;
                    ++n2;
                }
            }
        }
    }

    protected void reallocateIndexes() {
        if (this.mSortColIndex > -1) {
            this.sortByColumn(this.mSortColIndex, this.mAscending);
        } else {
            this.resetIndices();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.mModel.getIteratorBinding().getNavigatableRowIterator().getRangeStart();
        this.mRangeStart = n > -1 ? n : 0;
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    protected void initType() {
        JUTableBinding jUTableBinding;
        Class clazz;
        this.mSortColType = (class$oracle$jbo$domain$Number == null ? (class$oracle$jbo$domain$Number = JUTableSortModel.class$("oracle.jbo.domain.Number")) : class$oracle$jbo$domain$Number).isAssignableFrom(clazz = (jUTableBinding = this.mModel).getColumnClass(this.mSortColIndex)) ? (byte)0 : ((class$oracle$jbo$domain$Date == null ? (class$oracle$jbo$domain$Date = JUTableSortModel.class$("oracle.jbo.domain.Date")) : class$oracle$jbo$domain$Date).isAssignableFrom(clazz) ? (byte)1 : ((class$java$lang$Number == null ? (class$java$lang$Number = JUTableSortModel.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) ? (byte)8 : ((class$java$util$Date == null ? (class$java$util$Date = JUTableSortModel.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz) ? (byte)4 : ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = JUTableSortModel.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) ? (byte)16 : ((class$java$lang$String == null ? (class$java$lang$String = JUTableSortModel.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz) ? (byte)2 : (byte)32)))));
    }

    public void sortByColumn(int n, boolean bl) {
        JTable jTable = (JTable)this.mModel.getControl();
        int n2 = jTable.getSelectedRow();
        if (this.mSortColIndex != n) {
            this.resetIndices();
            this.mSortColType = (byte)32;
            this.mSortColIndex = n;
        }
        if (this.mSortColIndex > -1) {
            this.mAscending = bl;
            this.checkModel();
            this.initType();
            this.shuttlesort((int[])this.mIndices.clone(), this.mIndices, 0, this.mIndices.length);
        }
        this.fireTableChanged(new TableModelEvent(this));
        if (n2 > -1) {
            NavigatableRowIterator navigatableRowIterator = this.mModel.getIteratorBinding().getNavigatableRowIterator();
            Row row = navigatableRowIterator.getCurrentRow();
            n2 = -1;
            if (row != null) {
                n2 = this.getSortedIndex(navigatableRowIterator.getRangeIndexOf(row));
            }
            if (n2 > -1) {
                jTable.setRowSelectionInterval(n2, n2);
            }
        }
    }

    final int getModelIndex(int n) {
        int n2 = -1;
        if (this.mSortColIndex > -1) {
            int n3 = n - this.mRangeStart;
            if (n3 >= 0 && n3 < this.getRangeSize()) {
                n2 = this.mIndices[n3];
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    final int getSortedIndex(int n) {
        int n2 = -1;
        if (this.mSortColIndex > -1) {
            int n3 = this.mIndices.length;
            --n3;
            while (n3 >= 0) {
                if (this.mIndices[n3] == n) {
                    n2 = n3;
                    break;
                }
                --n3;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    protected void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compareRows(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compareRows(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    protected void swap(int n, int n2) {
        int n3 = this.mIndices[n];
        this.mIndices[n] = this.mIndices[n2];
        this.mIndices[n2] = n3;
    }

    protected final int compareRowsByColumn(int n, int n2, int n3) {
        JUTableBinding jUTableBinding = this.mModel;
        Object object = jUTableBinding.getValueAt(n + this.mRangeStart, n3);
        Object object2 = jUTableBinding.getValueAt(n2 + this.mRangeStart, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.mSortColType) {
            case 0: {
                Number number = (Number)object;
                Number number2 = (Number)object2;
                return number.compareTo((NUMBER)number2);
            }
            case 1: {
                oracle.jbo.domain.Date date = (oracle.jbo.domain.Date)object;
                oracle.jbo.domain.Date date2 = (oracle.jbo.domain.Date)object2;
                return date.compareTo((DATE)date2);
            }
            case 8: {
                java.lang.Number number = (java.lang.Number)object;
                double d = number.doubleValue();
                java.lang.Number number3 = (java.lang.Number)object2;
                double d2 = number3.doubleValue();
                return d < d2 ? -1 : (d > d2 ? 1 : 0);
            }
            case 4: {
                Date date = (Date)object;
                long l = date.getTime();
                Date date3 = (Date)object2;
                long l2 = date3.getTime();
                return l < l2 ? -1 : (l > l2 ? 1 : 0);
            }
            case 16: {
                Boolean bl = (Boolean)object;
                boolean bl2 = bl;
                Boolean bl3 = (Boolean)object2;
                boolean bl4 = bl3;
                return bl2 == bl4 ? 0 : (bl2 ? 1 : -1);
            }
            case 2: {
                String string = (String)object;
                String string2 = (String)object2;
                int n4 = string.compareTo(string2);
                return n4 < 0 ? -1 : (n4 > 0 ? 1 : 0);
            }
        }
        return this.compareObjectTypes(object, object2);
    }

    protected int compareObjectTypes(Object object, Object object2) {
        String string;
        String string2 = object.toString();
        int n = string2.compareTo(string = object2.toString());
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JUTableSortModel jUTableSortModel = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    boolean bl;
                    int n3 = mouseEvent.getModifiers() & 1;
                    boolean bl2 = bl = n3 == 0;
                    if (bl == jUTableSortModel.mAscending && n2 == jUTableSortModel.mSortColIndex) {
                        n2 = -1;
                    }
                    jUTableSortModel.sortByColumn(n2, bl);
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public JUTableBinding getTableBinding() {
        return this.mModel;
    }

    public Object getValueAt(int n, int n2) {
        int n3;
        this.checkModel();
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            return this.mModel.getValueAt(this.mRangeStart + this.mIndices[n3], n2);
        }
        return this.mModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3;
        this.checkModel();
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            this.mModel.setValueAt(object, this.mRangeStart + this.mIndices[n3], n2);
            return;
        }
        this.mModel.setValueAt(object, n, n2);
    }

    public int getRowCount() {
        return this.mModel == null ? 0 : this.mModel.getRowCount();
    }

    public int getColumnCount() {
        return this.mModel == null ? 0 : this.mModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.mModel == null ? null : this.mModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.mModel == null ? null : this.mModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3;
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            Row row;
            NavigatableRowIterator navigatableRowIterator = this.mModel.getIteratorBinding().getNavigatableRowIterator();
            Row row2 = navigatableRowIterator.getCurrentRow();
            if (row2 != (row = navigatableRowIterator.getRowAtRangeIndex(this.mIndices[n3]))) {
                navigatableRowIterator.setCurrentRow(row);
            }
            return this.mModel.isCellEditable(this.mRangeStart + this.mIndices[n3], n2);
        }
        return this.mModel.isCellEditable(n, n2);
    }

    final boolean isUnsortedDisplay() {
        return this.mSortColIndex < 0;
    }

    public static TableModel enableColumnSorting(JTable jTable, JUTableBinding jUTableBinding, JUTableSortModel jUTableSortModel) {
        block4: {
            if (jUTableSortModel == null) {
                jUTableSortModel = new JUTableSortModel(jUTableBinding);
            } else {
                try {
                    jUTableSortModel.setTableBinding(jUTableBinding);
                }
                catch (Exception exception) {
                    jUTableBinding.reportException(exception);
                    if (jUTableSortModel != null) break block4;
                    Diagnostic.println((String)"Failed to create custom SortModel for JTable. Using default implementation");
                    jUTableSortModel = new JUTableSortModel(jUTableBinding);
                }
            }
        }
        jUTableSortModel.addMouseListenerToHeaderInTable(jTable);
        jTable.setModel(jUTableSortModel);
        jTable.setSelectionModel(new SortedListSelectionModel(jUTableSortModel, jTable.getSelectionModel()));
        return jUTableSortModel;
    }
}

