/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.rtp.util.Signed;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMPanel;

public class ViewRtpStreamInfo
extends JMPanel {
    private SessionManager mngrSession = this.mngrSession;
    private RTPStream stream;
    private UpdateThread threadUpdate = null;
    private JMPanel panelContent = null;
    private JMPanel panelLabels = null;
    private JMPanel panelData = null;
    private Label fieldOwner;
    private Label fieldSsrc;
    private Label fieldLostPdu;
    private Label fieldProcessedPdu;
    private Label fieldMisorderedPdu;
    private Label fieldInvalidPdu;
    private Label fieldDuplicatePdu;
    private static final String LABEL_NAME = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.owner");
    private static final String LABEL_SSRC = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.ssrc");
    private static final String LABEL_LOST_PDU = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.lostpdu");
    private static final String LABEL_PROCESSED_PDU = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.processedpdu");
    private static final String LABEL_MISORDERED_PDU = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.misorderedpdu");
    private static final String LABEL_INVALID_PDU = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.invalidpdu");
    private static final String LABEL_DUPLICATE_PDU = JMFI18N.getResource("jmstudio.rtpsessionctrl.stream.duplicatepdu");

    public ViewRtpStreamInfo(SessionManager sessionManager, RTPStream rTPStream) {
        this.stream = rTPStream;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.threadUpdate == null) {
            this.threadUpdate = new UpdateThread();
        }
        this.threadUpdate.start();
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        this.panelContent = new JMPanel(new BorderLayout(6, 6));
        this.add((Component)this.panelContent, "North");
        this.panelLabels = new JMPanel(new GridLayout(0, 1, 0, 0));
        this.panelContent.add((Component)this.panelLabels, "West");
        this.panelData = new JMPanel(new GridLayout(0, 1, 0, 0));
        this.panelContent.add((Component)this.panelData, "Center");
        Label label = new Label(LABEL_NAME);
        this.panelLabels.add(label);
        this.fieldOwner = new Label();
        this.panelData.add(this.fieldOwner);
        label = new Label(LABEL_SSRC);
        this.panelLabels.add(label);
        this.fieldSsrc = new Label();
        this.panelData.add(this.fieldSsrc);
        if (this.stream instanceof ReceiveStream) {
            label = new Label(LABEL_LOST_PDU);
            this.panelLabels.add(label);
            this.fieldLostPdu = new Label();
            this.panelData.add(this.fieldLostPdu);
            label = new Label(LABEL_PROCESSED_PDU);
            this.panelLabels.add(label);
            this.fieldProcessedPdu = new Label();
            this.panelData.add(this.fieldProcessedPdu);
            label = new Label(LABEL_MISORDERED_PDU);
            this.panelLabels.add(label);
            this.fieldMisorderedPdu = new Label();
            this.panelData.add(this.fieldMisorderedPdu);
            label = new Label(LABEL_INVALID_PDU);
            this.panelLabels.add(label);
            this.fieldInvalidPdu = new Label();
            this.panelData.add(this.fieldInvalidPdu);
            label = new Label(LABEL_DUPLICATE_PDU);
            this.panelLabels.add(label);
            this.fieldDuplicatePdu = new Label();
            this.panelData.add(this.fieldDuplicatePdu);
        }
        this.updateFields();
    }

    public void removeNotify() {
        if (this.threadUpdate != null) {
            this.threadUpdate.terminate();
            this.threadUpdate = null;
        }
        super.removeNotify();
    }

    private void updateFields() {
        this.fieldOwner.setText(this.stream.getParticipant().getCNAME());
        this.fieldSsrc.setText(String.valueOf(Signed.UnsignedInt((int)this.stream.getSSRC())));
        if (this.stream instanceof ReceiveStream) {
            ReceptionStats receptionStats = ((ReceiveStream)this.stream).getSourceReceptionStats();
            this.fieldLostPdu.setText(String.valueOf(receptionStats.getPDUlost()));
            this.fieldProcessedPdu.setText(String.valueOf(receptionStats.getPDUProcessed()));
            this.fieldMisorderedPdu.setText(String.valueOf(receptionStats.getPDUMisOrd()));
            this.fieldInvalidPdu.setText(String.valueOf(receptionStats.getPDUInvalid()));
            this.fieldDuplicatePdu.setText(String.valueOf(receptionStats.getPDUDuplicate()));
        }
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void run() {
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                    ViewRtpStreamInfo.this.updateFields();
                }
                catch (Exception exception) {}
            }
        }

        public void terminate() {
            this.boolTerminate = true;
        }
    }
}

