/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class PanelMediaTargetNetwork
extends JMPanel
implements TextListener,
FocusListener {
    private JMAppsCfg cfgJMApps = null;
    private Panel panelLabels;
    private Panel panelAddress;
    private Panel panelPort;
    private Panel panelTtl;
    private TextField[][] arrTextVideoTrackAddress = null;
    private TextField[][] arrTextAudioTrackAddress = null;
    private TextField[] arrTextVideoPort = null;
    private TextField[] arrTextAudioPort = null;
    private Choice[] arrComboVideoTtl = null;
    private Choice[] arrComboAudioTtl = null;
    private int nVideoCount = 0;
    private int nAudioCount = 0;
    private static final int MAX_TRACK_COUNT = 8;

    public PanelMediaTargetNetwork(JMAppsCfg jMAppsCfg) {
        this.cfgJMApps = jMAppsCfg;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkValidFields(boolean bl) {
        int n2;
        String string;
        int n3;
        int n4 = 0;
        while (n4 < this.nVideoCount) {
            n3 = 0;
            while (n3 < 4) {
                if (this.arrTextVideoTrackAddress[n4][n3].isEnabled()) {
                    string = this.arrTextVideoTrackAddress[n4][n3].getText();
                    try {
                        n2 = Integer.valueOf(string);
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    if (n2 < 0 || n2 > 255) {
                        if (bl) {
                            MessageDialog.createErrorDialog(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.error.video.sessionaddr")) + " " + (n4 + 1));
                        }
                        return false;
                    }
                }
                ++n3;
            }
            if (this.arrTextVideoPort[n4].isEnabled()) {
                string = this.arrTextVideoPort[n4].getText();
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                if (n2 < 0 || (n2 & 1) == 1) {
                    if (bl) {
                        MessageDialog.createErrorDialog(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.error.video.port")) + " " + (n4 + 1));
                    }
                    return false;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.nAudioCount) {
            n3 = 0;
            while (n3 < 4) {
                if (this.arrTextAudioTrackAddress[n4][n3].isEnabled()) {
                    string = this.arrTextAudioTrackAddress[n4][n3].getText();
                    try {
                        n2 = Integer.valueOf(string);
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    if (n2 < 0 || n2 > 255) {
                        if (bl) {
                            MessageDialog.createErrorDialog(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.error.audio.sessionaddr")) + " " + (n4 + 1));
                        }
                        return false;
                    }
                }
                ++n3;
            }
            if (this.arrTextAudioPort[n4].isEnabled()) {
                string = this.arrTextAudioPort[n4].getText();
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                if (n2 < 0 || (n2 & 1) == 1) {
                    if (bl) {
                        MessageDialog.createErrorDialog(this.getFrame(), String.valueOf(JMFI18N.getResource("jmstudio.error.audio.port")) + " " + (n4 + 1));
                    }
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof TextField) {
            ((TextField)object).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof TextField) {
            ((TextField)object).select(1, 0);
        }
    }

    public String[] getAudioAddresses() {
        String[] stringArray = new String[this.nAudioCount];
        int n2 = 0;
        while (n2 < this.nAudioCount) {
            stringArray[n2] = this.arrTextAudioTrackAddress[n2][0].getText().trim();
            int n3 = 1;
            while (n3 < 4) {
                stringArray[n2] = String.valueOf(stringArray[n2]) + "." + this.arrTextAudioTrackAddress[n2][n3].getText().trim();
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getAudioPorts() {
        String[] stringArray = new String[this.nAudioCount];
        int n2 = 0;
        while (n2 < this.nAudioCount) {
            stringArray[n2] = this.arrTextAudioPort[n2].getText().trim();
            ++n2;
        }
        return stringArray;
    }

    public String[] getAudioTtls() {
        String[] stringArray = new String[this.nAudioCount];
        int n2 = 0;
        while (n2 < this.nAudioCount) {
            stringArray[n2] = this.arrComboAudioTtl[n2].getSelectedItem().trim();
            ++n2;
        }
        return stringArray;
    }

    public String[] getVideoAddresses() {
        String[] stringArray = new String[this.nVideoCount];
        int n2 = 0;
        while (n2 < this.nVideoCount) {
            stringArray[n2] = this.arrTextVideoTrackAddress[n2][0].getText().trim();
            int n3 = 1;
            while (n3 < 4) {
                stringArray[n2] = String.valueOf(stringArray[n2]) + "." + this.arrTextVideoTrackAddress[n2][n3].getText().trim();
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getVideoPorts() {
        String[] stringArray = new String[this.nVideoCount];
        int n2 = 0;
        while (n2 < this.nVideoCount) {
            stringArray[n2] = this.arrTextVideoPort[n2].getText().trim();
            ++n2;
        }
        return stringArray;
    }

    public String[] getVideoTtls() {
        String[] stringArray = new String[this.nVideoCount];
        int n2 = 0;
        while (n2 < this.nVideoCount) {
            stringArray[n2] = this.arrComboVideoTtl[n2].getSelectedItem().trim();
            ++n2;
        }
        return stringArray;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "North");
        Panel panel2 = new Panel(new GridLayout(0, 1));
        panel.add((Component)panel2, "North");
        panel2.add(new Label(JMFI18N.getResource("jmstudio.export.targetnw.label1")));
        panel2.add(new Label(JMFI18N.getResource("jmstudio.export.targetnw.label2")));
        this.panelLabels = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelLabels, "West");
        this.panelAddress = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelAddress, "Center");
        Panel panel3 = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panel3, "East");
        this.panelPort = new Panel(new GridLayout(0, 1, 6, 6));
        panel3.add((Component)this.panelPort, "Center");
        this.panelTtl = new Panel(new GridLayout(0, 1, 6, 6));
        panel3.add((Component)this.panelTtl, "East");
        this.arrTextVideoTrackAddress = new TextField[8][4];
        this.arrTextAudioTrackAddress = new TextField[8][4];
        this.arrTextVideoPort = new TextField[8];
        this.arrTextAudioPort = new TextField[8];
        this.arrComboVideoTtl = new Choice[8];
        this.arrComboAudioTtl = new Choice[8];
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            while (n3 < 4) {
                this.arrTextVideoTrackAddress[n2][n3] = new TextField();
                this.arrTextVideoTrackAddress[n2][n3].addTextListener(this);
                this.arrTextVideoTrackAddress[n2][n3].addFocusListener(this);
                this.arrTextAudioTrackAddress[n2][n3] = new TextField();
                this.arrTextAudioTrackAddress[n2][n3].addTextListener(this);
                this.arrTextAudioTrackAddress[n2][n3].addFocusListener(this);
                ++n3;
            }
            this.arrTextVideoPort[n2] = new TextField(5);
            this.arrTextVideoPort[n2].addFocusListener(this);
            this.arrTextAudioPort[n2] = new TextField(5);
            this.arrTextAudioPort[n2].addFocusListener(this);
            this.arrComboVideoTtl[n2] = new Choice();
            this.arrComboVideoTtl[n2].addItem("1");
            this.arrComboVideoTtl[n2].addItem("2");
            this.arrComboVideoTtl[n2].addItem("3");
            this.arrComboVideoTtl[n2].addItem("4");
            this.arrComboVideoTtl[n2].addItem("8");
            this.arrComboVideoTtl[n2].addItem("16");
            this.arrComboVideoTtl[n2].addItem("32");
            this.arrComboVideoTtl[n2].addItem("64");
            this.arrComboVideoTtl[n2].addItem("128");
            this.arrComboVideoTtl[n2].addItem("255");
            this.arrComboAudioTtl[n2] = new Choice();
            this.arrComboAudioTtl[n2].addItem("1");
            this.arrComboAudioTtl[n2].addItem("2");
            this.arrComboAudioTtl[n2].addItem("3");
            this.arrComboAudioTtl[n2].addItem("4");
            this.arrComboAudioTtl[n2].addItem("8");
            this.arrComboAudioTtl[n2].addItem("16");
            this.arrComboAudioTtl[n2].addItem("32");
            this.arrComboAudioTtl[n2].addItem("64");
            this.arrComboAudioTtl[n2].addItem("128");
            this.arrComboAudioTtl[n2].addItem("255");
            if (this.cfgJMApps != null) {
                JMAppsCfg.RtpData rtpData = this.cfgJMApps.getLastTransmitRtpData("Video " + (n2 + 1));
                if (rtpData != null) {
                    this.arrTextVideoTrackAddress[n2][0].setText(rtpData.strAddress0);
                    this.arrTextVideoTrackAddress[n2][1].setText(rtpData.strAddress1);
                    this.arrTextVideoTrackAddress[n2][2].setText(rtpData.strAddress2);
                    this.arrTextVideoTrackAddress[n2][3].setText(rtpData.strAddress3);
                    this.arrTextVideoPort[n2].setText(rtpData.strPort);
                    this.arrComboVideoTtl[n2].select(rtpData.strTtl);
                }
                if ((rtpData = this.cfgJMApps.getLastTransmitRtpData("Audio " + (n2 + 1))) != null) {
                    this.arrTextAudioTrackAddress[n2][0].setText(rtpData.strAddress0);
                    this.arrTextAudioTrackAddress[n2][1].setText(rtpData.strAddress1);
                    this.arrTextAudioTrackAddress[n2][2].setText(rtpData.strAddress2);
                    this.arrTextAudioTrackAddress[n2][3].setText(rtpData.strAddress3);
                    this.arrTextAudioPort[n2].setText(rtpData.strPort);
                    this.arrComboAudioTtl[n2].select(rtpData.strTtl);
                }
            }
            ++n2;
        }
    }

    public void saveData() {
        if (this.cfgJMApps == null) {
            return;
        }
        int n2 = 0;
        while (n2 < 8) {
            JMAppsCfg.RtpData rtpData = this.cfgJMApps.createRtpDataObject();
            rtpData.strAddress0 = this.arrTextVideoTrackAddress[n2][0].getText();
            rtpData.strAddress1 = this.arrTextVideoTrackAddress[n2][1].getText();
            rtpData.strAddress2 = this.arrTextVideoTrackAddress[n2][2].getText();
            rtpData.strAddress3 = this.arrTextVideoTrackAddress[n2][3].getText();
            rtpData.strPort = this.arrTextVideoPort[n2].getText();
            rtpData.strTtl = this.arrComboVideoTtl[n2].getSelectedItem();
            this.cfgJMApps.setLastTransmitRtpData(rtpData, "Video " + (n2 + 1));
            rtpData = this.cfgJMApps.createRtpDataObject();
            rtpData.strAddress0 = this.arrTextAudioTrackAddress[n2][0].getText();
            rtpData.strAddress1 = this.arrTextAudioTrackAddress[n2][1].getText();
            rtpData.strAddress2 = this.arrTextAudioTrackAddress[n2][2].getText();
            rtpData.strAddress3 = this.arrTextAudioTrackAddress[n2][3].getText();
            rtpData.strPort = this.arrTextAudioPort[n2].getText();
            rtpData.strTtl = this.arrComboAudioTtl[n2].getSelectedItem();
            this.cfgJMApps.setLastTransmitRtpData(rtpData, "Audio " + (n2 + 1));
            ++n2;
        }
    }

    public void setJMStudioCfg(JMAppsCfg jMAppsCfg) {
        this.cfgJMApps = jMAppsCfg;
        if (jMAppsCfg == null) {
            return;
        }
        int n2 = 0;
        while (n2 < 8) {
            JMAppsCfg.RtpData rtpData = jMAppsCfg.getLastTransmitRtpData("Video " + (n2 + 1));
            if (rtpData != null) {
                this.arrTextVideoTrackAddress[n2][0].setText(rtpData.strAddress0);
                this.arrTextVideoTrackAddress[n2][1].setText(rtpData.strAddress1);
                this.arrTextVideoTrackAddress[n2][2].setText(rtpData.strAddress2);
                this.arrTextVideoTrackAddress[n2][3].setText(rtpData.strAddress3);
                this.arrTextVideoPort[n2].setText(rtpData.strPort);
                this.arrComboVideoTtl[n2].select(rtpData.strTtl);
            }
            if ((rtpData = jMAppsCfg.getLastTransmitRtpData("Audio " + (n2 + 1))) != null) {
                this.arrTextAudioTrackAddress[n2][0].setText(rtpData.strAddress0);
                this.arrTextAudioTrackAddress[n2][1].setText(rtpData.strAddress1);
                this.arrTextAudioTrackAddress[n2][2].setText(rtpData.strAddress2);
                this.arrTextAudioTrackAddress[n2][3].setText(rtpData.strAddress3);
                this.arrTextAudioPort[n2].setText(rtpData.strPort);
                this.arrComboAudioTtl[n2].select(rtpData.strTtl);
            }
            ++n2;
        }
    }

    public void setTracks(boolean[] blArray, boolean[] blArray2) {
        int n2;
        Panel panel;
        String string = JMFI18N.getResource("jmstudio.export.targetnw.audio");
        String string2 = JMFI18N.getResource("jmstudio.export.targetnw.video");
        this.nVideoCount = blArray.length;
        this.nAudioCount = blArray2.length;
        this.panelLabels.removeAll();
        this.panelAddress.removeAll();
        this.panelPort.removeAll();
        this.panelTtl.removeAll();
        Label label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.track"), 1);
        this.panelLabels.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.sessionaddr"), 1);
        this.panelAddress.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.port"), 1);
        this.panelPort.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.ttl"), 1);
        this.panelTtl.add(label);
        int n3 = 0;
        while (n3 < this.nVideoCount) {
            label = new Label(String.valueOf(string2) + " " + (n3 + 1), 0);
            label.setEnabled(blArray[n3]);
            this.panelLabels.add(label);
            panel = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panel);
            n2 = 0;
            while (n2 < 4) {
                this.arrTextVideoTrackAddress[n3][n2].setEnabled(blArray[n3]);
                panel.add(this.arrTextVideoTrackAddress[n3][n2]);
                ++n2;
            }
            this.arrTextVideoPort[n3].setEnabled(blArray[n3]);
            this.panelPort.add(this.arrTextVideoPort[n3]);
            this.arrComboVideoTtl[n3].setEnabled(blArray[n3]);
            this.panelTtl.add(this.arrComboVideoTtl[n3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.nAudioCount) {
            label = new Label(String.valueOf(string) + " " + (n3 + 1), 0);
            label.setEnabled(blArray2[n3]);
            this.panelLabels.add(label);
            panel = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panel);
            n2 = 0;
            while (n2 < 4) {
                this.arrTextAudioTrackAddress[n3][n2].setEnabled(blArray2[n3]);
                panel.add(this.arrTextAudioTrackAddress[n3][n2]);
                ++n2;
            }
            this.arrTextAudioPort[n3].setEnabled(blArray2[n3]);
            this.panelPort.add(this.arrTextAudioPort[n3]);
            this.arrComboAudioTtl[n3].setEnabled(blArray2[n3]);
            this.panelTtl.add(this.arrComboAudioTtl[n3]);
            ++n3;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        TextField textField;
        String string;
        Object object = textEvent.getSource();
        if (object instanceof TextField && (string = (textField = (TextField)object).getText()).length() > 2) {
            textField.transferFocus();
        }
    }
}

