/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.Log;
import com.sun.media.rtsp.Connection;
import com.sun.media.rtsp.RtspListener;
import com.sun.media.rtsp.Server;
import com.sun.media.rtsp.protocol.Message;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class RtspManager {
    private Vector listeners = new Vector();
    private int connectionCounter;
    private Vector connections = new Vector();
    private String address;
    private int port;

    public RtspManager() {
        Server server = new Server(this);
        server.start();
    }

    public RtspManager(boolean bl) {
        if (bl) {
            Server server = new Server(this);
            server.start();
        }
    }

    public void addConnection(Socket socket) {
        ++this.connectionCounter;
        Connection connection = new Connection(this, this.connectionCounter, socket);
        this.connections.addElement(connection);
    }

    public void addListener(RtspListener rtspListener) {
        this.listeners.addElement(rtspListener);
    }

    public void closeConnection(int n2) {
        Connection connection = this.getConnection(n2);
        if (connection != null) {
            connection.close();
            this.connections.removeElement(connection);
        } else {
            System.out.println("connection not found!");
        }
    }

    public int createConnection(String string, int n2) {
        this.address = string;
        this.port = n2;
        int n3 = -1;
        try {
            Connection connection = new Connection(this, this.connectionCounter + 1, string.getBytes(), n2);
            this.connections.addElement(connection);
            n3 = connection.connectionId;
            ++this.connectionCounter;
        }
        catch (UnknownHostException unknownHostException) {
            Log.error("[EXCEPTION]: Unknown host.");
            n3 = -2;
        }
        catch (ConnectException connectException) {
            Log.error("[EXCEPTION]: Can't connect to server.");
            n3 = -3;
        }
        return n3;
    }

    public void dataIndication(int n2, Message message) {
        int n3 = 0;
        while (n3 < this.listeners.size()) {
            RtspListener rtspListener = (RtspListener)this.listeners.elementAt(n3);
            rtspListener.rtspMessageIndication(n2, message);
            ++n3;
        }
    }

    public Connection getConnection(int n2) {
        Connection connection = null;
        int n3 = 0;
        while (n3 < this.connections.size()) {
            Connection connection2 = (Connection)this.connections.elementAt(n3);
            if (connection2.connectionId == n2) {
                connection = connection2;
                break;
            }
            ++n3;
        }
        return connection;
    }

    public void removeConnection(int n2) {
        Connection connection = this.getConnection(n2);
        this.connections.removeElement(connection);
        int n3 = 0;
        while (n3 < this.listeners.size()) {
            RtspListener rtspListener = (RtspListener)this.listeners.elementAt(n3);
            rtspListener.rtspConnectionTerminated(n2);
            ++n3;
        }
    }

    public void removeListener(RtspListener rtspListener) {
        this.listeners.removeElement(rtspListener);
    }

    public boolean sendMessage(int n2, String string) {
        Log.comment("outgoing msg:");
        Log.comment(string);
        Connection connection = this.getConnection(n2);
        boolean bl = connection == null ? false : connection.sendData(string.getBytes());
        return bl;
    }
}

