/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.avi;

import com.sun.media.parser.video.AviParser;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.avi.FileDataSource;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;

public class DataSource
extends PushBufferDataSource {
    private String fileName;
    private javax.media.protocol.DataSource inputDataSource;
    private AviParser aviParser;
    private Track[] tracks;
    private Format[] formats;
    private int numTracks;
    private String contentType = "raw";
    private boolean connected = false;
    private PushBufferStream[] streams = new PushBufferStream[0];

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        MediaLocator mediaLocator = this.getLocator();
        if (mediaLocator == null) {
            System.err.println("medialocator is null");
            throw new IOException(String.valueOf(String.valueOf(this)) + ": connect() failed");
        }
        String string = mediaLocator.getRemainder();
        this.doConnect(string);
        this.streams = new PushBufferStream[this.numTracks];
        int n2 = 0;
        while (n2 < this.numTracks) {
            this.streams[n2] = new AviSourceStream(this.tracks[n2]);
            ++n2;
        }
        System.out.println("connected");
        this.connected = true;
    }

    public void disconnect() {
    }

    public void doConnect(String string) throws IOException {
        try {
            this.fileName = string;
            this.inputDataSource = new FileDataSource(string);
            this.inputDataSource.connect();
            this.aviParser = new AviParser();
            this.aviParser.setSource(this.inputDataSource);
            try {
                this.tracks = this.aviParser.getTracks();
            }
            catch (BadHeaderException badHeaderException) {
                throw new IOException("");
            }
            if (this.tracks == null || this.tracks.length <= 0) {
                throw new IOException("Unable to get the tracks");
            }
            int n2 = 0;
            while (n2 < this.tracks.length) {
                System.out.println(this.tracks[n2].getFormat().getEncoding());
                ++n2;
            }
            this.numTracks = this.tracks.length;
            this.formats = new Format[this.numTracks];
            int n3 = 0;
            while (n3 < this.numTracks) {
                System.out.println(this.tracks[n3]);
                this.formats[n3] = this.tracks[n3].getFormat();
                this.tracks[n3].setEnabled(true);
                ++n3;
            }
        }
        catch (IncompatibleSourceException incompatibleSourceException) {
            throw new IOException(incompatibleSourceException.getMessage());
        }
    }

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        System.out.println("avids: getContentType returns " + this.contentType);
        return this.contentType;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.streams;
    }

    public void start() throws IOException {
        int n2 = 0;
        while (n2 < this.numTracks) {
            if (this.streams[n2] != null) {
                ((AviSourceStream)this.streams[n2]).start();
            }
            ++n2;
        }
    }

    public void stop() throws IOException {
    }

    class AviSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        private BufferTransferHandler transferHandler = null;
        private boolean started = false;
        private Buffer buffer = new Buffer();
        private Format format;
        private Track track;

        AviSourceStream(Track track) {
            this.track = track;
            this.buffer.setData(null);
            this.format = track.getFormat();
        }

        public void connect() throws IOException {
        }

        void disconnect() {
        }

        public Format getFormat() {
            return this.format;
        }

        public synchronized void read(Buffer buffer) {
            if (this.buffer.getLength() > 0) {
                buffer.setOffset(this.buffer.getOffset());
                buffer.setData(this.buffer.getData());
                buffer.setLength(this.buffer.getLength());
                buffer.setTimeStamp(this.buffer.getTimeStamp());
                buffer.setFormat(this.format);
            } else {
                buffer.setLength(this.buffer.getLength());
            }
        }

        public void run() {
            while (true) {
                this.track.readFrame(this.buffer);
                AviSourceStream aviSourceStream = this;
                synchronized (aviSourceStream) {
                    if (this.transferHandler != null) {
                        this.transferHandler.transferData(this);
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }

        public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
            System.out.println("setTransferHandler: " + bufferTransferHandler);
            this.transferHandler = bufferTransferHandler;
        }

        void start() throws IOException {
            if (this.started) {
                return;
            }
            if (this.transferHandler != null) {
                new Thread(this).start();
                this.started = true;
            }
        }

        void stop() throws IOException {
            this.started = false;
        }
    }
}

