/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.RepConversion;
import oracle.jbo.domain.BaseLobDomain;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.LobStreamInterface;
import oracle.jbo.domain.Raw;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainInterface;
import oracle.jdbc.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.svcmsg.ResponseValues;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BlobDomain
extends BaseLobDomain
implements Serializable,
XMLDomainInterface,
LobStreamInterface {
    private static final long serialVersionUID = 3776103424947309941L;
    transient BLOB mylob;

    public BlobDomain() {
    }

    public BlobDomain(BLOB bLOB) {
        super((Datum)bLOB);
        this.mylob = bLOB;
    }

    public BlobDomain(byte[] byArray) {
        super(byArray);
    }

    public BlobDomain(BLOB bLOB, byte[] byArray) {
        super((Datum)bLOB, byArray);
        this.mylob = bLOB;
    }

    public BlobDomain(BlobDomain blobDomain, byte[] byArray) {
        super(blobDomain, byArray);
        try {
            if (blobDomain.lob != null) {
                this.syncLob((Datum)new BLOB((OracleConnection)blobDomain.mylob.getJavaSqlConnection()));
            }
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public BlobDomain(ResponseValues responseValues) {
        super(responseValues);
    }

    public void useBLOB(BLOB bLOB) {
        if (bLOB != null) {
            this.syncLob((Datum)bLOB);
            if (this.mDataModified && this.mData == null) {
                this.mDataModified = false;
            }
        }
    }

    public void prepareForDML(Object object) {
        if (this.mylob == null) {
            try {
                this.syncLob((Datum)BLOB.empty_lob());
                this.mClient = false;
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BlobDomain) {
            return super.equals(object);
        }
        return false;
    }

    protected String getXMLElementTag() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public Node getXMLContentNode(Document document) {
        byte[] byArray = this.toByteArray();
        Text text = document.createTextNode(byArray != null ? RepConversion.bArray2String((byte[])byArray) : "");
        return text;
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        return "#PCDATA";
    }

    public static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass(clazz);
    }

    public static BLOB createEmptyBLOB(Object object) {
        try {
            BLOB bLOB = BLOB.empty_lob();
            return bLOB;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.getOutputStream();
    }

    public InputStream getBinaryStream() {
        return this.getInputStream();
    }

    public byte[] getBytes(long l, int n) {
        if (this.mData != null) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.mData.getStorage(), (int)l, byArray, 0, n);
            return byArray;
        }
        if (this.mClient) {
            Method method = BlobDomain.getInvokeDomainMethod();
            try {
                if (this.mIndexString == null) {
                    this.getRemoteIdString();
                }
                byte[] byArray = (byte[])method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "getBytes", new String[]{Long.TYPE.getName(), Integer.TYPE.getName()}, new Object[]{new Long(l), new Integer(n)});
                return byArray;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        if (this.mylob != null) {
            return this.readBytesFromLob(l, n);
        }
        return null;
    }

    byte[] readBytesFromLob(long l, int n) {
        try {
            byte[] byArray = this.mylob.getBytes(l, n);
            return byArray;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    void writeBytesToLob() {
        try {
            this.mylob.putBytes(1L, this.mData.toByteArray());
            super.resetCachedData();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    OutputStream getInternalOutputStream() {
        try {
            OutputStream outputStream = this.mylob.getBinaryOutputStream();
            return outputStream;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    InputStream getInternalStream() {
        try {
            InputStream inputStream = this.mylob.getBinaryStream();
            return inputStream;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    InputStream getInternalDataStream() {
        return new ByteArrayInputStream(this.mData.toByteArray());
    }

    void syncLob(Datum datum) {
        this.mylob = (BLOB)datum;
        this.lob = this.mylob;
    }

    public long getLength() {
        if (this.mClient) {
            return super.getRemoteLength();
        }
        if (!this.mDataModified && this.mylob != null) {
            try {
                long l = this.mylob.length();
                return l;
            }
            catch (SQLException sQLException) {
                Diagnostic.println((String)"Warning : SQLException during BlobDomain.getLength()");
            }
        }
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0L;
    }

    public int getBufferSize() {
        if (this.mClient) {
            return super.getRemoteBufferSize();
        }
        if (!this.mDataModified && this.mylob != null) {
            try {
                int n = this.mylob.getBufferSize();
                return n;
            }
            catch (SQLException sQLException) {
                Diagnostic.println((String)"Warning : SQLException during BlobDomain.getLength()");
            }
        }
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0;
    }

    public int getBytes(long l, int n, byte[] byArray) {
        if (this.mClient) {
            byte[] byArray2 = this.getBytes(l, n);
            if (byArray2 != null) {
                n = byArray2.length;
                System.arraycopy(byArray2, 0, byArray, 0, n);
                return n;
            }
            return 0;
        }
        try {
            int n2 = this.mylob.getBytes(l, n, byArray);
            return n2;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public Writer getCharacterOutputStream() {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public void closeCharacterOutputStream() {
        this.closeOutputStream();
    }

    public static class 1facClass
    implements XMLDomainFactory {
        Class mAttrClass;

        1facClass(Class clazz) {
            this.mAttrClass = clazz;
        }

        public DomainInterface createDomainFromXMLElement(Element element) {
            try {
                BlobDomain blobDomain = (BlobDomain)this.mAttrClass.newInstance();
                Node node = element.getFirstChild();
                if (node != null) {
                    blobDomain.setBytes(Raw.readBytesFromXML(node));
                }
                BlobDomain blobDomain2 = blobDomain;
                return blobDomain2;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
    }
}

