/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.DomainValidationException;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.LobStreamInterface;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.BFILE;

public class BFileDomain
implements Serializable,
LobStreamInterface {
    private static final long serialVersionUID = -4600794293346504285L;
    transient ByteArrayOutputStream mData;
    private transient BFILE bFile;
    private transient Transaction xAct;
    static final String CLIENT_LOB_DOMAIN_INPUT = "oracle.jbo.client.remote.LobDomainInputStream";
    static final String CLIENT_APPMODULE_CLASS = "oracle.jbo.client.remote.ApplicationModuleImpl";
    private static final int MAX_CHUNK_SIZE = Short.MAX_VALUE;
    transient InputStream inStream;
    transient Reader inReader;
    transient DomainOwnerInterface mOwner;
    transient boolean mDataModified;
    transient boolean mClient;
    transient Integer relIdx;
    transient String mIndexString;
    private static /* synthetic */ Class class$oracle$jbo$Row;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$Object;
    private static /* synthetic */ Class class$oracle$jbo$Transaction;
    private static /* synthetic */ Class class$oracle$jbo$domain$DomainOwnerInterface;

    private /* synthetic */ void $init$() {
        this.mData = null;
        this.bFile = null;
        this.xAct = null;
        this.inReader = null;
        this.mOwner = null;
        this.mDataModified = false;
        this.mClient = false;
        this.relIdx = new Integer(-1);
        this.mIndexString = null;
    }

    public BFileDomain() {
        this.$init$();
    }

    public BFileDomain(BFILE bFILE) {
        this.$init$();
        this.bFile = bFILE;
    }

    public BFileDomain(BFILE bFILE, byte[] byArray) {
        this.$init$();
        this.bFile = bFILE;
        this.setBytes(byArray);
    }

    public BFileDomain(BFileDomain bFileDomain, byte[] byArray) {
        this.$init$();
        this.shareBFILE(bFileDomain);
        this.setBytes(byArray);
    }

    public void shareBFILE(BFileDomain bFileDomain) {
        if (this.bFile == null) {
            this.bFile = bFileDomain.bFile;
            try {
                this.bFile = new BFILE((OracleConnection)this.bFile.getJavaSqlConnection());
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public void useBFILE(BFILE bFILE) {
        if (this.bFile == null) {
            this.bFile = bFILE;
        }
    }

    public void setBytes(byte[] byArray) throws DomainValidationException {
    }

    public void loadFromDatabase(Transaction transaction) throws Exception {
        this.xAct = transaction;
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        this.xAct = transaction;
        this.mOwner = domainOwnerInterface;
        HashMap hashMap = (HashMap)object;
        Integer n = (Integer)hashMap.get((Object)"0");
        Integer n2 = this.relIdx = n != null ? n : this.relIdx;
        if (hashMap.get((Object)"3") != null) {
            this.mClient = true;
        }
        if (this.xAct instanceof ApplicationModule) {
            this.mClient = true;
        }
        this.mIndexString = null;
    }

    static Object invokeCreateCallableStatement(Transaction transaction, String string, int n) {
        try {
            Class<?> clazz = Class.forName("oracle.jbo.server.DBTransactionImpl");
            Class[] classArray = new Class[2];
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = BFileDomain.class$("java.lang.String");
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            Method method = clazz.getMethod("createCallableStatement", classArray);
            Object object = method.invoke((Object)transaction, string, new Integer(n));
            return object;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    private ByteArrayOutputStream dumpBFile(Transaction transaction, BFILE bFILE) {
        byte[] byArray = null;
        this.mData = new ByteArrayOutputStream();
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin dbms_lob.read (?, ?, ?, ?); end;", 1);
        try {
            bFILE = BFileDomain.fileopen(transaction, bFILE);
            long l = BFileDomain.getLength(transaction, bFILE);
            long l2 = 0L;
            int n = 31744;
            byArray = new byte[n];
            while (l2 < l) {
                oracleCallableStatement.setBfile(1, bFILE);
                oracleCallableStatement.setLong(2, (long)n);
                oracleCallableStatement.registerOutParameter(2, 2);
                oracleCallableStatement.setLong(3, l2 + 1L);
                oracleCallableStatement.registerOutParameter(4, -3);
                oracleCallableStatement.execute();
                long l3 = oracleCallableStatement.getLong(2);
                byte[] byArray2 = oracleCallableStatement.getBytes(4);
                this.mData.write(byArray2, 0, (int)l3);
                l2 += l3;
            }
            BFileDomain.fileclose(transaction, bFILE);
            BFileDomain.fileisopen(transaction, bFILE);
            oracleCallableStatement.close();
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        return this.mData;
    }

    private static long getLength(Transaction transaction, BFILE bFILE) throws SQLException {
        long l;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin ? := dbms_lob.getLength (?); end;", 1);
        try {
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBfile(2, bFILE);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            oracleCallableStatement.close();
            throw throwable;
        }
        oracleCallableStatement.close();
        return l;
    }

    private static boolean fileexists(Transaction transaction, BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin ? := dbms_lob.fileexists (?); end;", 1);
        try {
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBfile(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    private static String filegetname(Transaction transaction, BFILE bFILE) throws SQLException {
        String string;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin dbms_lob.filegetname (?, ?, ?); end;", 1);
        try {
            oracleCallableStatement.setBfile(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2) + oracleCallableStatement.getString(3);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    private static BFILE fileopen(Transaction transaction, BFILE bFILE) throws SQLException {
        BFILE bFILE2;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin dbms_lob.fileopen (?, 0); end;", 1);
        try {
            oracleCallableStatement.setBfile(1, bFILE);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE2 = oracleCallableStatement.getBFILE(1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            throw throwable;
        }
        oracleCallableStatement.close();
        return bFILE2;
    }

    private static boolean fileisopen(Transaction transaction, BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin ? := dbms_lob.fileisopen (?); end;", 1);
        try {
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBfile(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleCallableStatement.close();
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    private static void fileclose(Transaction transaction, BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)BFileDomain.invokeCreateCallableStatement(transaction, "begin dbms_lob.fileclose (?); end;", 1);
        oracleCallableStatement.setBfile(1, bFILE);
        oracleCallableStatement.execute();
        oracleCallableStatement.close();
    }

    public Object getData() {
        return this.bFile;
    }

    public void saveToDatabase(Transaction transaction) throws Exception {
        if (this.bFile == null || this.mData != null) {
            // empty if block
        }
    }

    public void saveToDatabase(Transaction transaction, Object object) throws SQLException {
        BFILE bFILE = ((BFileDomain)object).bFile;
        if (this.bFile != null) {
            this.bFile.setLocator(bFILE.getLocator());
        } else {
            this.useBFILE(bFILE);
        }
        if (this.mData == null) {
            this.mData = this.dumpBFile(transaction, this.bFile);
        }
    }

    public void prepareForDML(Object object) {
        if (this.bFile != null || this.mData != null) {
            // empty if block
        }
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public byte[] toByteArray() {
        if (this.mData == null && this.bFile != null) {
            this.mData = this.dumpBFile(this.xAct, this.bFile);
        }
        if (this.mData != null) {
            return this.mData.toByteArray();
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof BFileDomain;
    }

    public OutputStream getOutputStream() {
        OutputStream outputStream = null;
        return outputStream;
    }

    public void closeOutputStream() {
    }

    public InputStream getInputStream() {
        if (this.inStream != null) {
            return this.inStream;
        }
        if (this.bFile != null) {
            try {
                this.inStream = this.bFile.getBinaryStream();
            }
            catch (SQLException sQLException) {}
        } else if (this.mClient) {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            try {
                Class clazz;
                Class clazz2;
                Class<?> clazz3 = Class.forName(CLIENT_LOB_DOMAIN_INPUT);
                Class[] classArray = new Class[3];
                Class clazz4 = class$oracle$jbo$Transaction;
                if (clazz4 == null) {
                    clazz4 = classArray[0] = (class$oracle$jbo$Transaction = BFileDomain.class$("oracle.jbo.Transaction"));
                }
                if ((clazz2 = class$oracle$jbo$domain$DomainOwnerInterface) == null) {
                    clazz2 = classArray[1] = (class$oracle$jbo$domain$DomainOwnerInterface = BFileDomain.class$("oracle.jbo.domain.DomainOwnerInterface"));
                }
                if ((clazz = class$java$lang$String) == null) {
                    clazz = class$java$lang$String = BFileDomain.class$("java.lang.String");
                }
                classArray[2] = clazz;
                Constructor<?> constructor = clazz3.getConstructor(classArray);
                this.inStream = (InputStream)constructor.newInstance(this.xAct, this.getOwnerRow(), this.mIndexString);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof JboException) {
                    throw (JboException)throwable;
                }
                throw new JboException(throwable);
            }
        }
        return this.inStream;
    }

    public Reader getCharacterStream() {
        if (this.inReader != null) {
            return this.inReader;
        }
        this.inReader = new InputStreamReader(this.getInputStream());
        return this.inReader;
    }

    protected DomainOwnerInterface getOwnerRow() {
        DomainOwnerInterface domainOwnerInterface = this.mOwner;
        while (domainOwnerInterface instanceof LobInterface) {
            domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
        }
        return domainOwnerInterface instanceof Row ? domainOwnerInterface : null;
    }

    public String getRemoteIdString() {
        if (this.mIndexString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.relIdx.toString());
            DomainOwnerInterface domainOwnerInterface = this.mOwner;
            while (domainOwnerInterface instanceof LobInterface) {
                stringBuffer = stringBuffer.insert(0, '.');
                stringBuffer = stringBuffer.insert(0, new Integer(((LobInterface)domainOwnerInterface).getOwnerAttributeIndex()).toString());
                domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
            }
            this.mIndexString = stringBuffer.toString();
        }
        return this.mIndexString;
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            BFileDomain bFileDomain = (BFileDomain)lobInterface;
            this.bFile = bFileDomain.bFile;
            this.inStream = bFileDomain.inStream;
            this.mOwner = bFileDomain.mOwner;
            this.xAct = bFileDomain.xAct;
            this.mClient = bFileDomain.mClient;
            this.relIdx = bFileDomain.relIdx;
        }
    }

    public void syncClientLob(LobInterface lobInterface) {
    }

    public DomainOwnerInterface getOwner() {
        return this.mOwner;
    }

    public long getSize() {
        return -1;
    }

    public int getOwnerAttributeIndex() {
        return this.relIdx;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.relIdx);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.relIdx = (Integer)objectInputStream.readObject();
    }

    public void openFile() {
        if (this.mClient) {
            Method method = BFileDomain.getInvokeDomainMethod();
            try {
                if (this.mIndexString == null) {
                    this.getRemoteIdString();
                }
                method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "openFile", new String[0], new Object[0]);
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        try {
            this.bFile.openFile();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public void closeFile() {
        if (this.mClient) {
            Method method = BFileDomain.getInvokeDomainMethod();
            try {
                if (this.mIndexString == null) {
                    this.getRemoteIdString();
                }
                method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "closeFile", new String[0], new Object[0]);
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        try {
            this.bFile.closeFile();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public static Method getInvokeDomainMethod() {
        try {
            Method method;
            Class clazz;
            Class clazz2;
            Class clazz3;
            Class<?> clazz4 = Class.forName(CLIENT_APPMODULE_CLASS);
            Class[] classArray = new Class[6];
            Class clazz5 = class$oracle$jbo$Row;
            if (clazz5 == null) {
                clazz5 = classArray[0] = (class$oracle$jbo$Row = BFileDomain.class$("oracle.jbo.Row"));
            }
            if ((clazz3 = class$java$lang$String) == null) {
                clazz3 = class$java$lang$String = BFileDomain.class$("java.lang.String");
            }
            classArray[1] = clazz3;
            classArray[2] = Boolean.TYPE;
            Class clazz6 = class$java$lang$String;
            if (clazz6 == null) {
                clazz6 = classArray[3] = (class$java$lang$String = BFileDomain.class$("java.lang.String"));
            }
            if ((clazz2 = array$Ljava$lang$String) == null) {
                clazz2 = classArray[4] = (array$Ljava$lang$String = BFileDomain.class$("[Ljava.lang.String;"));
            }
            if ((clazz = array$Ljava$lang$Object) == null) {
                clazz = array$Ljava$lang$Object = BFileDomain.class$("[Ljava.lang.Object;");
            }
            classArray[5] = clazz;
            Method method2 = method = clazz4.getMethod("invokeDomainMethod", classArray);
            return method2;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public void closeInputStream() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inStream = null;
        }
    }

    public void closeCharacterStream() {
        if (this.inReader != null) {
            try {
                this.inReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inReader = null;
        }
    }

    public Writer getCharacterOutputStream() {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public void closeCharacterOutputStream() {
        this.closeOutputStream();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

