/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.util.ArrayList;
import java.util.List;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordUtils;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;

public class KeywordIndexItem
implements TopicBaseBean {
    public boolean indented = false;
    public String displayLabel = null;
    public String sortingLabel = null;
    public String convertedLabel = null;
    public static final String STATUS_DIRECT_LINK = "topic";
    public static final String STATUS_HAS_TOPICS = "topiclist";
    private ArrayList _keywordNodes = null;
    private List _topics = null;
    private int _id = 0;

    public KeywordIndexItem(String string, String string2, String string3, boolean bl) {
        this.displayLabel = string;
        this.sortingLabel = string2;
        this.convertedLabel = string3;
        this.indented = bl;
        this._keywordNodes = new ArrayList(1);
    }

    public void addNode(TopicTreeNode topicTreeNode) {
        this._keywordNodes.add(topicTreeNode);
        this._topics = null;
    }

    public void removeNode(View view) {
        int n = this._keywordNodes.size() - 1;
        while (n >= 0) {
            TopicTreeNode topicTreeNode = (TopicTreeNode)this._keywordNodes.get(n);
            if (topicTreeNode.getView() == view) {
                this._keywordNodes.remove(n);
            }
            --n;
        }
        this._topics = null;
    }

    public int getNodeCount() {
        return this._keywordNodes.size();
    }

    public TopicTreeNode getNodeByIndex(int n) {
        TopicTreeNode topicTreeNode = null;
        if (n < this._keywordNodes.size()) {
            topicTreeNode = (TopicTreeNode)this._keywordNodes.get(n);
        }
        return topicTreeNode;
    }

    public List getEntries() {
        if (this._topics != null) {
            return this._topics;
        }
        this._topics = KeywordUtils.getEntriesFromKeywordListItem(this);
        return this._topics;
    }

    public void clearEntries() {
        this._topics = null;
    }

    public boolean getIndent() {
        return this.indented;
    }

    public String getLinkStatus() {
        if (this.getEntries().size() <= 1) {
            return STATUS_DIRECT_LINK;
        }
        return STATUS_HAS_TOPICS;
    }

    public String getText() {
        return this.displayLabel;
    }

    public String getSortingText() {
        return this.sortingLabel;
    }

    public Topic getTopic() {
        List list = this.getEntries();
        if (list.size() == 1) {
            return ((TopicBaseBean)list.get(0)).getTopic();
        }
        return null;
    }

    public String getSource() {
        return null;
    }

    public int getTopicId() {
        return this._id;
    }

    public void setTopicId(int n) {
        this._id = n;
    }

    public TopicTreeNode getTopicTreeNode() {
        throw new UnsupportedOperationException();
    }
}

