/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotValidateEvent;
import oracle.bali.ewt.table.TableEvent;

class GridResizer
extends MouseAdapter
implements MouseMotionListener {
    private static final int _TARGET = 5;
    private static final int _MIN_SIZE = 2;
    private int _resizeItem = -1;
    private int _resizeOffset;
    private boolean _itemResized;
    private int _column;
    private int _row;
    private PivotHeader _header;

    public GridResizer(PivotHeader pivotHeader) {
        this._header = pivotHeader;
        this._header.getGrid().addMouseListener(this);
        this._header.getGrid().addMouseMotionListener(this);
    }

    public void dispose() {
        this._header.getGrid().removeMouseListener(this);
        this._header.getGrid().removeMouseMotionListener(this);
        this._header = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point point = grid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = grid.getColumnAt(point.x);
        int n3 = grid.getRowAt(point.y);
        if (n2 < 0 || n3 < 0) {
            grid.setCursor(Cursor.getDefaultCursor());
            return;
        }
        Point point2 = grid.getCanvasOrigin();
        int n4 = mouseEvent.getX() + -point2.x - grid.getColumnPosition(n2);
        if (this._isResizing(grid, n2, n3, n4, n = mouseEvent.getY() + -point2.y - grid.getRowPosition(n3)) != -1) {
            grid.setCursor(this._getResizeCursor());
            mouseEvent.consume();
        } else {
            grid.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        if (!bl) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point point = grid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = grid.getColumnAt(point.x);
        int n2 = grid.getRowAt(point.y);
        if (n < 0 || n2 < 0) {
            return;
        }
        Point point2 = grid.getCanvasOrigin();
        int n3 = mouseEvent.getX() + -point2.x - grid.getColumnPosition(n);
        int n4 = mouseEvent.getY() + -point2.y - grid.getRowPosition(n2);
        this._resizeItem = this._isResizing(grid, n, n2, n3, n4);
        if (this._resizeItem != -1) {
            int n5;
            int n6;
            int n7;
            boolean bl2 = GridResizer._isHorizontal(this._header);
            if (bl2) {
                n7 = 2001;
                n6 = this._resizeItem;
                n5 = -1;
            } else {
                n7 = 2003;
                n6 = -1;
                n5 = this._resizeItem;
            }
            if (this._fireCancelableTableEvent(n7, n6, n5)) {
                this._header.getGrid().setCursor(this._getResizeCursor());
                this._header.setResizeItem(this._resizeItem);
                this._resizeOffset = bl2 ? point.x - (grid.getColumnPosition(this._resizeItem) + grid.getColumnWidth(this._resizeItem)) : point.y - (grid.getRowPosition(this._resizeItem) + grid.getRowHeight(this._resizeItem));
                this._column = n;
                this._row = n2;
                PivotTable pivotTable = this._header.getPivotTable();
                if (pivotTable != null) {
                    pivotTable.getPivotGrid().setCurrentlyResizing(true);
                }
                mouseEvent.consume();
            } else {
                this._header.getGrid().setCursor(Cursor.getDefaultCursor());
                this._resizeItem = -1;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            this._itemResized = true;
            this._setSize(mouseEvent, false);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            int n;
            int n2;
            int n3;
            PivotTable pivotTable = this._header.getPivotTable();
            if (pivotTable != null) {
                pivotTable.getPivotGrid().setCurrentlyResizing(false);
            }
            if (this._itemResized) {
                this._setSize(mouseEvent, true);
                this._itemResized = false;
            } else {
                this._header.setResizeItem(-1);
            }
            if (GridResizer._isHorizontal(this._header)) {
                n3 = 2002;
                n2 = this._resizeItem;
                n = -1;
            } else {
                n3 = 2004;
                n2 = -1;
                n = this._resizeItem;
            }
            this._fireTableEvent(n3, n2, n);
            this._header.getGrid().setCursor(Cursor.getDefaultCursor());
            mouseEvent.consume();
        }
        this._resizeItem = -1;
        this._resizeOffset = 0;
    }

    private int _isResizing(Grid grid, int n, int n2, int n3, int n4) {
        Header header;
        PivotTable pivotTable = this._header.getPivotTable();
        if (pivotTable == null) {
            return -1;
        }
        PivotGrid pivotGrid = pivotTable.getPivotGrid();
        boolean bl = GridResizer._isHorizontal(this._header);
        Header header2 = header = bl ? pivotGrid.getColumnHeader() : pivotGrid.getRowHeader();
        if (!header.getCanResizeItems()) {
            return -1;
        }
        int n5 = 0;
        n5 = bl ? n2 : n;
        if (!this._header.isLevelResizable(n5)) {
            return -1;
        }
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, n, n2);
        if (abstractBigCell != null) {
            return this._isResizing(grid, n, n2, abstractBigCell, n3, n4);
        }
        return -1;
    }

    private int _isResizing(Grid grid, int n, int n2, AbstractBigCell abstractBigCell, int n3, int n4) {
        boolean bl;
        int n5;
        int n6;
        int n7;
        Point point = this._convertPoint(grid, abstractBigCell, n, n2, n3, n4);
        boolean bl2 = GridResizer._isHorizontal(this._header);
        if (bl2) {
            n7 = point.x;
            n6 = grid.getNextVisibleColumn(abstractBigCell.getColumn() - 1);
            n5 = grid.getPreviousVisibleColumn(n6 + abstractBigCell.getColumnCount());
        } else {
            n7 = point.y;
            n6 = grid.getNextVisibleRow(abstractBigCell.getRow() - 1);
            n5 = grid.getPreviousVisibleRow(n6 + abstractBigCell.getRowCount());
        }
        int n8 = bl2 ? this._getWidth(grid, abstractBigCell) : this._getHeight(grid, abstractBigCell);
        boolean bl3 = n7 >= n8 - 5;
        boolean bl4 = bl = n7 >= 0 && n7 <= 5;
        if (!bl3 && !bl) {
            return -1;
        }
        if (bl3) {
            return n5;
        }
        if (bl) {
            int n9;
            int n10 = n9 = bl2 ? grid.getPreviousVisibleColumn(n6) : grid.getPreviousVisibleRow(n6);
            if (n9 >= 0) {
                return n9;
            }
        }
        return -1;
    }

    private void _setSize(MouseEvent mouseEvent, boolean bl) {
        Grid grid = this._header.getGrid();
        Point point = grid.getCanvasOrigin();
        int n = mouseEvent.getX() + -point.x - grid.getColumnPosition(this._column);
        int n2 = mouseEvent.getY() + -point.y - grid.getRowPosition(this._row);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, this._column, this._row);
        if (abstractBigCell == null) {
            this._setSize(grid, this._column, this._row, n, n2, bl);
        } else {
            this._setSize(grid, this._column, this._row, abstractBigCell, n, n2, bl);
        }
    }

    private void _setSize(Grid grid, int n, int n2, int n3, int n4, boolean bl) {
    }

    private void _setSize(Grid grid, int n, int n2, AbstractBigCell abstractBigCell, int n3, int n4, boolean bl) {
        PivotTable pivotTable = this._header.getPivotTable();
        int n5 = 0;
        if (GridResizer._isHorizontal(this._header)) {
            int n6;
            int n7;
            if (n != this._resizeItem) {
                abstractBigCell = AbstractBigCell.getBigCell(grid, this._resizeItem, n2);
            }
            n5 = (n7 = grid.getPreviousVisibleColumn(abstractBigCell.getColumn() + abstractBigCell.getColumnCount())) == n ? n3 : this._header.getColumnWidth(n7) + n3;
            int n8 = this._header.getGrid().getColumnGeometryManager().getMinimumItemSize(n7);
            if ((n5 -= this._resizeOffset) < n8) {
                n5 = n8;
            }
            if (n5 > (n6 = this._header.getGrid().getColumnGeometryManager().getMaximumItemSize(n7))) {
                n5 = n6;
            }
            if (bl && pivotTable.getEqualSizedColumns()) {
                pivotTable.tryDefaultColumns();
                this._header.setColumnWidth(n7, -1);
                this.trySetColumnWidth(n7, -1, false);
                pivotTable.setDefaultColumnWidth(n5);
            } else {
                pivotTable.setColumnWidth(n7, n5);
            }
        } else {
            int n9;
            int n10;
            if (n2 != this._resizeItem) {
                abstractBigCell = AbstractBigCell.getBigCell(grid, n, this._resizeItem);
            }
            n5 = (n10 = grid.getPreviousVisibleRow(abstractBigCell.getRow() + abstractBigCell.getRowCount())) == n2 ? n4 : this._header.getRowHeight(n10) + n4;
            int n11 = this._header.getGrid().getRowGeometryManager().getMinimumItemSize(n10);
            if ((n5 -= this._resizeOffset) < n11) {
                n5 = n11;
            }
            if (n5 > (n9 = this._header.getGrid().getRowGeometryManager().getMaximumItemSize(n10))) {
                n5 = n9;
            }
            if (bl && pivotTable.getEqualSizedRows()) {
                pivotTable.tryDefaultRows();
                this._header.setRowHeight(n10, -1);
                this.trySetRowHeight(n10, -1);
                pivotTable.setDefaultRowHeight(n5);
            } else {
                pivotTable.setRowHeight(n10, n5);
            }
        }
        if (bl) {
            this._header.setResizeItem(-1);
        }
    }

    private int _getWidth(Grid grid, AbstractBigCell abstractBigCell) {
        int n = 0;
        int n2 = abstractBigCell.getColumn();
        int n3 = abstractBigCell.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            if (grid.isColumnVisible(n4 + n2)) {
                n += grid.getColumnWidth(n4 + n2);
            }
            ++n4;
        }
        return n;
    }

    private int _getHeight(Grid grid, AbstractBigCell abstractBigCell) {
        int n = 0;
        int n2 = abstractBigCell.getRow();
        int n3 = abstractBigCell.getRowCount();
        int n4 = 0;
        while (n4 < n3) {
            if (grid.isRowVisible(n4 + n2)) {
                n += grid.getRowHeight(n4 + n2);
            }
            ++n4;
        }
        return n;
    }

    private Cursor _getResizeCursor() {
        if (GridResizer._isHorizontal(this._header)) {
            return Cursor.getPredefinedCursor(10);
        }
        return Cursor.getPredefinedCursor(9);
    }

    private static boolean _isHorizontal(PivotHeader pivotHeader) {
        return pivotHeader.getOrientation() == 0;
    }

    private void trySetColumnWidth(int n, int n2, boolean bl) {
        PivotGrid pivotGrid = this._header.getPivotTable().getPivotGrid();
        int n3 = pivotGrid.getGrid().getColumnCount();
        if (n < n3) {
            pivotGrid.setColumnWidth(n, n2);
        }
    }

    private void trySetRowHeight(int n, int n2) {
        PivotGrid pivotGrid = this._header.getPivotTable().getPivotGrid();
        int n3 = pivotGrid.getGrid().getRowCount();
        if (n < n3) {
            pivotGrid.setRowHeight(n, n2);
        }
    }

    private boolean _fireCancelableTableEvent(int n, int n2, int n3) {
        PivotTable pivotTable = this._header.getPivotTable();
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(pivotTable, n, n2, n3);
        pivotTable.postEvent(pivotValidateEvent);
        return !pivotValidateEvent.isCancelled();
    }

    private void _fireTableEvent(int n, int n2, int n3) {
        PivotTable pivotTable = this._header.getPivotTable();
        TableEvent tableEvent = new TableEvent(pivotTable, n, n2, n3);
        pivotTable.postEvent(tableEvent);
    }

    private Point _convertPoint(Grid grid, AbstractBigCell abstractBigCell, int n, int n2, int n3, int n4) {
        int n5 = abstractBigCell.getColumn();
        while (n5 < n) {
            if (grid.isColumnVisible(n5)) {
                n3 += grid.getColumnWidth(n5);
            }
            ++n5;
        }
        int n6 = abstractBigCell.getRow();
        while (n6 < n2) {
            if (grid.isRowVisible(n6)) {
                n4 += grid.getRowHeight(n6);
            }
            ++n6;
        }
        return new Point(n3, n4);
    }
}

