/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;

public class StandardGridKeyHandler
implements GridKeyHandler {
    private static StandardGridKeyHandler _sManager;

    protected StandardGridKeyHandler() {
    }

    public void handleKeyEvent(Grid grid, KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            return;
        }
        GridSelectionManager gridSelectionManager = grid.getGridSelectionManager();
        Cell cell = grid.getFocusCell();
        Cell cell2 = null;
        Cell cell3 = grid.getAnchorCell();
        boolean bl = false;
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isShiftDown();
        int n = keyEvent.getID();
        boolean bl4 = true;
        if (n == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    cell2 = this.enter(grid, cell, keyEvent, bl3);
                    break;
                }
                case 40: {
                    cell2 = this.down(grid, cell, keyEvent);
                    break;
                }
                case 38: {
                    cell2 = this.up(grid, cell, keyEvent);
                    break;
                }
                case 37: {
                    cell2 = this.left(grid, cell, keyEvent);
                    break;
                }
                case 39: {
                    cell2 = this.right(grid, cell, keyEvent);
                    break;
                }
                case 35: {
                    cell2 = this.end(grid, cell, keyEvent);
                    break;
                }
                case 36: {
                    cell2 = this.home(grid, cell, keyEvent);
                    break;
                }
                case 34: {
                    cell2 = this.pageDown(grid, cell, keyEvent);
                    grid.setFirstRowOnScreen(cell2.row);
                    keyEvent.consume();
                    bl4 = false;
                    break;
                }
                case 33: {
                    cell2 = this.pageUp(grid, cell, keyEvent);
                    grid.setLastRowOnScreen(cell2.row);
                    keyEvent.consume();
                    bl4 = false;
                    break;
                }
                case 32: {
                    if (!keyEvent.isControlDown()) break;
                    bl = true;
                    cell2 = cell;
                }
            }
        }
        if (!bl && (cell2 == null || cell != null && cell2.column == cell.column && cell2.row == cell.row)) {
            return;
        }
        keyEvent.consume();
        grid.freezeRepaints();
        try {
            try {
                if (bl) {
                    TwoDSelection twoDSelection = new TwoDSelection(null, null, cell2);
                    if (gridSelectionManager.getSelection().containsCell(cell2)) {
                        gridSelectionManager.removeSelection(twoDSelection);
                    } else {
                        gridSelectionManager.addSelection(twoDSelection);
                    }
                    grid.setAnchorCell(cell2.column, cell2.row);
                } else if (bl3 && cell3 != null) {
                    TwoDSelection twoDSelection = grid.getModelRangeSelection(cell2.column, cell2.row, cell3.column, cell3.row);
                    if (bl2) {
                        gridSelectionManager.addSelection(twoDSelection);
                    } else {
                        gridSelectionManager.setSelection(twoDSelection, cell2);
                    }
                } else if (!bl2) {
                    TwoDSelection twoDSelection = new TwoDSelection(null, null, cell2);
                    gridSelectionManager.setSelection(twoDSelection, cell2);
                    grid.setAnchorCell(cell2.column, cell2.row);
                }
                grid.requestFocus(cell2.column, cell2.row, keyEvent);
            }
            catch (PropertyVetoException propertyVetoException) {
                Object var15_17 = null;
                grid.unfreezeRepaints();
            }
            Object var15_16 = null;
            grid.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            grid.unfreezeRepaints();
            throw throwable;
        }
        if (bl4) {
            grid.scrollCellIntoView(cell2.column, cell2.row);
        }
    }

    protected Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
        grid.commitCellEdit();
        if (bl) {
            return this.up(grid, cell, keyEvent);
        }
        return this.down(grid, cell, keyEvent);
    }

    protected Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        keyEvent.consume();
        if (cell == null) {
            n2 = grid.getNextVisibleRow(-1);
            n = grid.getNextVisibleColumn(-1);
        } else {
            n2 = cell.row;
            n = grid.getPreviousVisibleColumn(cell.column);
        }
        if (n == -1) {
            return cell;
        }
        return new Cell(n, n2);
    }

    protected Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        keyEvent.consume();
        if (cell == null) {
            n2 = grid.getNextVisibleRow(-1);
            n = grid.getNextVisibleColumn(-1);
        } else {
            n2 = cell.row;
            n = grid.getNextVisibleColumn(cell.column);
        }
        if (n == -1) {
            return cell;
        }
        return new Cell(n, n2);
    }

    protected Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        keyEvent.consume();
        if (cell == null) {
            n2 = grid.getNextVisibleRow(-1);
            n = grid.getNextVisibleColumn(-1);
        } else {
            n2 = grid.getPreviousVisibleRow(cell.row);
            n = cell.column;
        }
        if (n2 == -1) {
            return cell;
        }
        return new Cell(n, n2);
    }

    protected Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        keyEvent.consume();
        if (cell == null) {
            n2 = grid.getNextVisibleRow(-1);
            n = grid.getNextVisibleColumn(-1);
        } else {
            n2 = grid.getNextVisibleRow(cell.row);
            n = cell.column;
        }
        if (n2 == -1) {
            return cell;
        }
        return new Cell(n, n2);
    }

    protected Cell pageUp(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        int n3;
        keyEvent.consume();
        if (cell == null) {
            n3 = grid.getNextVisibleRow(-1);
            n2 = grid.getNextVisibleColumn(-1);
        } else {
            n3 = cell.row;
            n2 = cell.column;
        }
        if (n3 <= 0) {
            return cell;
        }
        if (-grid.getCanvasOriginY() == 0) {
            return new Cell(n2, grid.getNextVisibleRow(-1));
        }
        int n4 = -grid.getCanvasOriginY() - grid.getInnerHeight();
        n3 = grid.getRowAt(-grid.getCanvasOriginY() - 1);
        boolean bl = false;
        if (n4 < 0 && grid.getRowPosition(n3 = grid.getRowAt(grid.getInnerHeight() - 1)) + grid.getRowHeight(n3) > grid.getInnerHeight()) {
            bl = true;
        }
        if (!bl && (n = grid.getRowAt(-grid.getCanvasOriginY() + grid.getInnerHeight() - 1)) == n3) {
            bl = true;
        }
        if (bl && (n = grid.getPreviousVisibleRow(n3)) != -1) {
            n3 = n;
        }
        return new Cell(n2, n3);
    }

    protected Cell pageDown(Grid grid, Cell cell, KeyEvent keyEvent) {
        int n;
        int n2;
        int n3;
        keyEvent.consume();
        if (cell == null) {
            n3 = grid.getNextVisibleRow(-1);
            n2 = grid.getNextVisibleColumn(-1);
        } else {
            n3 = cell.row;
            n2 = cell.column;
        }
        if (n3 < 0 || n3 == grid.getRowCount() - 1) {
            return cell;
        }
        int n4 = grid.getInnerHeight();
        int n5 = -grid.getCanvasOriginY() + n4;
        n3 = grid.getRowAt(n5);
        boolean bl = false;
        if (-grid.getCanvasOriginY() + grid.getInnerHeight() + n4 > grid.getCanvasHeight()) {
            n4 = grid.getCanvasHeight() - (-grid.getCanvasOriginY() + grid.getInnerHeight());
            if (n4 == 0) {
                return new Cell(n2, grid.getPreviousVisibleRow(grid.getRowCount()));
            }
            n5 = -grid.getCanvasOriginY() + n4;
            n3 = grid.getRowAt(n5);
            if (grid.getRowPosition(n3) < n5) {
                bl = true;
            }
        }
        if (!bl && (n = grid.getRowAt(-grid.getCanvasOriginY())) == n3) {
            bl = true;
        }
        if (bl && (n = grid.getNextVisibleRow(n3)) != -1) {
            n3 = n;
        }
        return new Cell(n2, n3);
    }

    protected Cell home(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getNextVisibleRow(-1);
        if (cell == null || cell.row == n) {
            return cell;
        }
        return new Cell(cell.column, n);
    }

    protected Cell end(Grid grid, Cell cell, KeyEvent keyEvent) {
        keyEvent.consume();
        int n = grid.getRowCount();
        int n2 = grid.getPreviousVisibleRow(n);
        if (cell == null || cell.row == n2) {
            return cell;
        }
        return new Cell(cell.column, n2);
    }

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new StandardGridKeyHandler();
        }
        return _sManager;
    }
}

