/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import oracle.bali.ewt.dTree.DTreeActivateListener;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeEditListener;
import oracle.bali.ewt.dTree.DTreeEmptyDecoration;
import oracle.bali.ewt.dTree.DTreeEvent;
import oracle.bali.ewt.dTree.DTreeExpandedEnumeration;
import oracle.bali.ewt.dTree.DTreeExpansionListener;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeItemValidateEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.dTree.DTreeSingleSelectionManager;
import oracle.bali.ewt.dTree.DTreeToolTipManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.event.ListenerManager;

public class DTree
extends ScrollableComponent
implements Accessible {
    public static final String PROPERTY_SELECTION = "selection";
    public static final int DROP_STYLE_NONE = 0;
    public static final int DROP_STYLE_INTO = 1;
    public static final int DROP_STYLE_BEFORE = 2;
    public static final int DROP_STYLE_AFTER = 3;
    private DTreeItem _makeVisibleItem;
    private DTreeItem _makeChildrenVisibleItem;
    private MakeVisibleRunnable _makeVisibleRunnable;
    private MakeChildVisibleRunnable _makeChildVisibleRunnable;
    private DTreeRootItem _root;
    private DTreeItem _focused;
    private int _indentwd;
    private int _rowheight;
    private int _nositems;
    private int _noslevels;
    private int _layoutFrozenLevel;
    private DTreeSelectionManager _selManager = new DTreeSingleSelectionManager();
    private DTreeDecoration _decoration;
    private ListenerManager _activatelm;
    private ListenerManager _editlm;
    private ListenerManager _expandlm;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private DTreeItem _mousePressItem;
    private DTreeItem _dropItem;
    private int _dropStyle;
    private boolean _editable;
    private DTreeItem _editItem;
    private Component _editor;
    private EditDismisser _editDismisser;
    private boolean _selectedAtPress;
    private ActionListener _keyboardListener;
    private DTreeToolTipManager _toolTipManager;
    private boolean _layoutValid;
    private Dimension _canvasSize;
    private SelectionListener _selListener;
    private Vector _selections;
    private static final int _DEFAULT_INDENTWIDTH = 18;
    private static final int _DEFAULT_ITEMS_ON_SCREEN = 20;
    private static final int _DEFAULT_LEVELS_ON_SCREEN = 5;
    private static final int _PREFERRED_WIDTH_ADJUSTMENT = 100;
    private static final int _MINIMUM_WIDTH_OF_EDITOR = 100;

    public static DTreeItem getCommonAncestor(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        DTreeItem dTreeItem3 = dTreeItem;
        while (dTreeItem3 != null) {
            if (DTree.isItemDescendent(dTreeItem2, dTreeItem3)) {
                return dTreeItem3;
            }
            dTreeItem3 = dTreeItem3.getParent();
        }
        return null;
    }

    public static boolean isItemBefore(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        DTreeItem dTreeItem3 = DTree.getCommonAncestor(dTreeItem, dTreeItem2);
        if (dTreeItem3 == dTreeItem) {
            return true;
        }
        if (dTreeItem3 == dTreeItem2) {
            return false;
        }
        DTreeItem dTreeItem4 = dTreeItem;
        DTreeItem dTreeItem5 = dTreeItem2;
        while (dTreeItem4.getParent() != dTreeItem3) {
            dTreeItem4 = dTreeItem4.getParent();
        }
        while (dTreeItem5.getParent() != dTreeItem3) {
            dTreeItem5 = dTreeItem5.getParent();
        }
        return dTreeItem4.getIndex() < dTreeItem5.getIndex();
    }

    public static boolean isItemDescendent(DTreeItem dTreeItem, DTreeItem dTreeItem2) {
        while (dTreeItem != null) {
            if (dTreeItem == dTreeItem2) {
                return true;
            }
            dTreeItem = dTreeItem.getParent();
        }
        return false;
    }

    public static boolean isItemVisible(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        if (dTreeItem2 == null) {
            return dTreeItem.getTree() != null;
        }
        return dTreeItem2.isExpanded() && DTree.isItemVisible(dTreeItem2);
    }

    public DTree() {
        this(null);
    }

    public DTree(DTreeRootItem dTreeRootItem) {
        this._selManager.setTree(this);
        this._selListener = new SelectionListener();
        this._selManager.addPropertyChangeListener(this._selListener);
        this._selManager.addVetoableChangeListener(this._selListener);
        if (this._decoration == null) {
            this._decoration = DTreeEmptyDecoration.getInstance();
        }
        this._indentwd = 18;
        this._nositems = 20;
        this._noslevels = 5;
        this._canvasSize = new Dimension(0, 0);
        this.enableEvents(56L);
        this.updateUI();
        this._setRoot(dTreeRootItem);
    }

    public final void addActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm == null) {
            this._activatelm = new ListenerManager();
        }
        this._activatelm.addListener((EventListener)dTreeActivateListener);
    }

    public final void addEditListener(DTreeEditListener dTreeEditListener) {
        if (this._editlm == null) {
            this._editlm = new ListenerManager();
        }
        this._editlm.addListener((EventListener)dTreeEditListener);
    }

    public final void addExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm == null) {
            this._expandlm = new ListenerManager();
        }
        this._expandlm.addListener((EventListener)dTreeExpansionListener);
    }

    public void cancelEdit() {
        this._endEdit(false);
    }

    public boolean commitEdit() {
        return this._endEdit(true);
    }

    public void freezeLayouts() {
        ++this._layoutFrozenLevel;
    }

    public DTreeDecoration getDecoration() {
        return this._decoration;
    }

    public DTreeItem getDropHighlightItem() {
        return this._dropItem;
    }

    public int getDropHighlightStyle() {
        return this._dropStyle;
    }

    public Enumeration getExpandedEnumeration() {
        return new DTreeExpandedEnumeration(this);
    }

    public DTreeItem getFocusedItem() {
        this._focused = this._getFocusedItem(this._focused);
        return this._focused;
    }

    public int getIndentWidth() {
        return this._indentwd;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (this._root == null) {
            return null;
        }
        return this._root.getItemAt(n, n2);
    }

    public DTreeItem getDraggableItemAt(int n, int n2) {
        DTreeItem dTreeItem = this.getItemAt(n, n2);
        if (dTreeItem == null) {
            return null;
        }
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n3 = point.x;
        int n4 = point.x + rectangle.x + rectangle.width;
        if (n3 < n && n < n4) {
            return dTreeItem;
        }
        return null;
    }

    public int getPreferredItemsOnScreen() {
        return this._nositems;
    }

    public int getPreferredLevelsOnScreen() {
        return this._noslevels;
    }

    public DTreeItem getPreviousVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        DTreeItem dTreeItem3 = dTreeItem.getParent();
        int n = dTreeItem.getIndex();
        if (n > 0) {
            dTreeItem2 = dTreeItem3.getItem(n - 1);
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = dTreeItem3;
        } else if (dTreeItem2.isExpanded()) {
            dTreeItem2 = this._getLastVisibleItem(dTreeItem2);
        }
        if (dTreeItem2 == this.getRoot()) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    public final DTreeItem getNextVisibleItem(DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded() && dTreeItem.getItemCount() > 0) {
            return dTreeItem.getItem(0);
        }
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        while (dTreeItem2 != null) {
            int n = dTreeItem.getIndex();
            if (n < dTreeItem2.getItemCount() - 1) {
                return dTreeItem2.getItem(n + 1);
            }
            dTreeItem = dTreeItem2;
            dTreeItem2 = dTreeItem2.getParent();
        }
        return null;
    }

    public DTreeRootItem getRoot() {
        return this._root;
    }

    public final DTreeSelection getSelection() {
        return this.getSelectionManager().getSelection();
    }

    public DTreeSelectionManager getSelectionManager() {
        return this._selManager;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isEditing() {
        return this._editItem != null;
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
        Cloneable cloneable;
        Object object;
        if (!DTree.isItemVisible(dTreeItem) || !dTreeItem.isExpanded()) {
            return;
        }
        if (this.getFont() == null) {
            this._invalidateTreeLayout();
            return;
        }
        DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
        dTreeSelectionManager.itemsAdded(dTreeItem, n, n2);
        if (this._selections != null) {
            object = this._selections.elements();
            while (object.hasMoreElements()) {
                cloneable = (DTreeSelection)object.nextElement();
                cloneable.__itemsAdded(dTreeItem, n, n2);
            }
        }
        this._layoutValid = false;
        if (this._layoutFrozenLevel > 0) {
            return;
        }
        object = this.layoutCanvas();
        this.setCanvasSize(((Dimension)object).width, ((Dimension)object).height);
        cloneable = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        DTreeItem dTreeItem2 = dTreeItem.getItem(n);
        if (dTreeItem2 == null) {
            return;
        }
        int n3 = dTreeItem2.getY();
        if (n3 < -((Point)cloneable).y) {
            this.repaint();
        } else if (n3 < -((Point)cloneable).y + dimension.height) {
            this.repaint();
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsInvalidated(DTreeItem dTreeItem, int n, int n2) {
        if (!this._isTreeLayoutValid()) {
            this.repaint();
        } else {
            DTreeItem dTreeItem2 = dTreeItem.getItem(n);
            DTreeItem dTreeItem3 = dTreeItem.getItem(n + n2 - 1);
            Dimension dimension = this.getInnerSize();
            Point point = this._convertCanvasToInner(0, dTreeItem2.getY());
            Point point2 = this._convertCanvasToInner(0, dTreeItem3.getY());
            point2.y += dTreeItem3.getSize().height;
            if (point.y < dimension.height && point2.y > 0) {
                this.repaint();
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
        if (DTree.isItemVisible(dTreeItem) && dTreeItem.isExpanded()) {
            this._invalidateTreeLayout();
        }
        DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
        dTreeSelectionManager.itemsRemoved(dTreeItem, n, n2);
        if (this._selections != null) {
            Enumeration enumeration = this._selections.elements();
            while (enumeration.hasMoreElements()) {
                DTreeSelection dTreeSelection = (DTreeSelection)enumeration.nextElement();
                dTreeSelection.__itemsRemoved(dTreeItem, n, n2);
            }
        }
        this._fireVisibleDataPropertyChange();
    }

    public void makeVisible(DTreeItem dTreeItem) {
        this._makeVisible(dTreeItem, true);
    }

    public void removeActivateListener(DTreeActivateListener dTreeActivateListener) {
        if (this._activatelm != null) {
            this._activatelm.removeListener((EventListener)dTreeActivateListener);
        }
    }

    public void removeEditListener(DTreeEditListener dTreeEditListener) {
        if (this._editlm != null) {
            this._editlm.removeListener((EventListener)dTreeEditListener);
        }
    }

    public void removeExpansionListener(DTreeExpansionListener dTreeExpansionListener) {
        if (this._expandlm != null) {
            this._expandlm.removeListener((EventListener)dTreeExpansionListener);
        }
    }

    public void setDecoration(DTreeDecoration dTreeDecoration) {
        DTreeDecoration dTreeDecoration2 = this.getDecoration();
        if (dTreeDecoration2 != dTreeDecoration) {
            if (dTreeDecoration == null) {
                dTreeDecoration = DTreeEmptyDecoration.getInstance();
            }
            this._decoration = dTreeDecoration;
            this._invalidateTreeLayout();
        }
    }

    public void setDropHighlightItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getDropHighlightItem();
        if (dTreeItem2 != dTreeItem) {
            this._dropItem = dTreeItem;
            if (dTreeItem2 != null) {
                this._paintItemImmediate(dTreeItem2);
            }
            if (this._dropItem != null) {
                this._paintItemImmediate(this._dropItem);
                this.makeVisible(this._dropItem);
            }
        }
    }

    public void setDropHighlightStyle(int n) {
        int n2 = this.getDropHighlightStyle();
        if (n2 != n) {
            this._dropStyle = n;
            DTreeItem dTreeItem = this.getDropHighlightItem();
            if (dTreeItem != null) {
                this._paintItemImmediate(dTreeItem);
            }
        }
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this._registerF2(bl);
        }
    }

    public void setFocusedItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = this.getFocusedItem();
        if (dTreeItem2 != (dTreeItem = this._getFocusedItem(dTreeItem))) {
            this._focused = dTreeItem;
            this._paintItemImmediate(dTreeItem2);
            this._paintItemImmediate(this._focused);
            this.makeVisible(this._focused);
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleActiveDescendant", dTreeItem2, dTreeItem);
            }
        }
    }

    public void setIndentWidth(int n) {
        if (n != this._indentwd) {
            this._indentwd = n;
            this._invalidateTreeLayout();
        }
    }

    public void setPreferredItemsOnScreen(int n) {
        if (n != this._nositems) {
            this._nositems = n;
            this.invalidate();
        }
    }

    public void setPreferredLevelsOnScreen(int n) {
        if (n != this._noslevels) {
            this._noslevels = n;
            this.invalidate();
        }
    }

    public final void setSelection(DTreeSelection dTreeSelection) throws PropertyVetoException {
        this.getSelectionManager().setSelection(dTreeSelection);
    }

    public void setSelectionManager(DTreeSelectionManager dTreeSelectionManager) {
        if (this._selManager != dTreeSelectionManager) {
            this._selManager.setTree(null);
            this._selManager.removePropertyChangeListener(this._selListener);
            this._selManager.removeVetoableChangeListener(this._selListener);
            this._selManager = dTreeSelectionManager == null ? new DTreeSingleSelectionManager() : dTreeSelectionManager;
            this._selManager.setTree(this);
            this._selManager.addPropertyChangeListener(this._selListener);
            this._selManager.addVetoableChangeListener(this._selListener);
            this.repaintInterior();
        }
    }

    public void setRoot(DTreeRootItem dTreeRootItem) {
        this._setRoot(dTreeRootItem);
    }

    public boolean startEdit(DTreeItem dTreeItem) {
        if (!this.isEditable()) {
            return false;
        }
        this.cancelEdit();
        Component component = dTreeItem.startEdit();
        if (component == null) {
            return false;
        }
        DTreeItemValidateEvent dTreeItemValidateEvent = new DTreeItemValidateEvent(this, 2007, dTreeItem);
        this.processEvent(dTreeItemValidateEvent);
        if (dTreeItemValidateEvent.isCancelled()) {
            return false;
        }
        this._makeHorizontalVisible(dTreeItem);
        this._editor = component;
        this._editItem = dTreeItem;
        this._editDismisser = new EditDismisser();
        component.addKeyListener(this._editDismisser);
        component.addFocusListener(this._editDismisser);
        component.setVisible(true);
        this.add(component);
        component.setBounds(this._getEditBounds(dTreeItem));
        component.requestFocus();
        return true;
    }

    public void setToolTipManager(DTreeToolTipManager dTreeToolTipManager) {
        DTreeToolTipManager dTreeToolTipManager2 = this._toolTipManager;
        this._toolTipManager = dTreeToolTipManager;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this._toolTipManager == null) {
            if (dTreeToolTipManager2 != null) {
                toolTipManager.unregisterComponent(this);
            }
        } else if (dTreeToolTipManager2 == null) {
            toolTipManager.registerComponent(this);
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
    }

    public DTreeToolTipManager getToolTipManager() {
        return this._toolTipManager;
    }

    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._toolTipManager == null) {
            return super.getToolTipText(mouseEvent);
        }
        DTreeItem dTreeItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (dTreeItem == null) {
            return null;
        }
        return this._toolTipManager.getToolTipValue(this, dTreeItem);
    }

    public void unfreezeLayouts() {
        --this._layoutFrozenLevel;
        if (this._layoutFrozenLevel == 0) {
            this._invalidateTreeLayout();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDTree();
        }
        return this.accessibleContext;
    }

    public Dimension getMinimumSize() {
        return this.convertInnerToOuterSize(this.getIndentWidth(), this._rowheight);
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        DTreeItem dTreeItem = this.getItemAt(0, n + n4);
        if (dTreeItem != null) {
            n4 = dTreeItem.getY() - n;
        }
        return new Rectangle(n3, n4, n3, n4);
    }

    public Dimension getPreferredScrollableViewportSize() {
        this._validateTreeLayout();
        int n = this.getIndentWidth() * this.getPreferredLevelsOnScreen();
        int n2 = this._rowheight * this.getPreferredItemsOnScreen();
        return this.convertInnerToOuterSize(n += 100, n2);
    }

    public EWTTreeUI getUI() {
        return (EWTTreeUI)this.ui;
    }

    public String getUIClassID() {
        return "EWTTreeUI";
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void setCanvasOrigin(int n, int n2) {
        this.commitEdit();
        super.setCanvasOrigin(n, n2);
    }

    public void updateUI() {
        this.setUI((EWTTreeUI)UIManager.getUI(this));
        this.cancelEdit();
        this.updateEditorUI();
    }

    protected void updateEditorUI() {
        Component component;
        DTreeItem dTreeItem = this.getRoot();
        if (dTreeItem != null && (dTreeItem = dTreeItem.getItem(0)) != null && (component = dTreeItem.startEdit()) != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
            ((JComponent)component).setBorder(UIManager.getBorder("Tree.editorBorder"));
        }
    }

    protected Object getPaintData(Object object) {
        if (object.equals("Tree.expandedIcon") || object.equals("Tree.collapsedIcon")) {
            return UIManager.get(object);
        }
        return super.getPaintData(object);
    }

    protected int getRowCount() {
        return this._getVisibleItemCount();
    }

    protected int getVMaximum() {
        int n;
        Dimension dimension = this.getCanvasSize();
        if (this._rowheight == 0) {
            n = 0;
        } else {
            n = dimension.height / this._rowheight;
            if (dimension.height % this._rowheight != 0) {
                ++n;
            }
        }
        return n;
    }

    protected int getVOffsetOfValue(int n) {
        return -n * this._rowheight;
    }

    protected int getVValueOfOffset(int n) {
        int n2 = 0;
        if (this._rowheight != 0) {
            n2 = -n / this._rowheight;
            if (-n % this._rowheight != 0) {
                ++n2;
            }
        }
        return n2;
    }

    protected Dimension layoutCanvas() {
        if (this._root == null) {
            return new Dimension(0, 0);
        }
        if (this._isTreeLayoutValid()) {
            return new Dimension(this._canvasSize.width, this._canvasSize.height);
        }
        DTreeDecoration dTreeDecoration = this.getDecoration();
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(this);
        this._root.layout(immInsets.left, immInsets.top);
        int n = this._root.getSubTreeHeight() + immInsets.top + immInsets.bottom;
        int n2 = this.getRowCount();
        this._rowheight = n2 == 0 ? 0 : n / n2;
        this._canvasSize = new Dimension(this._root.getSubTreeWidth() + immInsets.left + immInsets.right, n);
        this._layoutValid = true;
        return new Dimension(this._canvasSize.width, this._canvasSize.height);
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        DTreeItem dTreeItem = this.getItemAt(0, rectangle.y);
        if (dTreeItem == null) {
            return;
        }
        DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
        DTreeItem dTreeItem2 = this.getFocusedItem();
        DTreeItem dTreeItem3 = this.getDropHighlightItem();
        int n = this.getDropHighlightStyle();
        DTreeDecoration dTreeDecoration = this.getDecoration();
        Dimension dimension = this.getCanvasSize();
        int n2 = dimension.width;
        ImmInsets immInsets = dTreeDecoration.getDecorationInsets(this);
        PaintContext paintContext = this.getPaintContext();
        this._repairDecoration(paintContext, graphics, dTreeItem.getParent(), dTreeDecoration);
        while (dTreeItem != null) {
            int n3 = dTreeItem.getX();
            int n4 = dTreeItem.getY();
            if (n4 > rectangle.y + rectangle.height) break;
            Dimension dimension2 = dTreeItem.getSize();
            if (n4 + dimension2.height > rectangle.y) {
                graphics.translate(0, n4);
                dTreeDecoration.paintDecoration(paintContext, graphics, dTreeItem, n3, dimension2.height);
                graphics.translate(n3, 0);
                boolean bl = this._editItem != dTreeItem && dTreeSelectionManager.isSelected(dTreeItem) || dTreeItem == dTreeItem3 && n == 1;
                this.paintItem(graphics, dTreeItem, bl, dTreeItem == dTreeItem2, dimension2.width, dimension2.height);
                graphics.translate(-n3, -n4);
            }
            if (n3 + dimension2.width + immInsets.right > n2) {
                n2 = n3 + dimension2.width + immInsets.right;
            }
            dTreeItem = this.getNextVisibleItem(dTreeItem);
        }
        if (n2 > dimension.width) {
            this.setCanvasSize(n2, dimension.height);
            this._invalidateTreeLayout();
        } else if (this._makeVisibleItem != null) {
            MakeVisibleRunnable makeVisibleRunnable = this._getMakeVisibleRunnable();
            makeVisibleRunnable.setToBeVisibleItem(this._makeVisibleItem);
            this._makeVisibleItem = null;
            SwingUtilities.invokeLater(makeVisibleRunnable);
        } else if (this._makeChildrenVisibleItem != null) {
            MakeChildVisibleRunnable makeChildVisibleRunnable = this._getMakeChildVisibleRunnable();
            makeChildVisibleRunnable.setToBeVisibleItem(this._makeChildrenVisibleItem);
            this._makeChildrenVisibleItem = null;
            SwingUtilities.invokeLater(makeChildVisibleRunnable);
        }
    }

    protected void paintItem(Graphics graphics, DTreeItem dTreeItem, boolean bl, boolean bl2, int n, int n2) {
        dTreeItem.paint(graphics, bl, this.hasFocus() && bl2, n, n2);
    }

    protected void processActivateEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._activatelm == null || (enumeration = this._activatelm.getListeners()) == null) {
            return;
        }
        if (dTreeItemEvent.getID() == 2004) {
            while (enumeration.hasMoreElements()) {
                DTreeActivateListener dTreeActivateListener = (DTreeActivateListener)enumeration.nextElement();
                dTreeActivateListener.dTreeItemActivate(dTreeItemEvent);
            }
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DTreeEvent) {
            switch (aWTEvent.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processExpansionEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2004: {
                    this.processActivateEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
                case 2007: 
                case 2008: 
                case 2009: {
                    this.processEditEvent((DTreeItemEvent)aWTEvent);
                    break;
                }
            }
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processEditEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        if (this._editlm == null || (enumeration = this._editlm.getListeners()) == null) {
            return;
        }
        int n = dTreeItemEvent.getID();
        while (enumeration.hasMoreElements()) {
            DTreeEditListener dTreeEditListener = (DTreeEditListener)enumeration.nextElement();
            switch (n) {
                case 2007: {
                    dTreeEditListener.dTreeItemEditing(dTreeItemEvent);
                    break;
                }
                case 2008: {
                    dTreeEditListener.dTreeItemEdited(dTreeItemEvent);
                    break;
                }
                case 2009: {
                    dTreeEditListener.dTreeItemEditCancelled(dTreeItemEvent);
                }
            }
        }
    }

    protected void processExpansionEvent(DTreeItemEvent dTreeItemEvent) {
        Enumeration enumeration;
        int n = dTreeItemEvent.getID();
        if (this._expandlm != null && (enumeration = this._expandlm.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                DTreeExpansionListener dTreeExpansionListener = (DTreeExpansionListener)enumeration.nextElement();
                switch (n) {
                    case 2000: {
                        dTreeExpansionListener.dTreeItemExpanding(dTreeItemEvent);
                        break;
                    }
                    case 2001: {
                        dTreeExpansionListener.dTreeItemExpanded(dTreeItemEvent);
                        break;
                    }
                    case 2002: {
                        dTreeExpansionListener.dTreeItemCollapsing(dTreeItemEvent);
                        break;
                    }
                    case 2003: {
                        dTreeExpansionListener.dTreeItemCollapsed(dTreeItemEvent);
                    }
                }
            }
        }
        DTreeItem dTreeItem = dTreeItemEvent.getItem();
        switch (n) {
            case 2002: {
                if (((Cancelable)((Object)dTreeItemEvent)).isCancelled()) break;
                DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
                dTreeSelectionManager.itemCollapsing(dTreeItemEvent);
                break;
            }
            case 2003: {
                this._invalidateTreeLayout();
                DTreeItem dTreeItem2 = this.getFocusedItem();
                if (!DTree.isItemDescendent(dTreeItem2, dTreeItem)) break;
                this.setFocusedItem(dTreeItem);
                break;
            }
            case 2001: {
                this._invalidateTreeLayout();
                if (this._layoutFrozenLevel != 0) break;
                this.invalidate();
                this.repaint();
                this._makeChildrenVisible(dTreeItem);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        AccessibleContext accessibleContext;
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004 || n == 1005) {
            this.repaint();
        }
        if ((accessibleContext = this.accessibleContext) != null && n == 1004) {
            accessibleContext.firePropertyChange("AccessibleActiveDescendant", null, this.getFocusedItem());
        }
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        DTreeItem dTreeItem = this.getFocusedItem();
        boolean bl = false;
        if (dTreeItem != null) {
            bl = dTreeItem.isExpanded();
            dTreeItem.processKeyEvent(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
        }
        if (keyEvent.getID() == 401 && !keyEvent.isAltDown()) {
            this._handleKeyboardAction(keyEvent, dTreeItem, bl);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 501) {
            this.requestFocus();
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._mousePressItem = dTreeItem;
                DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
                this._selectedAtPress = dTreeSelectionManager.isSelected(dTreeItem);
                ImmInsets immInsets = this.getBorderInsets();
                int n2 = dTreeItem.getX();
                int n3 = dTreeItem.getY();
                mouseEvent.translatePoint(-immInsets.left, -immInsets.top - n3);
                DTreeDecoration dTreeDecoration = this.getDecoration();
                dTreeDecoration.processMouseEvent(mouseEvent, dTreeItem);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                Point point2 = this.getCanvasOrigin();
                mouseEvent.translatePoint(-point2.x - n2, -point2.y);
                dTreeItem.processMouseEvent(mouseEvent);
                mouseEvent.translatePoint(point2.x + immInsets.left + n2, point2.y + immInsets.top + n3);
                if (mouseEvent.isConsumed()) {
                    return;
                }
            }
            if (dTreeItem == null || !this._selectedAtPress) {
                this._handleMouseSelection(mouseEvent, dTreeItem, point);
            }
        } else if (n == 502) {
            if (this._mousePressItem != null) {
                if (this._mousePressItem.getTree() == this) {
                    this._dispatchItemMouseEvent(mouseEvent, this._mousePressItem);
                }
                this._mousePressItem = null;
            }
        } else if (n == 500) {
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._dispatchItemMouseEvent(mouseEvent, dTreeItem);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                if (this._selectedAtPress && mouseEvent.getClickCount() == 1) {
                    this._handleMouseSelection(mouseEvent, dTreeItem, point);
                }
                this._handleMouseEdit(mouseEvent, dTreeItem);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (mouseEvent.getID() == 503) {
            Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            DTreeItem dTreeItem = this.getItemAt(point.x, point.y);
            if (dTreeItem != null) {
                this._dispatchItemMouseEvent(mouseEvent, dTreeItem);
            }
        } else if (mouseEvent.getID() == 506 && this._mousePressItem != null) {
            if (this._mousePressItem.getTree() != this) {
                this._mousePressItem = null;
            } else {
                this._dispatchItemMouseEvent(mouseEvent, this._mousePressItem);
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    void __fireAccessibleEvent(String string, Object object, Object object2) {
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext == null) {
            return;
        }
        if ("AccessibleChild".equals(string)) {
            if (object instanceof Accessible) {
                object = ((Accessible)object).getAccessibleContext();
            }
            if (object2 instanceof Accessible) {
                object2 = ((Accessible)object2).getAccessibleContext();
            }
        }
        accessibleContext.firePropertyChange(string, object, object2);
    }

    void __addSelection(DTreeSelection dTreeSelection) {
        if (this._selections == null) {
            this._selections = new Vector(1, 1);
        }
        this._selections.addElement(dTreeSelection);
    }

    void __removeSelection(DTreeSelection dTreeSelection) {
        this._selections.removeElement(dTreeSelection);
    }

    private Point _convertCanvasToInner(int n, int n2) {
        Point point = this.getCanvasOrigin();
        point.x += n;
        point.y += n2;
        return point;
    }

    private void _dispatchItemMouseEvent(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        ImmInsets immInsets = this.getBorderInsets();
        int n = dTreeItem.getX();
        int n2 = dTreeItem.getY();
        Point point = this.getCanvasOrigin();
        mouseEvent.translatePoint(-point.x - immInsets.left - n, -point.y - immInsets.top - n2);
        dTreeItem.processMouseEvent(mouseEvent);
        mouseEvent.translatePoint(point.x + immInsets.left + n, point.y + immInsets.top + n2);
    }

    private boolean _endEdit(boolean bl) {
        if (!this.isEditing()) {
            return false;
        }
        this._editor.removeKeyListener(this._editDismisser);
        this._editor.removeFocusListener(this._editDismisser);
        this.remove(this._editor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DTree.this.requestFocus();
            }
        });
        int n = 2009;
        if (bl && this._editItem.commitEdit(this._editor)) {
            n = 2008;
        }
        DTreeItem dTreeItem = this._editItem;
        this._editItem = null;
        this._editor = null;
        this._editDismisser = null;
        this.processEvent(new DTreeItemEvent(this, n, dTreeItem));
        return n == 2008;
    }

    private void _fireVisibleDataPropertyChange() {
        AccessibleDTree accessibleDTree = (AccessibleDTree)this.accessibleContext;
        if (accessibleDTree != null) {
            accessibleDTree.fireVisibleDataPropertyChange();
        }
    }

    private Rectangle _getEditBounds(DTreeItem dTreeItem) {
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n = rectangle.width;
        int n2 = this.getCanvasSize().width - dTreeItem.getX();
        if (n >= n2) {
            n -= rectangle.x;
        }
        int n3 = point.x + rectangle.x;
        n = Math.max(n, 100);
        n = Math.min(n, n2 - rectangle.x);
        return new Rectangle(n3, point.y + rectangle.y, n, rectangle.height);
    }

    private Rectangle _getEditableBounds(DTreeItem dTreeItem) {
        Point point = this.convertCanvasToOuter(dTreeItem.getX(), dTreeItem.getY());
        Rectangle rectangle = dTreeItem.getEditBounds();
        int n = rectangle.width;
        int n2 = point.x + rectangle.x;
        return new Rectangle(n2, point.y + rectangle.y, n, rectangle.height);
    }

    private DTreeItem _getFirstVisibleItem() {
        int n;
        DTreeRootItem dTreeRootItem = this.getRoot();
        if (dTreeRootItem != null && (n = dTreeRootItem.getItemCount()) > 0) {
            return dTreeRootItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _getFocusedItem(DTreeItem dTreeItem) {
        if (dTreeItem == null || dTreeItem.getParent() == null || dTreeItem.getTree() == null) {
            DTreeRootItem dTreeRootItem = this.getRoot();
            dTreeItem = dTreeRootItem == null || dTreeRootItem.getItemCount() <= 0 ? null : dTreeRootItem.getItem(0);
        }
        return dTreeItem;
    }

    private DTreeItem _getLastVisibleItem() {
        return this._getLastVisibleItem(null);
    }

    private DTreeItem _getLastVisibleItem(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        if (dTreeItem2 == null) {
            dTreeItem2 = this.getRoot();
        }
        while (dTreeItem2 != null && dTreeItem2.isExpanded()) {
            int n = dTreeItem2.getItemCount();
            DTreeItem dTreeItem3 = null;
            if (n <= 0 || (dTreeItem3 = dTreeItem2.getItem(n - 1)) == null) break;
            dTreeItem2 = dTreeItem3;
        }
        if (dTreeItem2 == this.getRoot()) {
            return null;
        }
        return dTreeItem2;
    }

    private int _getRowsPerPage() {
        if (this._rowheight == 0) {
            return 0;
        }
        return this.getInnerSize().height / this._rowheight;
    }

    private int _getVisibleItemCount() {
        int n = 0;
        Enumeration enumeration = this.getExpandedEnumeration();
        while (enumeration.hasMoreElements()) {
            DTreeItem dTreeItem = (DTreeItem)enumeration.nextElement();
            n += dTreeItem.getItemCount();
        }
        return n;
    }

    private void _handleMouseEdit(MouseEvent mouseEvent, DTreeItem dTreeItem) {
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1) {
            Rectangle rectangle = this._getEditableBounds(dTreeItem);
            DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
            if (this._selectedAtPress && dTreeSelectionManager.isSelected(dTreeItem) && rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.startEdit(dTreeItem);
            }
        }
    }

    private void _handleKeyboardAction(KeyEvent keyEvent, DTreeItem dTreeItem, boolean bl) {
        if (dTreeItem == null) {
            if (this.getRoot() == null) {
                return;
            }
            dTreeItem = this.getRoot();
        }
        int n = keyEvent.getKeyCode();
        DTreeItem dTreeItem2 = null;
        switch (n) {
            case 32: {
                dTreeItem2 = this._handleSpace(keyEvent, dTreeItem);
                break;
            }
            case 38: {
                dTreeItem2 = this.getPreviousVisibleItem(dTreeItem);
                break;
            }
            case 40: {
                dTreeItem2 = this.getNextVisibleItem(dTreeItem);
                break;
            }
            case 36: {
                dTreeItem2 = this._getFirstVisibleItem();
                break;
            }
            case 35: {
                dTreeItem2 = this._getLastVisibleItem();
                break;
            }
            case 33: {
                dTreeItem2 = this._handlePageUp(dTreeItem);
                break;
            }
            case 34: {
                dTreeItem2 = this._handlePageDown(dTreeItem);
                break;
            }
            case 37: {
                dTreeItem2 = this._handleLeft(dTreeItem);
                break;
            }
            case 39: {
                dTreeItem2 = this._handleRight(dTreeItem);
            }
        }
        if (dTreeItem2 != null) {
            if (!keyEvent.isControlDown() || keyEvent.isShiftDown() || n == 32) {
                this._updateSelection(keyEvent, dTreeItem2);
            }
            this.setFocusedItem(dTreeItem2);
            keyEvent.consume();
        }
    }

    private void _handleKeyboardEdit(DTreeItem dTreeItem) {
        if (dTreeItem != null && dTreeItem != this.getRoot()) {
            this.startEdit(dTreeItem);
        }
    }

    private DTreeItem _handleLeft(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (!(dTreeItem == null || dTreeItem.isExpandable() && dTreeItem.isExpanded() || (dTreeItem2 = dTreeItem.getParent()) != this.getRoot())) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    private void _handleMouseSelection(MouseEvent mouseEvent, DTreeItem dTreeItem, Point point) {
        if (dTreeItem != null) {
            if (dTreeItem.getTree() == null) {
                dTreeItem = null;
            } else {
                int n = dTreeItem.getX();
                int n2 = dTreeItem.getSize().width;
                if (point.x < n || point.x >= n + n2) {
                    dTreeItem = null;
                }
            }
        }
        if (dTreeItem != null) {
            this._updateSelection(mouseEvent, dTreeItem);
        }
    }

    private DTreeItem _handlePageDown(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        int n = this._getRowsPerPage() - 1;
        while (n > 0 && dTreeItem2 != null) {
            dTreeItem2 = this.getNextVisibleItem(dTreeItem2);
            --n;
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getLastVisibleItem();
        }
        if (dTreeItem2 == this.getRoot()) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    private DTreeItem _handlePageUp(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem;
        int n = this._getRowsPerPage() - 1;
        while (n > 0 && dTreeItem2 != null) {
            dTreeItem2 = this.getPreviousVisibleItem(dTreeItem2);
            --n;
        }
        if (dTreeItem2 == null) {
            dTreeItem2 = this._getFirstVisibleItem();
        }
        if (dTreeItem2 == this.getRoot()) {
            dTreeItem2 = null;
        }
        return dTreeItem2;
    }

    private DTreeItem _handleRight(DTreeItem dTreeItem) {
        int n;
        if (dTreeItem != null && dTreeItem.isExpandable() && dTreeItem.isExpanded() && (n = dTreeItem.getItemCount()) > 0) {
            return dTreeItem.getItem(0);
        }
        return null;
    }

    private DTreeItem _handleSpace(KeyEvent keyEvent, DTreeItem dTreeItem) {
        if (keyEvent.isShiftDown() || keyEvent.isControlDown()) {
            return dTreeItem;
        }
        DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
        if (!dTreeSelectionManager.isSelected(dTreeItem) && dTreeItem.getParent() != null) {
            try {
                dTreeSelectionManager.toggleItem(dTreeItem);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        return null;
    }

    private void _makeChildrenVisible(DTreeItem dTreeItem) {
        this._makeChildrenVisible(dTreeItem, true);
    }

    private void _makeChildrenVisible(DTreeItem dTreeItem, boolean bl) {
        DTreeItem dTreeItem2 = this._getLastVisibleItem(dTreeItem);
        if (dTreeItem2 == null) {
            this.makeVisible(dTreeItem);
            return;
        }
        this._validateTreeLayout();
        Point point = this.getCanvasOrigin();
        int n = point.y;
        Rectangle rectangle = this.getInnerBounds();
        int n2 = dTreeItem.getY();
        int n3 = dTreeItem2.getY();
        int n4 = dTreeItem2.getSize().height;
        Point point2 = this._convertCanvasToInner(0, n3);
        if (point2.y < 0) {
            n = -n3;
        } else if (point2.y + n4 > rectangle.height) {
            n = rectangle.height - (n3 + n4);
        }
        if (n2 < -n) {
            n = -n2;
        }
        if (n != point.y) {
            if (bl) {
                this._makeChildrenVisibleItem = dTreeItem;
            }
            this.setCanvasOrigin(point.x, n);
        }
    }

    private void _makeHorizontalVisible(DTreeItem dTreeItem) {
        this.makeVisible(dTreeItem);
        Point point = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        int n = dTreeItem.getX();
        Point point2 = this._convertCanvasToInner(n, 0);
        int n2 = dTreeItem.getSize().width;
        int n3 = point.x;
        if (point2.x < 0) {
            n3 = -n;
        } else if (point2.x + n2 > rectangle.width && n + (n3 = rectangle.width - (n + n2)) < 0) {
            n3 = -n;
        }
        if (point.x != n3) {
            this.setCanvasOrigin(n3, point.y);
        }
    }

    private void _paintItemImmediate(DTreeItem dTreeItem) {
        if (dTreeItem == null || dTreeItem.getTree() != this || !DTree.isItemVisible(dTreeItem)) {
            return;
        }
        this._validateTreeLayout();
        int n = dTreeItem.getX();
        int n2 = dTreeItem.getY();
        Point point = this.convertCanvasToOuter(n, n2);
        Dimension dimension = dTreeItem.getSize();
        this.repaint(point.x, point.y, dimension.width, dimension.height);
    }

    private void _repairDecoration(PaintContext paintContext, Graphics graphics, DTreeItem dTreeItem, DTreeDecoration dTreeDecoration) {
        DTreeRootItem dTreeRootItem = this.getRoot();
        while (dTreeItem != dTreeRootItem) {
            int n = dTreeItem.getY();
            graphics.translate(0, n);
            dTreeDecoration.paintDecoration(paintContext, graphics, dTreeItem, dTreeItem.getX(), dTreeItem.getSize().height);
            graphics.translate(0, -n);
            dTreeItem = dTreeItem.getParent();
        }
    }

    private void _setRoot(DTreeRootItem dTreeRootItem) {
        if (this._root != dTreeRootItem) {
            try {
                this.setSelection(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            AccessibleContext accessibleContext = this.accessibleContext;
            if (this._root != null) {
                this._root.setTree(null);
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange("AccessibleChild", this._root.getAccessibleContext(), null);
                }
                this._root = null;
            }
            if (dTreeRootItem != null) {
                this._root = dTreeRootItem;
                this._root.setTree(this);
                this._root.setExpanded(true);
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange("AccessibleChild", null, this._root.getAccessibleContext());
                }
            }
            this._invalidateTreeLayout();
        }
    }

    private void _updateSelection(InputEvent inputEvent, DTreeItem dTreeItem) {
        DTreeSelectionManager dTreeSelectionManager = this.getSelectionManager();
        this.freezeRepaints();
        try {
            block6: {
                try {
                    if (inputEvent.isShiftDown()) {
                        dTreeSelectionManager.extendSelection(dTreeItem);
                        break block6;
                    }
                    if (inputEvent.isControlDown()) {
                        dTreeSelectionManager.toggleItem(dTreeItem);
                        break block6;
                    }
                    dTreeSelectionManager.selectItem(dTreeItem);
                }
                catch (PropertyVetoException propertyVetoException) {
                    Object var6_5 = null;
                    this.unfreezeRepaints();
                }
            }
            Object var6_4 = null;
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unfreezeRepaints();
            throw throwable;
        }
    }

    private void _invalidateTreeLayout() {
        this._layoutValid = false;
        this.invalidateCanvas();
    }

    private boolean _isTreeLayoutValid() {
        return this._layoutValid;
    }

    private void _validateTreeLayout() {
        if (!this._layoutValid) {
            Dimension dimension = this.layoutCanvas();
            this.setCanvasSize(dimension.width, dimension.height);
            this._layoutValid = true;
        }
    }

    void __paintSelectionChanges(DTreeSelection dTreeSelection, DTreeSelection dTreeSelection2) {
        DTreeItem dTreeItem = this._getSingleSelectedItem(dTreeSelection);
        DTreeItem dTreeItem2 = this._getSingleSelectedItem(dTreeSelection2);
        if (dTreeItem != null && dTreeItem2 != null) {
            this._paintItemImmediate(dTreeItem);
            this._paintItemImmediate(dTreeItem2);
        } else {
            this.repaint();
        }
    }

    private DTreeItem _getSingleSelectedItem(DTreeSelection dTreeSelection) {
        if (dTreeSelection.getCount() != 1) {
            return null;
        }
        DTreeRange dTreeRange = dTreeSelection.getRange(0);
        if (dTreeRange.getCount() != 1) {
            return null;
        }
        DTreeItem dTreeItem = dTreeRange.getParent();
        return dTreeItem.getItem(dTreeRange.getStartIndex());
    }

    private void _registerF2(boolean bl) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
        if (bl) {
            if (this._keyboardListener == null) {
                this._keyboardListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DTreeItem dTreeItem = DTree.this.getFocusedItem();
                        if (dTreeItem != null) {
                            DTree.this._handleKeyboardEdit(dTreeItem);
                        }
                    }
                };
            }
            this.registerKeyboardAction(this._keyboardListener, "", keyStroke, 0);
        } else if (this._keyboardListener != null) {
            this.unregisterKeyboardAction(keyStroke);
        }
    }

    private void _makeVisible(DTreeItem dTreeItem, boolean bl) {
        Object object;
        if (dTreeItem == null) {
            return;
        }
        if (!DTree.isItemVisible(dTreeItem)) {
            object = dTreeItem.getParent();
            try {
                this.freezeLayouts();
                while (object != null) {
                    if (!object.isExpanded()) {
                        object.setExpanded(true);
                    }
                    object = object.getParent();
                }
                Object var5_4 = null;
                this.unfreezeLayouts();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.unfreezeLayouts();
                throw throwable;
            }
        }
        this._validateTreeLayout();
        object = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        int n = dTreeItem.getY();
        Point point = this._convertCanvasToInner(0, n);
        int n2 = dTreeItem.getSize().height;
        int n3 = ((Point)object).y;
        if (point.y < 0) {
            n3 = -n;
        } else if (point.y + n2 > rectangle.height) {
            n3 = rectangle.height - (n + n2);
        }
        if (((Point)object).y != n3) {
            if (bl) {
                this._makeVisibleItem = dTreeItem;
            }
            this.setCanvasOrigin(((Point)object).x, n3);
        }
    }

    private MakeVisibleRunnable _getMakeVisibleRunnable() {
        if (this._makeVisibleRunnable == null) {
            this._makeVisibleRunnable = new MakeVisibleRunnable();
        }
        return this._makeVisibleRunnable;
    }

    private MakeChildVisibleRunnable _getMakeChildVisibleRunnable() {
        if (this._makeChildVisibleRunnable == null) {
            this._makeChildVisibleRunnable = new MakeChildVisibleRunnable();
        }
        return this._makeChildVisibleRunnable;
    }

    private class MakeChildVisibleRunnable
    implements Runnable {
        private DTreeItem _toBeVisibleItem;

        private MakeChildVisibleRunnable() {
        }

        public void run() {
            DTree.this._makeChildrenVisible(this._toBeVisibleItem, false);
        }

        public void setToBeVisibleItem(DTreeItem dTreeItem) {
            this._toBeVisibleItem = dTreeItem;
        }
    }

    private class MakeVisibleRunnable
    implements Runnable {
        private DTreeItem _toBeVisibleItem;

        private MakeVisibleRunnable() {
        }

        public void run() {
            DTree.this._makeVisible(this._toBeVisibleItem, false);
        }

        public void setToBeVisibleItem(DTreeItem dTreeItem) {
            this._toBeVisibleItem = dTreeItem;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private SelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == DTree.PROPERTY_SELECTION) {
                DTreeSelection dTreeSelection = (DTreeSelection)propertyChangeEvent.getOldValue();
                DTreeSelection dTreeSelection2 = (DTreeSelection)propertyChangeEvent.getNewValue();
                DTree.this.__paintSelectionChanges(dTreeSelection, dTreeSelection2);
                DTree.this.firePropertyChange(DTree.PROPERTY_SELECTION, dTreeSelection, dTreeSelection2);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName() == DTree.PROPERTY_SELECTION) {
                DTree.this.fireVetoableChange(DTree.PROPERTY_SELECTION, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private class EditDismisser
    extends KeyAdapter
    implements FocusListener {
        private EditDismisser() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                DTree.this.commitEdit();
                keyEvent.consume();
            } else if (n == 27) {
                DTree.this.cancelEdit();
                keyEvent.consume();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            DTree.this.commitEdit();
        }

        public void focusGained(FocusEvent focusEvent) {
        }
    }

    protected class AccessibleDTree
    extends JComponent.AccessibleJComponent
    implements PropertyChangeListener,
    DTreeExpansionListener {
        public AccessibleDTree() {
            super(DTree.this);
            DTree.this.addPropertyChangeListener(this);
            DTree.this.addExpansionListener(this);
        }

        public int getAccessibleChildrenCount() {
            return DTree.this.getRoot() == null ? 0 : 1;
        }

        public Accessible getAccessibleChild(int n) {
            if (n == 0) {
                return DTree.this.getRoot();
            }
            return null;
        }

        public Accessible getAccessibleAt(Point point) {
            Point point2 = DTree.this.convertOuterToCanvas(point.x, point.y);
            return DTree.this.getItemAt(point2.x, point2.y);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(DTree.PROPERTY_SELECTION)) {
                DTreeSelection dTreeSelection = (DTreeSelection)propertyChangeEvent.getOldValue();
                DTreeSelection dTreeSelection2 = (DTreeSelection)propertyChangeEvent.getNewValue();
                this.firePropertyChange("AccessibleSelection", DTree.this.getFocusedItem(), null);
            }
        }

        public void dTreeItemExpanded(DTreeItemEvent dTreeItemEvent) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
            dTreeItem.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
        }

        public void dTreeItemCollapsed(DTreeItemEvent dTreeItemEvent) {
            DTreeItem dTreeItem = dTreeItemEvent.getItem();
            this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
            dTreeItem.getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
        }

        public void dTreeItemExpanding(DTreeItemEvent dTreeItemEvent) {
        }

        public void dTreeItemCollapsing(DTreeItemEvent dTreeItemEvent) {
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }
    }
}

