/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import oracle.ord.im.OrdHttpUploadException;
import oracle.ord.im.OrdMultipartUtil;

class OrdMultipartHeader {
    private String header;
    private String headerName;
    private String headerValue;
    private int entityCount;
    private String[] headerEntities;
    private String[] headerEntityValues;
    private static final int MAX_HEADER_ENTITIES = 4;
    private static final int SPACE = 32;
    private static final int QUOTES = 34;
    private static final int EQUALS = 61;
    private static final int COLON = 58;
    private static final int SEMI_COLON = 59;

    OrdMultipartHeader(String string, String string2, boolean bl) {
        this.header = String.valueOf(string) + ": " + string2;
        this.headerName = string;
        this.headerValue = string2;
        if (bl) {
            byte[] byArray = OrdMultipartUtil.stringToByteArray(string2);
            this.parseHeaderEntities(byArray, 0, byArray.length);
        }
    }

    OrdMultipartHeader(String string, boolean bl) throws OrdHttpUploadException {
        this.header = string;
        byte[] byArray = OrdMultipartUtil.stringToByteArray(string);
        this.parseNameValue(byArray, byArray.length, bl);
    }

    OrdMultipartHeader(byte[] byArray, int n, boolean bl) throws OrdHttpUploadException {
        this.header = OrdMultipartUtil.byteArrayToString(byArray, 0, n);
        this.parseNameValue(byArray, n, bl);
    }

    String getHeader() {
        return this.header;
    }

    String getHeaderEntity(int n) {
        if (n <= 4) {
            return this.headerEntities[n];
        }
        return null;
    }

    String getHeaderEntityValue(int n) {
        if (n <= 4) {
            return this.headerEntityValues[n];
        }
        return null;
    }

    String getHeaderName() {
        return this.headerName;
    }

    String getHeaderValue() {
        return this.headerValue;
    }

    private void parseHeaderEntities(byte[] byArray, int n, int n2) {
        this.headerEntities = new String[4];
        this.headerEntityValues = new String[4];
        int n3 = n;
        this.entityCount = 0;
        while (this.entityCount < 4) {
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            n4 = n3;
            block1: while (n3 < n2) {
                byte by = byArray[n3];
                if (by == 59 || by == 61) {
                    n5 = n3++;
                    if (by == 59) break;
                    byte by2 = byArray[n3];
                    if (by2 == 34) {
                        ++n3;
                    } else {
                        by2 = 59;
                    }
                    n6 = n3;
                    while (n3 < n2) {
                        by = byArray[n3];
                        if (by == by2) {
                            n7 = n3++;
                            if (by2 != 34) break block1;
                            ++n3;
                            break block1;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n3;
            }
            if (n4 >= 0) {
                if (n5 < 0) {
                    n5 = n2;
                }
                this.headerEntities[this.entityCount] = OrdMultipartUtil.byteArrayToString(byArray, n4, n5 - n4);
            }
            if (n6 >= 0) {
                if (n7 < 0) {
                    n7 = n2;
                }
                this.headerEntityValues[this.entityCount] = OrdMultipartUtil.byteArrayToString(byArray, n6, n7 - n6);
            }
            while (n3 < n2) {
                if (byArray[n3] != 32) break;
                ++n3;
            }
            if (n3 >= n2) break;
            ++this.entityCount;
        }
    }

    private void parseNameValue(byte[] byArray, int n, boolean bl) throws OrdHttpUploadException {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 58) {
                this.headerName = OrdMultipartUtil.byteArrayToString(byArray, 0, n2);
                break;
            }
            ++n2;
        }
        if (this.headerName == null) {
            throw new OrdHttpUploadException(108, this.header);
        }
        ++n2;
        while (n2 < n) {
            if (byArray[n2] != 32) {
                this.headerValue = OrdMultipartUtil.byteArrayToString(byArray, n2, n - n2);
                if (!bl) break;
                this.parseHeaderEntities(byArray, n2, n);
                break;
            }
            ++n2;
        }
    }
}

