/*
 * Decompiled with CFR 0.152.
 */
package jndi.url.metadata;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import jndi.MetadataContext;

public class MetadataURLContext
implements Context {
    protected Hashtable myEnv;

    private /* synthetic */ void $init$() {
        this.myEnv = null;
    }

    public MetadataURLContext() {
        this.$init$();
    }

    protected MetadataURLContext(Hashtable hashtable) {
        this.$init$();
        this.myEnv = hashtable;
    }

    protected ResolveResult getRootURLContext(String string, Hashtable hashtable) throws NamingException {
        if (!string.startsWith("metadata:/")) {
            throw new IllegalArgumentException(string + " is not a metadata URL");
        }
        String string2 = string.length() > 10 ? string.substring(11) : null;
        CompositeName compositeName = new CompositeName();
        if (string2 != null) {
            compositeName.add(string2);
        }
        Context context = MetadataContext.getStaticNamespace(hashtable);
        return new ResolveResult((Object)context, compositeName);
    }

    protected Name getURLSuffix(String string, String string2) throws NamingException {
        String string3 = string2.substring(string.length());
        if (string3.length() == 0) {
            return new CompositeName();
        }
        if (string3.charAt(0) == '/') {
            string3 = string3.substring(1);
        }
        return new CompositeName().add(string3);
    }

    protected String getURLPrefix(String string) throws NamingException {
        int n = string.indexOf(":");
        if (n < 0) {
            throw new OperationNotSupportedException("Invalid URL: " + string);
        }
        if (string.startsWith("//", ++n)) {
            int n2 = string.indexOf("/", n += 2);
            n = n2 >= 0 ? n2 : string.length();
        }
        return string.substring(0, n);
    }

    protected boolean urlEquals(String string, String string2) {
        return string.equals(string2);
    }

    protected Context getContinuationContext(Name name) throws NamingException {
        Object object = this.lookup(name.get(0));
        CannotProceedException cannotProceedException = new CannotProceedException();
        cannotProceedException.setResolvedObj(object);
        cannotProceedException.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cannotProceedException);
    }

    public Object lookup(String string) throws NamingException {
        Object object;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookup(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public Object lookup(Name name) throws NamingException {
        Object object;
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            object = context.lookup(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public void bind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.bind(resolveResult.getRemainingName(), object);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.bind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.bind(name.getSuffix(1), object);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rebind(resolveResult.getRemainingName(), object);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.rebind(name.get(0), object);
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.rebind(name.getSuffix(1), object);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public void unbind(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.unbind(resolveResult.getRemainingName());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.unbind(name.getSuffix(1));
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public void rename(String string, String string2) throws NamingException {
        String string3;
        String string4 = this.getURLPrefix(string);
        if (!this.urlEquals(string4, string3 = this.getURLPrefix(string2))) {
            throw new OperationNotSupportedException("Renaming using different URL prefixes not supported : " + string + " " + string2);
        }
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.rename(resolveResult.getRemainingName(), this.getURLSuffix(string3, string2));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name.size() == 1) {
            if (name2.size() != 1) {
                throw new OperationNotSupportedException("Renaming to a Name with more components not supported: " + name2);
            }
            this.rename(name.get(0), name2.get(0));
        } else {
            if (!this.urlEquals(name.get(0), name2.get(0))) {
                throw new OperationNotSupportedException("Renaming using different URLs as first components not supported: " + name + " " + name2);
            }
            Context context = this.getContinuationContext(name);
            try {
                context.rename(name.getSuffix(1), name2.getSuffix(1));
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public NamingEnumeration list(String string) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            namingEnumeration = context.list(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration;
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            namingEnumeration = context.list(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration;
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            namingEnumeration = context.listBindings(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return namingEnumeration;
    }

    public void destroySubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            context.destroySubcontext(resolveResult.getRemainingName());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            Context context = this.getContinuationContext(name);
            try {
                context.destroySubcontext(name.getSuffix(1));
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
    }

    public Context createSubcontext(String string) throws NamingException {
        Context context;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context2 = (Context)resolveResult.getResolvedObj();
        try {
            context = context2.createSubcontext(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context2.close();
            throw throwable;
        }
        context2.close();
        return context;
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context context;
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        Context context2 = this.getContinuationContext(name);
        try {
            context = context2.createSubcontext(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context2.close();
            throw throwable;
        }
        context2.close();
        return context;
    }

    public Object lookupLink(String string) throws NamingException {
        Object object;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookupLink(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public Object lookupLink(Name name) throws NamingException {
        Object object;
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            object = context.lookupLink(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    public NameParser getNameParser(String string) throws NamingException {
        NameParser nameParser;
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            nameParser = context.getNameParser(resolveResult.getRemainingName());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return nameParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        NameParser nameParser;
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        Context context = this.getContinuationContext(name);
        try {
            nameParser = context.getNameParser(name.getSuffix(1));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return nameParser;
    }

    public String composeName(String string, String string2) throws NamingException {
        if (string2.equals("")) {
            return string;
        }
        if (string.equals("")) {
            return string2;
        }
        return string2 + "/" + string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        this.myEnv = (Hashtable)this.myEnv.clone();
        return this.myEnv.remove(string);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.myEnv = this.myEnv == null ? new Hashtable(11, 0.75f) : (Hashtable)this.myEnv.clone();
        return this.myEnv.put(string, object);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public void close() throws NamingException {
    }
}

