/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.inspector.beans.ArrayPropertyEditorFactory;
import oracle.bali.inspector.beans.BeansGroupProvider;
import oracle.bali.inspector.beans.BeansPropertyEditorFactory;
import oracle.bali.inspector.beans.DefaultBeansGroupProvider;
import oracle.bali.inspector.beans.FieldPropertyEditorFactory;
import oracle.bali.inspector.beans.IndexedModel;
import oracle.bali.share.beans.JavaIntrospector;
import oracle.bali.share.util.IntegerUtils;

public class BeansModel
extends PropertyModel {
    public static final int INDEX_COLUMN_ID = 0;
    public static final int INDEX_COLUMN_IS_DRILLABLE = 1;
    public static final int INDEX_COLUMN_EDITOR_FACTORY = 2;
    public static final int INDEX_COLUMN_VALUE = 3;
    public static final int INDEX_COLUMN_DISPLAY_VALUE = 4;
    public static final int INDEX_COLUMN_IS_WRITABLE = 5;
    public static final int INDEX_COLUMN_DISPLAY_NAME = 6;
    public static final int INDEX_COLUMN_VALUE_CLASS = 7;
    public static final int INDEX_COLUMN_IS_READABLE = 8;
    public static final int INDEX_COLUMN_GROUP = 9;
    public static final int INDEX_COLUMN_MODEL = 10;
    public static final int INDEX_COLUMN_DESCRIPTION = 11;
    public static final int INDEX_COLUMN_IS_EXPERT = 12;
    public static final int INDEX_COLUMN_IS_HIDDEN = 13;
    public static final int INDEX_COLUMN_NAME = 14;
    private static final Object[] _COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_IS_DRILLABLE, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_MODEL, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_IS_EXPERT, PropertyModel.COLUMN_IS_HIDDEN, PropertyModel.COLUMN_NAME};
    private static final String _RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final Hashtable _sNameDescriptions = BeansModel._createNameDescriptions();
    private Object _target;
    private transient Hashtable _propertyHashtable;
    private transient BeanInfo _beanInfo;
    private transient AbstractPropertyEditorFactory[] _descriptors;
    private transient PropertyModel[] _models;
    private BeansModel _parentModel;
    private int _index;
    private BeansGroupProvider _groupProvider;
    private boolean _displayFields;
    private boolean _displayIndexedProperties;
    private boolean _displayArrays;
    private boolean _allowRecursion;
    private PropertyChangeListener _listener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Font;

    public BeansModel(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this._displayFields = true;
        this._displayArrays = true;
        this._displayIndexedProperties = true;
        this._allowRecursion = true;
        this._target = object;
        Class<?> clazz = object.getClass();
        try {
            this._beanInfo = this.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        try {
            Class[] classArray = new Class[]{class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BeansModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
            Method method = clazz.getMethod("addPropertyChangeListener", classArray);
            this._listener = new Listener();
            method.invoke(object, this._listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BeansModel(Object object, BeansModel beansModel, int n) {
        this(object);
        this._parentModel = beansModel;
        this._index = n;
    }

    public Object getTarget() {
        return this._target;
    }

    public BeansGroupProvider getGroupProvider() {
        if (this._groupProvider == null) {
            this._groupProvider = new DefaultBeansGroupProvider();
        }
        return this._groupProvider;
    }

    public void setGroupProvider(BeansGroupProvider beansGroupProvider) {
        if (this._groupProvider != beansGroupProvider) {
            this._groupProvider = beansGroupProvider;
            this.fireTableDataChanged();
        }
    }

    public void setDisplayFields(boolean bl) {
        if (this._displayFields != bl) {
            int n;
            int n2 = n = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int n3 = this._models.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (this._models[n4] instanceof BeansModel) {
                        ((BeansModel)this._models[n4]).setDisplayFields(bl);
                    }
                    ++n4;
                }
            }
            this._displayFields = bl;
            this._reset(n);
        }
    }

    public boolean isDisplayFields() {
        return this._displayFields;
    }

    public void setDisplayIndexedProperties(boolean bl) {
        if (this._displayIndexedProperties != bl) {
            int n;
            int n2 = n = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int n3 = this._models.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (this._models[n4] instanceof BeansModel) {
                        ((BeansModel)this._models[n4]).setDisplayIndexedProperties(bl);
                    }
                    ++n4;
                }
            }
            this._displayIndexedProperties = bl;
            this._reset(n);
        }
    }

    public boolean isDisplayIndexedProperties() {
        return this._displayIndexedProperties;
    }

    public void setDisplayArrayProperties(boolean bl) {
        if (this._displayArrays != bl) {
            int n;
            int n2 = n = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int n3 = this._models.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (this._models[n4] instanceof BeansModel) {
                        ((BeansModel)this._models[n4]).setDisplayArrayProperties(bl);
                    }
                    ++n4;
                }
            }
            this._displayArrays = bl;
            this._reset(n);
        }
    }

    public boolean isDisplayArrayProperties() {
        return this._displayArrays;
    }

    public void setRecursionAllowed(boolean bl) {
        if (bl != this.isRecursionAllowed()) {
            int n;
            int n2 = n = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int n3 = this._models.length;
                int n4 = 0;
                while (n4 < n3) {
                    if (this._models[n4] instanceof BeansModel) {
                        ((BeansModel)this._models[n4]).setRecursionAllowed(bl);
                    }
                    ++n4;
                }
            }
            this._allowRecursion = bl;
            this._reset(n);
        }
    }

    public boolean isRecursionAllowed() {
        return this._allowRecursion;
    }

    public String getTargetDisplayName() {
        Object object = this._target;
        if (object != null) {
            Method method = null;
            String string = null;
            try {
                method = object.getClass().getMethod("getName", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method != null) {
                try {
                    string = (String)method.invoke(object, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && this._beanInfo != null) {
                string = this._beanInfo.getBeanDescriptor().getName();
            }
            return string;
        }
        return null;
    }

    public Object[] getColumnMapping() {
        return _COLUMNS;
    }

    public int getColumnCount() {
        return _COLUMNS.length;
    }

    public int getRowCount() {
        AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray = this._getDescriptors();
        return abstractPropertyEditorFactoryArray != null ? abstractPropertyEditorFactoryArray.length : 0;
    }

    public Enumeration getPropertyIDs() {
        return this._getPropertyHashTable().keys();
    }

    public void invalidateValueData() {
        AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray = this._getDescriptors();
        int n = abstractPropertyEditorFactoryArray == null ? 0 : abstractPropertyEditorFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            abstractPropertyEditorFactoryArray[n2].invalidateCachedValues();
            if (this._models != null && this._models[n2] != null) {
                this._models[n2].invalidateValueData();
            }
            ++n2;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, this.getRowCount() - 1, 3);
        this.fireTableChanged(tableModelEvent);
    }

    public void setPropertyByID(int n, Object object, Object object2) throws Exception {
        Integer n2 = (Integer)this._getPropertyHashTable().get(object);
        if (n2 != null) {
            this.setValueAt(object2, n2, n);
        }
    }

    public Object getPropertyByID(int n, Object object) {
        Integer n2 = (Integer)this._getPropertyHashTable().get(object);
        if (n2 != null) {
            return this.getValueAt(n2, n);
        }
        return PropertyModel.DOES_NOT_EXIST;
    }

    public Object getValueAt(int n, int n2) {
        AbstractPropertyEditorFactory abstractPropertyEditorFactory = this._getDescriptor(n);
        if (abstractPropertyEditorFactory != null) {
            switch (n2) {
                case 2: {
                    return abstractPropertyEditorFactory.getPropertyEditorFactory();
                }
                case 3: {
                    return this._getPropertyValue(abstractPropertyEditorFactory);
                }
                case 4: {
                    return this._getPropertyDisplayValue(abstractPropertyEditorFactory);
                }
                case 5: {
                    boolean bl = abstractPropertyEditorFactory.isWritable();
                    if (!bl && this._parentModel != null && !(abstractPropertyEditorFactory instanceof FieldPropertyEditorFactory)) {
                        bl = this.isPropertyWritable(abstractPropertyEditorFactory.getName(), this._parentModel, this._index);
                    }
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    return abstractPropertyEditorFactory.getDisplayName();
                }
                case 7: {
                    return abstractPropertyEditorFactory.getType();
                }
                case 8: {
                    return abstractPropertyEditorFactory.isReadable() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 0: {
                    return abstractPropertyEditorFactory.getPropertyID();
                }
                case 9: {
                    return this.getGroupProvider().getGroup(abstractPropertyEditorFactory.getName(), abstractPropertyEditorFactory.getType());
                }
                case 10: {
                    return this._getModel(n);
                }
                case 1: {
                    return this._isDrillable(n) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 11: {
                    Object var7_7;
                    String string = null;
                    String string2 = abstractPropertyEditorFactory.getName();
                    Object v0 = var7_7 = string2 == null ? null : _sNameDescriptions.get(string2);
                    if (var7_7 != null) {
                        string = this._getTranslatedString(var7_7);
                    }
                    if (string == null) {
                        string = abstractPropertyEditorFactory.getShortDescription();
                    }
                    return string;
                }
                case 12: {
                    return abstractPropertyEditorFactory.isExpert() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 13: {
                    return abstractPropertyEditorFactory.isHidden() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 14: {
                    return abstractPropertyEditorFactory.getName();
                }
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 3) {
            boolean bl = false;
            AbstractPropertyEditorFactory abstractPropertyEditorFactory = this._getDescriptor(n);
            try {
                bl = this._parentModel != null && !abstractPropertyEditorFactory.isWritable() ? this.setImmutableValue(abstractPropertyEditorFactory.getName(), object, this._parentModel, this._index) : abstractPropertyEditorFactory.setValue(object);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                String string = object != null ? object.toString() : null;
                this.throwIllegalArgumentException(throwable, abstractPropertyEditorFactory.getName(), string);
            }
            if (bl) {
                this._fireRowValueInvalidate(n);
            }
        }
    }

    public void dispose() {
        super.dispose();
        try {
            Class<?> clazz = this.getTarget().getClass();
            Class[] classArray = new Class[]{class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BeansModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
            Method method = clazz.getMethod("removePropertyChangeListener", classArray);
            method.invoke(this.getTarget(), this._listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._listener = null;
        this._descriptors = null;
        if (this._models != null) {
            int n = 0;
            while (n < this._models.length) {
                if (this._models[n] != null) {
                    this._models[n].dispose();
                }
                ++n;
            }
        }
        this._models = null;
        this._parentModel = null;
    }

    protected BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        return JavaIntrospector.getBeanInfo((Class)clazz);
    }

    protected boolean setImmutableValue(String string, Object object, BeansModel beansModel, int n) throws Exception {
        int n2;
        Class clazz = (Class)beansModel.getValueAt(n, 7);
        Object object2 = beansModel.getPropertyValue(n);
        if (clazz == (class$java$awt$Color == null ? (class$java$awt$Color = BeansModel.class$("java.awt.Color")) : class$java$awt$Color)) {
            n2 = (Integer)object;
            if ("RGB".equals(string)) {
                object = new Color(n2);
            } else {
                Color color = (Color)object2;
                if (color == null) {
                    color = Color.white;
                }
                if ("red".equals(string)) {
                    object = new Color(n2, color.getGreen(), color.getBlue());
                } else if ("green".equals(string)) {
                    object = new Color(color.getRed(), n2, color.getBlue());
                } else if ("blue".equals(string)) {
                    object = new Color(color.getRed(), color.getGreen(), n2);
                }
            }
        } else if (clazz == (class$java$awt$Font == null ? (class$java$awt$Font = BeansModel.class$("java.awt.Font")) : class$java$awt$Font)) {
            Font font = (Font)object2;
            if (font == null) {
                font = FontUtils.getDefaultDialogFont();
            }
            if ("name".equals(string)) {
                String string2 = object.toString();
                object = new Font(string2, font.getStyle(), font.getSize());
            } else if ("bold".equals(string)) {
                boolean bl = Boolean.TRUE.equals(object);
                int n3 = 0;
                if (font.isPlain()) {
                    n3 |= 0;
                }
                if (font.isItalic()) {
                    n3 |= 2;
                }
                if (bl) {
                    n3 |= 1;
                }
                object = new Font(font.getName(), n3, font.getSize());
            } else if ("plain".equals(string)) {
                boolean bl = Boolean.TRUE.equals(object);
                int n4 = 0;
                if (bl) {
                    n4 |= 0;
                }
                if (font.isItalic()) {
                    n4 |= 2;
                }
                if (font.isBold()) {
                    n4 |= 1;
                }
                object = new Font(font.getName(), n4, font.getSize());
            } else if ("italic".equals(string)) {
                boolean bl = Boolean.TRUE.equals(object);
                int n5 = 0;
                if (font.isPlain()) {
                    n5 |= 0;
                }
                if (bl) {
                    n5 |= 2;
                }
                if (font.isBold()) {
                    n5 |= 1;
                }
                object = new Font(font.getName(), n5, font.getSize());
            } else if ("size".equals(string)) {
                Integer n6 = (Integer)object;
                object = new Font(font.getName(), font.getStyle(), n6);
            } else if ("style".equals(string)) {
                Integer n7 = (Integer)object;
                object = new Font(font.getName(), (int)n7, font.getSize());
            } else if ("family".equals(string)) {
                // empty if block
            }
        }
        int n8 = n2 = object2 != object ? 1 : 0;
        if (n2 != 0) {
            beansModel.setValueAt(object, n, 3);
        }
        return n2 != 0;
    }

    protected boolean isPropertyWritable(String string, BeansModel beansModel, int n) {
        boolean bl = Boolean.TRUE.equals(beansModel.getValueAt(n, 5));
        if (bl) {
            bl = false;
            Class clazz = (Class)beansModel.getValueAt(n, 7);
            if (clazz == (class$java$awt$Font == null ? (class$java$awt$Font = BeansModel.class$("java.awt.Font")) : class$java$awt$Font)) {
                if ("name".equals(string) || "bold".equals(string) || "italic".equals(string) || "size".equals(string)) {
                    bl = true;
                }
            } else if (clazz == (class$java$awt$Color == null ? (class$java$awt$Color = BeansModel.class$("java.awt.Color")) : class$java$awt$Color) && ("red".equals(string) || "green".equals(string) || "blue".equals(string))) {
                bl = true;
            }
        }
        return bl;
    }

    protected BeansModel createBeansModel(Object object, BeansModel beansModel, int n) {
        return new BeansModel(object, beansModel, n);
    }

    protected final PropertyEditor getPropertyEditor(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        AbstractPropertyEditorFactory abstractPropertyEditorFactory = this._getDescriptor(n);
        return abstractPropertyEditorFactory == null ? null : abstractPropertyEditorFactory.__getPropertyEditor();
    }

    AbstractPropertyEditorFactory[] createDescriptors() {
        AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray;
        block8: {
            BeanInfo beanInfo;
            PropertyDescriptor[] propertyDescriptorArray;
            int n;
            int n2;
            int n3;
            Class<?> clazz;
            block6: {
                block7: {
                    abstractPropertyEditorFactoryArray = null;
                    Object object = this.getTarget();
                    clazz = object.getClass();
                    if (!clazz.isArray()) break block6;
                    if (!this.isDisplayArrayProperties()) break block7;
                    int n4 = Array.getLength(this.getTarget());
                    abstractPropertyEditorFactoryArray = new AbstractPropertyEditorFactory[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        abstractPropertyEditorFactoryArray[n5] = new ArrayPropertyEditorFactory(this.getTarget(), n5);
                        ++n5;
                    }
                    break block8;
                }
                return new AbstractPropertyEditorFactory[0];
            }
            boolean bl = this.isDisplayFields();
            Field[] fieldArray = null;
            if (bl) {
                try {
                    fieldArray = clazz.getFields();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((n3 = (n2 = fieldArray == null ? 0 : fieldArray.length) + (n = (propertyDescriptorArray = (beanInfo = this._beanInfo) == null ? null : this._filterProperties(beanInfo.getPropertyDescriptors())) == null ? 0 : propertyDescriptorArray.length)) <= 0) break block8;
            abstractPropertyEditorFactoryArray = new AbstractPropertyEditorFactory[n3];
            int n6 = 0;
            while (n6 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n6];
                abstractPropertyEditorFactoryArray[n6] = new BeansPropertyEditorFactory(this._target, propertyDescriptor);
                ++n6;
            }
            int n7 = 0;
            while (n7 < n2) {
                Field field = fieldArray[n7];
                abstractPropertyEditorFactoryArray[n7 + n] = new FieldPropertyEditorFactory(this._target, field);
                ++n7;
            }
        }
        return abstractPropertyEditorFactoryArray;
    }

    private PropertyDescriptor[] _filterProperties(PropertyDescriptor[] propertyDescriptorArray) {
        int n = propertyDescriptorArray.length;
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>(n);
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                if (this.isDisplayIndexedProperties()) {
                    vector.add(propertyDescriptor);
                }
            } else if (propertyDescriptor.getPropertyType().isArray()) {
                if (this.isDisplayArrayProperties()) {
                    vector.add(propertyDescriptor);
                }
            } else if (!this.isRecursionAllowed()) {
                if (this._parentModel != null) {
                    Object object;
                    Object object2 = this._parentModel.getValueAt(this._index, 14);
                    if (object2 == null || !object2.equals(propertyDescriptor.getName()) || (object = this._parentModel.getValueAt(this._index, 7)) != propertyDescriptor.getPropertyType()) {
                        vector.add(propertyDescriptor);
                    }
                } else {
                    vector.add(propertyDescriptor);
                }
            } else {
                vector.add(propertyDescriptor);
            }
            ++n2;
        }
        propertyDescriptorArray = new PropertyDescriptor[vector.size()];
        vector.copyInto(propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    private void _reset(int n) {
        if (n == -1) {
            return;
        }
        this._descriptors = null;
        this._propertyHashtable = null;
        int n2 = this.getRowCount();
        int n3 = n2 - n;
        if (n3 > 0) {
            this.fireTableRowsInserted(0, n3 - 1);
        } else if (n3 < 0) {
            this.fireTableRowsDeleted(0, -n3 - 1);
        }
        this.fireTableRowsUpdated(0, n2 - 1);
    }

    private Hashtable _getPropertyHashTable() {
        if (this._propertyHashtable == null) {
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
            AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray = this._getDescriptors();
            int n = abstractPropertyEditorFactoryArray == null ? 0 : abstractPropertyEditorFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                hashtable.put(abstractPropertyEditorFactoryArray[n2].getPropertyID(), IntegerUtils.getInteger((int)n2));
                ++n2;
            }
            this._propertyHashtable = hashtable;
        }
        return this._propertyHashtable;
    }

    private AbstractPropertyEditorFactory _getDescriptor(int n) {
        int n2 = this.getRowCount();
        if (n2 <= 0 || n >= n2) {
            return null;
        }
        AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray = this._getDescriptors();
        return abstractPropertyEditorFactoryArray[n];
    }

    private AbstractPropertyEditorFactory[] _getDescriptors() {
        if (this._descriptors == null) {
            this._descriptors = this.createDescriptors();
        }
        return this._descriptors;
    }

    private PropertyModel _getModel(int n) {
        int n2 = this.getRowCount();
        if (n2 == 0) {
            return null;
        }
        if (this._models == null) {
            this._models = new PropertyModel[n2];
        }
        if (this._models[n] == null) {
            try {
                AbstractPropertyEditorFactory abstractPropertyEditorFactory = this._getDescriptor(n);
                if (abstractPropertyEditorFactory instanceof BeansPropertyEditorFactory && ((BeansPropertyEditorFactory)abstractPropertyEditorFactory).getPropertyDescriptor() instanceof IndexedPropertyDescriptor) {
                    BeansPropertyEditorFactory beansPropertyEditorFactory = (BeansPropertyEditorFactory)abstractPropertyEditorFactory;
                    IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)beansPropertyEditorFactory.getPropertyDescriptor();
                    this._models[n] = new IndexedModel(this.getTarget(), indexedPropertyDescriptor);
                } else {
                    Object object = this._getPropertyValue(abstractPropertyEditorFactory);
                    if (object != PropertyModel.DOES_NOT_EXIST) {
                        BeansModel beansModel = this.createBeansModel(object, this, n);
                        beansModel.setDisplayFields(this.isDisplayFields());
                        beansModel.setDisplayArrayProperties(this.isDisplayArrayProperties());
                        beansModel.setDisplayIndexedProperties(this.isDisplayIndexedProperties());
                        beansModel.setRecursionAllowed(this.isRecursionAllowed());
                        this._models[n] = beansModel;
                    }
                }
            }
            catch (Exception exception) {
                this._models[n] = null;
            }
        }
        return this._models[n];
    }

    static int __getIndexedPropertyCount(Object object, IndexedPropertyDescriptor indexedPropertyDescriptor, BeansModel beansModel) {
        Class<?> clazz = object.getClass();
        String string = indexedPropertyDescriptor.getName();
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        String string3 = "get" + string2 + "Count";
        Method method = null;
        Object object2 = null;
        boolean bl = false;
        try {
            if (beansModel.isDisplayIndexedProperties()) {
                method = clazz.getMethod(string3, null);
                object2 = method == null ? null : method.invoke(object, null);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if ((bl || object2 == null) && beansModel.isDisplayArrayProperties()) {
            boolean bl2;
            Class<?> clazz2 = indexedPropertyDescriptor.getPropertyType();
            boolean bl3 = bl2 = clazz2 == null ? false : clazz2.isArray();
            if (bl2) {
                string3 = "get" + string2;
                try {
                    Method method2 = clazz.getMethod(string3, null);
                    Object object3 = method2.invoke(object, null);
                    if (object3 != null) {
                        object2 = new Integer(Array.getLength(object3));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    private boolean _isDrillable(int n) {
        boolean bl;
        AbstractPropertyEditorFactory abstractPropertyEditorFactory = this._getDescriptor(n);
        if (abstractPropertyEditorFactory == null) {
            return false;
        }
        if (!this.isRecursionAllowed() && this.getTarget().getClass() == abstractPropertyEditorFactory.getType()) {
            return false;
        }
        if (abstractPropertyEditorFactory instanceof BeansPropertyEditorFactory && ((BeansPropertyEditorFactory)abstractPropertyEditorFactory).getPropertyDescriptor() instanceof IndexedPropertyDescriptor) {
            BeansPropertyEditorFactory beansPropertyEditorFactory = (BeansPropertyEditorFactory)abstractPropertyEditorFactory;
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)beansPropertyEditorFactory.getPropertyDescriptor();
            int n2 = BeansModel.__getIndexedPropertyCount(this.getTarget(), indexedPropertyDescriptor, this);
            return n2 != 0;
        }
        Class clazz = abstractPropertyEditorFactory.getType();
        boolean bl2 = bl = clazz == null ? false : clazz.isArray();
        if (bl) {
            Object object = this._getPropertyValue(abstractPropertyEditorFactory);
            return object == PropertyModel.DOES_NOT_EXIST ? false : Array.getLength(object) != 0;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = this.getBeanInfo(clazz);
            if (beanInfo == null) {
                return false;
            }
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            return false;
        }
        return this._getModel(n) != null;
    }

    private Object _getPropertyValue(AbstractPropertyEditorFactory abstractPropertyEditorFactory) {
        try {
            return abstractPropertyEditorFactory.getValue(this._target);
        }
        catch (Exception exception) {
            return PropertyModel.DOES_NOT_EXIST;
        }
    }

    private Object _getPropertyDisplayValue(AbstractPropertyEditorFactory abstractPropertyEditorFactory) {
        try {
            return abstractPropertyEditorFactory.getDisplayValue();
        }
        catch (Exception exception) {
            return PropertyModel.DOES_NOT_EXIST;
        }
    }

    private void _fireRowValueInvalidate(int n) {
        this.fireTableCellUpdated(n, 3);
        if (this._models != null && this._models[n] != null) {
            this._models[n] = null;
            this.fireTableCellUpdated(n, 10);
        }
    }

    private String _getTranslatedString(String string) {
        String string2 = null;
        if (string != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
            string2 = resourceBundle.getString(string);
        }
        return string2;
    }

    private static Hashtable _createNameDescriptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("background", "DESCRIPTION_BACKGROUND");
        hashtable.put("enabled", "DESCRIPTION_ENABLED");
        hashtable.put("font", "DESCRIPTION_FONT");
        hashtable.put("foreground", "DESCRIPTION_FOREGROUND");
        hashtable.put("name", "DESCRIPTION_NAME");
        hashtable.put("text", "DESCRIPTION_TEXT");
        hashtable.put("visible", "DESCRIPTION_VISIBLE");
        return hashtable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            String string = propertyChangeEvent.getPropertyName();
            AbstractPropertyEditorFactory[] abstractPropertyEditorFactoryArray = BeansModel.this._getDescriptors();
            int n2 = n = abstractPropertyEditorFactoryArray == null ? 0 : abstractPropertyEditorFactoryArray.length;
            if (string != null) {
                int n3 = 0;
                while (n3 < n) {
                    AbstractPropertyEditorFactory abstractPropertyEditorFactory = abstractPropertyEditorFactoryArray[n3];
                    if (abstractPropertyEditorFactory.getName().equals(string) && abstractPropertyEditorFactory.updateValueIfNecessary(propertyChangeEvent.getNewValue())) {
                        BeansModel.this._fireRowValueInvalidate(n3);
                    }
                    ++n3;
                }
            } else {
                BeansModel.this.invalidateValueData();
            }
        }
    }
}

