/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyGroup;

public abstract class PropertyModel
extends AbstractTableModel {
    public static final String PROPERTY_DISPLAY_NAME = "targetDisplayName";
    public static final Object COLUMN_VALUE_CLASS = new String("Class");
    public static final Object COLUMN_NAME = new String("column_Name");
    public static final Object COLUMN_DISPLAY_NAME = new String("Name");
    public static final Object COLUMN_VALUE = new String("Value");
    public static final Object COLUMN_DISPLAY_VALUE = new String("Display Value");
    public static final Object COLUMN_IS_EXPERT = new String("Expert");
    public static final Object COLUMN_IS_HIDDEN = new String("Hidden");
    public static final Object COLUMN_DESCRIPTION = new String("Description");
    public static final Object COLUMN_IS_READABLE = new String("Readable");
    public static final Object COLUMN_IS_WRITABLE = new String("Writable");
    public static final Object COLUMN_EDITOR_FACTORY = new String("Editor Factory");
    public static final Object COLUMN_ID = new String("ID");
    public static final Object COLUMN_GROUP = new String("Group");
    public static final Object COLUMN_LEVEL = new String("Level");
    public static final Object COLUMN_IS_DRILLABLE = new String("Drillable");
    public static final Object COLUMN_MODEL = new String("Model");
    public static final Object DOES_NOT_EXIST = "";
    public static final int NONEXISTENT_COLUMN = -1;
    private static boolean _sConstructorInitialized = false;
    private static Constructor _sRuntimeExceptionConstructor;
    private static final String _RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_SHORT_ERROR = "SHORT_ERROR";
    private static final String _KEY_LONG_ERROR = "LONG_ERROR";
    private Locale _locale = Locale.getDefault();
    private transient PropertyChangeSupport _propertySupport;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    protected PropertyModel() {
    }

    public abstract Object[] getColumnMapping();

    public abstract String getTargetDisplayName();

    public abstract void invalidateValueData();

    public int getColumnIndex(Object object) {
        Object[] objectArray = this.getColumnMapping();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (object.equals(objectArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isDataConflicting(int n, int n2) {
        return false;
    }

    public boolean isPropertyCommon(int n) {
        return true;
    }

    public Object getData(Object object, int n) {
        int n2 = this.getColumnIndex(object);
        if (n2 != -1) {
            return this.getValueAt(n, n2);
        }
        return DOES_NOT_EXIST;
    }

    public void setPropertyByID(int n, Object object, Object object2) throws Throwable {
        int n2 = this.getColumnIndex(COLUMN_ID);
        if (n2 != -1) {
            int n3 = this.getRowCount();
            this.startRead();
            boolean bl = false;
            try {
                int n4 = 0;
                while (n4 < n3) {
                    if (this.getValueAt(n4, n2) == object) {
                        bl = true;
                        this.stopRead();
                        this.setValueAt(object2, n4, n);
                        break;
                    }
                    ++n4;
                }
                Object var9_8 = null;
                if (!bl) {
                    this.stopRead();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!bl) {
                    this.stopRead();
                }
                throw throwable;
            }
        }
    }

    public Object getPropertyByID(int n, Object object) {
        int n2 = this.getColumnIndex(COLUMN_ID);
        if (n2 != -1) {
            int n3 = this.getRowCount();
            this.startRead();
            try {
                int n4 = 0;
                while (n4 < n3) {
                    if (this.getValueAt(n4, n2) == object) {
                        Object object2 = this.getValueAt(n4, n);
                        Object var8_7 = null;
                        this.stopRead();
                        return object2;
                    }
                    ++n4;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.stopRead();
                throw throwable;
            }
            Object var8_8 = null;
            this.stopRead();
            {
            }
        }
        return DOES_NOT_EXIST;
    }

    public int getPropertyIndex(Object object) {
        int n = this.getColumnIndex(COLUMN_ID);
        if (n != -1) {
            int n2 = this.getRowCount();
            this.startRead();
            try {
                int n3 = 0;
                while (n3 < n2) {
                    if (this.getValueAt(n3, n) == object) {
                        int n4 = n3;
                        Object var7_6 = null;
                        this.stopRead();
                        return n4;
                    }
                    ++n3;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.stopRead();
                throw throwable;
            }
            Object var7_7 = null;
            this.stopRead();
            {
            }
        }
        return -1;
    }

    public final boolean getBooleanData(int n, int n2) {
        Object object = this.getValueAt(n2, n);
        if (object != null) {
            return Boolean.TRUE.equals(object);
        }
        return true;
    }

    public final boolean getBooleanData(Object object, int n) {
        int n2 = this.getColumnIndex(object);
        if (n2 != -1) {
            return this.getBooleanData(n2, n);
        }
        return true;
    }

    protected void setData(Object object, int n, Object object2) throws Throwable {
        int n2 = this.getColumnIndex(object);
        if (n2 != -1) {
            this.setValueAt(object2, n, n2);
        }
    }

    public final void setPropertyValue(int n, Object object) throws Throwable {
        this.setData(COLUMN_VALUE, n, object);
    }

    public final String getPropertyDisplayName(int n) {
        return this.getPropertyDisplayName(n, this.getLocale());
    }

    public final String getPropertyDisplayName(int n, Locale locale) {
        return (String)this.getData(COLUMN_DISPLAY_NAME, n);
    }

    public final String getPropertyName(int n) {
        return (String)this.getData(COLUMN_NAME, n);
    }

    public final PropertyEditorFactory getPropertyEditorFactory(int n) {
        return (PropertyEditorFactory)this.getData(COLUMN_EDITOR_FACTORY, n);
    }

    public final Object getPropertyID(int n) {
        return this.getData(COLUMN_ID, n);
    }

    public final Object getPropertyValue(int n) {
        return this.getData(COLUMN_VALUE, n);
    }

    public final Object getPropertyDisplayValue(int n) {
        return this.getData(COLUMN_DISPLAY_VALUE, n);
    }

    public final String getPropertyDescription(int n) {
        return (String)this.getData(COLUMN_DESCRIPTION, n);
    }

    public final boolean isPropertyWritable(int n) {
        return this.getBooleanData(COLUMN_IS_WRITABLE, n);
    }

    public final boolean isPropertyReadable(int n) {
        return this.getBooleanData(COLUMN_IS_READABLE, n);
    }

    public final PropertyGroup getPropertyGroup(int n) {
        Object object = this.getData(COLUMN_GROUP, n);
        if (object == DOES_NOT_EXIST || !(object instanceof PropertyGroup)) {
            return null;
        }
        return (PropertyGroup)object;
    }

    public final PropertyModel getPropertyModel(int n) {
        Object object = this.getData(COLUMN_MODEL, n);
        if (object == DOES_NOT_EXIST || !(object instanceof PropertyModel)) {
            return null;
        }
        return (PropertyModel)object;
    }

    public final boolean isPropertyDrillable(int n) {
        Object object = this.getData(COLUMN_IS_DRILLABLE, n);
        if (object == DOES_NOT_EXIST || !(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    public int getColumnCount() {
        return this.getColumnMapping().length;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Enumeration getPropertyIDs() {
        int n = this.getColumnIndex(COLUMN_ID);
        if (n != -1) {
            return new PropertyIDEnumeration(n);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = this.getColumnIndex(COLUMN_DISPLAY_VALUE);
        if (n3 == n2) {
            return this.isPropertyWritable(n);
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void dispose() {
        this._propertySupport = null;
    }

    public boolean isSettable(Object object, Object object2) {
        return object2 != object && (object2 == null || !object2.equals(object));
    }

    public void startRead() {
    }

    public void stopRead() {
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    protected void throwIllegalArgumentException(Throwable throwable, String string, Object object) {
        String string2 = object == null ? _KEY_SHORT_ERROR : _KEY_LONG_ERROR;
        String string3 = this._getTranslatedString(string2);
        MessageFormat messageFormat = new MessageFormat(string3);
        Object[] objectArray = object == null ? new Object[]{string} : new Object[]{string, object};
        throw PropertyModel.createException(throwable, messageFormat.format(objectArray));
    }

    private static RuntimeException createException(Throwable throwable, String string) {
        Object[] objectArray;
        if (!_sConstructorInitialized) {
            try {
                Object object;
                if (class$java$lang$RuntimeException == null) {
                    class$java$lang$RuntimeException = PropertyModel.class$("java.lang.RuntimeException");
                    object = class$java$lang$RuntimeException;
                } else {
                    object = class$java$lang$RuntimeException;
                }
                objectArray = object;
                _sRuntimeExceptionConstructor = objectArray.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PropertyModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = PropertyModel.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _sConstructorInitialized = true;
        }
        if (_sRuntimeExceptionConstructor != null) {
            try {
                objectArray = new Object[]{string, throwable};
                return (RuntimeException)_sRuntimeExceptionConstructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new IllegalArgumentException(string);
    }

    private String _getTranslatedString(String string) {
        String string2 = null;
        if (string != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
            string2 = resourceBundle.getString(string);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PropertyIDEnumeration
    implements Enumeration {
        private int _propertyIDColumnIndex;
        private int _currRowIndex;

        public PropertyIDEnumeration(int n) {
            this._propertyIDColumnIndex = n;
        }

        public boolean hasMoreElements() {
            return this._currRowIndex < PropertyModel.this.getRowCount();
        }

        public Object nextElement() {
            return PropertyModel.this.getValueAt(this._currRowIndex++, this._propertyIDColumnIndex);
        }
    }
}

