/*
 * Decompiled with CFR 0.152.
 */
package tdg.net;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.EventObject;
import java.util.Vector;
import tdg.net.TextProtocolListener;

public class TextProtocolConnection
implements Serializable {
    public static final int DISCONNECTED = 1;
    public static final int CONNECTED = 255;
    protected String serverHost = "";
    protected String serverMessage = "";
    protected int serverPort;
    protected volatile Socket TextProtocolSocket;
    protected volatile BufferedReader BRSocketInput;
    protected volatile BufferedWriter PSSocketOutput;
    protected Vector TextProtocolListeners = new Vector();
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected int state = 1;

    public String getServerHost() {
        return this.serverHost;
    }

    public synchronized void setServerHost(String s) {
        if (!s.equals(this.serverHost)) {
            this.state = 1;
            this.serverHost = s;
        }
    }

    public String getServerMessage() {
        return this.serverMessage;
    }

    protected void setServerMessage(String s) {
        String oldServerMessage = this.serverMessage != null ? this.serverMessage : "";
        this.serverMessage = s;
        this.changes.firePropertyChange("ServerMessage", oldServerMessage, s);
    }

    public synchronized void addTextProtocolListener(TextProtocolListener Listener) {
        this.TextProtocolListeners.addElement(Listener);
    }

    public synchronized void removeTextProtocolListener(TextProtocolListener Listener) {
        this.TextProtocolListeners.removeElement(Listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    protected synchronized void connect() throws IOException {
        if (this.state == 1) {
            this.dispatchserverconnecting();
            this.TextProtocolSocket = new Socket(this.getServerHost(), this.serverPort);
            this.BRSocketInput = new BufferedReader(new InputStreamReader(this.TextProtocolSocket.getInputStream(), "ASCII"));
            OutputStreamWriter osr = new OutputStreamWriter(this.TextProtocolSocket.getOutputStream(), "ASCII");
            this.PSSocketOutput = new BufferedWriter(osr);
            String firstLine = this.BRSocketInput.readLine();
            this.setServerMessage(firstLine);
            this.dispatchconnected();
            this.state = 255;
        }
    }

    protected String readSingleLineResponse(String Command) {
        String CurrentLine;
        try {
            this.PSSocketOutput.write(Command + "\n");
            this.PSSocketOutput.flush();
        }
        catch (IOException e) {
            this.dispatchServerNetworkError();
            return "";
        }
        try {
            CurrentLine = this.BRSocketInput.readLine();
            this.setServerMessage(CurrentLine);
        }
        catch (IOException e) {
            this.dispatchServerNetworkError();
            return "";
        }
        return CurrentLine;
    }

    protected void dispatchconnected() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            if (this.TextProtocolListeners == null) {
                return;
            }
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).connected(eo);
            ++i;
        }
    }

    protected void dispatchloggedIn() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            if (this.TextProtocolListeners == null) {
                return;
            }
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).loggedIn(eo);
            ++i;
        }
    }

    protected void dispatchserverconnecting() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            if (this.TextProtocolListeners == null) {
                return;
            }
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).connecting(eo);
            ++i;
        }
    }

    protected void dispatchserverDisconnected() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            if (this.TextProtocolListeners == null) {
                return;
            }
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).serverDisconnected(eo);
            ++i;
        }
    }

    protected void dispatchServerNetworkError() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).serverNetworkError(eo);
            ++i;
        }
    }

    protected void dispatchServerProtocolError() {
        Vector l;
        EventObject eo = new EventObject(this);
        TextProtocolConnection textProtocolConnection = this;
        synchronized (textProtocolConnection) {
            l = (Vector)this.TextProtocolListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((TextProtocolListener)l.elementAt(i)).serverProtocolError(eo);
            ++i;
        }
    }
}

