/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.IdentObj;

public class Detectiv
implements Serializable {
    public static final int MIN_LINEWIDTH = 4;
    public static final int INIT_CAPACITY = 4096;
    private Perspective m_Perspective;
    private Vector m_detList;
    boolean m_bExceptionalFlag;
    Rectangle m_defaultClipRect;

    public Detectiv(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_detList = new Vector(4096);
        this.m_bExceptionalFlag = false;
    }

    public DetObj findNodeOf(int x, int y, VC vc) {
        DetObj detObj = null;
        boolean bFound = false;
        int i = this.m_detList.size() - 1;
        while (i >= 0 && !bFound) {
            detObj = (DetObj)this.m_detList.elementAt(i);
            if (detObj.isPointInObj(x, y, vc)) {
                bFound = true;
            }
            --i;
        }
        return detObj;
    }

    public DetObj findNodeOf(int nSeriesID, int nGroupID) {
        DetObj detObj = null;
        boolean bFound = false;
        int nIdx = this.m_detList.size() - 1;
        while (nIdx >= 0 && !bFound) {
            detObj = (DetObj)this.m_detList.elementAt(nIdx);
            if (detObj.getSeriesID() == nSeriesID && detObj.getGroupID() == nGroupID) {
                bFound = true;
            }
            --nIdx;
        }
        return detObj;
    }

    public DetObj findNodeOf(IdentObj id) {
        block9: {
            IdentObj dtoID;
            int i;
            DetObj detObj;
            block8: {
                detObj = null;
                i = this.m_detList.size() - 1;
                while (i >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj != null && detObj.isDetectable() && (dtoID = detObj.getIdentID()).equals(id)) {
                        return detObj;
                    }
                    --i;
                }
                if (id.getObjectID() != -3) break block8;
                i = this.m_detList.size() - 1;
                while (i >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj != null && detObj.isDetectable() && (dtoID = detObj.getIdentID()).getSeriesID() == id.getSeriesID() && dtoID.getGroupID() == id.getGroupID()) {
                        return detObj;
                    }
                    --i;
                }
                i = this.m_detList.size() - 1;
                while (i >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj != null && detObj.isDetectable() && (dtoID = detObj.getIdentID()).getSeriesID() == id.getSeriesID()) {
                        return detObj;
                    }
                    --i;
                }
                break block9;
            }
            if (!id.isExceptional()) break block9;
            i = this.m_detList.size() - 1;
            while (i >= 0) {
                detObj = (DetObj)this.m_detList.elementAt(i);
                if (detObj != null && detObj.isDetectable() && (dtoID = detObj.getIdentID()).isExceptional() && dtoID.getSeriesID() == id.getSeriesID() && dtoID.getGroupID() == id.getGroupID()) {
                    return detObj;
                }
                --i;
            }
        }
        return null;
    }

    public IdentObj getExceptionalID(IdentObj id) {
        if (id == null) {
            return null;
        }
        int s = id.getSeriesID();
        int g = id.getGroupID();
        IdentObj erID = this.m_Perspective.getExceptionalRiser(s, g);
        return erID;
    }

    public Enumeration getList() {
        return this.m_detList.elements();
    }

    public Vector getVectorList() {
        return this.m_detList;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    public boolean isExceptional(IdentObj id) {
        IdentObj excID = this.getExceptionalID(id);
        return excID != null;
    }

    public boolean isExceptionalAllowed() {
        return this.m_Perspective.isExceptionalAllowed();
    }

    public void insertDetNode(DetObj detObj) {
        this.m_detList.addElement(detObj);
    }

    public void removeDetNode(DetObj detObj) {
        this.m_detList.removeElement(detObj);
    }

    public void paint(Graphics g, VC vc) {
        int i = 0;
        while (i < this.m_detList.size()) {
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            detObj.paint(g, vc);
            ++i;
        }
    }

    private void releaseDetListReferences() {
        int i = this.m_detList.size() - 1;
        while (i >= 0) {
            BlackBoxIF bb;
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            if (detObj != null && (bb = detObj.getBlackBox()) != null) {
                bb.releaseReferences();
            }
            --i;
        }
    }

    public void releaseReferences() {
        this.releaseDetListReferences();
        this.m_Perspective = null;
    }

    public void resetList() {
        this.releaseDetListReferences();
        this.m_detList = new Vector(4096);
    }

    public void setDefaultClipRect(Rectangle r) {
        this.m_defaultClipRect = r;
    }

    public void setExceptionalFlag(boolean bNewValue) {
        this.m_bExceptionalFlag = bNewValue;
    }
}

