/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class DetOval
extends DetObj {
    Rectangle m_rBounds;
    boolean m_bNoFill;
    boolean m_bDrawCircular;
    boolean m_bDestCoords = false;
    Rectangle m_rDestBounds;
    Polygon m_polygon;
    boolean m_bClip = false;
    int m_nReferenceLineWidth = 0;
    int m_nUnitWidth = 0;

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox) {
        this(m_Detectiv, id, x, y, width, height, blackBox, null, false, true, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, x, y, width, height, blackBox, clipRect, bMoveable, bDetectable, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bNoFill) {
        this(m_Detectiv, id, x, y, width, height, blackBox, clipRect, bMoveable, bDetectable, bNoFill, true);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bNoFill, int nLineWidth, int nUnit) {
        this(m_Detectiv, id, x, y, width, height, blackBox, clipRect, bMoveable, bDetectable, bNoFill, true, nLineWidth, nUnit);
    }

    private DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bNoFill, boolean bDrawCircular, int nWidth, int nUnit) {
        super(m_Detectiv, id, blackBox, clipRect, bMoveable, bDetectable);
        this.m_rBounds = new Rectangle(x, y, width, height);
        this.m_bNoFill = bNoFill;
        this.m_bDrawCircular = bDrawCircular;
        this.m_nReferenceLineWidth = nWidth;
        this.m_nUnitWidth = nUnit;
    }

    private DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bNoFill, boolean bDrawCircular) {
        super(m_Detectiv, id, blackBox, clipRect, bMoveable, bDetectable);
        this.m_rBounds = new Rectangle(x, y, width, height);
        this.m_bNoFill = bNoFill;
        this.m_bDrawCircular = bDrawCircular;
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bDrawCircular) {
        this(m_Detectiv, id, x, y, width, height, blackBox, null, true, true, false, bDrawCircular);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        this(m_Detectiv, id, x, y, width, height, blackBox, null, bMoveable, bDetectable, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, int width, int height, BlackBoxIF blackBox, Rectangle clipRect) {
        this(m_Detectiv, id, 0, 0, width, height, blackBox, clipRect, false, true, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, Rectangle clipRect) {
        this(m_Detectiv, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false, true, false, false);
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, boolean destCoords, Polygon p) {
        super(m_Detectiv, id, blackBox, null, false, true);
        this.m_bDestCoords = destCoords;
        this.m_rDestBounds = r;
        this.m_polygon = p;
        this.m_bNoFill = false;
        this.m_bDrawCircular = false;
    }

    public DetOval(Detectiv m_Detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, boolean destCoords, Polygon p, Rectangle clipRect) {
        super(m_Detectiv, id, blackBox, clipRect, false, true);
        this.m_bDestCoords = destCoords;
        this.m_rDestBounds = r;
        this.m_polygon = p;
        this.m_bNoFill = false;
        this.m_bDrawCircular = false;
        this.m_bClip = clipRect != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetOval)) {
            return false;
        }
        DetOval detOval = (DetOval)obj;
        return this.m_id.equals(detOval.m_id);
    }

    public Rectangle getBounds() {
        Rectangle ret = null;
        ret = this.m_bDestCoords ? (this.m_rDestBounds != null ? this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds) : this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_polygon.getBounds())) : this.m_rBounds;
        if (this.m_bClip && ret != null) {
            ret = ret.intersection(this.m_clipRect);
        }
        return ret;
    }

    public Rectangle getBounds(VC vc) {
        Rectangle ret = null;
        if (this.m_bDrawCircular) {
            Rectangle rDest = vc.virtToDest(new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height));
            int diameter = Math.min(rDest.width, rDest.height);
            rDest.x += (rDest.width - diameter) / 2;
            rDest.y += (rDest.height - diameter) / 2;
            rDest.width = rDest.height = diameter;
            ret = vc.destToVirt(rDest);
        } else {
            ret = this.m_bDestCoords ? (this.m_rDestBounds != null ? vc.destToVirt(this.m_rDestBounds) : vc.destToVirt(this.m_polygon.getBounds())) : this.m_rBounds;
        }
        if (this.m_bClip && ret != null) {
            ret = ret.intersection(this.m_clipRect);
        }
        return ret;
    }

    public void hilite(Graphics g, VC vc) {
        Shape shape = null;
        if (this.m_bClip) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            shape = g.getClip();
            g.setClip(rClip);
        }
        if (this.m_bDestCoords && this.m_polygon != null) {
            g.setXORMode(Color.yellow);
            g.drawPolygon(this.m_polygon);
            g.setPaintMode();
            if (shape != null) {
                g.setClip(shape);
            }
            return;
        }
        Rectangle dest = this.m_bDestCoords && this.m_rDestBounds != null ? this.m_rDestBounds : vc.virtToDest(this.getBounds(vc));
        g.setXORMode(Color.yellow);
        g.drawOval(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
        if (this.m_bClip) {
            g.setClip(shape);
        }
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        int slopHeight = vc.destToVirtHeight(5);
        int slopWidth = vc.destToVirtWidth(5);
        Rectangle rBounds = this.getBounds(vc);
        if (this.m_bNoFill) {
            rBounds.grow(slopWidth / 2, slopHeight / 2);
            if (!this.isPointInOval(x, y, rBounds, vc)) {
                return false;
            }
            rBounds.grow(-slopWidth, -slopHeight);
            return !this.isPointInOval(x, y, rBounds, vc);
        }
        return this.isPointInOval(x, y, rBounds, vc);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    private boolean isPointInOval(int x, int y, Rectangle bounds, VC vc) {
        boolean bInside;
        if (!this.m_bDetectable) {
            return false;
        }
        if (this.m_bClip && !this.m_clipRect.contains(x, y)) {
            return false;
        }
        if (!this.m_bDestCoords) {
            double b;
            double yCenter;
            double dy;
            double a;
            double xCenter;
            double dx;
            bInside = !bounds.contains(x, y) ? false : (dx = (double)x - (xCenter = (double)bounds.x + (double)bounds.width / 2.0)) * dx / ((a = (double)bounds.width / 2.0) * a) + (dy = (double)y - (yCenter = (double)bounds.y + (double)bounds.height / 2.0)) * dy / ((b = (double)bounds.height / 2.0) * b) <= 1.0;
        } else if (this.m_rDestBounds != null && !this.m_rDestBounds.contains(vc.virtToDestX(x), vc.virtToDestY(y))) {
            bInside = false;
        } else if (this.m_polygon != null) {
            bInside = this.m_polygon.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        } else {
            bounds = this.m_rDestBounds != null ? this.m_rDestBounds : this.m_polygon.getBounds();
            double a = (double)bounds.width / 2.0;
            double b = (double)bounds.height / 2.0;
            double xCenter = (double)bounds.x + (double)bounds.width / 2.0;
            double yCenter = (double)bounds.y + (double)bounds.height / 2.0;
            double dx = (double)vc.virtToDestX(x) - xCenter;
            double dy = (double)vc.virtToDestY(y) - yCenter;
            bInside = dx * dx / (a * a) + dy * dy / (b * b) <= 1.0;
        }
        return bInside;
    }

    public void paintIt(Graphics g, VC vc) {
        Shape shape = null;
        if (this.m_bClip) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            shape = g.getClip();
            g.setClip(rClip);
        }
        if (this.m_bDestCoords) {
            if (g instanceof PrinterGraphics && ((PrinterGraphics)((Object)g)).getPrinterJob() != null && this.m_rDestBounds != null || this.m_polygon == null) {
                this.m_blackBox.paint(g, this.m_rDestBounds, true, this.m_bNoFill);
            } else if (this.m_polygon != null) {
                this.m_blackBox.paint(g, this.m_polygon);
            }
        } else if (this.getReferenceObject()) {
            this.m_blackBox.paint(g, vc.virtToDest(this.getBounds(vc)), true, this.m_bNoFill, this.m_nReferenceLineWidth);
        } else {
            this.m_blackBox.paint(g, vc.virtToDest(this.getBounds(vc)), true, this.m_bNoFill);
        }
        if (this.m_bClip) {
            g.setClip(shape);
        }
    }

    public void setBounds(Rectangle rBounds) {
        this.m_rBounds = rBounds;
    }

    public Polygon getShape(VC vc) {
        Polygon ret = null;
        ret = this.m_polygon != null ? vc.destToVirt(this.m_polygon) : (this.m_rDestBounds != null ? (this.m_bClip ? this.rectToPoly(this.m_clipRect.intersection(vc.destToVirt(this.m_rDestBounds))) : this.rectToPoly(vc.destToVirt(this.m_rDestBounds))) : (this.m_bClip ? this.rectToPoly(this.m_clipRect.intersection(this.m_rBounds)) : this.rectToPoly(this.m_rBounds)));
        return ret;
    }
}

