/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.util.Vector;
import tdg.Assert;
import tdg.Perspective;
import tdg.TDGNestedLabel;

public class TDGTestNestedGroupLabels
implements TDGNestedLabel {
    protected Perspective m_Perspective;
    protected String[][] m_Labels = new String[][]{{"Q1", "Q2", "Q3", "Q4"}, {"1997", "1998", "1999"}};
    protected boolean[][] m_raShown;
    protected int[] m_raShownPerLevel;
    protected int[][] m_raGrouping;

    public TDGTestNestedGroupLabels(Perspective perspective) {
        this.m_Perspective = perspective;
        this.calc();
    }

    public void calc() {
        int j;
        int nLevels = this.getNumLevels();
        int nMaxLabels = this.getNumLabelsAvailOnLevel(0);
        int nEVG = this.m_Perspective.getEffectiveViewableGroups();
        int nEGO = this.m_Perspective.getEffectiveGroupOffset();
        int nPerGroup = this.m_Labels[0].length;
        this.m_raShown = new boolean[nLevels][nMaxLabels];
        this.m_raShownPerLevel = new int[this.getNumLevels()];
        this.m_raGrouping = new int[nLevels - 1][nMaxLabels];
        int i = 0;
        while (i < nMaxLabels) {
            if (i >= nEGO && i < nEGO + nEVG) {
                this.m_raShown[0][i] = true;
                j = i / nPerGroup;
                this.m_raShown[1][j] = true;
            }
            ++i;
        }
        i = 0;
        while (i < nLevels) {
            j = 0;
            while (j < nMaxLabels) {
                if (this.m_raShown[i][j]) {
                    int n = i;
                    this.m_raShownPerLevel[n] = this.m_raShownPerLevel[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nLevels - 1) {
            j = 0;
            while (j < nMaxLabels) {
                int nBegin;
                int k = nBegin = j / nPerGroup * nPerGroup;
                while (k < nBegin + nPerGroup) {
                    if (this.m_raShown[i][k]) {
                        int[] nArray = this.m_raGrouping[i];
                        int n = j;
                        nArray[n] = nArray[n] + 1;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getNumLevels() {
        return this.m_Labels.length;
    }

    public int getNumLabelsOnLevel(int nLevel) {
        Assert.assert(nLevel >= 0 && nLevel < this.m_Labels.length);
        this.calc();
        int nLabels = this.m_raShownPerLevel[nLevel];
        return nLabels;
    }

    protected int getNumLabelsAvailOnLevel(int nLevel) {
        Assert.assert(nLevel >= 0 && nLevel < this.m_Labels.length);
        int nLabels = 1;
        int i = nLevel;
        while (i < this.getNumLevels()) {
            int nGroupsThisLevel = this.m_Labels[i].length;
            nLabels *= nGroupsThisLevel;
            ++i;
        }
        return nLabels;
    }

    public Vector getAllLabels(int nLevel) {
        Assert.assert(nLevel >= 0 && nLevel < this.m_Labels.length);
        this.calc();
        int nLabels = this.getNumLabelsOnLevel(nLevel);
        Vector<String> vLabels = new Vector<String>(nLabels);
        int i = 0;
        while (i < nLabels) {
            String sLabel = this.getLabel(i, nLevel);
            if (sLabel != null) {
                vLabels.addElement(sLabel);
            }
            ++i;
        }
        return vLabels;
    }

    public String getLabel(int nGroup, int nLevel) {
        Assert.assert(nLevel >= 0 && nLevel < this.m_Labels.length);
        Assert.assert(nGroup >= 0);
        this.calc();
        int iShown = -1;
        int nMaxLabels = this.getNumLabelsAvailOnLevel(0);
        int i = 0;
        while (i < nMaxLabels) {
            if (this.m_raShown[nLevel][i]) {
                ++iShown;
            }
            if (iShown == nGroup) break;
            ++i;
        }
        Assert.assert(iShown >= 0);
        if (iShown < 0) {
            return null;
        }
        int g = i % this.m_Labels[nLevel].length;
        String sLabel = this.m_Labels[nLevel][g];
        return sLabel;
    }

    public int getLabelGrouping(int nGroup, int nLevel) {
        Assert.assert(nLevel >= 0 && nLevel < this.m_Labels.length);
        Assert.assert(nGroup >= 0);
        this.calc();
        int nGrouping = this.m_raGrouping[nLevel][nGroup];
        return nGrouping;
    }

    public int getParentIndex(int nGroup, int nLevel) {
        return -1;
    }
}

