/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import tdg.AssertionException;
import tdg.LookKeyObj;
import tdg.Perspective;
import tdg.TDGToken;
import tdg.TDGTokenizer;
import tdg.draw.IdentObj;
import tdg.model3d.Matrix3d;

public class TDGProperties
extends HashMap
implements Serializable {
    Perspective m_Perspective;
    String m_ChartObjectName;
    public static final int NB_IDENTOBJ_PARAMS = 6;
    IdentObj m_identObj = new IdentObj(-3);
    String m_szMethodName;
    String m_szParamObj;
    public static final int ANY_EXPECTED = 0;
    public static final int NEXTPARAM_EXPECTED = 1;
    public static final int SEPARATOR_EXPECTED = 2;
    public static final int OPEN_PARENTHESES_EXPECTED = 3;
    Vector m_Tokens = new Vector();
    int m_nIndex;
    TDGToken m_Token;
    Method[] m_Methods;
    int m_nCurrentSeries;
    FileOutputStream m_fos;
    boolean m_bDebugToFile;
    boolean m_bDebugToConsole;
    static final char LINEBREAK = '\n';

    public TDGProperties(Perspective perspective) {
        super(400);
        this.m_Perspective = perspective;
        this.m_bDebugToFile = false;
        this.m_bDebugToConsole = false;
        if (this.m_bDebugToFile) {
            try {
                this.m_fos = new FileOutputStream("debug.log");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean parseObject(Object obj) {
        boolean bValidParameter = true;
        if (obj.getClass().getName().equals("java.lang.Integer") || obj.getClass().getName().equals("java.lang.Double") || obj.getClass().getName().equals("java.lang.Boolean")) {
            this.m_szParamObj = obj.toString();
        } else if (obj.getClass().getName().equals("java.lang.String")) {
            this.m_szParamObj = "\"" + obj.toString() + "\"";
            this.m_szParamObj = TDGProperties.ReplaceMacro(this.m_szParamObj, "\n", "\\n");
        } else if (obj.getClass().getName().equals("java.awt.Color")) {
            Color c = (Color)obj;
            Integer r = new Integer(c.getRed());
            Integer g = new Integer(c.getGreen());
            Integer b = new Integer(c.getBlue());
            this.m_szParamObj = "new Color(" + r.toString() + "," + g.toString() + "," + b.toString() + ")";
        } else if (obj.getClass().getName().equals("java.awt.Rectangle")) {
            Rectangle r = (Rectangle)obj;
            Integer x = new Integer(r.x);
            Integer y = new Integer(r.y);
            Integer width = new Integer(r.width);
            Integer height = new Integer(r.height);
            this.m_szParamObj = "new Rectangle(" + x.toString() + "," + y.toString() + "," + width.toString() + "," + height.toString() + ")";
        } else if (obj.getClass().getName().equals("tdg.model3d.Matrix3d")) {
            Matrix3d m3d = (Matrix3d)obj;
            Double m00 = new Double(m3d.m00);
            Double m01 = new Double(m3d.m01);
            Double m02 = new Double(m3d.m02);
            Double m10 = new Double(m3d.m10);
            Double m11 = new Double(m3d.m11);
            Double m12 = new Double(m3d.m12);
            Double m20 = new Double(m3d.m20);
            Double m21 = new Double(m3d.m21);
            Double m22 = new Double(m3d.m22);
            this.m_szParamObj = m00.toString() + "," + m01.toString() + "," + m02.toString() + "," + m10.toString() + "," + m11.toString() + "," + m12.toString() + "," + m20.toString() + "," + m21.toString() + "," + m22.toString();
        } else {
            bValidParameter = false;
        }
        return bValidParameter;
    }

    private void parseKey(LookKeyObj key) {
        boolean nIdentObjParam = false;
        this.m_szMethodName = key.getAttr().toString();
        this.m_identObj = key.getIdentObj();
    }

    private void writeLine(OutputStream out) throws IOException {
        String szLine;
        if (this.isProperty()) {
            szLine = this.m_ChartObjectName.equals("") ? "set" + this.m_szMethodName + "(" + this.m_szParamObj + ");\r\n" : this.m_ChartObjectName + ".set" + this.m_szMethodName + "(" + this.m_szParamObj + ");\r\n";
        } else {
            String szParam;
            String szIdentObjMethod = this.m_identObj.getIdentObjMethod();
            if (!this.m_identObj.isMISC_NA()) {
                Integer p = new Integer(this.m_identObj.getMiscID());
                szParam = "," + p.toString();
            } else {
                szParam = "";
            }
            szLine = szIdentObjMethod.equals("GLOBAL_SCALAR_PROPERTY") ? "set" + this.m_szMethodName + "(" + this.m_szParamObj + szParam + ");\r\n" : (this.m_ChartObjectName.equals("") ? "set" + this.m_szMethodName + "(" + szIdentObjMethod + "," + this.m_szParamObj + szParam + ");\r\n" : this.m_ChartObjectName + ".set" + this.m_szMethodName + "(" + this.m_ChartObjectName + "." + szIdentObjMethod + "," + this.m_szParamObj + szParam + ");\r\n");
        }
        out.write(szLine.getBytes());
    }

    private boolean isProperty() {
        return this.m_identObj.isOBJECT_NA() && this.m_identObj.isSERIES_NA() && this.m_identObj.isGROUP_NA() && this.m_identObj.isSTACK_NA() && this.m_identObj.isMISC_NA();
    }

    public void save(OutputStream out, String ChartObjectName) throws IOException {
        this.m_ChartObjectName = ChartObjectName;
    }

    public void save(OutputStream out) throws IOException {
        this.m_ChartObjectName = "";
    }

    public void _save(OutputStream out) throws IOException {
        Iterator e = this.keySet().iterator();
        while (e.hasNext()) {
            Object objKey = e.next();
            String szClassName = objKey.getClass().getName();
            if (szClassName.equals("java.lang.String")) continue;
            LookKeyObj key = (LookKeyObj)objKey;
            Object obj = this.get(key);
            this.debugPrintln("key = " + key);
            this.parseKey(key);
            if (this.parseObject(obj)) {
                this.debugPrintln("Parameter = " + this.m_szParamObj);
                this.writeLine(out);
                continue;
            }
            this.debugPrintln("saving of : " + this.m_szMethodName + " object : " + obj.getClass().getName() + " failed!!!!!!!!!");
        }
    }

    public void load(InputStream in) {
        in = this.initialization(in, this.m_Perspective.getClass());
        this.parsePass1(in);
        if (this.m_bDebugToFile || this.m_bDebugToConsole) {
            Enumeration e = this.m_Tokens.elements();
            while (e.hasMoreElements()) {
                TDGToken token = (TDGToken)e.nextElement();
                String szTemp = token.toString();
                this.debugPrintln(szTemp);
            }
        }
        this.parsePass2();
    }

    private void parsePass1(InputStream in) {
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        TDGTokenizer st = new TDGTokenizer(r);
        int nextTokenExpected = 1;
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.slashStarComments(true);
        st.quoteChar(34);
        st.parseNumbers();
        this.m_Tokens.removeAllElements();
        try {
            do {
                TDGToken token = null;
                switch (st.nextToken()) {
                    case -3: {
                        String szWord = st.sval;
                        if (szWord.equals("new")) {
                            token = new TDGToken(1);
                            nextTokenExpected = 1;
                            break;
                        }
                        if (szWord.equals("true")) {
                            token = new TDGToken(2, Boolean.TRUE);
                            nextTokenExpected = 2;
                            break;
                        }
                        if (szWord.equals("false")) {
                            token = new TDGToken(2, Boolean.FALSE);
                            nextTokenExpected = 2;
                            break;
                        }
                        if (szWord.equals("null")) {
                            token = new TDGToken(10);
                            nextTokenExpected = 2;
                            break;
                        }
                        token = new TDGToken(3, szWord);
                        nextTokenExpected = 3;
                        break;
                    }
                    case 40: {
                        token = new TDGToken(4);
                        nextTokenExpected = 1;
                        break;
                    }
                    case 41: {
                        token = new TDGToken(5);
                        nextTokenExpected = 2;
                        break;
                    }
                    case 59: {
                        token = new TDGToken(6);
                        nextTokenExpected = 1;
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 44: {
                        token = new TDGToken(7);
                        nextTokenExpected = 1;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 34: {
                        String szString = st.sval;
                        szString = TDGProperties.ReplaceMacro(szString, "\\n", "\n");
                        szString = TDGProperties.ReplaceMacro(szString, "[QUOTE]", "'");
                        szString = this.UnicodeTranslation(szString);
                        token = new TDGToken(8, szString);
                        nextTokenExpected = 2;
                        break;
                    }
                    case -2: {
                        token = new TDGToken(9, new Double(st.nval));
                        nextTokenExpected = 2;
                        break;
                    }
                    default: {
                        this.debugPrintln("st.ttype = " + st.ttype);
                        this.debugPrintln("Unknown String ->[" + st.sval + "]");
                        this.debugPrintln("Unknown Number ->[" + st.nval + "]");
                    }
                }
                if (token == null) continue;
                this.m_Tokens.addElement(token);
            } while (st.ttype != -1);
            in.close();
        }
        catch (Exception error) {
            this.debugPrintln("Exception in parsePass1");
            error.printStackTrace();
        }
    }

    private void parsePass2() {
        this.m_nIndex = 0;
        while (this.m_nIndex < this.m_Tokens.size()) {
            this.parseParameter();
            this.m_Token = this.getToken(1);
            if (this.m_Token == null) {
                this.debugPrintln(";");
                this.debugPrintln("Parsing Done");
                break;
            }
            if (this.m_Token.getType() == 6) {
                this.debugPrintln(";");
            } else {
                this.debugPrintln("Wrong token encountered");
                while (this.m_nIndex < this.m_Tokens.size() && this.m_Token.getType() != 6) {
                    this.m_Token = this.getToken(1);
                }
            }
            this.m_Token = this.getToken(1);
        }
    }

    private Object parseParameter() {
        this.debugPrint("[");
        Vector<Object> params = new Vector<Object>();
        this.m_Token = this.getToken(0);
        switch (this.m_Token.getType()) {
            case 1: {
                this.m_Token = this.getToken(1);
                if (this.m_Token == null || this.m_Token.getType() != 3) {
                    return null;
                }
                String szConstructorName = (String)this.m_Token.getObject();
                this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.m_Token = this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.debugPrint("new " + szConstructorName + "(");
                while (this.m_Token.isNewParameter()) {
                    params.addElement(this.parseParameter());
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    if (this.m_Token.getType() != 7) continue;
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    this.debugPrint(",");
                }
                if (this.m_Token.getType() != 5) {
                    throw new AssertionException("Parser Error: open parentheses expected");
                }
                this.debugPrint(")");
                return this.invokeConstructor(szConstructorName, params);
            }
            case 3: {
                String szMethodName = (String)this.m_Token.getObject();
                this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.m_Token = this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.debugPrint(szMethodName + "(");
                while (this.m_Token.isNewParameter()) {
                    params.addElement(this.parseParameter());
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    if (this.m_Token.getType() != 7) continue;
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    this.debugPrint(",");
                }
                if (this.m_Token.getType() != 5) {
                    return null;
                }
                this.debugPrint(")");
                return this.invokeMethod(szMethodName, params);
            }
            case 2: 
            case 8: 
            case 9: {
                this.debugPrint(this.m_Token.getObject().toString() + "]");
                return this.m_Token.getObject();
            }
            case 10: {
                this.debugPrint("NULL]");
                return null;
            }
        }
        return null;
    }

    private TDGToken getToken(int offset) {
        if (this.m_nIndex + offset < this.m_Tokens.size()) {
            this.m_nIndex += offset;
            TDGToken token = (TDGToken)this.m_Tokens.elementAt(this.m_nIndex);
            return token;
        }
        return null;
    }

    private Object invokeMethod(String szMethodName, Vector params) {
        boolean bSuccess = false;
        Object retObject = null;
        Object[] obj = new Object[params.size()];
        int i = 0;
        while (i < params.size()) {
            obj[i] = params.elementAt(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_Methods.length) {
            if (this.m_Methods[i2].getName().equals(szMethodName)) {
                Class<?>[] paramClass = this.m_Methods[i2].getParameterTypes();
                if (params.size() == paramClass.length) {
                    int j = 0;
                    while (j < paramClass.length) {
                        if (obj[j] == null) {
                            return null;
                        }
                        if (paramClass[j].getName().equals("int") && obj[j].getClass().getName().equals("java.lang.Double")) {
                            obj[j] = new Integer(((Double)obj[j]).intValue());
                        }
                        ++j;
                    }
                    try {
                        retObject = this.m_Methods[i2].invoke((Object)this.m_Perspective, obj);
                        bSuccess = true;
                        break;
                    }
                    catch (InvocationTargetException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
            }
            ++i2;
        }
        if (!bSuccess) {
            if (szMethodName.equals("setSeriesLabelArray")) {
                if (this.m_Perspective.getUseSampleData()) {
                    this.m_Perspective.setUseSampleData(false);
                }
                int i3 = 0;
                while (i3 < params.size()) {
                    Object o = params.elementAt(i3);
                    if (o instanceof String) {
                        this.m_Perspective.setSeriesLabel(i3, (String)o);
                    }
                    ++i3;
                }
                bSuccess = true;
            } else if (szMethodName.equals("setGroupLabelArray")) {
                if (this.m_Perspective.getUseSampleData()) {
                    this.m_Perspective.setUseSampleData(false);
                }
                int i4 = 0;
                while (i4 < params.size()) {
                    Object o = params.elementAt(i4);
                    if (o instanceof String) {
                        this.m_Perspective.setGroupLabel(i4, (String)o);
                    }
                    ++i4;
                }
                bSuccess = true;
            } else if (szMethodName.equals("setDataSeries")) {
                if (this.m_Perspective.getUseSampleData()) {
                    this.m_Perspective.setUseSampleData(false);
                }
                int i5 = 0;
                while (i5 < params.size()) {
                    Object o = params.elementAt(i5);
                    if (o == null || o.getClass().getName().equals("java.lang.Double") || o.getClass().getName().equals("java.lang.String")) {
                        this.m_Perspective.setData(this.m_nCurrentSeries, i5, o);
                    }
                    ++i5;
                }
                ++this.m_nCurrentSeries;
                bSuccess = true;
            }
        }
        if (bSuccess) {
            this.debugPrint("]\"invoke ok\"");
        } else {
            this.debugPrint("]\"invoke failed!!!!!!!!!!!!\"");
        }
        return retObject;
    }

    private Object invokeConstructor(String szConstructorName, Vector params) {
        Serializable retObject = null;
        Object[] obj = new Object[params.size()];
        int i = 0;
        while (i < params.size()) {
            obj[i] = params.elementAt(i);
            ++i;
        }
        if (szConstructorName.equals("Color")) {
            retObject = params.size() == 1 && obj[0].getClass().getName().equals("java.lang.Double") ? new Color(((Double)obj[0]).intValue()) : (params.size() == 3 ? (obj[0].getClass().getName().equals("java.lang.Double") && obj[1].getClass().getName().equals("java.lang.Double") && obj[2].getClass().getName().equals("java.lang.Double") && ((Double)obj[0] > 1.0 || (Double)obj[1] > 1.0 || (Double)obj[2] > 1.0) ? new Color(((Double)obj[0]).intValue(), ((Double)obj[1]).intValue(), ((Double)obj[2]).intValue()) : new Color(((Double)obj[0]).floatValue(), ((Double)obj[1]).floatValue(), ((Double)obj[2]).floatValue())) : Color.white);
        } else if (szConstructorName.equals("Rectangle")) {
            retObject = params.size() == 4 && obj[0].getClass().getName().equals("java.lang.Double") && obj[1].getClass().getName().equals("java.lang.Double") && obj[2].getClass().getName().equals("java.lang.Double") && obj[3].getClass().getName().equals("java.lang.Double") ? new Rectangle(((Double)obj[0]).intValue(), ((Double)obj[1]).intValue(), ((Double)obj[2]).intValue(), ((Double)obj[3]).intValue()) : new Rectangle();
        }
        if (retObject != null) {
            this.debugPrint("]\"invoke ok\"");
        } else {
            this.debugPrint("]\"invoke failed!!!!!!!!!!!!\"");
        }
        return retObject;
    }

    /*
     * WARNING - void declaration
     */
    public String UnicodeTranslation(String SourceString) {
        int aPosition;
        String aProcessedString = "";
        String aMacro = "\\u";
        aProcessedString = SourceString;
        while ((aPosition = aProcessedString.indexOf(aMacro)) != -1) {
            void var4_5;
            String testString = aProcessedString.substring(0, (int)var4_5);
            testString = testString + this.makeUnicodeChar(aProcessedString.substring((int)(var4_5 + 2), (int)(var4_5 + 6)));
            aPosition = var4_5 + (aMacro.length() + 4);
            aProcessedString = testString = testString + aProcessedString.substring(aPosition, aProcessedString.length());
        }
        return aProcessedString;
    }

    char makeUnicodeChar(String aUnicodeEscape) {
        aUnicodeEscape = aUnicodeEscape.toUpperCase();
        char[] charArray = aUnicodeEscape.toCharArray();
        int anInt = this.hex2Int(charArray[3]) + this.hex2Int(charArray[2]) * 16 + this.hex2Int(charArray[1]) * 256 + this.hex2Int(charArray[0]) * 4096;
        char resultChar = (char)anInt;
        return resultChar;
    }

    int hex2Int(char aChar) {
        int resultInt = 0;
        switch (aChar) {
            case '0': {
                resultInt = 0;
                break;
            }
            case '1': {
                resultInt = 1;
                break;
            }
            case '2': {
                resultInt = 2;
                break;
            }
            case '3': {
                resultInt = 3;
                break;
            }
            case '4': {
                resultInt = 4;
                break;
            }
            case '5': {
                resultInt = 5;
                break;
            }
            case '6': {
                resultInt = 6;
                break;
            }
            case '7': {
                resultInt = 7;
                break;
            }
            case '8': {
                resultInt = 8;
                break;
            }
            case '9': {
                resultInt = 9;
                break;
            }
            case 'A': {
                resultInt = 10;
                break;
            }
            case 'B': {
                resultInt = 11;
                break;
            }
            case 'C': {
                resultInt = 12;
                break;
            }
            case 'D': {
                resultInt = 13;
                break;
            }
            case 'E': {
                resultInt = 14;
                break;
            }
            case 'F': {
                resultInt = 15;
            }
        }
        return resultInt;
    }

    /*
     * WARNING - void declaration
     */
    public static String ReplaceMacro(String SourceString, String aMacro, String Replacement) {
        int aPosition;
        String aProcessedString = "";
        aProcessedString = SourceString;
        while ((aPosition = aProcessedString.indexOf(aMacro)) != -1) {
            void var5_5;
            String testString = aProcessedString.substring(0, (int)var5_5);
            testString = testString + Replacement;
            aPosition = var5_5 + aMacro.length();
            aProcessedString = testString = testString + aProcessedString.substring(aPosition, aProcessedString.length());
        }
        return aProcessedString;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream initialization(InputStream in, Class c) {
        this.m_nCurrentSeries = 0;
        this.m_Methods = c.getMethods();
        byte[] b = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int nCount;
            while ((nCount = in.read(b)) > 0) {
                void var4_5;
                out.write(b, 0, (int)var4_5);
            }
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String szBuffer = new String(out.toByteArray());
        szBuffer = TDGProperties.ReplaceMacro(szBuffer, "&quot;", "\"");
        return new ByteArrayInputStream(szBuffer.getBytes());
    }

    private void debugPrint(String str) {
        if (this.m_bDebugToConsole) {
            System.out.print(str);
        }
        if (this.m_bDebugToFile) {
            try {
                this.m_fos.write(str.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void debugPrintln(String str) {
        if (this.m_bDebugToConsole) {
            System.out.println(str);
        }
        if (this.m_bDebugToFile) {
            try {
                str = str + "\n\r";
                this.m_fos.write(str.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

