/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.io.Serializable;
import tdg.DataFormat;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.data.in.TDGDataGrid;

public class TDGDataSampler
implements TDGDataGrid,
Serializable {
    boolean isDirtyFlag = false;
    Object[][] external_data_array;
    Perspective m_Perspective;
    JGraphType currentGraphType = null;
    String[] rowLabels;
    int numRows;
    String[] colLabels;
    int numCols;
    String chartTitle = null;
    String chartSubTitle = null;
    String chartFootnote = null;
    String chartX1Title = null;
    String chartY1Title = null;
    String chartY2Title = null;
    String chartO1Title = null;
    String chartO2Title = null;
    static double[][] DataSheetHL = new double[][]{{37.75, 36.25, 38.125, 37.3125, 38.75, 36.5, 37.875, 36.75, 37.5, 36.5, 37.5625, 36.8125, 37.375, 35.9375, 37.625, 36.3125, 38.25, 36.75, 38.125, 36.875, 39.375, 37.6875, 39.875, 39.25, 39.75, 38.375, 39.625, 39.0, 40.875, 39.3125, 41.8125, 40.625, 45.125, 42.5, 47.875, 45.5, 46.875, 42.625, 47.875, 45.3125}, {47.75, 46.25, 48.125, 47.3125, 48.75, 46.5, 47.875, 46.75, 47.5, 46.5, 47.5625, 46.8125, 47.375, 45.9375, 47.625, 46.3125, 48.25, 46.75, 48.125, 46.875, 49.375, 47.6875, 49.875, 49.25, 49.75, 48.375, 49.625, 49.0, 50.875, 49.3125, 51.8125, 50.625, 55.125, 52.5, 57.875, 55.5, 56.875, 52.625, 57.875, 55.3125}};
    static double[][] DataSheetHLC = new double[][]{{37.75, 36.25, 36.8125, 38.125, 37.3125, 37.9375, 38.75, 36.5, 37.375, 37.875, 36.75, 37.0625, 37.5, 36.5, 36.625, 37.5625, 36.8125, 37.2187, 37.375, 35.9375, 36.5625, 37.625, 36.3125, 37.625, 38.25, 36.75, 37.125, 38.125, 36.875, 37.375, 39.375, 37.6875, 39.125, 39.875, 39.25, 39.5, 39.75, 38.375, 39.4375, 39.625, 39.0, 39.125, 40.875, 39.3125, 40.1875, 41.8125, 40.625, 41.5625, 45.125, 42.5, 45.0, 47.875, 45.5, 46.125, 46.875, 42.625, 46.3125, 47.875, 45.3125, 45.75}, {53.75, 49.25, 50.8125, 48.125, 47.3125, 47.9375, 48.75, 46.5, 47.375, 47.875, 46.75, 47.0625, 47.5, 46.5, 46.625, 57.5625, 55.8125, 57.2187, 67.375, 63.9375, 66.5625, 57.625, 56.3125, 57.625, 58.25, 56.75, 57.125, 58.125, 56.875, 57.375, 59.375, 57.6875, 59.125, 69.875, 69.25, 69.5, 69.75, 62.375, 62.4375, 59.625, 59.0, 59.125, 60.875, 59.3125, 60.1875, 71.8125, 64.625, 71.5625, 75.125, 72.5, 73.0, 77.875, 75.5, 76.125, 66.875, 62.625, 66.3125, 77.875, 75.3125, 75.75}};
    static double[][] DataSheetOHLC = new double[][]{{36.5, 37.75, 36.25, 36.8125, 37.5, 38.125, 37.3125, 37.9375, 38.375, 38.75, 36.5, 37.375, 37.1875, 37.875, 36.75, 37.0625, 37.5, 37.5, 36.5, 36.625, 37.125, 37.5625, 36.8125, 37.2187, 36.1875, 37.375, 35.9375, 36.5625, 36.5, 37.625, 36.3125, 37.625, 37.875, 38.25, 36.75, 37.125, 36.875, 38.125, 36.875, 37.375, 37.875, 39.375, 37.6875, 39.125, 39.5625, 39.875, 39.25, 39.5, 39.25, 39.75, 38.375, 39.4375, 39.375, 39.625, 39.0, 39.125, 39.375, 40.875, 39.3125, 40.1875, 41.25, 41.8125, 40.625, 41.5625, 42.75, 45.125, 42.5, 45.0, 46.5, 47.875, 45.5, 46.125, 44.875, 46.875, 42.625, 46.3125, 47.875, 47.875, 45.3125, 45.75}, {56.5, 57.75, 56.25, 56.8125, 57.5, 58.125, 57.3125, 57.9375, 58.375, 58.75, 56.5, 57.375, 57.1875, 57.875, 56.75, 57.0625, 57.5, 57.5, 56.5, 56.625, 57.125, 57.5625, 56.8125, 57.2187, 56.1875, 57.375, 55.9375, 56.5625, 56.5, 57.625, 56.3125, 57.625, 57.875, 58.25, 56.75, 57.125, 56.875, 58.125, 56.875, 57.375, 57.875, 59.375, 57.6875, 59.125, 59.5625, 59.875, 59.25, 59.5, 59.25, 59.75, 58.375, 59.4375, 59.375, 59.625, 59.0, 59.125, 59.375, 60.875, 59.3125, 60.1875, 61.25, 61.8125, 60.625, 61.5625, 62.75, 65.125, 62.5, 65.0, 66.5, 67.875, 65.5, 66.125, 64.875, 66.875, 62.625, 66.3125, 67.875, 67.875, 65.3125, 65.75}};
    static double[][] DataSheetOC = new double[][]{{37.75, 36.25, 38.125, 39.3125, 38.75, 36.5, 37.875, 36.75, 37.5, 38.5, 37.5625, 36.8125, 37.375, 35.9375, 37.625, 36.3125, 38.25, 36.75, 38.125, 36.875, 39.375, 37.6875, 39.875, 41.25, 39.75, 38.375, 39.625, 39.0, 40.875, 39.3125, 41.8125, 44.625, 45.125, 42.5, 47.875, 45.5, 46.875, 42.625, 47.875, 45.3125}, {47.75, 46.25, 48.125, 47.3125, 48.75, 46.5, 47.875, 46.75, 47.5, 46.5, 47.5625, 46.8125, 47.375, 45.9375, 47.625, 46.3125, 48.25, 46.75, 48.125, 46.875, 49.375, 47.6875, 49.875, 49.25, 49.75, 48.375, 49.625, 49.0, 50.875, 49.3125, 51.8125, 50.625, 55.125, 52.5, 57.875, 55.5, 56.875, 52.625, 57.875, 55.3125}};
    static double[][] DataSheetHLV = new double[][]{{37.75, 36.25, 5411800.0, 38.125, 37.3125, 5775600.0, 38.75, 36.5, 4334000.0, 37.875, 36.75, 4258600.0, 37.5, 36.5, 2153300.0, 37.5625, 36.8125, 3754200.0, 37.375, 35.9375, 738100.0, 37.625, 36.3125, 3178700.0, 38.25, 36.75, 2382900.0, 38.125, 36.875, 3030200.0, 39.375, 37.6875, 6167700.0, 39.875, 39.25, 5138000.0, 39.75, 38.375, 2931900.0, 39.625, 39.0, 2347700.0, 40.875, 39.3125, 4125900.0, 41.8125, 40.625, 5843800.0, 45.125, 42.5, 8886700.0, 47.875, 45.5, 1.43259E7, 46.875, 42.625, 1.67617E7, 47.875, 45.3125, 8154800.0}};
    static double[][] DataSheetHLCV = new double[][]{{37.75, 36.25, 36.8125, 5411800.0, 38.125, 37.3125, 37.9375, 5775600.0, 38.75, 36.5, 37.375, 4334000.0, 37.875, 36.75, 37.0625, 4258600.0, 37.5, 36.5, 36.625, 2153300.0, 37.5625, 36.8125, 37.2187, 3754200.0, 37.375, 35.9375, 36.5625, 738100.0, 37.625, 36.3125, 37.625, 3178700.0, 38.25, 36.75, 37.125, 2382900.0, 38.125, 36.875, 37.375, 3030200.0, 39.375, 37.6875, 39.125, 6167700.0, 39.875, 39.25, 39.5, 5138000.0, 39.75, 38.375, 39.4375, 2931900.0, 39.625, 39.0, 39.125, 2347700.0, 40.875, 39.3125, 40.1875, 4125900.0, 41.8125, 40.625, 41.5625, 5843800.0, 45.125, 42.5, 45.0, 8886700.0, 47.875, 45.5, 46.125, 1.43259E7, 46.875, 42.625, 46.3125, 1.67617E7, 47.875, 45.3125, 45.75, 8154800.0}};
    static double[][] DataSheetOHLCV = new double[][]{{36.5, 37.75, 36.25, 36.8125, 5411800.0, 37.5, 38.125, 37.3125, 37.9375, 5775600.0, 38.375, 38.75, 36.5, 37.375, 4334000.0, 37.1875, 37.875, 36.75, 37.0625, 4258600.0, 37.5, 37.5, 36.5, 36.625, 2153300.0, 37.125, 37.5625, 36.8125, 37.2187, 3754200.0, 36.1875, 37.375, 35.9375, 36.5625, 738100.0, 36.5, 37.625, 36.3125, 37.625, 3178700.0, 37.875, 38.25, 36.75, 37.125, 2382900.0, 36.875, 38.125, 36.875, 37.375, 3030200.0, 37.875, 39.375, 37.6875, 39.125, 6167700.0, 39.5625, 39.875, 39.25, 39.5, 5138000.0, 39.25, 39.75, 38.375, 39.4375, 2931900.0, 39.375, 39.625, 39.0, 39.125, 2347700.0, 39.375, 40.875, 39.3125, 40.1875, 4125900.0, 41.25, 41.8125, 40.625, 41.5625, 5843800.0, 42.75, 45.125, 42.5, 45.0, 8886700.0, 46.5, 47.875, 45.5, 46.125, 1.43259E7, 44.875, 46.875, 42.625, 46.3125, 1.67617E7, 47.875, 47.875, 45.3125, 45.75, 8154800.0}};
    static double[][] DataSheetOCV = new double[][]{{37.75, 36.25, 5411800.0, 38.125, 39.3125, 5775600.0, 38.75, 36.5, 4334000.0, 37.875, 36.75, 4258600.0, 37.5, 38.5, 2153300.0, 37.5625, 36.8125, 3754200.0, 37.375, 35.9375, 738100.0, 37.625, 39.3125, 3178700.0, 38.25, 36.75, 2382900.0, 38.125, 36.875, 3030200.0, 39.375, 37.6875, 6167700.0, 39.875, 39.25, 5138000.0, 39.75, 38.375, 2931900.0, 39.625, 39.0, 2347700.0, 40.875, 39.3125, 4125900.0, 41.8125, 43.625, 5843800.0, 45.125, 42.5, 8886700.0, 47.875, 45.5, 1.43259E7, 46.875, 42.625, 1.67617E7, 47.875, 45.3125, 8154800.0}};
    static double[][] DataSheetPie = new double[][]{{19565.0, 16235.0, 12000.0, 7000.0, 30200.0}, {5970.0, 5063.0, 3000.0, 18007.0, 7800.0}, {58762.0, 49500.0, 3098.0, 11022.0, 80390.0}, {3139.0, 2626.0, 6100.0, 16003.0, 43000.0}, {22369.0, 18621.0, 13600.0, 38009.0, 12000.0}};
    static double[][] DataSheetXYLBL = new double[][]{{14.0, 23.0, 1.0, 33.0, 35.0, 2.0}, {34.0, 54.0, 1.0, 42.0, 66.0, 2.0}, {45.0, 54.0, 1.0, 50.0, 39.0, 2.0}, {11.0, 87.0, 1.0, 9.0, 80.0, 2.0}, {43.0, 98.0, 1.0, 60.0, 77.0, 2.0}, {5.0, 35.0, 1.0, 18.0, 29.0, 2.0}};
    static String[] DataSheetXYLBLString = new String[]{"Data pt1", "Data pt2", "Data pt3", "Data pt4", "Data pt5", "Data pt6"};
    static double[][] DataSheetXYZLBL = new double[][]{{14.0, 23.0, 123.0, 1.0, 33.0, 35.0, 97.0, 2.0}, {34.0, 54.0, 112.0, 1.0, 42.0, 66.0, 122.0, 2.0}, {45.0, 54.0, 141.0, 1.0, 50.0, 39.0, 102.0, 2.0}, {11.0, 87.0, 132.0, 1.0, 9.0, 80.0, 111.0, 2.0}, {43.0, 98.0, 99.0, 1.0, 60.0, 77.0, 98.0, 2.0}, {5.0, 35.0, 105.0, 1.0, 18.0, 29.0, 125.0, 2.0}};
    static String[] DataSheetXYZLBLString = new String[]{"Data pt1", "Data pt2", "Data pt3", "Data pt4", "Data pt5", "Data pt6"};
    static double[][] DataSheetRESOURCE = new double[][]{{650.0, 4800.0}, {500.0, 4000.0}, {300.0, 4500.0}, {500.0, 4800.0}, {300.0, 5000.0}, {400.0, 5500.0}, {400.0, 3500.0}, {500.0, 5000.0}};
    static String[] DataSheetRESOURCEString = new String[]{"Birds", "Snakes", "Bears", "Big Cats", "Monkees", "Apes", "Alligators", "Elephants"};
    static double[][] DataSheetGeneral = new double[][]{{35.0, 10.0, 15.0, 26.0, 39.0, 3.0}, {35.0, 20.0, 33.0, 59.0, 31.0, 33.0}, {25.0, 36.0, 39.0, 34.0, 47.0, 27.0}, {15.0, 20.0, 25.0, 35.0, 60.0, 30.0}, {10.0, 10.0, 10.0, 10.0, 10.0, 30.0}};

    public TDGDataSampler(Perspective a_Perspective, JGraphType gt) {
        this.m_Perspective = a_Perspective;
        this.currentGraphType = gt;
        this.LoadGraphSpecificData();
    }

    public void setDataMatrix(double[][] theData) {
        this.external_data_array = new Object[this.numRows][this.numCols];
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                this.external_data_array[row][col] = new Double(theData[row][col]);
                ++col;
            }
            ++row;
        }
    }

    public void LoadGraphSpecificData() {
        int i;
        if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_HL)) {
            this.numRows = DataSheetHL.length;
            this.numCols = DataSheetHL[0].length;
            this.setDataMatrix(DataSheetHL);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_HLC)) {
            this.numRows = DataSheetHLC.length;
            this.numCols = DataSheetHLC[0].length;
            this.setDataMatrix(DataSheetHLC);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_OHLC)) {
            this.numRows = DataSheetOHLC.length;
            this.numCols = DataSheetOHLC[0].length;
            this.setDataMatrix(DataSheetOHLC);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_OC)) {
            this.numRows = DataSheetOC.length;
            this.numCols = DataSheetOC[0].length;
            this.setDataMatrix(DataSheetOC);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_HL_VOL)) {
            this.numRows = DataSheetHLV.length;
            this.numCols = DataSheetHLV[0].length;
            this.setDataMatrix(DataSheetHLV);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_HLC_VOL)) {
            this.numRows = DataSheetHLCV.length;
            this.numCols = DataSheetHLCV[0].length;
            this.setDataMatrix(DataSheetHLCV);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_OHLC_VOL)) {
            this.numRows = DataSheetOHLCV.length;
            this.numCols = DataSheetOHLCV[0].length;
            this.setDataMatrix(DataSheetOHLCV);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_OC_VOL)) {
            this.numRows = DataSheetOCV.length;
            this.numCols = DataSheetOCV[0].length;
            this.setDataMatrix(DataSheetOCV);
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_XY_LBL)) {
            this.numRows = DataSheetXYLBL.length;
            this.numCols = DataSheetXYLBL[0].length;
            this.setDataMatrix(DataSheetXYLBL);
            i = 0;
            while (i < this.numRows) {
                this.m_Perspective.setData(i, 2, DataSheetXYLBLString[i]);
                ++i;
            }
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_XYZ_LBL)) {
            this.numRows = DataSheetXYZLBL.length;
            this.numCols = DataSheetXYZLBL[0].length;
            this.setDataMatrix(DataSheetXYZLBL);
            i = 0;
            while (i < this.numRows) {
                this.m_Perspective.setData(i, 2, DataSheetXYZLBLString[i]);
                ++i;
            }
        } else if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_RESOURCE)) {
            this.numRows = DataSheetRESOURCE.length;
            this.numCols = DataSheetRESOURCE[0].length;
            this.setDataMatrix(DataSheetRESOURCE);
        } else if (this.currentGraphType.isPieType()) {
            this.numRows = DataSheetPie.length;
            this.numCols = DataSheetPie[0].length;
            this.setDataMatrix(DataSheetPie);
        } else {
            this.numRows = DataSheetGeneral.length;
            this.numCols = DataSheetGeneral[0].length;
            this.setDataMatrix(DataSheetGeneral);
        }
        if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_HL)) {
            this.rowLabels = new String[this.numRows];
            i = 0;
            while (i < this.numRows) {
                this.rowLabels[i] = this.m_Perspective.PFJRes.getString("SERIES") + " " + i;
                ++i;
            }
            this.colLabels = new String[this.numCols];
            int i2 = 0;
            while (i2 < this.numCols) {
                this.colLabels[i2] = this.m_Perspective.PFJRes.getString("GROUP") + " " + i2;
                ++i2;
            }
        } else {
            this.rowLabels = new String[this.numRows];
            i = 0;
            while (i < this.numRows) {
                this.rowLabels[i] = this.m_Perspective.PFJRes.getString("SERIES") + " " + i;
                ++i;
            }
            this.colLabels = new String[this.numCols];
            int i3 = 0;
            while (i3 < this.numCols) {
                this.colLabels[i3] = this.m_Perspective.PFJRes.getString("GROUP") + " " + i3;
                ++i3;
            }
        }
        this.chartTitle = this.m_Perspective.PFJRes.getString("CHARTTITLE");
        this.chartSubTitle = this.m_Perspective.PFJRes.getString("CHARTSUBTITLE");
        this.chartFootnote = this.m_Perspective.PFJRes.getString("FOOTNOTE");
        this.chartX1Title = "";
        this.chartY1Title = "";
        this.chartY2Title = "";
        this.chartO1Title = "";
        this.chartO2Title = "";
    }

    public String getY2AxisTitle() {
        return this.chartY2Title;
    }

    public String getO1AxisTitle() {
        return this.chartO1Title;
    }

    public String getO2AxisTitle() {
        return this.chartO2Title;
    }

    public String getX1AxisTitle() {
        return this.chartX1Title;
    }

    public String getY1AxisTitle() {
        return this.chartY1Title;
    }

    public String getFootnote() {
        return this.chartFootnote;
    }

    public String getSubtitle() {
        return this.chartSubTitle;
    }

    public String getTitle() {
        return this.chartTitle;
    }

    public Object columnLabel(int c) {
        return this.colLabels[c];
    }

    public int getColumns() {
        return this.numCols;
    }

    public Object getValue(int row, int col) {
        return this.external_data_array[row][col];
    }

    public void setValue(int row, int col, Object obj) {
        this.external_data_array[row][col] = obj;
    }

    public Object rowLabel(int r) {
        if (this.currentGraphType.getDataFormat().equals(DataFormat.DF_RESOURCE)) {
            if (r < 0 || r >= DataSheetRESOURCEString.length) {
                return "";
            }
            return DataSheetRESOURCEString[r];
        }
        return this.rowLabels[r];
    }

    public int getRows() {
        return this.numRows;
    }

    public boolean isDirty() {
        boolean tempDirty = this.isDirtyFlag;
        this.isDirtyFlag = false;
        return tempDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirtyFlag = isDirty;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

