/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import tdg.Assert;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.draw.DetObj;
import tdg.draw.IdentObj;

public class ScrollData
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptScrollRect = null;
    public Rectangle m_rOldScroll = null;

    public ScrollData(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mousePressedScroll(Point ptPressed) {
        this.m_ptScrollRect = ptPressed;
        this.m_rOldScroll = null;
    }

    public void drawScroller(Graphics gx) {
        gx.setXORMode(Color.yellow);
        if (this.m_rOldScroll != null) {
            gx.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
        }
        gx.setPaintMode();
    }

    public void mouseReleasedScroll(MouseEvent evt, int obj, Graphics g) {
        if (obj == 20 || obj == 26) {
            JGraphType gt = this.m_Perspective.getJGraphType();
            Rectangle rScroller = obj == 20 ? this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getGroupScroller())) : this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getSeriesScroller()));
            this.drawScroller(g);
            if (this.m_rOldScroll != null) {
                boolean bHorz = obj == 20 ? gt.isOrientHorz() : this.m_Perspective.m_chart.m_Legend.isHorz();
                double fRatio = bHorz ? (double)(this.m_rOldScroll.y - rScroller.y) / (double)(rScroller.height - this.m_rOldScroll.height) : (double)(this.m_rOldScroll.x - rScroller.x) / (double)(rScroller.width - this.m_rOldScroll.width);
                if (obj == 20) {
                    int nGroupOffset = (int)Math.round(fRatio * (double)(this.m_Perspective.getNumTotalGroups() - this.m_Perspective.getNumGroups()));
                    this.m_Perspective.setScrollOffsetGroup(nGroupOffset);
                } else {
                    int nSeriesOffset = (int)Math.round(fRatio * (double)(this.m_Perspective.getNumTotalSeries() - this.m_Perspective.getNumSeries()));
                    this.m_Perspective.setScrollOffsetSeries(nSeriesOffset);
                }
            }
            this.m_rOldScroll = null;
        }
    }

    public void mouseDraggedScroll(MouseEvent evt, IdentObj id, Graphics g) {
        int obj;
        int n = obj = id == null ? -3 : id.getObjectID();
        if (id.isScrollerThumb()) {
            JGraphType gt = this.m_Perspective.getJGraphType();
            DetObj aDetObj = this.m_Perspective.m_selList.firstDetObjElement();
            Assert.assert(aDetObj);
            Rectangle rThumb = this.m_Perspective.m_VC.virtToDest(aDetObj.getBounds());
            Rectangle rScroller = obj == 20 ? this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getGroupScroller())) : this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getSeriesScroller()));
            Point newPoint = new Point(evt.getX(), evt.getY());
            boolean bHorz = obj == 20 ? gt.isOrientHorz() : this.m_Perspective.m_chart.m_Legend.isHorz();
            if (bHorz) {
                int dy = newPoint.y - this.m_ptScrollRect.y;
                rThumb.y += dy;
                if (rThumb.y < rScroller.y) {
                    rThumb.y = rScroller.y;
                } else if (rThumb.y + rThumb.height > rScroller.y + rScroller.height) {
                    rThumb.y = rScroller.y + rScroller.height - rThumb.height;
                }
            } else {
                int dx = newPoint.x - this.m_ptScrollRect.x;
                rThumb.x += dx;
                if (rThumb.x < rScroller.x) {
                    rThumb.x = rScroller.x;
                } else if (rThumb.x + rThumb.width > rScroller.x + rScroller.width) {
                    rThumb.x = rScroller.x + rScroller.width - rThumb.width;
                }
            }
            g.setXORMode(Color.yellow);
            if (this.m_rOldScroll != null) {
                g.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
            }
            g.drawRect(rThumb.x, rThumb.y, rThumb.width, rThumb.height);
            g.setPaintMode();
            this.m_rOldScroll = rThumb;
        }
    }

    public boolean keyEditOfScroller(int nKeyCode, int nObjectID) {
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        boolean bHandled = false;
        boolean kSeriesOffset = true;
        boolean kGroupOffset = false;
        block0 : switch (nKeyCode) {
            case 37: {
                switch (nObjectID) {
                    case 22: {
                        this.decrementScrollOffset(kGroupOffset);
                        bHandled = true;
                        break;
                    }
                    case 23: {
                        if (nViewableGroups > 1) {
                            this.m_Perspective.setViewableGroups(nViewableGroups - 1);
                        }
                        bHandled = true;
                        break;
                    }
                    case 24: {
                        this.incrementScrollOffset(kGroupOffset);
                        bHandled = true;
                        break;
                    }
                    case 28: {
                        this.decrementScrollOffset(kSeriesOffset);
                        bHandled = true;
                        break;
                    }
                    case 29: {
                        if (nViewableSeries > 1) {
                            this.m_Perspective.setViewableSeries(nViewableSeries - 1);
                        }
                        bHandled = true;
                        break;
                    }
                    case 30: {
                        this.incrementScrollOffset(kSeriesOffset);
                        bHandled = true;
                    }
                }
                break;
            }
            case 39: {
                switch (nObjectID) {
                    case 22: {
                        this.incrementScrollOffset(kGroupOffset);
                        bHandled = true;
                        break block0;
                    }
                    case 23: {
                        if (nViewableGroups < this.m_Perspective.getNumTotalGroups()) {
                            this.m_Perspective.setViewableGroups(++nViewableGroups);
                            if (this.m_Perspective.getEffectiveGroupOffset() + nViewableGroups > this.m_Perspective.getNumTotalGroups()) {
                                this.m_Perspective.setScrollOffsetGroup(this.m_Perspective.getEffectiveGroupOffset() - 1);
                            }
                        }
                        bHandled = true;
                        break block0;
                    }
                    case 24: {
                        this.decrementScrollOffset(kGroupOffset);
                        bHandled = true;
                        break block0;
                    }
                    case 28: {
                        this.incrementScrollOffset(kSeriesOffset);
                        bHandled = true;
                        break block0;
                    }
                    case 29: {
                        if (nViewableSeries < this.m_Perspective.getNumTotalSeries()) {
                            this.m_Perspective.setViewableSeries(++nViewableSeries);
                            if (this.m_Perspective.getEffectiveSeriesOffset() + nViewableSeries > this.m_Perspective.getNumTotalSeries()) {
                                this.m_Perspective.setScrollOffsetSeries(this.m_Perspective.getEffectiveSeriesOffset() - 1);
                            }
                        }
                        bHandled = true;
                        break block0;
                    }
                    case 30: {
                        this.decrementScrollOffset(kSeriesOffset);
                        bHandled = true;
                    }
                }
            }
        }
        return bHandled;
    }

    public boolean keyEditOfVDR(int nKeyCode) {
        boolean bHandled = false;
        boolean bSeriesAreRows = this.m_Perspective.getSeriesAreRows();
        switch (nKeyCode) {
            case 38: {
                this.decrementScrollOffset(bSeriesAreRows);
                bHandled = true;
                break;
            }
            case 40: {
                this.incrementScrollOffset(bSeriesAreRows);
                bHandled = true;
                break;
            }
            case 37: {
                this.decrementScrollOffset(!bSeriesAreRows);
                bHandled = true;
                break;
            }
            case 39: {
                this.incrementScrollOffset(!bSeriesAreRows);
                bHandled = true;
            }
        }
        return bHandled;
    }

    private void decrementScrollOffset(boolean bSeries) {
        if (bSeries) {
            if (this.m_Perspective.getScrollOffsetSeries() > 0) {
                this.m_Perspective.setScrollOffsetSeries(this.m_Perspective.getScrollOffsetSeries() - 1);
            }
        } else if (this.m_Perspective.getScrollOffsetGroup() > 0) {
            this.m_Perspective.setScrollOffsetGroup(this.m_Perspective.getScrollOffsetGroup() - 1);
        }
    }

    private void incrementScrollOffset(boolean bSeries) {
        int nGroupOffset = this.m_Perspective.getEffectiveGroupOffset();
        int nSeriesOffset = this.m_Perspective.getEffectiveSeriesOffset();
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        if (bSeries) {
            if (nSeriesOffset + nViewableSeries < this.m_Perspective.getNumTotalSeries()) {
                this.m_Perspective.setScrollOffsetSeries(nSeriesOffset + 1);
            }
        } else if (nGroupOffset + nViewableGroups < this.m_Perspective.getNumTotalGroups()) {
            this.m_Perspective.setScrollOffsetGroup(nGroupOffset + 1);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

