/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import tdg.Assert;
import tdg.AssertionException;
import tdg.DataFormat;
import tdg.DataItem;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.Point2d;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetLine;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class JChart_2D_Scat
extends JChart_2D_Standard {
    static final int HORZ_QUAD_LINE = 500;
    static final int VERT_QUAD_LINE = 600;
    private int[][] m_bubbleSizes;
    private int[][] m_bubbleSizesX;
    private int[][] m_bubbleSizesY;

    public void calc() {
        super.calc();
        if (this.m_Perspective.getConnectScatterMarkers()) {
            this.drawLines(false);
        }
        this.drawFitLines();
        this.drawQuadrantLines();
        if (this.m_nDepthRadius > 0) {
            this.drawAllMarkersWithDepth();
        } else {
            this.drawMarkers();
        }
        this.drawLabels();
    }

    protected void calcBubbleSizes(double dataMin, double dataMax) {
        int frameDestHeight;
        this.m_bubbleSizesX = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizesY = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizes = null;
        int bubbleCount = this.m_nTotalSeries * this.m_nTotalGroups;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int s = 0;
        int g = 0;
        VC vc = this.m_Perspective.getVC();
        Rectangle frameVirtRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        int frameDestWidth = vc.virtToDestWidth(frameVirtRect.width);
        if (frameDestWidth < 1) {
            frameDestWidth = 1;
        }
        if ((frameDestHeight = vc.virtToDestHeight(frameVirtRect.height)) < 1) {
            frameDestHeight = 1;
        }
        boolean bVerticallyDense = frameVirtRect.height / frameDestHeight > frameVirtRect.width / frameDestWidth;
        this.m_bubbleSizes = bVerticallyDense ? this.m_bubbleSizesY : this.m_bubbleSizesX;
        double maxDestAreaPercent = 0.1;
        double maxBubbleDestArea = maxDestAreaPercent * (double)frameDestWidth * (double)frameDestHeight;
        double minDestAreaPercent = 5.0E-5;
        double minBubbleDestArea = minDestAreaPercent * (double)frameDestWidth * (double)frameDestHeight;
        if (maxBubbleDestArea < minBubbleDestArea) {
            double tmpArea = maxBubbleDestArea;
            maxBubbleDestArea = minBubbleDestArea;
            minBubbleDestArea = tmpArea;
        }
        int maxBubbleDestDiameter = (int)Math.ceil(2.0 * Math.sqrt(maxBubbleDestArea / Math.PI));
        int minBubbleDestDiameter = (int)Math.ceil(2.0 * Math.sqrt(minBubbleDestArea / Math.PI));
        if (minBubbleDestDiameter < 5) {
            minBubbleDestDiameter = 5;
        }
        int maxBubbleVirtDiameter = 0;
        int minBubbleVirtDiameter = 0;
        if (bVerticallyDense) {
            maxBubbleVirtDiameter = vc.destToVirtHeight(maxBubbleDestDiameter);
            minBubbleVirtDiameter = vc.destToVirtHeight(minBubbleDestDiameter);
        } else {
            maxBubbleVirtDiameter = vc.destToVirtWidth(maxBubbleDestDiameter);
            minBubbleVirtDiameter = vc.destToVirtWidth(minBubbleDestDiameter);
        }
        boolean bContinueProcessing = true;
        if (maxBubbleVirtDiameter < minBubbleVirtDiameter + 1000) {
            maxBubbleVirtDiameter = minBubbleVirtDiameter + 1000;
            bContinueProcessing = false;
        }
        int origMaxBVD = maxBubbleVirtDiameter;
        int origMinBVD = minBubbleVirtDiameter;
        int[] newRange = null;
        if (bContinueProcessing && (maxBubbleVirtDiameter = (newRange = this._adjustBubbleSizeRangeForCount(origMinBVD, origMaxBVD, minBubbleVirtDiameter, maxBubbleVirtDiameter, gEnum, sEnum))[1]) < (minBubbleVirtDiameter = newRange[0]) + 1000) {
            maxBubbleVirtDiameter = minBubbleVirtDiameter + 1000;
            bContinueProcessing = false;
        }
        if (bContinueProcessing && (maxBubbleVirtDiameter = (newRange = this._adjustBubbleSizeRangeForDataRange(origMinBVD, origMaxBVD, minBubbleVirtDiameter, maxBubbleVirtDiameter, dataMin, dataMax))[1]) < (minBubbleVirtDiameter = newRange[0]) + 1000) {
            maxBubbleVirtDiameter = minBubbleVirtDiameter + 1000;
            bContinueProcessing = false;
        }
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int destSize;
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                double fRelSize = this.getRelZVal(s, g, bubbleCount);
                int markerSize = minBubbleVirtDiameter + (int)(fRelSize * (double)(maxBubbleVirtDiameter - minBubbleVirtDiameter));
                if (bVerticallyDense) {
                    this.m_bubbleSizesY[s][g] = markerSize;
                    destSize = vc.virtToDestHeight(markerSize);
                    this.m_bubbleSizesX[s][g] = vc.destToVirtWidth(destSize);
                    continue;
                }
                this.m_bubbleSizesX[s][g] = markerSize;
                destSize = vc.virtToDestWidth(markerSize);
                this.m_bubbleSizesY[s][g] = vc.destToVirtHeight(destSize);
            }
        }
    }

    private int[] _adjustBubbleSizeRangeForCount(int origMinBVD, int origMaxBVD, int minBubbleVirtDiameter, int maxBubbleVirtDiameter, GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        int newMin = origMinBVD;
        int newMax = origMaxBVD;
        int bubbleCount = this.m_nTotalSeries * this.m_nTotalGroups;
        double avgRelVal = this._calcAverageZRelVal(gEnum, sEnum);
        int t1Min = 5;
        int t1Max = 20;
        int t2Min = 30;
        int t2Max = 200;
        double floor = 0.2;
        int t1 = t1Min + (int)((1.0 - avgRelVal) * (double)(t1Max - t1Min));
        int t2 = t2Min + (int)((1.0 - avgRelVal) * (double)(t2Max - t2Min));
        double p12 = (1.0 - floor) / (double)(t2 - t1);
        if (bubbleCount >= t2) {
            newMax = newMin + (int)(floor * (double)(newMax - newMin));
        } else if (bubbleCount >= t1) {
            newMax -= (int)(p12 * (double)(bubbleCount - t1) * (double)(newMax - newMin));
        }
        return new int[]{newMin, newMax};
    }

    private int[] _adjustBubbleSizeRangeForDataRange(int origMinBVD, int origMaxBVD, int minBubbleVirtDiameter, int maxBubbleVirtDiameter, double dataMin, double dataMax) {
        int newMin = minBubbleVirtDiameter;
        int newMax = maxBubbleVirtDiameter;
        double dataRange = dataMax - dataMin;
        boolean bOneVal = false;
        if (dataRange == 0.0) {
            bOneVal = true;
            dataRange = dataMax;
        }
        if (!bOneVal) {
            double bubbleRatio = (double)maxBubbleVirtDiameter / (double)minBubbleVirtDiameter;
            double scale = 100.0 / bubbleRatio;
            double dataRatio = scale * bubbleRatio;
            if (dataMax > 0.0 && dataMin > 0.0) {
                dataRatio = dataMax / dataMin;
            } else if (dataMax < 0.0 && dataMin < 0.0) {
                dataRatio = dataMin / dataMax;
            }
            double tmpDataMin = dataMin;
            double tmpDataMax = dataMax;
            if (dataRatio < 2.0 * scale && dataRatio != scale * bubbleRatio) {
                dataRatio = 2.0 * scale;
                tmpDataMin = 1.0;
                tmpDataMax = dataRatio;
            }
            if (dataRatio < scale * bubbleRatio) {
                int endBuffer = (int)(((double)maxBubbleVirtDiameter * (tmpDataMin * scale) - (double)minBubbleVirtDiameter * tmpDataMax) / (tmpDataMax + tmpDataMin * scale));
                newMin += endBuffer;
                newMax -= endBuffer;
            }
        }
        return new int[]{newMin, newMax};
    }

    private double getRelZVal(int s, int g, int bubbleCount) {
        double fValueZ = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XYZ_Z).m_fValue;
        double fRelSize = this.m_Z1Axis.getValueRelCoord(fValueZ);
        if (bubbleCount == 1) {
            fRelSize = 1.0;
        }
        return fRelSize;
    }

    private double _calcAverageZRelVal(GroupsEnumerator gEnum, SeriesEnumerator sEnum) {
        int g = 0;
        int s = 0;
        int bubbleCount = this.m_nTotalGroups * this.m_nTotalSeries;
        double totalRelSize = 0.0;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                double fRelSize = this.getRelZVal(s, g, bubbleCount);
                totalRelSize += fRelSize;
            }
        }
        double avgRelSize = totalRelSize / (double)bubbleCount;
        return avgRelSize;
    }

    private int _getBubbleSize(int series, int group) {
        if (this.m_bubbleSizes != null) {
            return this.m_bubbleSizes[series][group];
        }
        return -1;
    }

    protected int getBubbleSizeX(int s, int g) {
        if (this.m_bubbleSizesX != null) {
            return this.m_bubbleSizesX[s][g];
        }
        return -1;
    }

    protected int getBubbleSizeY(int s, int g) {
        if (this.m_bubbleSizesY != null) {
            return this.m_bubbleSizesY[s][g];
        }
        return -1;
    }

    protected void drawLabels() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vectStrLabels = null;
        IdentObj id = this.m_Perspective.getDataText();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        Rectangle rClip = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isScatterWithLabel() || this.m_bDataTextDisplay) {
            int g;
            int s;
            vectStrLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    vectStrLabels.addElement(this.m_DataLabel[s][g]);
                }
            }
            Dimension labelDim = new Dimension(5000, 1600);
            boolean bScatLabelFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
            TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bScatLabelFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
            int nFontSizeVC = bScatLabelFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
            Graphics gx = this.m_Perspective.getGraphicsContext();
            textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vectStrLabels, labelDim, this.m_Perspective.m_VC);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                    BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
                    Rectangle rLabel = this.calcDataValuePosition(s, g, labelDim);
                    if (rLabel == null) continue;
                    IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                    new DetLabel(this.m_Detectiv, newID, this.m_DataLabel[s][g], rLabel, textStyle, (BlackBoxIF)blackBox, false, rClip);
                }
            }
        }
    }

    protected void drawQuadrantLines() {
        IdentObj newID;
        IdentObj id = this.m_Perspective.getQuadrantLine();
        boolean bDisplay = this.m_gt.isBubble() ? this.m_Perspective.getDisplay(id) : this.m_Perspective.getDisplay(this.m_Perspective.getScatterQuadrantLine());
        if (!bDisplay) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        blackBox.setBorderColor(this.m_Perspective.getBorderColor(id));
        int nWidth = this.m_Perspective.getLineWidth(id);
        int nVert = this.m_Perspective.getQuadrantLineCountX();
        int nHorz = this.m_Perspective.getQuadrantLineCountY();
        Rectangle rFrame = this.m_Perspective.getFrameRect(true);
        int x0 = rFrame.x;
        int x1 = rFrame.x + rFrame.width;
        int y0 = rFrame.y;
        int y1 = rFrame.y + rFrame.height;
        int i = 0;
        while (i < nHorz) {
            double yValue = this.m_Perspective.getQuadrantLineValueY(i);
            int yQuad = yValue == 1.234567E301 ? y0 + (i + 1) * rFrame.height / (nHorz + 1) : y0 + (int)(this.m_Y1Axis.getValueRelCoord(yValue) * (double)rFrame.height);
            newID = new IdentObj(id);
            newID.setMiscID(i + 500);
            new DetLine(this.m_Detectiv, newID, x0, yQuad, x1, yQuad, blackBox, this.m_rClip, nWidth);
            ++i;
        }
        i = 0;
        while (i < nVert) {
            double xValue = this.m_Perspective.getQuadrantLineValueX(i);
            int xQuad = xValue == 1.234567E301 ? x0 + (i + 1) * rFrame.width / (nVert + 1) : x0 + (int)(this.m_X1Axis.getValueRelCoord(xValue) * (double)rFrame.width);
            newID = new IdentObj(id);
            newID.setMiscID(i + 600);
            new DetLine(this.m_Detectiv, newID, xQuad, y0, xQuad, y1, blackBox, this.m_rClip, nWidth);
            ++i;
        }
    }

    protected Point getCoords(int s, int g) {
        Point center = !this.m_bHorz ? new Point(this.m_numXCoords[s][g], this.m_numYCoords[s][g]) : new Point(this.m_numYCoords[s][g], this.m_numXCoords[s][g]);
        return center;
    }

    public Point2d getDataValuesXY(int s, int g) throws AssertionException {
        double x = this.getXValue(s, g);
        double y = this.getYValue(s, g);
        return new Point2d(x, y);
    }

    public String getLabelValue(int s, int g) {
        DataItem item = this.m_gt.isBubble() ? DataItem.DI_XYZ_LBL_LBL : DataItem.DI_XY_LBL_LBL;
        String sValue = this.m_Access.getDataAsString(s, g, item);
        return sValue;
    }

    public double getLabelXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getLabelYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_LBL_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public int getMarkerSize(int s, int g) {
        if (this.m_gt.isBubble()) {
            return this._getBubbleSize(s, g);
        }
        return super.getMarkerSize(s, g);
    }

    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        RelativeAxisObj xAxis = this.m_X1Axis;
        RelativeAxisObj yAxis = this.whichAxisForSeries(s, null);
        int xCoord = (int)xAxis.getValueCoord(x);
        int yCoord = (int)yAxis.getValueCoord(y);
        return new Point(xCoord, yCoord);
    }

    public double getXValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_XValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_X;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_YValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_ZValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XYZ_Z;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getYValue(int s, int g) throws AssertionException {
        DataItem item = DataItem.DI_XY_Y;
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    public boolean wantLegend() {
        return true;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        boolean bBubble = this.m_gt.isBubble();
        String ResultString = dataTextTemplate;
        ResultString = this.ReplaceMacro(ResultString, "[X]", dataItems[0]);
        ResultString = this.ReplaceMacro(ResultString, "[Y]", dataItems[1]);
        if (bBubble) {
            ResultString = this.ReplaceMacro(ResultString, "[SIZE]", dataItems[2]);
        }
        return ResultString;
    }
}

