/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import com.threedgraphics.math.FP;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import tdg.Access;
import tdg.Assert;
import tdg.AssertionException;
import tdg.AxisTemplate;
import tdg.GroupsEnumerator;
import tdg.MinMaxObj;
import tdg.Perspective;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLine;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class Axis2DObj
extends RelativeAxisObj {
    private static final int TITLE_HEIGHT = 3;
    private static final int TITLE_HEIGHT_STAGGER = 4;
    protected static final int kAUTOSKIP = 1;
    protected static final int kMANUALSKIP = 2;
    protected static final int MAX_TITLE_SIZE = 1300;
    protected static final int TITLE_AXISLABEL_DISTANCE = 50;
    private static final int TICKSIZE = 250;
    private static final double TICK_DEPTH_FACTOR = 1.15;
    public static final int LABEL_BOUNDS_MARGIN = 300;
    public static final int LABEL_MARGIN_INSIDE = 5;
    public static final int LABEL_MARGIN_OUTSIDE = 10;
    public static final int VERTICAL_LABEL_GAP = 5;
    private static final int DEFAULT_LABEL_VERT_MARGIN = 100;
    private static final int DEFAULT_LABEL_HORZ_MARGIN = 100;
    static final int BACK_WALL = 0;
    static final int LEFT_WALL = 700;
    static final int RIGHT_WALL = 800;
    static final int BOTTOM_WALL = 900;
    static final int GRID_OFFSET = 0;
    static final int TICK_OFFSET = 10000;
    static final int RIGHT_EDGE = 16000;
    static final int RIGHT_MARGIN = 15900;
    static final int LEFT_EDGE = -16000;
    static final int LEFT_MARGIN = -15900;
    static final int BOTTOM_EDGE = -16000;
    static final int BOTTOM_MARGIN = -15900;
    static final int TOP_EDGE = 16000;
    static final int TOP_MARGIN = 15900;
    protected boolean m_bVertScale;
    protected boolean m_bDisplayOnCalc;
    protected boolean m_bLabelStagger;
    Rectangle m_rLegend;
    Rectangle m_rTitle;
    Rectangle m_rSubTitle;
    Rectangle m_rFootnote;
    protected int m_axisLengthVC;
    protected int m_axisOrgVC;
    protected Point m_frameDepthOffset;
    protected Rectangle m_rFrame;

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate id, int nAxisType, boolean bVertical, boolean bAscending) {
        super(perspective, access, id, nAxisType, bAscending);
        this.initVariables(bVertical, true);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate id, int nAxisType, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        super(perspective, access, id, nAxisType, bAscending, nAxisOffset, nAxisSize);
        this.initVariables(bVertical, true);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bDrawOnCalc) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.initVariables(bVertical, bDrawOnCalc);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        this(perspective, access, id, minMax, bVertical, bAscending, nAxisOffset, nAxisSize, true);
    }

    protected void adjustTitlePosPass1(int nSide, Vector rVectLabels, Rectangle rTitle) {
        if (this.m_bVertScale) {
            if (this.m_gt.isPieBarType()) {
                this.adjustTitleRightmost(rVectLabels, rTitle);
            } else {
                switch (nSide) {
                    case 0: {
                        this.adjustTitleLeftmost(rVectLabels, rTitle);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.adjustTitleRightmost(rVectLabels, rTitle);
                    }
                }
            }
        } else {
            switch (nSide) {
                case 1: 
                case 2: {
                    this.adjustTitleHighest(rVectLabels, rTitle);
                    break;
                }
                case 0: {
                    this.adjustTitleLowest(rVectLabels, rTitle);
                }
            }
        }
    }

    protected void adjustTitleLowest(Vector rVectLabels, Rectangle rTitle) {
        int nYLowest = 16000;
        int i = 0;
        while (i < rVectLabels.size()) {
            Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
            nYLowest = Math.min(nYLowest, rLabel.y);
            ++i;
        }
        rTitle.y = nYLowest - rTitle.height - this.m_Perspective.m_VC.destToVirtHeight(10);
        if (rTitle.y < -16000) {
            rTitle.y = -15900;
        }
    }

    protected void adjustTitleHighest(Vector rVectLabels, Rectangle rTitle) {
        int nYHighest = -16000;
        int i = 0;
        while (i < rVectLabels.size()) {
            Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
            nYHighest = Math.max(nYHighest, rLabel.y + rLabel.height);
            ++i;
        }
        rTitle.y = nYHighest + this.m_Perspective.m_VC.destToVirtHeight(10);
        if (rTitle.y + rTitle.height > 16000) {
            rTitle.y = 15900 - rTitle.height;
        }
    }

    protected void adjustTitleLeftmost(Vector rVectLabels, Rectangle rTitle) {
        int nXLeftMost = 16000;
        int i = 0;
        while (i < rVectLabels.size()) {
            Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
            nXLeftMost = Math.min(nXLeftMost, rLabel.x);
            ++i;
        }
        rTitle.x = nXLeftMost - rTitle.width - this.m_Perspective.m_VC.destToVirtWidth(10);
        if (rTitle.x < -16000) {
            rTitle.x = -15900;
        }
    }

    protected void adjustTitleRightmost(Vector rVectLabels, Rectangle rTitle) {
        int nXRightMost = -16000;
        int i = 0;
        while (i < rVectLabels.size()) {
            Rectangle rLabel = (Rectangle)rVectLabels.elementAt(i);
            nXRightMost = Math.max(nXRightMost, rLabel.x + rLabel.width);
            ++i;
        }
        rTitle.x = nXRightMost + this.m_Perspective.m_VC.destToVirtWidth(10);
        if (rTitle.x + rTitle.width > 16000) {
            rTitle.x = 15900 - rTitle.width;
        }
    }

    protected void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension dimTitle) {
    }

    public void calc() {
        IdentObj id;
        boolean bNonZeroBaseline;
        double fBaseline = 0.0;
        this.initAxis();
        super.calc();
        if (this.m_Perspective.getAxesPreviewMode()) {
            return;
        }
        if (this.m_bNumericAxis && this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange() && !this.isLogScale()) {
            this.calcZeroLine();
        }
        if ((bNonZeroBaseline = this.m_Perspective.getNonZeroBaseline(id = this.getAxisIdentObj())) && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter() && !this.m_gt.isStockType() && !this.m_gt.isParetoType()) {
            fBaseline = this.m_Perspective.getNonZeroBaselineValue(id);
            if (this.isLogScale() && fBaseline < 0.0) {
                bNonZeroBaseline = false;
            }
            if (bNonZeroBaseline && this.m_bNumericAxis) {
                this.calcNonZeroLine(id);
            }
        }
    }

    public void calcAxisBody() {
        if (!this.m_bDisplayOnCalc) {
            return;
        }
        if (!this.m_Perspective.getDisplay(this.m_template.getBody())) {
            return;
        }
        int nSide = this.getAxisSide();
        Rectangle rFrame = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getBody());
        int nWidth = this.m_Perspective.getLineWidth(this.m_template.getBody());
        if (this.m_bVertScale) {
            if (nSide == 0 || nSide == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), rFrame.x - this.m_frameDepthOffset.x, this.m_axisOrgVC - this.m_frameDepthOffset.y, rFrame.x - this.m_frameDepthOffset.x, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.y, blackBox, null, nWidth);
            }
            if (nSide == 1 || nSide == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), rFrame.x + rFrame.width, this.m_axisOrgVC, rFrame.x + rFrame.width, this.m_axisOrgVC + this.m_axisLengthVC, blackBox, null, nWidth);
            }
        } else {
            if (nSide == 0 || nSide == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), this.m_axisOrgVC - this.m_frameDepthOffset.x, rFrame.y - this.m_frameDepthOffset.y, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.x, rFrame.y - this.m_frameDepthOffset.y, blackBox, null, nWidth);
            }
            if (nSide == 1 || nSide == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), this.m_axisOrgVC, rFrame.y + rFrame.height, this.m_axisOrgVC + this.m_axisLengthVC, rFrame.y + rFrame.height, blackBox, null, nWidth);
            }
        }
    }

    protected void calcMajorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMajor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
    }

    protected void calcMinorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        if (FP.between(fRelPos, 0.0, 1.0)) {
            this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMinor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
        }
    }

    protected void calcZeroLine() {
        if (!this.m_bNumericAxis) {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
        this.calcLineOnFrame(0, this.getValueRelCoord(0.0), this.m_template.getZeroLine(), new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine()), this.m_Perspective.getLineWidth(this.m_template.getZeroLine()), this.m_Perspective.getLineStyle(this.m_template.getZeroLine()));
    }

    public void calcNonZeroLine(IdentObj axisID) {
        IdentObj idObj;
        IdentObj id;
        if (this.m_bNumericAxis) {
            IdentObj idl = null;
            switch (axisID.getObjectID()) {
                case 2004: {
                    idl = this.m_Perspective.getY1AxisLine();
                    break;
                }
                case 2005: {
                    idl = this.m_Perspective.getY2AxisLine();
                    break;
                }
                case 2003: {
                    idl = this.m_Perspective.getX1AxisLine();
                }
            }
            id = new IdentObj(253, idl.getObjectID(), axisID.getObjectID());
            idObj = this.m_Perspective.getNonZeroBaseLineZeroLine(axisID);
            if (!this.m_Perspective.getDisplay(idObj) || this.m_gt.isRiserLine()) {
                return;
            }
        } else {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
        double fBaseline = this.m_Perspective.getNonZeroBaselineValue(axisID);
        BlackBoxObj bbo = new BlackBoxObj(this.m_Perspective, idObj);
        bbo.setBorderColor(this.m_Perspective.getFillColor(this.m_Perspective.getNonZeroBaseLineZeroLine(axisID)));
        this.calcLineOnFrame(0, this.getValueRelCoord(fBaseline), id, bbo, this.m_Perspective.getLineWidth(idObj), this.m_Perspective.getLineStyle(idObj));
    }

    protected boolean doDisplayOnCalc() {
        return this.m_bDisplayOnCalc;
    }

    protected boolean isVertical() {
        return this.m_bVertScale;
    }

    protected int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    protected boolean isAxisLabelVisible(int nSide) {
        return true;
    }

    public double getBaseCoord() {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getBaseRelCoord() * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(int g) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(g) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(double g) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(g) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getHighCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getHighRelCoord(s, g) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    protected void getLabelAndTitlePos(int nSide, int nNumLabels, Vector rVectLabels, Vector fVectRelLabelPos, Vector nVectAlign, Rectangle rTitle, boolean bLabelRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, TextStyleObj textStyle) {
        Rectangle rSpace = this.getSpaceAvailableForLabel(nSide, this.m_Perspective.m_VC, null);
        boolean bStaggerLabels = this.m_bLabelStagger && nNumLabels > 1;
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        Dimension dimTitle = this.calcTitleSpace(nSide, bStaggerLabels, rSpace, rTitle);
        if (this.isO1WithNestedLabels() && dimTitle.height != 0) {
            rSpace = this.getSpaceAvailableForLabel(nSide, this.m_Perspective.m_VC, dimTitle);
        }
        int nTitleRotate = this.getTitleRotation(this.m_template, nSide);
        int nTotalSpace = dimTitle.height;
        if (nTotalSpace > 0) {
            nTotalSpace = this.isVertical() ? (nTotalSpace += this.m_Perspective.m_VC.destToVirtWidth(10)) : (nTotalSpace += this.m_Perspective.m_VC.destToVirtHeight(10));
        }
        this.calcLabelAlignments(nSide, nNumLabels, nVectAlign);
        this.calcLabelPositions(nSide, nNumLabels, fVectRelLabelPos, rSpace, nTotalSpace, bStaggerLabels, rVectLabels);
        this.calcTitleBox(nSide, rSpace, dimTitle, bLeftDepthWall, rTitle);
    }

    protected void calcLabelPositions(int nSide, int nNumLabels, Vector fVectRelLabelPos, Rectangle rSpace, int nTitleSpace, boolean bStaggerLabels, Vector rVectLabels) {
        int nMaxLabelDim;
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        boolean bRightDepthWall = this.m_frameDepthOffset.x < 0;
        IdentObj idLabel = this.m_template.getLabel();
        int[] nLabelPos = new int[nNumLabels];
        int i = 0;
        while (i < nNumLabels) {
            double d = (Double)fVectRelLabelPos.elementAt(i);
            nLabelPos[i] = (int)this.scaleToVC(d);
            if (this.m_bVertScale) {
                if (nSide == 0 && bLeftDepthWall || nSide == 1 && bRightDepthWall) {
                    int n = i;
                    nLabelPos[n] = nLabelPos[n] - this.m_frameDepthOffset.y;
                }
            } else if ((bLeftDepthWall || bRightDepthWall) && nSide == 0) {
                int n = i;
                nLabelPos[n] = nLabelPos[n] - this.m_frameDepthOffset.x;
            }
            ++i;
        }
        int fontSize = !this.m_Perspective.getFontSizeAbsolute(idLabel) ? this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(idLabel)) : this.m_Perspective.getFontSize(idLabel);
        int rotation = this.m_Perspective.getTextRotation(idLabel);
        boolean rotated = rotation == 2 || rotation == 1;
        int gap = this.m_bVertScale && !rotated || !this.m_bVertScale && rotated ? 5 : TextStyleObj.calcAxisLabelGap(fontSize);
        gap = this.m_bVertScale ? this.m_Perspective.getVC().destToVirtHeight(gap) : this.m_Perspective.getVC().destToVirtWidth(gap);
        if (nNumLabels > 1) {
            nMaxLabelDim = Math.abs(nLabelPos[1] - nLabelPos[0]) - gap;
            if (bStaggerLabels) {
                nMaxLabelDim *= 2;
            }
        } else {
            nMaxLabelDim = this.m_bVertScale ? rSpace.height : rSpace.width;
        }
        boolean bFlip = false;
        rVectLabels.removeAllElements();
        int i2 = 0;
        while (i2 < nNumLabels) {
            Rectangle rLabel = new Rectangle(0, 0, 0, 0);
            if (this.m_bVertScale) {
                rLabel.y = nLabelPos[i2] - nMaxLabelDim / 2;
                rLabel.height = nMaxLabelDim;
                rLabel.width = rSpace.width - nTitleSpace;
                if (bStaggerLabels) {
                    rLabel.width /= 2;
                    rLabel.x = rSpace.x;
                    if (!bFlip && nSide == 0 || bFlip && nSide == 1) {
                        rLabel.x += rLabel.width;
                    }
                } else {
                    rLabel.x = rSpace.x;
                }
                if (nSide == 0) {
                    rLabel.x += nTitleSpace;
                }
            } else {
                rLabel.x = this.m_nNestingLevel == 1 ? nLabelPos[i2] : nLabelPos[i2] - nMaxLabelDim / 2;
                rLabel.width = nMaxLabelDim;
                rLabel.height = rSpace.height - nTitleSpace;
                if (bStaggerLabels) {
                    rLabel.height /= 2;
                    rLabel.y = rSpace.y;
                    if (!bFlip && nSide == 0 || bFlip && nSide == 1) {
                        rLabel.y += rLabel.height;
                    }
                } else {
                    rLabel.y = rSpace.y;
                }
                if (nSide == 0) {
                    rLabel.y += nTitleSpace;
                }
            }
            rVectLabels.addElement(rLabel);
            bFlip = !bFlip;
            ++i2;
        }
    }

    private void calcLabelAlignments(int nSide, int nNumLabels, Vector nVectAlign) {
        Integer nAlign = new Integer(3);
        nAlign = nSide == 0 ? (this.m_bVertScale ? new Integer(5) : new Integer(3)) : (this.m_bVertScale ? new Integer(1) : new Integer(7));
        int i = 0;
        while (i < nNumLabels) {
            nVectAlign.insertElementAt(nAlign, i);
            ++i;
        }
    }

    private Dimension calcTitleSpace(int nSide, boolean bStaggerLabels, Rectangle rSpace, Rectangle rTitle) {
        Dimension dimTitleVC = new Dimension(0, 0);
        IdentObj title = this.getTitle();
        String strTitle = this.m_Perspective.getTextString(title);
        if (this.m_Perspective.getDisplay(title) && strTitle.length() != 0) {
            TextStyleObj titleTextStyle = this.getTitleTextStyle(nSide);
            int nTitleFontSizeVC = this.getTitleFontSizeVC();
            int nDestTitleFontSize = this.m_Perspective.m_VC.virtToDestHeight(nTitleFontSizeVC);
            Graphics gx = this.m_Perspective.getGraphicsContext();
            Dimension dimMax = new Dimension(16000, 16000);
            dimMax = this.m_Perspective.m_VC.virtToDest(dimMax);
            Dimension dimTitleDC = titleTextStyle.getTextSizeDC(gx, strTitle, nDestTitleFontSize, this.m_Perspective.m_VC, dimMax, null);
            if (this.isVertical()) {
                dimTitleVC.width = this.m_Perspective.m_VC.destToVirtHeight(dimTitleDC.width);
                dimTitleVC.height = this.m_Perspective.m_VC.destToVirtWidth(dimTitleDC.height);
            } else {
                dimTitleVC.width = this.m_Perspective.m_VC.destToVirtWidth(dimTitleDC.width);
                dimTitleVC.height = this.m_Perspective.m_VC.destToVirtHeight(dimTitleDC.height);
            }
        }
        return dimTitleVC;
    }

    private void calcTitleBox(int nSide, Rectangle rSpace, Dimension dimTitle, boolean bLeftDepthWall, Rectangle rTitle) {
        if (rTitle != null) {
            if (this.m_bVertScale) {
                if (this.isNumericAxis()) {
                    rTitle.y = (int)Math.min(this.getMinCoord(), this.getMaxCoord());
                    rTitle.height = (int)Math.abs(this.getMaxCoord() - this.getMinCoord());
                } else {
                    rTitle.y = Math.min(this.m_axisOrgVC, this.m_axisOrgVC + this.m_axisLengthVC);
                    rTitle.height = Math.abs(this.m_axisLengthVC);
                }
                if (nSide == 0 && bLeftDepthWall) {
                    rTitle.y -= this.m_frameDepthOffset.y;
                }
                rTitle.width = dimTitle.height;
                rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - dimTitle.height;
            } else {
                if (this.isNumericAxis()) {
                    rTitle.x = (int)Math.min(this.getMinCoord(), this.getMaxCoord());
                    rTitle.width = (int)Math.abs(this.getMaxCoord() - this.getMinCoord());
                } else {
                    rTitle.x = Math.min(this.m_axisOrgVC, this.m_axisOrgVC + this.m_axisLengthVC);
                    rTitle.width = Math.abs(this.m_axisLengthVC);
                }
                if (nSide == 0) {
                    rTitle.x -= this.m_frameDepthOffset.x;
                }
                rTitle.height = dimTitle.height;
                rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - dimTitle.height;
            }
        }
    }

    protected Vector getLabels() {
        if (this.m_bNumericAxis) {
            return this.getNumericLabels();
        }
        int nNumLabels = this.getNumLabels();
        Vector sVectLabels = new Vector(nNumLabels);
        if (this.useSeriesLabels()) {
            SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_Access.getNumTotalSeries());
                sVectLabels.addElement(this.m_Perspective.getSeriesLabel(s));
            }
        } else if (this.isO1WithNestedLabels()) {
            sVectLabels = this.m_cbO1Labels.getAllLabels(this.m_nNestingLevel);
        } else {
            GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_Access.getNumTotalGroups());
                sVectLabels.addElement(this.m_Perspective.getGroupLabel(g));
            }
        }
        return sVectLabels;
    }

    protected Vector getLabelIdents() {
        Vector<IdentObj> idents;
        block4: {
            idents = null;
            if (this.m_bNumericAxis) break block4;
            int nNumLabels = this.getNumLabels();
            idents = new Vector<IdentObj>(nNumLabels);
            if (this.useSeriesLabels()) {
                SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
                while (sEnum.hasMoreElements()) {
                    int s = sEnum.nextSeries();
                    Assert.assert(s >= 0 && s < this.m_Access.getNumTotalSeries());
                    idents.addElement(new IdentObj(-3, s));
                }
            } else {
                GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_Access.getNumTotalGroups());
                    idents.addElement(new IdentObj(-3, -3, g));
                }
            }
        }
        return idents;
    }

    public double getLowCoord(double s, double g) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(s, g) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getLowCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(s, g) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    protected boolean getMajorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajor());
    }

    protected boolean getMinorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinor());
    }

    public Rectangle getSpaceAvailableForLabel(int nSide, VC vc, Dimension dimTitle) {
        Rectangle rTotalSpace = this.getSpaceAvailable(nSide, vc);
        Rectangle rLabelSpace = new Rectangle(rTotalSpace.x, rTotalSpace.y, rTotalSpace.width, rTotalSpace.height);
        if (this.isO1WithNestedLabels()) {
            rLabelSpace = this.getNestedO1SpaceAvailableForLabel(rLabelSpace, dimTitle);
        }
        return rLabelSpace;
    }

    private Rectangle getNestedO1SpaceAvailableForLabel(Rectangle rLabelSpace, Dimension dimTitle) {
        int nLevels;
        double fBracketFactor = 0.0;
        if (dimTitle != null) {
            int margin = this.m_Perspective.m_VC.destToVirtHeight(10);
            rLabelSpace.height -= dimTitle.height + margin;
            rLabelSpace.y += dimTitle.height + margin;
        }
        if (this.m_cbO1Labels != null && (nLevels = this.m_cbO1Labels.getNumLevels()) > 1) {
            if (this.m_bNestedLabelBrackets) {
                fBracketFactor = 0.5;
            }
            double fFactor = (double)nLevels + (double)(nLevels - 1) * fBracketFactor;
            if (this.m_bVertScale) {
                double fWidth = (double)rLabelSpace.width / fFactor;
                int nBracket = (int)(fWidth * fBracketFactor);
                rLabelSpace.width = (int)fWidth;
                rLabelSpace.x += (rLabelSpace.width + nBracket) * (nLevels - 1 - this.m_nNestingLevel);
            } else {
                double fHeight = (double)rLabelSpace.height / fFactor;
                int nBracket = (int)(fHeight * fBracketFactor);
                rLabelSpace.height = (int)fHeight;
                rLabelSpace.y += (rLabelSpace.height + nBracket) * (nLevels - 1 - this.m_nNestingLevel);
            }
        }
        return rLabelSpace;
    }

    private Rectangle getSpaceAvailable(int nSide, VC vc) {
        Rectangle rSpace;
        IdentObj idFootnote;
        IdentObj idSubtitle;
        IdentObj idTitle;
        Rectangle rFrame = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        Dimension dimVirtBounds = vc.getVirtDimension();
        boolean bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
        boolean bRightDepthWall = this.m_frameDepthOffset.x < 0;
        Rectangle rLegend = null;
        Rectangle rTitle = null;
        Rectangle rSubtitle = null;
        Rectangle rFootnote = null;
        IdentObj idLegend = this.m_Perspective.getLegendArea();
        if (this.m_Perspective.getDisplay(idLegend)) {
            rLegend = this.m_Perspective.getRect(idLegend);
        }
        if (this.m_Perspective.getDisplay(idTitle = this.m_Perspective.getTitle())) {
            rTitle = this.m_Perspective.getRect(idTitle);
        }
        if (this.m_Perspective.getDisplay(idSubtitle = this.m_Perspective.getSubtitle())) {
            rSubtitle = this.m_Perspective.getRect(idSubtitle);
        }
        if (this.m_Perspective.getDisplay(idFootnote = this.m_Perspective.getFootnote())) {
            rFootnote = this.m_Perspective.getRect(idFootnote);
        }
        if (nSide == 0) {
            if (this.m_bVertScale) {
                if (bLeftDepthWall) {
                    rFrame.x -= this.m_frameDepthOffset.x;
                    rFrame.width += this.m_frameDepthOffset.x;
                    rFrame.y -= this.m_frameDepthOffset.y;
                }
                rSpace = new Rectangle(-dimVirtBounds.width / 2, rFrame.y - 100, rFrame.x + dimVirtBounds.width / 2, rFrame.height + 200);
                if (rLegend != null && rLegend.x + rLegend.width < rSpace.x + rSpace.width && rLegend.y + rLegend.height > rSpace.y && rLegend.y < rSpace.y + rSpace.height) {
                    int newX = rLegend.x + rLegend.width;
                    int newWidth = rSpace.x + rSpace.width - newX;
                    rSpace.x = newX;
                    rSpace.width = newWidth;
                }
                int inside = this.m_Perspective.m_VC.destToVirtWidth(5);
                int outside = this.m_Perspective.m_VC.destToVirtWidth(10);
                rSpace.x += outside;
                rSpace.width -= inside + outside;
            } else {
                int top;
                if (bLeftDepthWall || bRightDepthWall) {
                    rFrame.x -= this.m_frameDepthOffset.x;
                    rFrame.width += this.m_frameDepthOffset.x;
                    rFrame.y -= this.m_frameDepthOffset.y;
                }
                rSpace = new Rectangle(rFrame.x - 100, -dimVirtBounds.height / 2, rFrame.width + 200, dimVirtBounds.height / 2 + rFrame.y);
                int newY = rSpace.y;
                if (rLegend != null && rLegend.y + rLegend.height < rSpace.y + rSpace.height && rLegend.x + rLegend.width > rSpace.x && rLegend.x < rSpace.x + rSpace.width) {
                    newY = rLegend.y + rLegend.height;
                }
                if (rFootnote != null && rFootnote.y + rFootnote.height < rSpace.y + rSpace.height && (top = rFootnote.y + rFootnote.height) > newY) {
                    newY = top;
                }
                rSpace.height -= newY - rSpace.y;
                rSpace.y = newY;
                int inside = this.m_Perspective.m_VC.destToVirtHeight(5);
                int outside = this.m_Perspective.m_VC.destToVirtHeight(10);
                int extra = this.m_Perspective.getAdditionalBottomAxisMargin();
                if (extra > 0) {
                    inside += extra;
                }
                rSpace.y += outside;
                rSpace.height -= inside + outside;
            }
        } else if (this.m_bVertScale) {
            if (bRightDepthWall) {
                rFrame.width -= this.m_frameDepthOffset.x;
                rFrame.y -= this.m_frameDepthOffset.y;
            }
            rSpace = new Rectangle(rFrame.x + rFrame.width, rFrame.y - 100, dimVirtBounds.width / 2 - rFrame.x - rFrame.width, rFrame.height + 200);
            if (rLegend != null && rLegend.x > rSpace.x && rLegend.y + rLegend.height > rSpace.y && rLegend.y < rSpace.y + rSpace.height) {
                rSpace.width = rLegend.x - rSpace.x;
            }
            int inside = this.m_Perspective.m_VC.destToVirtWidth(5);
            int outside = this.m_Perspective.m_VC.destToVirtWidth(10);
            rSpace.x += inside;
            rSpace.width -= inside + outside;
        } else {
            rSpace = new Rectangle(rFrame.x - 100, rFrame.y + rFrame.height, rFrame.width + 200, dimVirtBounds.width / 2 - (rFrame.y + rFrame.height));
            int newTop = rSpace.y + rSpace.height;
            if (rLegend != null && rLegend.y > rSpace.y && rLegend.x + rLegend.width > rSpace.x && rLegend.x < rSpace.x + rSpace.width) {
                newTop = rLegend.y;
            }
            if (rTitle != null && rTitle.y > rSpace.y && rTitle.y < newTop) {
                newTop = rTitle.y;
            }
            if (rSubtitle != null && rSubtitle.y > rSpace.y && rSubtitle.y < newTop) {
                newTop = rSubtitle.y;
            }
            rSpace.height = newTop - rSpace.y;
            int inside = this.m_Perspective.m_VC.destToVirtHeight(5);
            int outside = this.m_Perspective.m_VC.destToVirtHeight(10);
            rSpace.y += inside;
            rSpace.height -= inside + outside;
        }
        return rSpace;
    }

    protected int getTitleRotation(AxisTemplate template, int nSide) {
        IdentObj title = this.getTitle();
        int nRotation = this.m_Perspective.getTextRotation(title);
        if (!this.m_Perspective.getMoveAxisTitles()) {
            nRotation = nSide == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(title) == 2 ? 2 : 1) : (nSide == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(title) == 1 ? 1 : 2) : 0);
        }
        return nRotation;
    }

    public double getValueCoord(double fValue) {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getValueRelCoord(fValue) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getValueFromCoord(int nCoord) {
        if (this.m_bNumericAxis) {
            return this.getValueFromRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public int getGroupAboveCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return this.getGroupAboveRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public int getGroupBelowCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return this.getGroupBelowRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    private void initAxis() {
        if (this.m_bVertScale) {
            this.m_axisLengthVC = this.m_rFrame.height;
            this.m_axisOrgVC = this.m_rFrame.y;
        } else {
            this.m_axisLengthVC = this.m_rFrame.width;
            this.m_axisOrgVC = this.m_rFrame.x;
        }
    }

    private void initVariables(boolean bVertical, boolean bDisplayOnCalc) {
        boolean bY1Axis = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY1Axis().getObjectID();
        boolean bY2Axis = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY2Axis().getObjectID();
        this.m_bVertScale = bVertical;
        this.m_axisLengthVC = 0;
        this.m_axisOrgVC = 0;
        this.m_frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        this.m_bLabelStagger = this.m_Perspective.getLabelStagger(this.m_template.getLabel());
        this.m_rLegend = this.m_Perspective.getRect(new IdentObj(12));
        this.m_rTitle = this.m_Perspective.getRect(new IdentObj(5));
        this.m_rSubTitle = this.m_Perspective.getRect(new IdentObj(4));
        this.m_rFootnote = this.m_Perspective.getRect(new IdentObj(3));
        this.m_bDisplayOnCalc = bDisplayOnCalc;
        this.m_rFrame = this.m_Perspective.getFrameRect(false);
        if ((bY1Axis || bY2Axis) && this.m_Perspective.isGroupScrollerPresent()) {
            if (this.m_bVertScale) {
                int nHeight = this.m_Perspective.m_VC.destToVirtHeight(8);
                this.m_rFrame.y += nHeight;
                this.m_rFrame.height -= nHeight;
            } else {
                int nWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
                this.m_rFrame.x += nWidth;
                this.m_rFrame.width -= nWidth;
            }
        }
    }

    Rectangle getFrameRect() {
        return this.m_rFrame;
    }

    protected boolean isPolarAxis() {
        return false;
    }

    protected double scaleToVC(double fRelPos) {
        double fPosVC = (double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC;
        return fPosVC;
    }

    private boolean hasDepth() {
        return this.m_Perspective.getDepthRadius() > 0;
    }

    protected void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, BlackBoxIF blackBox, int nLineWidth) {
        this.calcLineOnFrame(nStyle, fRelPos, id, blackBox, nLineWidth, Perspective.SOLID);
    }

    protected void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, BlackBoxIF blackBox, int nLineWidth, int nLineStyle) {
        boolean bRightDepthWall;
        boolean bLeftDepthWall;
        int nPosVC = (int)this.scaleToVC(fRelPos);
        Rectangle rFrame = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        int nSide = this.getAxisSide();
        boolean bLeftSide = nSide == 0 || nSide == 2;
        boolean bRightSide = nSide == 1 || nSide == 2;
        int nLeftBottom = this.m_bVertScale ? rFrame.x : rFrame.y;
        int nRightTop = (this.m_bVertScale ? rFrame.width : rFrame.height) + nLeftBottom;
        int nOffset = 0;
        if (nLineWidth > 1 && id.getObjectID() == 253) {
            nOffset = 100;
        }
        if (this.m_Perspective.getDepthRadius() == 0) {
            if (this.m_frameDepthOffset.x == 0) {
                bLeftDepthWall = false;
                bRightDepthWall = false;
            } else {
                bLeftDepthWall = this.m_frameDepthOffset.x > 0;
                bRightDepthWall = this.m_frameDepthOffset.x < 0;
            }
        } else {
            bLeftDepthWall = this.m_frameDepthOffset.x >= 0;
            boolean bl = bRightDepthWall = this.m_frameDepthOffset.x < 0;
        }
        if (!this.m_bDisplayOnCalc) {
            return;
        }
        if (this.m_bVertScale) {
            rFrame.y -= 2000;
            rFrame.height += 4000;
            switch (nStyle) {
                case 0: {
                    IdentObj newID = new IdentObj(id);
                    int nMisc = id.getMiscID();
                    newID.setMiscID(0 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC + nOffset, nRightTop, nPosVC + nOffset, blackBox, rFrame, nLineWidth, nLineStyle);
                    if (bLeftDepthWall) {
                        Rectangle rClip = new Rectangle(nLeftBottom - this.m_frameDepthOffset.x, rFrame.y, this.m_frameDepthOffset.x, rFrame.height);
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(700 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nLeftBottom - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, blackBox, rClip, nLineWidth, nLineStyle);
                        break;
                    }
                    if (!bRightDepthWall) break;
                    Rectangle rClip = new Rectangle(nRightTop, rFrame.y, -this.m_frameDepthOffset.x, rFrame.height);
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, nRightTop - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, blackBox, rClip, nLineWidth, nLineStyle);
                    break;
                }
                case 1: {
                    Rectangle rClip;
                    IdentObj newID = new IdentObj(id);
                    int nMisc = id.getMiscID();
                    newID.setMiscID(0 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nRightTop, nPosVC, blackBox, rFrame, nLineWidth, nLineStyle);
                    if (bLeftSide) {
                        if (bLeftDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nLeftBottom - 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        }
                    } else if (bLeftDepthWall) {
                        rClip = new Rectangle(nLeftBottom - this.m_frameDepthOffset.x, rFrame.y, this.m_frameDepthOffset.x, rFrame.height);
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(700 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nLeftBottom - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, blackBox, rClip, nLineWidth, nLineStyle);
                    }
                    if (bRightSide) {
                        if (bRightDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10800 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), blackBox, null, nLineWidth, nLineStyle);
                            break;
                        }
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(10000 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, nRightTop + 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        break;
                    }
                    if (!bRightDepthWall) break;
                    rClip = new Rectangle(nRightTop, rFrame.y, -this.m_frameDepthOffset.x, rFrame.height);
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, nRightTop - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, blackBox, rClip, nLineWidth, nLineStyle);
                    break;
                }
                case 2: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nLeftBottom), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nPosVC), -this.m_frameDepthOffset.x + nLeftBottom, -this.m_frameDepthOffset.y + nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nLeftBottom + 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    if (bRightDepthWall) {
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(10800 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nRightTop), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nPosVC), blackBox, null, nLineWidth, nLineStyle);
                        break;
                    }
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10000 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, nRightTop - 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                    break;
                }
                case 3: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), -this.m_frameDepthOffset.x + nLeftBottom, -this.m_frameDepthOffset.y + nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom, nPosVC, nLeftBottom - 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    if (bRightDepthWall) {
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(10800 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop - this.m_frameDepthOffset.x, nPosVC - this.m_frameDepthOffset.y, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), blackBox, null, 0, nLineStyle);
                        break;
                    }
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10000 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop, nPosVC, nRightTop + 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                    break;
                }
                case 4: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nLeftBottom), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nPosVC), blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nLeftBottom + 250, nPosVC, nLeftBottom - 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    if (bRightDepthWall) {
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(10800 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nRightTop), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nPosVC), (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nPosVC), blackBox, null, nLineWidth, nLineStyle);
                        break;
                    }
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10000 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nRightTop - 250, nPosVC, nRightTop + 250, nPosVC, blackBox, null, nLineWidth, nLineStyle);
                }
            }
        } else {
            rFrame.x -= 2000;
            rFrame.width += 4000;
            switch (nStyle) {
                case 0: {
                    IdentObj newID = new IdentObj(id);
                    int nMisc = id.getMiscID();
                    newID.setMiscID(0 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC - nOffset, nLeftBottom, nPosVC - nOffset, nRightTop, blackBox, rFrame, nLineWidth, nLineStyle);
                    if (!bLeftDepthWall && !bRightDepthWall) break;
                    Rectangle rClip = new Rectangle(rFrame.x - this.m_frameDepthOffset.x, nLeftBottom - this.m_frameDepthOffset.y, rFrame.width + this.m_frameDepthOffset.x, this.m_frameDepthOffset.y);
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(700 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC - this.m_frameDepthOffset.x, nLeftBottom - this.m_frameDepthOffset.y, blackBox, rClip, nLineWidth, nLineStyle);
                    break;
                }
                case 1: {
                    IdentObj newID = new IdentObj(id);
                    int nMisc = id.getMiscID();
                    newID.setMiscID(0 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC, nRightTop, blackBox, rFrame, nLineWidth, nLineStyle);
                    if (bLeftSide) {
                        if (bLeftDepthWall || bRightDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nPosVC), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nLeftBottom), blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC, nLeftBottom - 250, blackBox, null, nLineWidth, nLineStyle);
                        }
                    } else if (bLeftDepthWall || bRightDepthWall) {
                        newID = new IdentObj(id);
                        nMisc = id.getMiscID();
                        newID.setMiscID(900 + nMisc);
                        new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC - this.m_frameDepthOffset.x, nLeftBottom - this.m_frameDepthOffset.y, blackBox, null, nLineWidth, nLineStyle);
                    }
                    if (!bRightSide) break;
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nRightTop, nPosVC, nRightTop + 250, blackBox, null, nLineWidth, nLineStyle);
                    break;
                }
                case 2: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall || bRightDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nPosVC), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nLeftBottom), -this.m_frameDepthOffset.x + nPosVC, -this.m_frameDepthOffset.y + nLeftBottom, blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC, nLeftBottom + 250, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nRightTop, nPosVC, nRightTop - 250, blackBox, null, nLineWidth, nLineStyle);
                    break;
                }
                case 3: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall || bRightDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, -this.m_frameDepthOffset.x + nPosVC, -this.m_frameDepthOffset.y + nLeftBottom, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nPosVC), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nLeftBottom), blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom, nPosVC, nLeftBottom - 250, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nRightTop, nPosVC, nRightTop + 250, blackBox, null, nLineWidth, nLineStyle);
                    break;
                }
                case 4: {
                    int nMisc;
                    IdentObj newID;
                    if (bLeftSide) {
                        if (bLeftDepthWall || bRightDepthWall) {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10700 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)nPosVC), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)nLeftBottom), (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)nPosVC), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)nLeftBottom), blackBox, null, nLineWidth, nLineStyle);
                        } else {
                            newID = new IdentObj(id);
                            nMisc = id.getMiscID();
                            newID.setMiscID(10000 + nMisc);
                            new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nLeftBottom + 250, nPosVC, nLeftBottom - 250, blackBox, null, nLineWidth, nLineStyle);
                        }
                    }
                    if (!bRightSide) break;
                    newID = new IdentObj(id);
                    nMisc = id.getMiscID();
                    newID.setMiscID(10800 + nMisc);
                    new DetLine(this.m_Perspective.getDetectiv(), newID, nPosVC, nRightTop - 250, nPosVC, nRightTop + 250, blackBox, null, nLineWidth, nLineStyle);
                }
            }
        }
    }

    protected void adjustLabelPos(int nSide, int nNumLabels, Vector rLabels) {
        boolean bStaggerLabels;
        boolean bl = bStaggerLabels = this.m_bLabelStagger && nNumLabels > 1;
        if (bStaggerLabels) {
            boolean bFlip = false;
            Rectangle r0 = (Rectangle)rLabels.elementAt(0);
            int labelCount = rLabels.size();
            int index = 0;
            while (index < labelCount) {
                Rectangle r = (Rectangle)rLabels.elementAt(index);
                if (bFlip) {
                    if (this.m_bVertScale) {
                        r.x = nSide == 0 ? r0.x - r0.width : r0.x + r0.width;
                    } else {
                        r.y = nSide == 0 ? r0.y - r0.height : r0.y + r0.height;
                    }
                }
                bFlip = !bFlip;
                ++index;
            }
        }
    }

    protected int getTitleJustVert(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustVert(id);
    }

    protected int getTitleJustHoriz(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustHoriz(id);
    }
}

