/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.math;

import com.threedgraphics.math.CurveFitIF;
import com.threedgraphics.math.FP;
import tdg.Assert;
import tdg.AssertionException;

public class FitHyperbolic
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        Assert.assert(FP.nonzero(x));
        double y = a[1] + a[2] / x;
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        Assert.assert(FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        Assert.assert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " / x";
        if (bHighOrderFirst) {
            return "y = " + strTerm2 + " + " + strTerm1;
        }
        return "y = " + strTerm1 + " + " + strTerm2;
    }
}

