/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import com.sun.media.util.JMFI18N;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Manager;
import jmapps.ui.MessageDialog;

public class JMAppsCfg {
    public static final String KEY_OPEN_FILE = "Last Open File";
    public static final String KEY_OPEN_RTP = "Last Open RTP";
    public static final String KEY_OPEN_URL = "Last Open URL";
    public static final String KEY_CAPTURE_AUDIO = "Last Capture Audio Device";
    public static final String KEY_CAPTURE_VIDEO = "Last Capture Video Device";
    public static final String KEY_TRANSMIT_RTP = "Last Transmit RTP";
    public static final String KEY_TRANSMIT_SOURCE = "Last Transmit Source";
    public static final String KEY_SAVE_FILE_CONTENT = "Last Save File Content Type";
    public static final String KEY_SAVE_FILE_TRACKS = "Last Save File Tracks";
    public static final String KEY_SAVE_FILE_DIR = "Last Save File Directory";
    public static final String KEY_RECENT_URL = "Recent URL";
    public static final String KEY_JMSTUDIO_FRAME_POS = "Location of JMStudio Frame";
    public static final String KEY_AUTO_PLAY = "Auto Play";
    public static final String KEY_AUTO_LOOP = "Auto Loop";
    public static final String KEY_KEEP_ASPECT = "Keep Aspect Ratio";
    private static String nameFileCfg = ".JMAppsCfg";
    private static final String signatureFileCfg = "JMStudio configuration data file.";
    private static final String signatureHashtable = "Embedded Hashtable";
    private Hashtable hashProperties = new Hashtable();

    public JMAppsCfg() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRecentUrls(String string, String string2) {
        Hashtable hashtable;
        Vector vector = null;
        Object v = this.hashProperties.get(KEY_RECENT_URL);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_RECENT_URL, hashtable);
        }
        v = hashtable.get(string);
        if (v != null && v instanceof Vector) {
            vector = (Vector)v;
        } else {
            vector = new Vector();
            hashtable.put(string, vector);
        }
        if (vector.contains(string2)) {
            vector.removeElement(string2);
        } else if (vector.size() >= 16) {
            vector.removeElementAt(15);
        }
        vector.insertElementAt(string2, 0);
    }

    public CaptureDeviceData createCaptureDeviceDataObject() {
        CaptureDeviceData captureDeviceData = new CaptureDeviceData();
        return captureDeviceData;
    }

    public RtpData createRtpDataObject() {
        RtpData rtpData = new RtpData();
        return rtpData;
    }

    public TrackData createTrackDataObject() {
        TrackData trackData = new TrackData();
        return trackData;
    }

    public boolean getAutoLoop() {
        boolean bl = true;
        Object v = this.hashProperties.get(KEY_AUTO_LOOP);
        if (v != null && v instanceof Boolean) {
            bl = (Boolean)v;
        }
        return bl;
    }

    public boolean getAutoPlay() {
        boolean bl = true;
        Object v = this.hashProperties.get(KEY_AUTO_PLAY);
        if (v != null && v instanceof Boolean) {
            bl = (Boolean)v;
        }
        return bl;
    }

    public Point getJMStudioFrameLocation(int n2) {
        int n3;
        int n4;
        Point point = null;
        Vector vector = null;
        Object object = this.hashProperties.get(KEY_JMSTUDIO_FRAME_POS);
        if (object != null && object instanceof Vector && (object = vector.elementAt(n4 = n2 < (n3 = (vector = (Vector)object).size()) ? n2 : n3 - 1)) != null && object instanceof Point) {
            point = new Point((Point)object);
            point.x += 20 * (n2 - n4);
            point.y += 20 * (n2 - n4);
        }
        if (point == null) {
            point = new Point(20 * n2, 20 * n2);
        }
        return point;
    }

    public boolean getKeepAspectRatio() {
        boolean bl = false;
        Object v = this.hashProperties.get(KEY_KEEP_ASPECT);
        if (v != null && v instanceof Boolean) {
            bl = (Boolean)v;
        }
        return bl;
    }

    public CaptureDeviceData getLastCaptureAudioData() {
        CaptureDeviceData captureDeviceData = null;
        Object v = this.hashProperties.get(KEY_CAPTURE_AUDIO);
        if (v != null && v instanceof CaptureDeviceData) {
            captureDeviceData = (CaptureDeviceData)v;
        }
        return captureDeviceData;
    }

    public CaptureDeviceData getLastCaptureVideoData() {
        CaptureDeviceData captureDeviceData = null;
        Object v = this.hashProperties.get(KEY_CAPTURE_VIDEO);
        if (v != null && v instanceof CaptureDeviceData) {
            captureDeviceData = (CaptureDeviceData)v;
        }
        return captureDeviceData;
    }

    public String getLastOpenFile() {
        String string = null;
        Object v = this.hashProperties.get(KEY_OPEN_FILE);
        if (v != null) {
            string = v.toString();
        }
        return string;
    }

    public RtpData getLastOpenRtpData() {
        RtpData rtpData = null;
        Object v = this.hashProperties.get(KEY_OPEN_RTP);
        if (v != null && v instanceof RtpData) {
            rtpData = (RtpData)v;
        }
        return rtpData;
    }

    public String getLastOpenUrl() {
        String string = null;
        Object v = this.hashProperties.get(KEY_OPEN_URL);
        if (v != null) {
            string = v.toString();
        }
        return string;
    }

    public String getLastSaveFileContentType() {
        String string = null;
        Object v = this.hashProperties.get(KEY_SAVE_FILE_CONTENT);
        if (v != null) {
            string = v.toString();
        }
        return string;
    }

    public String getLastSaveFileDir() {
        String string = null;
        Object v = this.hashProperties.get(KEY_SAVE_FILE_DIR);
        if (v != null) {
            string = v.toString();
        }
        return string;
    }

    public TrackData getLastSaveFileTrackData(String string) {
        Hashtable hashtable;
        TrackData trackData = null;
        Object v = this.hashProperties.get(KEY_SAVE_FILE_TRACKS);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_SAVE_FILE_TRACKS, hashtable);
        }
        v = hashtable.get(string);
        if (v != null && v instanceof TrackData) {
            trackData = (TrackData)v;
        }
        return trackData;
    }

    public RtpData getLastTransmitRtpData(String string) {
        Hashtable hashtable;
        RtpData rtpData = null;
        Object v = this.hashProperties.get(KEY_TRANSMIT_RTP);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_TRANSMIT_RTP, hashtable);
        }
        v = hashtable.get(string);
        if (v != null && v instanceof RtpData) {
            rtpData = (RtpData)v;
        }
        return rtpData;
    }

    public String getLastTransmitRtpSource() {
        String string = null;
        Object v = this.hashProperties.get(KEY_TRANSMIT_SOURCE);
        if (v != null) {
            string = v.toString();
        }
        return string;
    }

    public Enumeration getRecentUrlTypes() {
        Enumeration enumeration = null;
        Object v = this.hashProperties.get(KEY_RECENT_URL);
        if (v != null && v instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)v;
            enumeration = hashtable.keys();
        }
        return enumeration;
    }

    public Vector getRecentUrls(String string) {
        Hashtable hashtable;
        Vector vector = null;
        Object v = this.hashProperties.get(KEY_RECENT_URL);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_RECENT_URL, hashtable);
        }
        v = hashtable.get(string);
        if (v != null && v instanceof Vector) {
            vector = (Vector)v;
        }
        return vector;
    }

    protected void init() throws Exception {
        this.readFile();
    }

    private void readFile() {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            String string = System.getProperty("user.home");
            if (string != null) {
                nameFileCfg = String.valueOf(string) + File.separator + nameFileCfg;
            }
            fileInputStream = new FileInputStream(nameFileCfg);
        }
        catch (Exception exception) {
            return;
        }
        try {
            objectInputStream = new ObjectInputStream(fileInputStream);
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            Object object = objectInputStream.readObject();
            if (object.toString().equals(signatureHashtable)) {
                this.hashProperties = this.readHashtable(objectInputStream);
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.read"), exception);
        }
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.close"), exception);
        }
    }

    private Hashtable readHashtable(ObjectInputStream objectInputStream) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            String string = objectInputStream.readUTF();
            Object object = objectInputStream.readObject();
            if (object != null && object.toString().equals(signatureHashtable)) {
                object = this.readHashtable(objectInputStream);
            }
            hashtable.put(string, object);
            ++n3;
        }
        return hashtable;
    }

    public void save() {
        this.saveFile();
    }

    private void saveFile() {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(nameFileCfg);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(JMFI18N.getResource("jmstudio.error.cfgfile.create")) + " " + exception.getMessage());
            return;
        }
        try {
            objectOutputStream.writeUTF(signatureFileCfg);
            String string = Manager.getVersion();
            objectOutputStream.writeUTF(string);
            this.writeHashtable(objectOutputStream, this.hashProperties);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.write"), exception);
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.close"), exception);
        }
    }

    public void setAutoLoop(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.hashProperties.put(KEY_AUTO_LOOP, bl2);
    }

    public void setAutoPlay(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.hashProperties.put(KEY_AUTO_PLAY, bl2);
    }

    public void setJMStudioFrameLocation(Point point, int n2) {
        Vector vector = null;
        Object v = this.hashProperties.get(KEY_JMSTUDIO_FRAME_POS);
        if (v != null && v instanceof Vector) {
            vector = (Vector)v;
        } else {
            vector = new Vector();
            this.hashProperties.put(KEY_JMSTUDIO_FRAME_POS, vector);
        }
        int n3 = vector.size();
        if (n2 < n3) {
            vector.setElementAt(point, n2);
        } else {
            vector.addElement(point);
        }
    }

    public void setKeepAspectRatio(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.hashProperties.put(KEY_KEEP_ASPECT, bl2);
    }

    public void setLastCaptureAudioData(CaptureDeviceData captureDeviceData) {
        this.hashProperties.put(KEY_CAPTURE_AUDIO, captureDeviceData);
    }

    public void setLastCaptureVideoData(CaptureDeviceData captureDeviceData) {
        this.hashProperties.put(KEY_CAPTURE_VIDEO, captureDeviceData);
    }

    public void setLastOpenFile(String string) {
        this.hashProperties.put(KEY_OPEN_FILE, string);
    }

    public void setLastOpenRtpData(RtpData rtpData) {
        this.hashProperties.put(KEY_OPEN_RTP, rtpData);
    }

    public void setLastOpenUrl(String string) {
        this.hashProperties.put(KEY_OPEN_URL, string);
    }

    public void setLastSaveFileContentType(String string) {
        this.hashProperties.put(KEY_SAVE_FILE_CONTENT, string);
    }

    public void setLastSaveFileDir(String string) {
        this.hashProperties.put(KEY_SAVE_FILE_DIR, string);
    }

    public void setLastSaveFileTrackData(TrackData trackData, String string) {
        Hashtable hashtable;
        Object v = this.hashProperties.get(KEY_SAVE_FILE_TRACKS);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_SAVE_FILE_TRACKS, hashtable);
        }
        hashtable.put(string, trackData);
    }

    public void setLastTransmitRtpData(RtpData rtpData, String string) {
        Hashtable hashtable;
        Object v = this.hashProperties.get(KEY_TRANSMIT_RTP);
        if (v != null && v instanceof Hashtable) {
            hashtable = (Hashtable)v;
        } else {
            hashtable = new Hashtable();
            this.hashProperties.put(KEY_TRANSMIT_RTP, hashtable);
        }
        hashtable.put(string, rtpData);
    }

    public void setLastTransmitRtpSource(String string) {
        this.hashProperties.put(KEY_TRANSMIT_SOURCE, string);
    }

    private void writeHashtable(ObjectOutputStream objectOutputStream, Hashtable hashtable) throws Exception {
        objectOutputStream.writeObject(signatureHashtable);
        int n2 = hashtable.size();
        objectOutputStream.writeInt(n2);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Hashtable) {
                objectOutputStream.writeUTF(string);
                this.writeHashtable(objectOutputStream, (Hashtable)v);
            } else if (!(v instanceof Serializable)) {
                System.out.println("Error. Not Serializable object");
            } else {
                objectOutputStream.writeUTF(string);
                objectOutputStream.writeObject(v);
            }
            objectOutputStream.flush();
        }
    }

    public class RtpData
    implements Serializable {
        public String strAddress0 = "0";
        public String strAddress1 = "0";
        public String strAddress2 = "0";
        public String strAddress3 = "0";
        public String strPort = "0";
        public String strTtl = "1";

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.strAddress0 = objectInputStream.readUTF();
            this.strAddress1 = objectInputStream.readUTF();
            this.strAddress2 = objectInputStream.readUTF();
            this.strAddress3 = objectInputStream.readUTF();
            this.strPort = objectInputStream.readUTF();
            this.strTtl = objectInputStream.readUTF();
        }

        public String toString() {
            return "RtpData address " + this.strAddress0 + "." + this.strAddress1 + "." + this.strAddress2 + "." + this.strAddress3 + "; port " + this.strPort + "; TTL " + this.strTtl;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(this.strAddress0);
            objectOutputStream.writeUTF(this.strAddress1);
            objectOutputStream.writeUTF(this.strAddress2);
            objectOutputStream.writeUTF(this.strAddress3);
            objectOutputStream.writeUTF(this.strPort);
            objectOutputStream.writeUTF(this.strTtl);
        }
    }

    public class CaptureDeviceData
    implements Serializable {
        public boolean boolUse = false;
        public String strDeviceName = null;
        public Format format = null;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.boolUse = objectInputStream.readBoolean();
            boolean bl = objectInputStream.readBoolean();
            this.strDeviceName = bl ? objectInputStream.readUTF() : null;
            bl = objectInputStream.readBoolean();
            Object object = bl ? objectInputStream.readObject() : null;
            this.format = object != null && object instanceof Format ? (Format)object : null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeBoolean(this.boolUse);
            if (this.strDeviceName == null) {
                objectOutputStream.writeBoolean(false);
            } else {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeUTF(this.strDeviceName);
            }
            if (this.format == null) {
                objectOutputStream.writeBoolean(false);
            } else {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.format);
            }
        }
    }

    public class TrackData
    implements Serializable {
        public boolean boolEnable = false;
        public Format format = null;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.boolEnable = objectInputStream.readBoolean();
            boolean bl = objectInputStream.readBoolean();
            Object object = bl ? objectInputStream.readObject() : null;
            this.format = object != null && object instanceof Format ? (Format)object : null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeBoolean(this.boolEnable);
            if (this.format == null) {
                objectOutputStream.writeBoolean(false);
            } else {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.format);
            }
        }
    }
}

