/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.ui.ProgressBar;

public class ProgressDialog
extends JMDialog {
    public static final String ACTION_ABORT = JMFI18N.getResource("jmstudio.saveprogress.abort");
    public static final String ACTION_STOP = JMFI18N.getResource("jmstudio.saveprogress.stop");
    public static final String ACTION_PAUSE = JMFI18N.getResource("jmstudio.saveprogress.pause");
    public static final String ACTION_RESUME = JMFI18N.getResource("jmstudio.saveprogress.resume");
    private int nMinPos = 0;
    private int nMaxPos = 0;
    private String strMessage = null;
    private ActionListener listener;
    private ProgressBar progressBar = null;
    private Label labelProgress;
    private Button buttonPause;
    private Component component = null;

    public ProgressDialog(Frame frame, String string, int n2, int n3, ActionListener actionListener) {
        super(frame, string, false);
        this.nMinPos = n2;
        this.nMaxPos = n3;
        this.listener = actionListener;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ProgressDialog(Frame frame, String string, String string2, Component component, ActionListener actionListener) {
        super(frame, string, false);
        this.strMessage = string2;
        this.listener = actionListener;
        this.component = component;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        Panel panel = new JMPanel(new BorderLayout(6, 6));
        ((JMPanel)panel).setEmptyBorder(6, 6, 6, 6);
        if (this.nMaxPos > this.nMinPos) {
            this.add((Component)panel, "Center");
            this.progressBar = new ProgressBar(this.nMinPos, this.nMaxPos);
            panel.add((Component)this.progressBar, "Center");
            this.labelProgress = new Label("100%");
            panel.add((Component)this.labelProgress, "East");
        } else if (this.strMessage != null) {
            this.add((Component)panel, "Center");
            this.labelProgress = new Label(this.strMessage);
            panel.add((Component)this.labelProgress, "North");
            if (this.component != null) {
                Panel panel2 = new Panel(new FlowLayout());
                panel.add((Component)panel2, "Center");
                panel2.add(this.component);
            }
        }
        panel = new Panel(new FlowLayout(1));
        this.add((Component)panel, "South");
        Panel panel3 = new Panel(new GridLayout(1, 0, 6, 6));
        panel.add(panel3);
        this.buttonPause = new Button(ACTION_PAUSE);
        this.buttonPause.addActionListener(this.listener);
        panel3.add(this.buttonPause);
        Button button = this.strMessage == null ? new Button(ACTION_ABORT) : new Button(ACTION_STOP);
        button.addActionListener(this.listener);
        panel3.add(button);
        panel = new Panel();
        this.add((Component)panel, "North");
        this.pack();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setResizable(false);
        if (this.progressBar != null) {
            this.labelProgress.setText(this.progressBar.getCurPercent() + "%");
        }
        this.repaint();
    }

    public void setCurPos(int n2) {
        if (this.progressBar != null) {
            this.progressBar.setCurPos(n2);
            this.labelProgress.setText(this.progressBar.getCurPercent() + "%");
            this.repaint();
        } else {
            this.labelProgress.setText(String.valueOf(JMFI18N.getResource("jmstudio.saveprogress.saved")) + " " + n2 + " " + JMFI18N.getResource("jmstudio.saveprogress.seconds") + "...");
        }
    }

    public void setPauseButtonText(String string) {
        this.buttonPause.setLabel(string);
        this.repaint();
    }

    public void windowClosing(WindowEvent windowEvent) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, ACTION_ABORT);
        this.listener.actionPerformed(actionEvent);
    }
}

