/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.RTCPAPPPacket;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESItem;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.BadFormatException;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacketReceiver;
import com.sun.media.rtp.util.UDPPacketReceiver;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;

public class RTCPRawReceiver
extends PacketFilter {
    public DatagramSocket socket;
    private StreamSynch streamSynch;
    private OverallStats stats = null;

    public RTCPRawReceiver() {
    }

    public RTCPRawReceiver(int n2, String string, OverallStats overallStats, StreamSynch streamSynch) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(n2, string, -1, null, 1000, null);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public RTCPRawReceiver(DatagramSocket datagramSocket, OverallStats overallStats, StreamSynch streamSynch) {
        this.setSource(new UDPPacketReceiver(datagramSocket, 1000));
        this.stats = overallStats;
        this.streamSynch = streamSynch;
    }

    public RTCPRawReceiver(RTPConnector rTPConnector, OverallStats overallStats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        try {
            this.setSource(new RTPPacketReceiver(rTPConnector.getControlInputStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.stats = overallStats;
    }

    public RTCPRawReceiver(RTPPushDataSource rTPPushDataSource, OverallStats overallStats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        this.setSource(new RTPPacketReceiver(rTPPushDataSource));
        this.stats = overallStats;
    }

    public RTCPRawReceiver(SessionAddress sessionAddress, SessionAddress sessionAddress2, OverallStats overallStats, StreamSynch streamSynch, DatagramSocket datagramSocket) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = overallStats;
        UDPPacketReceiver uDPPacketReceiver = new UDPPacketReceiver(sessionAddress.getControlPort(), sessionAddress.getControlHostAddress(), sessionAddress2.getControlPort(), sessionAddress2.getControlHostAddress(), 1000, datagramSocket);
        this.setSource(uDPPacketReceiver);
        this.socket = uDPPacketReceiver.getSocket();
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public String filtername() {
        return "RTCP Raw Receiver";
    }

    public Packet handlePacket(Packet packet) {
        RTCPPacket rTCPPacket;
        this.stats.update(0, 1);
        this.stats.update(11, 1);
        this.stats.update(1, packet.length);
        try {
            rTCPPacket = this.parse(packet);
        }
        catch (BadFormatException badFormatException) {
            this.stats.update(13, 1);
            return null;
        }
        return rTCPPacket;
    }

    public Packet handlePacket(Packet packet, int n2) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionAddress, boolean bl) {
        return null;
    }

    public RTCPPacket parse(Packet packet) throws BadFormatException {
        RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket(packet);
        Vector<RTCPSDESPacket> vector = new Vector<RTCPSDESPacket>(2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(rTCPCompoundPacket.data, rTCPCompoundPacket.offset, rTCPCompoundPacket.length));
        try {
            int n2 = 0;
            while (n2 < rTCPCompoundPacket.length) {
                RTCPPacket rTCPPacket;
                int n3 = dataInputStream.readUnsignedByte();
                if ((n3 & 0xC0) != 128) {
                    throw new BadFormatException();
                }
                int n4 = dataInputStream.readUnsignedByte();
                int n5 = dataInputStream.readUnsignedShort();
                n5 = n5 + 1 << 2;
                int n6 = 0;
                if (n2 + n5 > rTCPCompoundPacket.length) {
                    throw new BadFormatException();
                }
                if (n2 + n5 == rTCPCompoundPacket.length ? (n3 & 0x20) != 0 && (n6 = rTCPCompoundPacket.data[rTCPCompoundPacket.offset + rTCPCompoundPacket.length - 1] & 0xFF) == 0 : (n3 & 0x20) != 0) {
                    throw new BadFormatException();
                }
                int n7 = n5 - n6;
                n3 &= 0x1F;
                switch (n4) {
                    case 200: {
                        Object object2;
                        this.stats.update(12, 1);
                        if (n7 != 28 + 24 * n3) {
                            this.stats.update(18, 1);
                            System.out.println("bad format.");
                            throw new BadFormatException();
                        }
                        RTCPSRPacket rTCPSRPacket = new RTCPSRPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPSRPacket;
                        rTCPSRPacket.ssrc = dataInputStream.readInt();
                        rTCPSRPacket.ntptimestampmsw = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.ntptimestamplsw = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.rtptimestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.packetcount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.octetcount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                        rTCPSRPacket.reports = new RTCPReportBlock[n3];
                        this.streamSynch.update(rTCPSRPacket.ssrc, rTCPSRPacket.rtptimestamp, rTCPSRPacket.ntptimestampmsw, rTCPSRPacket.ntptimestamplsw);
                        int n8 = 0;
                        while (n8 < rTCPSRPacket.reports.length) {
                            rTCPSRPacket.reports[n8] = object2 = new RTCPReportBlock();
                            ((RTCPReportBlock)object2).ssrc = dataInputStream.readInt();
                            long l2 = dataInputStream.readInt();
                            ((RTCPReportBlock)object2).fractionlost = (int)((l2 &= 0xFFFFFFFFL) >> 24);
                            ((RTCPReportBlock)object2).packetslost = (int)(l2 & 0xFFFFFFL);
                            ((RTCPReportBlock)object2).lastseq = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            ((RTCPReportBlock)object2).jitter = dataInputStream.readInt();
                            ((RTCPReportBlock)object2).lsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            ((RTCPReportBlock)object2).dlsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            ++n8;
                        }
                        break;
                    }
                    case 201: {
                        if (n7 != 8 + 24 * n3) {
                            this.stats.update(15, 1);
                            throw new BadFormatException();
                        }
                        RTCPRRPacket rTCPRRPacket = new RTCPRRPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPRRPacket;
                        rTCPRRPacket.ssrc = dataInputStream.readInt();
                        rTCPRRPacket.reports = new RTCPReportBlock[n3];
                        int n9 = 0;
                        while (n9 < rTCPRRPacket.reports.length) {
                            RTCPReportBlock rTCPReportBlock;
                            rTCPRRPacket.reports[n9] = rTCPReportBlock = new RTCPReportBlock();
                            rTCPReportBlock.ssrc = dataInputStream.readInt();
                            long l3 = dataInputStream.readInt();
                            rTCPReportBlock.fractionlost = (int)((l3 &= 0xFFFFFFFFL) >> 24);
                            rTCPReportBlock.packetslost = (int)(l3 & 0xFFFFFFL);
                            rTCPReportBlock.lastseq = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            rTCPReportBlock.jitter = dataInputStream.readInt();
                            rTCPReportBlock.lsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            rTCPReportBlock.dlsr = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
                            ++n9;
                        }
                        break;
                    }
                    case 202: {
                        Object object;
                        Object object2 = new RTCPSDESPacket(rTCPCompoundPacket);
                        rTCPPacket = object2;
                        ((RTCPSDESPacket)object2).sdes = new RTCPSDES[n3];
                        int n10 = 4;
                        int n11 = 0;
                        while (n11 < ((RTCPSDESPacket)object2).sdes.length) {
                            int n12;
                            RTCPSDES rTCPSDES;
                            ((RTCPSDESPacket)object2).sdes[n11] = rTCPSDES = new RTCPSDES();
                            rTCPSDES.ssrc = dataInputStream.readInt();
                            n10 += 5;
                            object = new Vector();
                            boolean bl = false;
                            while ((n12 = dataInputStream.readUnsignedByte()) != 0) {
                                if (n12 < 1 || n12 > 8) {
                                    this.stats.update(16, 1);
                                    throw new BadFormatException();
                                }
                                if (n12 == 1) {
                                    bl = true;
                                }
                                RTCPSDESItem rTCPSDESItem = new RTCPSDESItem();
                                ((Vector)object).addElement(rTCPSDESItem);
                                rTCPSDESItem.type = n12;
                                int n13 = dataInputStream.readUnsignedByte();
                                rTCPSDESItem.data = new byte[n13];
                                dataInputStream.readFully(rTCPSDESItem.data);
                                n10 += 2 + n13;
                            }
                            if (!bl) {
                                this.stats.update(16, 1);
                                throw new BadFormatException();
                            }
                            rTCPSDES.items = new RTCPSDESItem[((Vector)object).size()];
                            ((Vector)object).copyInto(rTCPSDES.items);
                            if ((n10 & 3) != 0) {
                                dataInputStream.skip(4 - (n10 & 3));
                                n10 = n10 + 3 & 0xFFFFFFFC;
                            }
                            ++n11;
                        }
                        if (n7 == n10) break;
                        this.stats.update(16, 1);
                        throw new BadFormatException();
                    }
                    case 203: {
                        RTCPBYEPacket rTCPBYEPacket = new RTCPBYEPacket(rTCPCompoundPacket);
                        rTCPPacket = rTCPBYEPacket;
                        rTCPBYEPacket.ssrc = new int[n3];
                        int n14 = 0;
                        while (n14 < rTCPBYEPacket.ssrc.length) {
                            rTCPBYEPacket.ssrc[n14] = dataInputStream.readInt();
                            ++n14;
                        }
                        if (n7 > 4 + 4 * n3) {
                            n14 = dataInputStream.readUnsignedByte();
                            rTCPBYEPacket.reason = new byte[n14];
                            ++n14;
                        } else {
                            n14 = 0;
                            rTCPBYEPacket.reason = new byte[0];
                        }
                        n14 = n14 + 3 & 0xFFFFFFFC;
                        if (n7 != 4 + 4 * n3 + n14) {
                            this.stats.update(17, 1);
                            throw new BadFormatException();
                        }
                        dataInputStream.readFully(rTCPBYEPacket.reason);
                        dataInputStream.skip(n14 - rTCPBYEPacket.reason.length);
                        break;
                    }
                    case 204: {
                        if (n7 < 12) {
                            throw new BadFormatException();
                        }
                        Object object = new RTCPAPPPacket(rTCPCompoundPacket);
                        rTCPPacket = object;
                        ((RTCPAPPPacket)object).ssrc = dataInputStream.readInt();
                        ((RTCPAPPPacket)object).name = dataInputStream.readInt();
                        ((RTCPAPPPacket)object).subtype = n3;
                        ((RTCPAPPPacket)object).data = new byte[n7 - 12];
                        dataInputStream.readFully(((RTCPAPPPacket)object).data);
                        dataInputStream.skip(n7 - 12 - ((RTCPAPPPacket)object).data.length);
                        break;
                    }
                    default: {
                        this.stats.update(14, 1);
                        throw new BadFormatException();
                    }
                }
                rTCPPacket.offset = n2;
                rTCPPacket.length = n5;
                vector.addElement((RTCPSDESPacket)rTCPPacket);
                dataInputStream.skipBytes(n6);
                n2 += n5;
            }
        }
        catch (EOFException eOFException) {
            throw new BadFormatException("Unexpected end of RTCP packet");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        rTCPCompoundPacket.packets = new RTCPPacket[vector.size()];
        vector.copyInto(rTCPCompoundPacket.packets);
        return rTCPCompoundPacket;
    }
}

