/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.FlashAudioPlayer;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import java.applet.AudioClip;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Sound
implements AudioClip {
    static final int sndMono = 0;
    static final int sndStereo = 1;
    static final int snd8Bit = 0;
    static final int snd16Bit = 2;
    static final int snd5K = 0;
    static final int snd11K = 4;
    static final int intsnd22K = 8;
    static final int intsnd44K = 12;
    static final int sndCompressNone = 0;
    static final int sndCompressADPCM = 16;
    static final int sndRateMask = 12;
    static final int sndCompressMask = 240;
    private int format;
    private int srcSamples;
    private int dstSamples;
    private byte[] srcData;
    private int srcDataStart;
    private int srcDataPos;
    private boolean stereo;
    private boolean dataIsValid;
    private byte[] mulawData;
    Sound next;
    int characterTag;
    static final int sndRate5K_2X = 11025;
    static final int sndRate8K_2X = 16000;
    static final int sndRate11K_2X = 22050;
    static final int sndRate22K_2X = 44100;
    static final int sndRate44K_2X = 88200;
    static final int[] kRateTable = new int[]{11025, 22050, 44100, 88200};
    static final int[] kRateShiftTable;
    private static final int kNextTag = 779316836;
    private static final int kSndFormatMulaw8 = 1;
    private static final int kHeaderSize = 28;
    private static final int kMuLawZero = 2;
    private static final int kMuLawBias = 132;
    private static byte[] mulawExpTable;
    int bitBuf;
    int bitPos;
    int nBits;
    int nSamples;
    int[] valpred = new int[2];
    int[] index = new int[2];
    static final int[] indexTable2;
    static final int[] indexTable3;
    static final int[] indexTable4;
    static final int[] indexTable5;
    static final int[][] indexTables;
    static final int[] stepsizeTable;

    static {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        kRateShiftTable = nArray;
        indexTable2 = new int[]{-1, 2};
        indexTable3 = new int[]{-1, -1, 2, 4};
        indexTable4 = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
        indexTable5 = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 4, 6, 8, 10, 13, 16};
        indexTables = new int[][]{indexTable2, indexTable3, indexTable4, indexTable5};
        stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    }

    Sound(int n2, int n3, byte[] byArray, int n4) {
        this.format = n2;
        this.srcSamples = n3;
        this.srcData = byArray;
        this.srcDataStart = this.srcDataPos = n4;
        this.stereo = this.Stereo();
        this.CreateMulawTable();
        switch (this.Rate2X()) {
            case 11025: {
                this.dstSamples = (int)(((long)n3 * 16000L + 11024L) / 11025L);
                break;
            }
            case 22050: {
                this.dstSamples = (int)(((long)n3 * 16000L + 22049L) / 22050L);
                break;
            }
            case 44100: {
                this.dstSamples = (int)(((long)n3 * 16000L + 44099L) / 44100L);
                break;
            }
            case 88200: {
                this.dstSamples = (int)(((long)n3 * 16000L + 88199L) / 88200L);
                break;
            }
        }
    }

    int BitsPerSample() {
        return (this.format & 2) != 0 ? 16 : 8;
    }

    int BytesPerSample() {
        return (this.format & 2) != 0 ? 2 : 1;
    }

    int CompressFormat() {
        return this.format & 0xF0;
    }

    boolean Compressed() {
        return (this.format & 0xF0) != 0;
    }

    private static byte Convert16BitToMulaw(int n2) {
        int n3;
        byte by;
        int n4;
        int n5;
        if (n2 < 0) {
            n5 = 128;
            n2 = -n2;
        } else {
            n5 = 0;
        }
        int n6 = n2 + 132;
        if (n6 > Short.MAX_VALUE) {
            n6 = Short.MAX_VALUE;
        }
        if ((n4 = ~(n5 | (by = mulawExpTable[n6 >> 7]) << 4 | (n3 = n6 >> by + 3 & 0xF))) == 0) {
            n4 = 2;
        }
        return (byte)n4;
    }

    synchronized boolean ConvertToMulaw(int n2) {
        if (this.dataIsValid) {
            return true;
        }
        this.mulawData = this.DecompressFromADPCMAndResample();
        if (this.mulawData != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(28);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(779316836);
                dataOutputStream.writeInt(28);
                if (FlashAudioPlayer.player.getRendererUsed() == 2) {
                    dataOutputStream.writeInt(this.dstSamples * n2);
                } else {
                    dataOutputStream.writeInt(this.dstSamples);
                }
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(8000);
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(0);
            }
            catch (IOException iOException) {
                System.out.println("ConvertToMulaw: IOException: return false");
                return false;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n3 = 0;
            while (n3 < 28) {
                this.mulawData[n3] = byArray[n3];
                ++n3;
            }
            this.dataIsValid = true;
            return true;
        }
        return false;
    }

    void CreateMulawTable() {
        if (mulawExpTable == null) {
            mulawExpTable = new byte[256];
            int n2 = 0;
            while (n2 < 8) {
                int n3;
                int n4 = n3 = 1 << n2;
                while (n3 > 0) {
                    Sound.mulawExpTable[n4] = (byte)n2;
                    ++n4;
                    --n3;
                }
                ++n2;
            }
            Sound.mulawExpTable[0] = 0;
        }
    }

    private void Decompress(byte[] byArray, int n2) {
        int n3 = 0;
        if (this.nBits == 0) {
            this.nBits = this.GetBits(2) + 2;
        }
        int[] nArray = indexTables[this.nBits - 2];
        int n4 = 1 << this.nBits - 2;
        int n5 = 1 << this.nBits - 1;
        if (!this.stereo) {
            int n6 = this.valpred[0];
            int n7 = this.index[0];
            int n8 = this.nSamples;
            while (n2-- > 0) {
                if ((++n8 & 0xFFF) == 1) {
                    n6 = this.GetSBits(16);
                    byArray[n3++] = Sound.Convert16BitToMulaw(n6);
                    n7 = this.GetBits(6);
                    continue;
                }
                int n9 = this.GetBits(this.nBits);
                int n10 = stepsizeTable[n7];
                int n11 = 0;
                int n12 = n4;
                do {
                    if ((n9 & n12) != 0) {
                        n11 += n10;
                    }
                    n10 >>= 1;
                } while ((n12 >>= 1) != 0);
                n6 = (n9 & n5) != 0 ? (n6 -= n11) : (n6 += (n11 += n10));
                if ((n7 += nArray[n9 & ~n5]) < 0) {
                    n7 = 0;
                } else if (n7 > 88) {
                    n7 = 88;
                }
                if (n6 != (short)n6) {
                    n6 = n6 < 0 ? Short.MIN_VALUE : Short.MAX_VALUE;
                }
                byArray[n3++] = Sound.Convert16BitToMulaw(n6);
            }
            this.valpred[0] = n6;
            this.index[0] = n7;
            this.nSamples = n8;
        } else {
            int n13 = 0;
            while (n2-- > 0) {
                int n14;
                ++this.nSamples;
                if ((this.nSamples & 0xFFF) == 1) {
                    n14 = 0;
                    while (n14 < 2) {
                        this.valpred[n14] = this.GetSBits(16);
                        if (n14 == 0) {
                            n13 = this.valpred[n14];
                        } else {
                            n13 += this.valpred[n14];
                            byArray[n3++] = Sound.Convert16BitToMulaw(n13 >>= 1);
                        }
                        this.index[n14] = this.GetBits(6);
                        ++n14;
                    }
                    continue;
                }
                n14 = 0;
                while (n14 < 2) {
                    int n15 = this.GetBits(this.nBits);
                    int n16 = stepsizeTable[this.index[n14]];
                    int n17 = 0;
                    int n18 = n4;
                    do {
                        if ((n15 & n18) != 0) {
                            n17 += n16;
                        }
                        n16 >>= 1;
                    } while ((n18 >>= 1) != 0);
                    n17 += n16;
                    if ((n15 & n5) != 0) {
                        int n19 = n14;
                        this.valpred[n19] = this.valpred[n19] - n17;
                    } else {
                        int n20 = n14;
                        this.valpred[n20] = this.valpred[n20] + n17;
                    }
                    int n21 = n14;
                    this.index[n21] = this.index[n21] + nArray[n15 & ~n5];
                    if (this.index[n14] < 0) {
                        this.index[n14] = 0;
                    } else if (this.index[n14] > 88) {
                        this.index[n14] = 88;
                    }
                    if (this.valpred[n14] != (short)this.valpred[n14]) {
                        int n22 = this.valpred[n14] = this.valpred[n14] < 0 ? Short.MIN_VALUE : Short.MAX_VALUE;
                    }
                    if (n14 == 0) {
                        n13 = this.valpred[n14];
                    } else {
                        n13 += this.valpred[n14];
                        byArray[n3++] = Sound.Convert16BitToMulaw(n13 >>= 1);
                    }
                    ++n14;
                }
            }
        }
    }

    private byte[] DecompressFromADPCMAndResample() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 28;
        int n6 = this.dstSamples + 28;
        switch (this.Rate2X()) {
            case 11025: {
                n2 = Matrix.div(361267200, 524288000);
                break;
            }
            case 22050: {
                n2 = Matrix.div(722534400, 524288000);
                break;
            }
            case 44100: {
                n2 = Matrix.div(1445068800, 524288000);
                break;
            }
            case 88200: {
                n2 = Matrix.div(1445068800, 0xFA00000);
                break;
            }
        }
        this.srcDataPos = this.srcDataStart;
        byte[] byArray = new byte[2048];
        if (byArray == null) {
            return null;
        }
        this.Skip(0);
        byte[] byArray2 = new byte[this.dstSamples + 28];
        if (byArray2 == null) {
            return null;
        }
        int n7 = this.srcSamples;
        while (n7 > 0) {
            if (n7 > 2048) {
                this.Decompress(byArray, 2048);
                n3 = 0x8000000;
            } else {
                this.Decompress(byArray, n7);
                n3 = n7 - 1 << 16;
            }
            while (n4 < n3 && n5 < n6) {
                byArray2[n5++] = byArray[n4 >> 16];
                n4 += n2;
            }
            if (n7 <= 2048) {
                byArray2[this.dstSamples - 1] = byArray[n7 - 1];
            } else {
                n4 -= 0x8000000;
            }
            n7 -= 2048;
        }
        return byArray2;
    }

    private void FillBuffer() {
        while (this.bitPos <= 24) {
            this.bitBuf = this.bitBuf << 8 | 0xFF & this.srcData[this.srcDataPos++];
            this.bitPos += 8;
        }
    }

    private int GetBits(int n2) {
        if (this.bitPos < n2) {
            this.FillBuffer();
        }
        int n3 = this.bitBuf << 32 - this.bitPos >>> 32 - n2;
        this.bitPos -= n2;
        return n3;
    }

    private int GetSBits(int n2) {
        if (this.bitPos < n2) {
            this.FillBuffer();
        }
        int n3 = this.bitBuf << 32 - this.bitPos >> 32 - n2;
        this.bitPos -= n2;
        return n3;
    }

    boolean Is8Bit() {
        return (this.format & 2) == 0;
    }

    int NChannels() {
        return (this.format & 1) != 0 ? 2 : 1;
    }

    int Rate2X() {
        return kRateTable[this.format >> 2 & 3];
    }

    int RateShift() {
        return kRateShiftTable[this.format >> 2 & 3];
    }

    void SetFormat(int n2) {
        this.format = n2;
        this.stereo = this.Stereo();
    }

    void SetSamples(int n2) {
        this.srcSamples = n2;
        switch (this.Rate2X()) {
            case 11025: {
                this.dstSamples = (int)(((long)n2 * 16000L + 11024L) / 11025L);
                break;
            }
            case 22050: {
                this.dstSamples = (int)(((long)n2 * 16000L + 22049L) / 22050L);
                break;
            }
            case 44100: {
                this.dstSamples = (int)(((long)n2 * 16000L + 44099L) / 44100L);
                break;
            }
            case 88200: {
                this.dstSamples = (int)(((long)n2 * 16000L + 88199L) / 88200L);
                break;
            }
        }
    }

    private void Skip(int n2) {
        int n3;
        int n4;
        if (this.nBits == 0) {
            this.nBits = this.GetBits(2) + 2;
        }
        if ((n4 = this.nSamples & 0xFFFFF000) > 0 && n2 > n4 + this.nSamples) {
            this.nSamples += n4;
            n2 -= n4;
            n3 = n4 * this.nBits;
            if (this.stereo) {
                n3 *= 2;
            }
            this.SkipBits(n3);
        }
        n3 = n2 >> 12;
        int n5 = n3 * (22 + this.nBits * 4095);
        if (this.stereo) {
            n5 *= 2;
        }
        this.SkipBits(n5);
        n2 &= 0xFFF;
        byte[] byArray = new byte[2048];
        int n6 = this.stereo ? 512 : 1024;
        while (n2 > 0) {
            int n7 = Math.min(n6, n2);
            this.Decompress(byArray, n7 + n7);
            n2 -= n7;
        }
    }

    private void SkipBits(int n2) {
        if (n2 <= 32) {
            while (n2 > 0) {
                int n3 = Math.min(16, n2);
                this.GetBits(n3);
                n2 -= n3;
            }
        } else {
            this.bitPos = 0;
            int n4 = (n2 -= this.bitPos) / 8;
            this.srcDataPos += n4;
            this.GetBits(n2 & 7);
        }
    }

    boolean Stereo() {
        return (this.format & 1) != 0;
    }

    public synchronized void loop() {
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, -1);
        }
    }

    public synchronized void play() {
        this.play(1);
    }

    public synchronized void play(int n2) {
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, n2);
        }
    }

    synchronized void playMultiple() {
        this.playMultiple(1);
    }

    synchronized void playMultiple(int n2) {
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, n2);
        }
    }

    synchronized void playNoMultiple() {
        this.playMultiple(1);
    }

    synchronized void playNoMultiple(int n2) {
        if (FlashAudioPlayer.player.getActiveSoundNum() != 0) {
            return;
        }
        this.stop();
        if (this.mulawData != null) {
            FlashAudioPlayer.player.start(this.mulawData, n2);
        }
    }

    public synchronized void stop() {
        FlashAudioPlayer.player.stop();
    }
}

