/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import com.sun.media.content.application.x_shockwave_flash.REdge;
import com.sun.media.content.application.x_shockwave_flash.RRun;
import com.sun.media.content.application.x_shockwave_flash.Rect;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.ScriptPlayer;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

final class DisplayList
implements ImageProducer {
    private Matrix cameraMat = new Matrix();
    private int backgroundColor = -1;
    private int backgroundColorPriority = 0;
    boolean antialias = false;
    private Rect devDirtyRgn = new Rect();
    private SObject objects;
    private Flash flash;
    SObject button = null;
    int buttonState = 0;
    private int buttonId = 0;
    static final int showAll = 0;
    static final int noBorder = 1;
    static final int exactFit = 2;
    static final int scaleMask = 15;
    static final int alignLeft = 16;
    static final int alignRight = 32;
    static final int alignTop = 64;
    static final int alignBottom = 128;
    boolean indexedColor;
    ColorModel model = null;
    private int width = 0;
    private int height = 0;
    private Rect bitClip;
    private Rect edgeClip;
    private int pixelSize = 0;
    private int pixelOrg;
    byte[] pixels8 = null;
    int[] pixels32 = null;
    private int topColorXleft;
    private RColor topColor;
    private RColor activeColors;
    private REdge[] activeEdges;
    private int nActive;
    private int maxActive;
    private REdge[] yindex;
    private int ylines;
    private int y;
    int bitY;
    private RRun firstRun;
    private RRun curRun;
    RRun runPool;
    private long rgb;
    private int pixelX;
    private int pixelW;
    private int pbufWidth;
    private int pbufTop;
    private int pbufNLines;
    private int pbufMaxLines;
    private int nColors;
    private int[] ctab;
    private byte[] itab;
    private int nEmpty;
    private int[] error;
    boolean forceCompleteScanlines = false;
    ImageConsumer theConsumer;
    boolean newConsumer;

    DisplayList(Flash flash) {
        this.flash = flash;
    }

    private final void AddEdges(REdge rEdge) {
        while (rEdge != null) {
            if (rEdge.anchor1y <= this.edgeClip.ymax && rEdge.anchor2y > this.edgeClip.ymin) {
                int n2 = rEdge.anchor1y - this.edgeClip.ymin;
                if (n2 < 0) {
                    n2 = 0;
                }
                rEdge.nextActive = this.yindex[n2];
                this.yindex[n2] = rEdge;
            }
            rEdge = rEdge.nextObj;
        }
    }

    private final void AdvanceLine() {
        ++this.pbufNLines;
        if (this.pbufNLines >= this.pbufMaxLines) {
            this.SendPixels();
        }
        this.pixelOrg = this.pbufNLines * this.pbufWidth - this.bitClip.xmin;
    }

    private final void BuildInverseTable() {
        if (this.itab == null || this.error == null) {
            this.itab = new byte[4096];
            this.error = new int[4096];
        }
        int n2 = 0;
        while (n2 < 4096) {
            this.error[n2] = 50000;
            ++n2;
        }
        this.nEmpty = 4096;
        int n3 = 3;
        while (n3 < 16 && this.nEmpty > 0) {
            int n4 = 0;
            while (n4 < this.nColors) {
                this.FillCube(this.ctab[n4], n4, n3);
                ++n4;
            }
            ++n3;
        }
        this.error = null;
    }

    private final int ColorDist(int n2, int n3) {
        int n4 = n2 - n3;
        return n4 < 0 ? -n4 : n4;
    }

    private final void DrawPixel(int n2, long l2, int n3) {
        this.SetPixel(n2, DisplayList.PackColor(l2 / 16L));
    }

    /*
     * Unable to fully structure code
     */
    private final void DrawSlab(int var1_1, int var2_2, RColor var3_3) {
        if (var1_1 < this.bitClip.xmin) {
            var1_1 = this.bitClip.xmin;
        }
        if (var2_2 > this.bitClip.xmax) {
            var2_2 = this.bitClip.xmax;
        }
        switch (var3_3.fillType) {
            case 64: 
            case 65: 
            case 66: {
                var3_3.bitmap.DrawSlab(this.pixelOrg, var1_1, var2_2, var3_3);
                break;
            }
            case 0: {
                var4_4 = var1_1 + this.pixelOrg;
                var5_7 = var2_2 - var1_1;
                if (var4_4 + var5_7 > this.pixelSize) {
                    return;
                }
                if (!this.indexedColor) ** GOTO lbl20
                while (var5_7-- > 0) {
                    this.pixels8[var4_4++] = var3_3.index;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    this.pixels32[var4_4++] = var3_3.color;
lbl20:
                    // 2 sources

                    ** while (var5_7-- > 0)
                }
lbl21:
                // 1 sources

                break;
            }
            case 16: {
                var4_5 = new Point(var1_1 << 8, this.bitY << 8);
                var3_3.ginvMat.transform(var4_5);
                var5_8 = var3_3.ginvMat.a >> 8;
                var6_10 = var3_3.ginvMat.b >> 8;
                var7_12 = var1_1;
                while (var7_12 < var2_2) {
                    var8_14 = (var4_5.x >> 15) + 128;
                    if (var8_14 > 256) {
                        var8_14 = 256;
                    } else if (var8_14 < 0) {
                        var8_14 = 0;
                    }
                    this.SetPixel(var7_12, var3_3.gcolorRamp[var8_14]);
                    var4_5.x += var5_8;
                    var4_5.y += var6_10;
                    ++var7_12;
                }
                break;
            }
            case 18: {
                var4_6 = new Point(var1_1 << 8, this.bitY << 8);
                var3_3.ginvMat.transform(var4_6);
                var5_9 = var3_3.ginvMat.a >> 8;
                var6_11 = var3_3.ginvMat.b >> 8;
                var7_13 = 0;
                var8_15 = Matrix.length(var4_6.x, var4_6.y) >> 14;
                if (var8_15 > 256) {
                    var8_15 = 256;
                }
                var9_16 = var1_1;
                while (var9_16 < var2_2) {
                    var10_17 = var4_6.x >> 14;
                    var11_18 = var10_17 * var10_17;
                    var10_17 = var4_6.y >> 14;
                    var11_18 += var10_17 * var10_17;
                    var12_19 = var8_15;
                    if ((var8_15 += var7_13) < 0) {
                        var8_15 = 0;
                    } else if (var8_15 > 256) {
                        var8_15 = 256;
                    }
                    while (true) {
                        if (var11_18 < var8_15 * var8_15) {
                            --var8_15;
                            continue;
                        }
                        if (var11_18 <= (var8_15 + 1) * (var8_15 + 1) || var8_15 >= 256) break;
                        ++var8_15;
                    }
                    var7_13 = var8_15 - var12_19;
                    this.SetPixel(var9_16, var3_3.gcolorRamp[var8_15]);
                    var4_6.x += var5_9;
                    var4_6.y += var6_11;
                    ++var9_16;
                }
                break;
            }
        }
    }

    static final long ExpandColor(int n2) {
        return ((long)n2 & 0xFF000000L) << 24 | ((long)n2 & 0xFF0000L) << 16 | ((long)n2 & 0xFF00L) << 8 | (long)n2 & 0xFFL;
    }

    private final void FillCube(int n2, int n3, int n4) {
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = n5 >> 4;
        int n9 = n6 >> 4;
        int n10 = n7 >> 4;
        int n11 = Math.max(0, n8 - n4);
        int n12 = Math.min(15, n8 + n4);
        int n13 = Math.max(0, n9 - n4);
        int n14 = Math.min(15, n9 + n4);
        int n15 = Math.max(0, n10 - n4);
        int n16 = Math.min(15, n10 + n4);
        n8 = n11;
        while (n8 <= n12) {
            int n17 = n8 == 15 ? 255 : n8 << 4;
            n9 = n13;
            while (n9 <= n14) {
                int n18 = n9 == 15 ? 255 : n9 << 4;
                int n19 = this.ColorDist(n17, n5) + this.ColorDist(n18, n6);
                int n20 = n8 << 8 | n9 << 4;
                n10 = n15;
                while (n10 <= n16) {
                    int n21 = n10 == 15 ? 255 : n10 << 4;
                    int n22 = n20 | n10;
                    int n23 = n19 + this.ColorDist(n21, n7);
                    if (n23 < this.error[n22]) {
                        if (this.error[n22] == 50000) {
                            --this.nEmpty;
                        }
                        this.error[n22] = n23;
                        this.itab[n22] = (byte)n3;
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    private SObject FindObject(int n2) {
        SObject sObject = this.objects;
        while (sObject != null) {
            if (sObject.id == n2) {
                return sObject;
            }
            sObject = sObject.next;
        }
        return null;
    }

    void FreeAll() {
        SObject sObject = this.objects;
        while (sObject != null) {
            this.devDirtyRgn.union(sObject.devBounds);
            sObject = sObject.next;
        }
        this.objects = null;
        this.button = null;
        if (this.backgroundColorPriority <= 1) {
            this.backgroundColor = -1;
            this.backgroundColorPriority = 0;
        }
    }

    private final void HideColor(RColor rColor, int n2) {
        if (rColor == this.topColor) {
            this.UpdateColor(n2);
        }
    }

    public synchronized SObject HitButton(int n2, int n3) {
        SObject sObject = null;
        int n4 = 0;
        SObject sObject2 = this.objects;
        while (sObject2 != null) {
            if (sObject2.character.type == 2 && sObject2.id > n4 && this.HitOneButton(sObject2, n2, n3)) {
                sObject = sObject2;
                n4 = sObject2.id;
            }
            sObject2 = sObject2.next;
        }
        return sObject;
    }

    public synchronized boolean HitOneButton(SObject sObject, int n2, int n3) {
        int n4;
        Point point = new Point(n2, n3);
        if (this.antialias) {
            point.x *= 4;
            point.y *= 4;
        }
        ScriptPlayer scriptPlayer = sObject.character.player;
        SParser sParser = new SParser();
        sParser.Attach(scriptPlayer.script, sObject.character.dataPos);
        while ((n4 = sParser.GetByte()) != 0) {
            SCharacter sCharacter;
            int n5 = sParser.GetWord();
            int n6 = sObject.id + sParser.GetWord();
            Matrix matrix = sParser.GetMatrix();
            int n7 = n5 << 16 | n6;
            if ((n4 & 8) == 0 || (sCharacter = scriptPlayer.FindCharacter(n5)) == null) continue;
            SObject sObject2 = new SObject();
            sObject2.display = this;
            sObject2.character = sCharacter;
            sObject2.id = n7;
            sObject2.mat = Matrix.concat(matrix, sObject.mat);
            sObject2.devMat = Matrix.concat(sObject2.mat, this.cameraMat);
            sObject2.devBounds = sObject2.devMat.transform(sCharacter.bounds);
            if (!sObject2.HitTest(point)) continue;
            return true;
        }
        return false;
    }

    final int IndexToRGB(int n2) {
        return this.ctab[n2];
    }

    private final void InitPixels() {
        this.pixelOrg = -this.bitClip.xmin;
        this.pbufWidth = this.bitClip.xmax - this.bitClip.xmin;
        this.pbufNLines = 0;
        this.pbufMaxLines = this.pixelSize / this.pbufWidth;
        this.pbufTop = this.bitClip.ymin;
    }

    public synchronized void Invalidate() {
        this.devDirtyRgn.ymin = 0;
        this.devDirtyRgn.xmin = 0;
        this.devDirtyRgn.xmax = this.width;
        this.devDirtyRgn.ymax = this.height;
        if (this.antialias) {
            this.devDirtyRgn.xmax *= 4;
            this.devDirtyRgn.ymax *= 4;
        }
    }

    private void ModifyCamera() {
        this.Invalidate();
        SObject sObject = this.objects;
        while (sObject != null) {
            sObject.ClearEdges();
            sObject.devMat = Matrix.concat(sObject.mat, this.cameraMat);
            sObject.devBounds = sObject.devMat.transform(sObject.character.bounds);
            sObject = sObject.next;
        }
    }

    static final int PackColor(long l2) {
        return (int)(l2 >> 24) & 0xFF000000 | (int)(l2 >> 16) & 0xFF0000 | (int)(l2 >> 8) & 0xFF00 | (int)l2 & 0xFF;
    }

    private final void PaintAARuns() {
        this.bitY = this.y / 4;
        this.PixelInit();
        RRun rRun = this.firstRun;
        while (true) {
            if (rRun.nColors > 0) {
                if (rRun.isPure && rRun.nColors == 4) {
                    RRun rRun2;
                    while ((rRun2 = rRun.next) != null && rRun2.isPure && rRun2.colors[0] == rRun.colors[0] && rRun2.nColors >= 4) {
                        rRun.xmax = rRun2.xmax;
                        rRun.next = rRun2.next;
                    }
                }
                int n2 = rRun.xmin / 4;
                int n3 = rRun.xmin & 3;
                int n4 = rRun.xmax / 4;
                int n5 = rRun.xmax & 3;
                long l2 = rRun.CalcColor(n2, this.bitY);
                if (n2 == n4) {
                    this.PixelAdd(l2, rRun.nColors, n2, n5 - n3);
                } else {
                    if (n3 > 0) {
                        this.PixelAdd(l2, rRun.nColors, n2, 4 - n3);
                        ++n2;
                    }
                    if (n2 < n4) {
                        long l3;
                        int n6;
                        int n7;
                        if (rRun.isPure && rRun.nColors == 4) {
                            this.DrawSlab(n2, n4, rRun.colors[0]);
                        } else if (rRun.isComplex) {
                            n7 = 4 * rRun.nColors;
                            n6 = n2;
                            while (n6 < n4) {
                                l3 = rRun.CalcColor(n6, this.bitY) * 4L;
                                this.DrawPixel(n6, l3, n7);
                                ++n6;
                            }
                        } else {
                            l3 = 4L * l2;
                            n7 = 4 * rRun.nColors;
                            n6 = n2;
                            while (n6 < n4) {
                                this.DrawPixel(n6, l3, n7);
                                ++n6;
                            }
                        }
                    }
                    if (n5 > 0) {
                        if (rRun.isComplex) {
                            l2 = rRun.CalcColor(n4, this.bitY);
                        }
                        this.PixelAdd(l2, rRun.nColors, n4, n5);
                    }
                }
            }
            if (rRun.next == null) break;
            rRun = rRun.next;
        }
        rRun.next = this.runPool;
        this.runPool = this.firstRun;
        this.firstRun = null;
        this.PixelPaint();
    }

    /*
     * Unable to fully structure code
     */
    private final void PaintAASlab(int var1_1, int var2_2) {
        var3_3 = this.curRun;
        if (var3_3 != null && var3_3.xmin < var2_2) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var3_3.next;
            if (var3_3 != null) continue;
            this.curRun = null;
            return;
lbl8:
            // 2 sources

            ** while (var3_3.xmax < var1_1)
        }
lbl9:
        // 1 sources

        if (var3_3.xmin < var1_1) {
            var3_3 = var3_3.Split(this, var1_1);
        }
        while (var3_3 != null && var3_3.xmin < var2_2) {
            if (var3_3.xmax > var2_2) {
                this.curRun = var3_3.Split(this, var2_2);
                var3_3.AddColor(this.topColor);
                return;
            }
            var3_3.AddColor(this.topColor);
            var3_3 = var3_3.next;
        }
        this.curRun = var3_3;
    }

    private final void PaintBits() {
        this.InitPixels();
        this.y = this.edgeClip.ymin;
        while (this.y < this.edgeClip.ymax) {
            int n2;
            boolean bl;
            int n3;
            REdge rEdge = this.yindex[this.y - this.edgeClip.ymin];
            while (rEdge != null) {
                rEdge.initStep(this.y);
                if (this.nActive == this.maxActive) {
                    this.maxActive *= 2;
                    REdge[] rEdgeArray = new REdge[this.maxActive];
                    System.arraycopy(this.activeEdges, 0, rEdgeArray, 0, this.nActive);
                    this.activeEdges = rEdgeArray;
                }
                n3 = this.nActive;
                while (true) {
                    if (n3 == 0 || this.activeEdges[n3 - 1].x < rEdge.x) break;
                    this.activeEdges[n3] = this.activeEdges[n3 - 1];
                    --n3;
                }
                this.activeEdges[n3] = rEdge;
                ++this.nActive;
                rEdge = rEdge.nextActive;
            }
            n3 = this.nActive - 1;
            do {
                bl = false;
                n2 = 0;
                while (n2 < n3) {
                    if (this.activeEdges[n2].x > this.activeEdges[n2 + 1].x) {
                        REdge rEdge2 = this.activeEdges[n2];
                        this.activeEdges[n2] = this.activeEdges[n2 + 1];
                        this.activeEdges[n2 + 1] = rEdge2;
                        if (!bl && n2 > 0 && this.activeEdges[n2 - 1].x > this.activeEdges[n2].x) {
                            bl = true;
                        }
                    }
                    ++n2;
                }
            } while (bl && --n3 > 0);
            if (this.antialias) {
                if (this.firstRun == null) {
                    if (this.runPool != null) {
                        this.firstRun = this.runPool;
                        this.runPool = this.firstRun.next;
                        this.firstRun.next = null;
                        this.firstRun.nColors = 0;
                        this.firstRun.isComplex = false;
                        this.firstRun.isPure = true;
                    } else {
                        this.firstRun = new RRun();
                    }
                    this.firstRun.xmin = this.edgeClip.xmin;
                    this.firstRun.xmax = this.edgeClip.xmax;
                }
                this.curRun = this.firstRun;
            } else {
                this.bitY = this.y;
            }
            n2 = 0;
            int n4 = this.y + 1;
            int n5 = 0;
            while (n5 < this.nActive) {
                REdge rEdge3 = this.activeEdges[n5];
                switch (rEdge3.fillRule) {
                    case 0: {
                        RColor rColor = rEdge3.color1;
                        if (rColor.visible != 0) {
                            rColor.visible = 0;
                            this.HideColor(rColor, rEdge3.x);
                        } else {
                            rColor.visible = 1;
                            this.ShowColor(rColor, rEdge3.x);
                        }
                        rColor = rEdge3.color2;
                        if (rColor.visible != 0) {
                            rColor.visible = 0;
                            this.HideColor(rColor, rEdge3.x);
                            break;
                        }
                        rColor.visible = 1;
                        this.ShowColor(rColor, rEdge3.x);
                        break;
                    }
                    case 1: {
                        RColor rColor = rEdge3.color1;
                        if (rColor.visible != 0) {
                            rColor.visible = 0;
                            this.HideColor(rColor, rEdge3.x);
                            break;
                        }
                        rColor.visible = 1;
                        this.ShowColor(rColor, rEdge3.x);
                        break;
                    }
                    case 2: {
                        RColor rColor = rEdge3.color1;
                        if (rColor.visible == 0) {
                            rColor.visible += rEdge3.dir;
                            this.ShowColor(rColor, rEdge3.x);
                            break;
                        }
                        rColor.visible += rEdge3.dir;
                        if (rColor.visible != 0) break;
                        this.HideColor(rColor, rEdge3.x);
                    }
                }
                if (rEdge3.anchor2y > n4) {
                    rEdge3.Step(n4);
                    this.activeEdges[n2] = rEdge3;
                    ++n2;
                }
                ++n5;
            }
            this.nActive = n2;
            if (this.antialias) {
                if ((this.y & 3) == 3) {
                    this.PaintAARuns();
                    if (this.theConsumer == null) {
                        return;
                    }
                    this.AdvanceLine();
                }
            } else {
                if (this.theConsumer == null) {
                    return;
                }
                this.AdvanceLine();
            }
            ++this.y;
        }
        if (this.theConsumer != null) {
            this.SendPixels();
        }
        this.runPool = null;
    }

    private final void PixelAdd(long l2, int n2, int n3, int n4) {
        if (this.pixelX != n3) {
            this.PixelPaint();
            this.pixelX = n3;
        }
        this.rgb += (long)n4 * l2;
        this.pixelW += n4 * n2;
    }

    private final void PixelInit() {
        this.rgb = 0L;
        this.pixelW = 0;
        this.pixelX = -32000;
    }

    private final void PixelPaint() {
        if (this.pixelW > 0) {
            this.DrawPixel(this.pixelX, this.rgb, this.pixelW);
            this.rgb = 0L;
            this.pixelW = 0;
        }
    }

    public synchronized void PlaceObject(SCharacter sCharacter, int n2, Matrix matrix, ColorTransform colorTransform) {
        SObject sObject = new SObject();
        sObject.next = this.objects;
        this.objects = sObject;
        sObject.display = this;
        sObject.character = sCharacter;
        sObject.id = n2;
        sObject.mat = matrix;
        sObject.cx = colorTransform;
        if (sCharacter.type == 2) {
            int n3 = 1;
            if (n2 == this.buttonId) {
                this.button = sObject;
                n3 = this.buttonState;
            }
            this.UpdateButton(sObject, n3);
            sObject.devBounds = new Rect();
        } else {
            sObject.devMat = Matrix.concat(sObject.mat, this.cameraMat);
            sObject.devBounds = sObject.devMat.transform(sCharacter.bounds);
            this.devDirtyRgn.union(sObject.devBounds);
        }
    }

    final int RGBToIndex(int n2) {
        int n3 = (n2 & 0xF00000) >> 12 | (n2 & 0xF000) >> 8 | (n2 & 0xF0) >> 4;
        return this.itab[n3] & 0xFF;
    }

    public synchronized void RemoveObject(int n2) {
        SObject sObject = null;
        SObject sObject2 = this.objects;
        while (sObject2 != null) {
            if (sObject2.id == n2) {
                if (sObject2.buttonState != 0) {
                    this.UpdateButton(sObject2, 0);
                    this.RemoveObject(n2);
                    if (this.button != sObject2) break;
                    this.button = null;
                    break;
                }
                if (sObject2.drawn) {
                    this.devDirtyRgn.union(sObject2.devBounds);
                }
                if (sObject != null) {
                    sObject.next = sObject2.next;
                    break;
                }
                this.objects = sObject2.next;
                break;
            }
            sObject = sObject2;
            sObject2 = sObject2.next;
        }
    }

    private final void SendPixels() {
        if (this.pbufNLines > 0) {
            if (this.indexedColor) {
                this.theConsumer.setPixels(this.bitClip.xmin, this.pbufTop, this.pbufWidth, this.pbufNLines, this.model, this.pixels8, 0, this.pbufWidth);
            } else {
                this.theConsumer.setPixels(this.bitClip.xmin, this.pbufTop, this.pbufWidth, this.pbufNLines, this.model, this.pixels32, 0, this.pbufWidth);
            }
        }
        this.pbufTop += this.pbufNLines;
        this.pbufNLines = 0;
    }

    public synchronized void SetBackgroundColor(int n2, int n3) {
        if (n3 >= this.backgroundColorPriority) {
            if (this.backgroundColor == n2 && n3 == this.backgroundColorPriority) {
                return;
            }
            this.Invalidate();
            this.backgroundColor = n2;
            this.backgroundColorPriority = n3;
        }
    }

    public synchronized boolean SetButtonState(SObject sObject, int n2) {
        boolean bl = false;
        if (sObject != this.button) {
            if (this.button != null) {
                this.button.character.player.PlayButtonSound(this.button, 1);
                this.UpdateButton(this.button, 1);
                bl = true;
            }
            this.button = sObject;
            if (this.button != null) {
                this.button.character.player.PlayButtonSound(this.button, n2);
                this.UpdateButton(this.button, n2);
                bl = true;
            }
        } else if (this.button != null && this.button.buttonState != n2) {
            this.button.character.player.PlayButtonSound(this.button, n2);
            this.UpdateButton(this.button, n2);
            bl = true;
        }
        if (this.button != null) {
            this.buttonState = n2;
            this.buttonId = this.button.id;
        } else {
            this.buttonId = 0;
        }
        return bl;
    }

    public synchronized void SetCamera(Rect rect, boolean bl, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Rect rect2 = new Rect(0, 0, this.width, this.height);
        if (bl) {
            rect2.xmax *= 4;
            rect2.ymax *= 4;
        }
        Matrix matrix = new Matrix();
        matrix.a = Matrix.div(Math.max(rect2.xmax - rect2.xmin, 16), Math.max(rect.xmax - rect.xmin, 16));
        matrix.d = Matrix.div(Math.max(rect2.ymax - rect2.ymin, 16), Math.max(rect.ymax - rect.ymin, 16));
        switch (n2 & 0xF) {
            default: {
                matrix.a = matrix.d = Math.min(matrix.a, matrix.d);
                break;
            }
            case 1: {
                matrix.a = matrix.d = Math.max(matrix.a, matrix.d);
            }
        }
        if ((n2 & 0x10) != 0) {
            n6 = rect.xmin;
            n5 = rect2.xmin;
        } else if ((n2 & 0x20) != 0) {
            n6 = rect.xmax;
            n5 = rect2.xmax;
        } else {
            n6 = (rect.xmin + rect.xmax) / 2;
            n5 = (rect2.xmin + rect2.xmax) / 2;
        }
        if ((n2 & 0x40) != 0) {
            n4 = rect.ymin;
            n3 = rect2.ymin;
        } else if ((n2 & 0x80) != 0) {
            n4 = rect.ymax;
            n3 = rect2.ymax;
        } else {
            n4 = (rect.ymin + rect.ymax) / 2;
            n3 = (rect2.ymin + rect2.ymax) / 2;
        }
        matrix.tx = n5 - Matrix.mul(n6, matrix.a);
        matrix.ty = n3 - Matrix.mul(n4, matrix.a);
        if (matrix.a != this.cameraMat.a || matrix.b != this.cameraMat.b || matrix.c != this.cameraMat.c || matrix.d != this.cameraMat.d || matrix.tx != this.cameraMat.tx || matrix.ty != this.cameraMat.ty || this.antialias != bl) {
            this.antialias = bl;
            this.cameraMat = matrix;
            this.ModifyCamera();
        }
        if (bl2) {
            this.Update();
        }
    }

    public synchronized void SetImage(int n2, int n3, ColorModel colorModel) {
        this.model = colorModel;
        this.width = n2;
        this.height = n3;
        this.Invalidate();
        if (this.model instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.model;
            this.nColors = indexColorModel.getMapSize();
            byte[] byArray = new byte[this.nColors];
            byte[] byArray2 = new byte[this.nColors];
            byte[] byArray3 = new byte[this.nColors];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            this.ctab = new int[this.nColors];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.nColors) {
                this.ctab[n5] = 0xFF000000 | (byArray[n5] & 0xFF) << 16 | (byArray2[n5] & 0xFF) << 8 | byArray3[n5] & 0xFF;
                if (this.ctab[n5] == -1) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 100) {
                this.forceCompleteScanlines = true;
                this.SetImage(n2, n3, ColorModel.getRGBdefault());
                return;
            }
            this.indexedColor = true;
            this.BuildInverseTable();
            if (this.pixels8 == null || this.pixelSize < 4 * this.width) {
                this.pixelSize = this.width * this.height;
                if (this.pixelSize > 100000 && !this.flash.allocateFullClug) {
                    this.pixelSize = 100000;
                }
                this.pixels8 = new byte[this.pixelSize];
                this.pixels32 = null;
            }
        } else {
            this.model = ColorModel.getRGBdefault();
            this.indexedColor = false;
            if (this.pixels32 == null || this.pixelSize < 4 * this.width) {
                this.pixelSize = this.width * this.height;
                if (this.pixelSize > 50000 && !this.flash.allocateFullClug) {
                    this.pixelSize = 50000;
                }
                this.pixels8 = null;
                this.pixels32 = new int[this.pixelSize];
            }
            this.ctab = null;
            this.itab = null;
        }
    }

    private final void SetPixel(int n2, int n3) {
        if (this.indexedColor) {
            this.pixels8[n2 + this.pixelOrg] = (byte)this.RGBToIndex(n3);
        } else {
            this.pixels32[n2 + this.pixelOrg] = n3;
        }
    }

    private final void ShowColor(RColor rColor, int n2) {
        if (this.topColor != null) {
            if (rColor.order > this.topColor.order) {
                if (this.antialias) {
                    this.PaintAASlab(this.topColorXleft, n2);
                } else {
                    this.DrawSlab(this.topColorXleft, n2, this.topColor);
                }
                this.topColor = rColor;
                this.topColorXleft = n2;
            }
        } else {
            this.topColor = rColor;
            this.topColorXleft = n2;
        }
        if (!rColor.onActiveList) {
            rColor.onActiveList = true;
            rColor.nextActive = this.activeColors;
            this.activeColors = rColor;
        }
    }

    boolean Update() {
        if (!this.devDirtyRgn.isEmpty()) {
            this.produce(true);
            return true;
        }
        return false;
    }

    private void UpdateButton(SObject sObject, int n2) {
        int n3 = sObject.buttonState;
        if (n3 == n2) {
            return;
        }
        ScriptPlayer scriptPlayer = sObject.character.player;
        SParser sParser = new SParser();
        int n4 = sObject.character.cxformPos;
        ColorTransform colorTransform = null;
        SParser sParser2 = null;
        if (n4 > 0) {
            sParser2 = new SParser();
        }
        int n5 = 0;
        while (n5 < 2) {
            int n6;
            sParser.Attach(scriptPlayer.script, sObject.character.dataPos);
            if (sParser2 != null) {
                sParser2.Attach(scriptPlayer.script, n4);
            }
            while ((n6 = sParser.GetByte()) != 0) {
                boolean bl;
                int n7 = sParser.GetWord();
                int n8 = (sObject.id & 0xFFFF) + sParser.GetWord();
                Matrix matrix = sParser.GetMatrix();
                int n9 = n7 << 16 | n8;
                if (n4 > 0) {
                    colorTransform = new ColorTransform();
                    sParser2.GetColorTransform(colorTransform);
                }
                boolean bl2 = (n6 & n2) != 0;
                boolean bl3 = bl = (n6 & n3) != 0;
                if (n5 == 1 && bl2 && !bl) {
                    SCharacter sCharacter = scriptPlayer.FindCharacter(n7);
                    if (sCharacter == null) continue;
                    this.PlaceObject(sCharacter, n9, Matrix.concat(matrix, sObject.mat), colorTransform);
                    continue;
                }
                if (n5 != 0 || bl2 || !bl) continue;
                this.RemoveObject(n9);
            }
            sObject.buttonState = n2;
            ++n5;
        }
    }

    private final void UpdateColor(int n2) {
        RColor rColor = null;
        RColor rColor2 = null;
        RColor rColor3 = this.activeColors;
        while (rColor3 != null) {
            if (rColor3.visible != 0) {
                if (rColor == null || rColor3.order > rColor.order) {
                    rColor = rColor3;
                }
                rColor2 = rColor3;
            } else {
                if (rColor2 != null) {
                    rColor2.nextActive = rColor3.nextActive;
                } else {
                    this.activeColors = rColor3.nextActive;
                }
                rColor3.onActiveList = false;
            }
            rColor3 = rColor3.nextActive;
        }
        if (this.topColor != rColor) {
            if (this.topColor != null) {
                if (this.antialias) {
                    this.PaintAASlab(this.topColorXleft, n2);
                } else {
                    this.DrawSlab(this.topColorXleft, n2, this.topColor);
                }
            }
            this.topColor = rColor;
            this.topColorXleft = n2;
        }
    }

    public synchronized boolean UpdateImageSize(int n2, int n3) {
        if (n2 != this.width || n3 != this.height) {
            this.SetImage(n2, n3, this.model);
            return true;
        }
        return false;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != this.theConsumer) {
            this.theConsumer = imageConsumer;
            this.newConsumer = true;
        }
    }

    synchronized int drawFrame(ScriptPlayer scriptPlayer, int n2) {
        return scriptPlayer.DrawFrame(n2);
    }

    synchronized void gotoFrame(ScriptPlayer scriptPlayer, int n2) {
        scriptPlayer.mute = true;
        scriptPlayer.nActions = 0;
        scriptPlayer.DrawFrame(n2 - 1);
        scriptPlayer.mute = false;
        scriptPlayer.nActions = 0;
        scriptPlayer.DrawFrame(n2);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumer == imageConsumer;
    }

    private synchronized void produce(boolean bl) {
        if (this.theConsumer == null) {
            this.flash.CauseUpdate(0, 0, 500, 500);
            this.flash.repaint();
            if (Thread.currentThread().getName().indexOf("Flash Player thread") >= 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            return;
        }
        if (this.newConsumer) {
            this.theConsumer.setDimensions(this.width, this.height);
            if (this.theConsumer == null) {
                return;
            }
            this.theConsumer.setColorModel(this.model);
            if (this.theConsumer == null) {
                return;
            }
            int n2 = 10;
            this.theConsumer.setHints(n2);
            this.newConsumer = false;
        }
        if (this.theConsumer == null) {
            return;
        }
        if (!bl) {
            this.bitClip = new Rect(0, 0, this.width, this.height);
        } else {
            this.bitClip = new Rect(this.devDirtyRgn);
            if (this.antialias) {
                this.bitClip.xmin /= 4;
                this.bitClip.ymin /= 4;
                this.bitClip.xmax /= 4;
                this.bitClip.ymax /= 4;
            }
            this.bitClip.xmin -= 2;
            this.bitClip.xmax += 2;
            this.bitClip.ymin -= 2;
            this.bitClip.ymax += 2;
            this.bitClip.xmin = Math.max(this.bitClip.xmin, 0);
            this.bitClip.xmax = Math.min(this.bitClip.xmax, this.width);
            this.bitClip.ymin = Math.max(this.bitClip.ymin, 0);
            this.bitClip.ymax = Math.min(this.bitClip.ymax, this.height);
            if (this.bitClip.xmin >= this.bitClip.xmax || this.bitClip.ymin >= this.bitClip.ymax) {
                this.bitClip.setEmpty();
            }
        }
        this.devDirtyRgn.setEmpty();
        if (!this.bitClip.isEmpty()) {
            if (this.forceCompleteScanlines) {
                this.bitClip.xmin = 0;
                this.bitClip.xmax = this.width;
            }
            if (this.antialias) {
                this.edgeClip = new Rect(this.bitClip);
                this.edgeClip.xmin *= 4;
                this.edgeClip.xmax *= 4;
                this.edgeClip.ymin *= 4;
                this.edgeClip.ymax *= 4;
            } else {
                this.edgeClip = this.bitClip;
            }
            this.ylines = this.edgeClip.ymax - this.edgeClip.ymin + 1;
            this.yindex = new REdge[this.ylines];
            if (this.activeEdges == null) {
                this.maxActive = 250;
                this.activeEdges = new REdge[this.maxActive];
            }
            this.nActive = 0;
            this.activeColors = null;
            this.topColor = null;
            this.topColorXleft = 0;
            SObject sObject = this.objects;
            while (sObject != null) {
                if (sObject.devBounds.testIntersect(this.edgeClip)) {
                    sObject.BuildEdges();
                    sObject.drawn = true;
                    this.AddEdges(sObject.edges);
                }
                sObject = sObject.next;
            }
            if (this.backgroundColor != 0) {
                REdge rEdge = new REdge();
                REdge rEdge2 = new REdge();
                RColor rColor = new RColor(this, this.backgroundColor);
                rColor.order = 0;
                rEdge.nextObj = rEdge2;
                Point point = new Point(this.edgeClip.xmin, this.edgeClip.ymin);
                Point point2 = new Point(this.edgeClip.xmin, this.edgeClip.ymax);
                rEdge.set(point, point2);
                point.x = point2.x = this.edgeClip.xmax;
                rEdge2.set(point, point2);
                rEdge2.fillRule = 1;
                rEdge.fillRule = 1;
                rEdge.color1 = rEdge2.color1 = rColor;
                this.AddEdges(rEdge);
            }
            this.PaintBits();
            this.theConsumer.imageComplete(2);
            this.flash.updateImageToScreeen(true, this.bitClip.xmin, this.bitClip.ymin, this.bitClip.xmax - this.bitClip.xmin + 1, this.bitClip.ymax - this.bitClip.ymin + 1);
        }
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        this.produce(false);
    }
}

