/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import com.sun.java.util.collections.HashMap;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import oracle.adf.share.ADFContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationPoolSvcMsgContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.Lock;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.ApplicationPoolException;
import oracle.jbo.common.ampool.ApplicationPoolImpl;
import oracle.jbo.common.ampool.EnvInfoProvider;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.common.ampool.SecurityUtil;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ampool.SessionCookieListener;

public class SessionCookieImpl
implements Serializable,
SessionCookie {
    static final long serialVersionUID = 2910740964920232094L;
    private final String mApplicationId;
    private final String mSessionId;
    private int mPassivationId;
    private int mReservedPassivationId;
    int mPrevPassivationId;
    private boolean mActivationRequired;
    private String mSSOSubscriber;
    private boolean mIsSingleThreaded;
    private boolean mIsReferenceCounting;
    protected Hashtable mEnvironment;
    private Hashtable mUserData;
    private long mLastUpdate;
    private transient Lock mMutex;
    private transient String mValue;
    private transient int mMostRecentStackId;
    private transient SessionCookieListener mListener;
    private transient HashMap mThreadAccess;
    private transient Hashtable mClientEnvironment;
    private transient int mSingleThreadedRefCount;
    private transient EnvInfoProvider mEnvInfoProvider;
    private transient boolean mInRelease;
    private transient boolean mActivated;
    private transient boolean mIgnorePiggyback;
    private transient ApplicationPoolSvcMsgContext mMessageContext;
    transient boolean mIsPiggybackReservePassivationId;
    private transient Object mInfoObject;
    private transient ApplicationPool mApplicationPool;
    private final transient int mHashcode;
    static final char COOKIE_SEPARATOR = '-';
    private static final long WAIT_TIME_INCREMENT = 1000L;
    private static final long DEFAULT_WAIT_TIMEOUT = 60000L;
    private static final String NULL_UTF = "_a";
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$AMPoolMessageBundle;

    private /* synthetic */ void $init$() {
        this.mActivationRequired = false;
        this.mSSOSubscriber = null;
        this.mIsSingleThreaded = true;
        this.mIsReferenceCounting = false;
        this.mEnvironment = null;
        this.mUserData = null;
        this.mLastUpdate = -1;
        this.mValue = null;
        this.mMostRecentStackId = -1;
        this.mListener = null;
        this.mThreadAccess = null;
        this.mClientEnvironment = null;
        this.mSingleThreadedRefCount = 0;
        this.mEnvInfoProvider = null;
        this.mInRelease = false;
        this.mActivated = false;
        this.mIgnorePiggyback = false;
        this.mMessageContext = null;
        this.mIsPiggybackReservePassivationId = false;
        this.mInfoObject = null;
    }

    public SessionCookieImpl(String string, String string2, ApplicationPool applicationPool, Principal principal) {
        this.$init$();
        if (string == null || string2 == null || applicationPool == null) {
            Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = SessionCookieImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
            }
            throw new ApplicationPoolException(clazz, "30011", new Object[]{string, string2, applicationPool == null ? "null" : applicationPool.getName()});
        }
        this.mApplicationId = string;
        this.mSessionId = string2;
        this.mApplicationPool = applicationPool;
        this.mEnvironment = (Hashtable)applicationPool.getEnvironment().clone();
        StringBuffer stringBuffer = new StringBuffer(this.mSessionId);
        stringBuffer.append('-');
        stringBuffer.append(this.mApplicationId);
        this.mHashcode = stringBuffer.toString().hashCode();
        this.mPassivationId = -1;
        this.mReservedPassivationId = -1;
        this.mPrevPassivationId = -1;
        if (principal != null) {
            String string3 = principal.getName();
            this.mEnvironment.put(PropertyMetadata.USER_PRINCIPAL.pName, string3);
            this.mEnvironment.put("jbo.security.authorized", "true");
            this.mSSOSubscriber = SecurityUtil.getRealmName(principal);
            Diagnostic.println("SessionCookieImpl SSOUSER " + string3);
            Diagnostic.println("SessionCookieImpl SSOSUBSCRIBER " + this.mSSOSubscriber);
            Diagnostic.println("SessionCookieImpl User Principal " + principal.getClass().getName());
        } else {
            Map map = ADFContext.getCurrent().getSessionScope();
            Object v = map.get("java.naming.security.principal");
            if (v != null) {
                this.setEnvironment("java.naming.security.principal", v);
                Object v2 = map.get("java.naming.security.credentials");
                if (v2 != null) {
                    this.setEnvironment("java.naming.security.credentials", v2);
                }
            }
        }
        this.initialize();
    }

    public SessionCookieImpl(String string, String string2, ApplicationPool applicationPool) {
        this(string, string2, applicationPool, null);
    }

    private void initialize() {
        if (this.mMutex == null) {
            this.mMutex = new Lock();
        }
        if (this.mUserData == null) {
            this.mUserData = new Hashtable(4);
        }
        if (this.mThreadAccess == null) {
            this.mThreadAccess = new HashMap(4);
        }
        if (this.mClientEnvironment == null) {
            this.mClientEnvironment = new Hashtable(4);
        }
        this.mMostRecentStackId = -1;
        this.mSingleThreadedRefCount = 0;
        if (this.mLastUpdate == (long)-1) {
            this.mLastUpdate = System.currentTimeMillis();
        }
    }

    public EnvInfoProvider getEnvInfoProvider() {
        return this.mEnvInfoProvider;
    }

    public void setEnvInfoProvider(EnvInfoProvider envInfoProvider) {
        this.mEnvInfoProvider = envInfoProvider;
    }

    public Date getLastUpdate() {
        return new Date(this.mLastUpdate);
    }

    public long getLastUpdateLong() {
        return this.mLastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            String string = this.getValue();
            return string;
        }
    }

    public int hashCode() {
        return this.mHashcode;
    }

    public boolean equals(Object object) {
        SessionCookie sessionCookie;
        return object != null && object instanceof SessionCookie && this.mSessionId.equals((sessionCookie = (SessionCookie)object).getSessionId()) && this.mApplicationId.equals(sessionCookie.getApplicationId());
    }

    public long getPoolSignature() {
        return this.mApplicationPool.getSignature();
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (this.mValue == null) {
                this.mValue = this.mReservedPassivationId != -1 ? Integer.toString(this.mReservedPassivationId) : Integer.toString(this.mPassivationId);
            }
            String string = this.mValue;
            return string;
        }
    }

    public String getEnvConfigurationName() {
        return this.mApplicationPool.getEnvConfigurationName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEnvironment() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            Hashtable hashtable = this.mEnvironment;
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEnvironment(Object object) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            Object v = this.mEnvironment.get(object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getClientEnvironment() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            Hashtable hashtable = (Hashtable)this.mClientEnvironment.clone();
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getClientEnvironment(Object object) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            Object v = this.mClientEnvironment.get(object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(Object object, Object object2) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (object2 == null) {
                this.mEnvironment.remove(object);
            } else {
                this.mEnvironment.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(Hashtable hashtable) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mEnvironment = (Hashtable)hashtable.clone();
            Object v = this.mEnvironment.remove("java.naming.applet");
            if (v != null) {
                this.mClientEnvironment.put("java.naming.applet", v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationModuleReserved() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = this.mApplicationPool.useApplicationModule(this, false) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationModuleReleased() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = ((ApplicationPoolImpl)this.mApplicationPool).isApplicationModuleReleased(this);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isApplicationModuleReleasedByThread() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = this.isApplicationModuleReleased();
            if (!bl) {
                boolean bl2 = this.isThreadUsing() ^ true;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
    }

    public ApplicationModule useApplicationModule() {
        return this.useApplicationModule(false);
    }

    public ApplicationModule useApplicationModule(boolean bl) {
        return this.useApplicationModule(bl, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationModule useApplicationModule(boolean bl, long l) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            ApplicationModule applicationModule = null;
            boolean bl2 = this.mMutex.hasLock();
            try {
                try {
                    this.mMutex.lock(l);
                    long l2 = 0L;
                    while (l2 < l || l == (long)-1) {
                        try {
                            applicationModule = this.mApplicationPool.useApplicationModule(this, true);
                            break;
                        }
                        catch (ApplicationPoolException applicationPoolException) {
                            if (applicationPoolException.getErrorCode() == null || !"30019".equals(applicationPoolException.getErrorCode()) || l2 + 1000L >= l && l != (long)-1) {
                                throw applicationPoolException;
                            }
                            Diagnostic.println("Waiting for another session to recycle this sessions previous ApplicationModule");
                            try {
                                this.mMutex.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            l2 += 1000L;
                        }
                    }
                    this.incrementThreadRefCount();
                }
                catch (RuntimeException runtimeException) {
                    if (this.mMutex.hasLock() && !bl2) {
                        this.mMutex.unlock(true);
                    }
                    throw runtimeException;
                }
                Object var13_9 = null;
                if (!bl && !bl2 && this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
                this.mIsPiggybackReservePassivationId = false;
            }
            catch (Throwable throwable) {
                Object var13_10 = null;
                if (!bl && !bl2 && this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
                this.mIsPiggybackReservePassivationId = false;
                throw throwable;
            }
            this.touch();
            ApplicationModule applicationModule2 = applicationModule;
            return applicationModule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            try {
                this.mMutex.lock(60000L);
                this.removeFromPool();
                this.resetStateInternal();
                this.mListener = null;
                Object var3_2 = null;
                if (this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            try {
                block10: {
                    this.mMutex.lock(60000L);
                    try {
                        if (this.isApplicationModuleReserved()) {
                            this.releaseApplicationModule(9);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!Diagnostic.isOn()) break block10;
                        Diagnostic.println("An exception occured while releasing the ApplicationModule during session timeout");
                    }
                }
                this.destroy();
                Object var4_3 = null;
                if (this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
                throw throwable;
            }
        }
    }

    protected void removeFromPool() {
        this.mApplicationPool.removeSessionCookie(this);
    }

    public void releaseApplicationModule(boolean bl, boolean bl2) {
        this.releaseApplicationModule(bl, bl2, 60000L);
    }

    public void releaseApplicationModule(boolean bl, boolean bl2, long l) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        this.releaseApplicationModule(n, l);
    }

    public void releaseApplicationModule(int n) {
        this.releaseApplicationModule(n, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseApplicationModule(int n, long l) {
        boolean bl = (n & 8) > 0;
        int n2 = 0xFFFFFFFB & (n &= 0xFFFFFFF7);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = SessionCookieImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                }
                throw new ApplicationPoolException(clazz, "30020", new Object[]{this.getSessionId(), this.getApplicationId()});
            }
        }
        int n3 = -1;
        int n4 = -1;
        Lock lock = this.mMutex;
        synchronized (lock) {
            block22: {
                block21: {
                    if (!bl && !this.isThreadUsing()) {
                        return;
                    }
                    n3 = this.getPassivationId();
                    try {
                        this.mMutex.lock(l);
                        if (!bl) {
                            this.decrementThreadRefCount();
                            if (!this.mIsSingleThreaded && this.getThreadCount() > 0) {
                                Object var12_8 = null;
                                if (this.mMutex.hasLock()) {
                                    this.mMutex.unlock(true);
                                }
                                return;
                            }
                            if (this.mIsReferenceCounting && this.getThreadRefCount() > 0) {
                                break block21;
                            }
                        } else {
                            this.mThreadAccess.clear();
                            this.mSingleThreadedRefCount = 0;
                        }
                        try {
                            this.mInRelease = true;
                            this.beforeApplicationModuleRelease(this.mApplicationPool.useApplicationModule(this, false));
                            this.mApplicationPool.releaseApplicationModule((SessionCookie)this, n);
                            Object var10_12 = null;
                            this.afterApplicationModuleRelease();
                            this.mInRelease = false;
                            break block22;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            this.afterApplicationModuleRelease();
                            this.mInRelease = false;
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_11 = null;
                        if (this.mMutex.hasLock()) {
                            this.mMutex.unlock(true);
                        }
                        throw throwable;
                    }
                }
                Object var12_9 = null;
                if (this.mMutex.hasLock()) {
                    this.mMutex.unlock(true);
                }
                return;
            }
            Object var12_10 = null;
            if (this.mMutex.hasLock()) {
                this.mMutex.unlock(true);
            }
            n4 = this.getPassivationId();
            this.touch();
        }
        if (n3 != n4) {
            this.fireCookieUpdated();
        }
    }

    protected void beforeApplicationModuleRelease(ApplicationModule applicationModule) {
    }

    protected void afterApplicationModuleRelease() {
    }

    public void writeValue(Object object) {
    }

    public void writeValue(Object object, String string) {
    }

    public String readValue(Object object) {
        return null;
    }

    public final Object getSyncLock() {
        return this.mMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActivationRequired() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = this.mActivationRequired;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActivationRequired(ApplicationModule applicationModule) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = this.isActivationRequired();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivationRequired(boolean bl) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mActivationRequired = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPassivationId() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            int n = this.mPassivationId;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassivationId(int n) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mPassivationId = n;
            this.mValue = null;
            this.touch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMostRecentStackId() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            ApplicationModule applicationModule = this.mApplicationPool.useApplicationModule(this, false);
            if (applicationModule != null) {
                this.mMostRecentStackId = applicationModule.getMostRecentStackId();
            }
            int n = this.mMostRecentStackId;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMostRecentStackId(int n) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mMostRecentStackId = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateState(Object object) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            block12: {
                if (this.isFailoverEnabled()) {
                    boolean bl;
                    boolean bl2 = this.isApplicationModuleReleased();
                    int n = -1;
                    try {
                        ApplicationModule applicationModule = null;
                        applicationModule = bl2 ? this.mApplicationPool.useApplicationModule(this, true) : this.mApplicationPool.useApplicationModule(this, false);
                        if (!bl2) {
                            n = -1;
                            int n2 = this.getReservedPassivationId();
                            n = n2 != -1 ? applicationModule.passivateState(n2, null, 0) : applicationModule.passivateState(null, 0);
                            this.setPassivationId(n);
                            this.setReservedPassivationId(-1);
                            this.getMostRecentStackId();
                            if (object != null) {
                                this.writeValue(object);
                            }
                        }
                        Object var9_7 = null;
                        if (!bl2) break block12;
                        bl = this.isFailoverEnabled();
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        if (bl2) {
                            boolean bl3 = this.isFailoverEnabled();
                            try {
                                this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, "true");
                                this.mApplicationPool.releaseApplicationModule((SessionCookie)this, 3);
                                Object var11_13 = null;
                                this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, bl3 ? "true" : "false");
                            }
                            catch (Throwable throwable2) {
                                Object var11_14 = null;
                                this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, bl3 ? "true" : "false");
                                throw throwable2;
                            }
                            n = this.getPassivationId();
                        }
                        throw throwable;
                    }
                    try {
                        this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, "true");
                        this.mApplicationPool.releaseApplicationModule((SessionCookie)this, 3);
                        Object var11_11 = null;
                        this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, bl ? "true" : "false");
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        this.mEnvironment.put(PropertyMetadata.ENV_DO_FAILOVER.pName, bl ? "true" : "false");
                        throw throwable;
                    }
                    n = this.getPassivationId();
                    {
                    }
                }
            }
        }
    }

    public void reservePassivationId() {
        this.reservePassivationId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reservePassivationId(Object object) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (this.getReservedPassivationId() == -1 && this.isWriteCookieValue()) {
                boolean bl = this.isApplicationModuleReleased();
                ApplicationModule applicationModule = null;
                if (bl) {
                    this.mIsPiggybackReservePassivationId = true;
                    return;
                }
                applicationModule = this.mApplicationPool.useApplicationModule(this, false);
                int n = applicationModule.reservePassivationId();
                this.setReservedPassivationId(n);
                this.getMostRecentStackId();
                if (object != null) {
                    this.writeValue(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReservedPassivationId() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            int n = this.mReservedPassivationId;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReservedPassivationId(int n) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mReservedPassivationId = n;
            this.mValue = null;
        }
    }

    public Hashtable getUserData() {
        return this.mUserData;
    }

    public String getSSOUserName() {
        return (String)this.mEnvironment.get(PropertyMetadata.SECURITY_PRINCIPAL.pName);
    }

    public String getSSOSubscriber() {
        return this.mSSOSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetState() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (!this.isApplicationModuleReleased()) {
                Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = SessionCookieImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                }
                ApplicationPoolException applicationPoolException = new ApplicationPoolException(clazz, "30017", new Object[]{this.getSessionId(), this.getApplicationId()});
                throw applicationPoolException;
            }
            ((ApplicationPoolImpl)this.mApplicationPool).resetApplicationModule(this, 19);
            this.resetStateInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStateInternal() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mPassivationId = -1;
            this.mReservedPassivationId = -1;
            this.mPrevPassivationId = -1;
            this.mMostRecentStackId = -1;
            this.mActivationRequired = false;
            this.mValue = null;
            this.mThreadAccess.clear();
            this.mSingleThreadedRefCount = 0;
            this.touch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInto(SessionCookie sessionCookie) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            sessionCookie.setPassivationId(this.mPassivationId);
            sessionCookie.setReservedPassivationId(this.mReservedPassivationId);
            sessionCookie.setActivationRequired(this.mActivationRequired);
            sessionCookie.setMostRecentStackId(this.mMostRecentStackId);
            ((SessionCookieImpl)sessionCookie).mPrevPassivationId = this.mPrevPassivationId;
            try {
                sessionCookie.setEnvironment(this.mEnvironment);
            }
            catch (ApplicationPoolException applicationPoolException) {
                // empty catch block
            }
            this.touch();
        }
    }

    public boolean isFailoverEnabled() {
        boolean bl = false;
        String string = (String)this.mEnvironment.get(PropertyMetadata.ENV_DO_FAILOVER.pName);
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    protected boolean isWriteCookieValue() {
        return this.isFailoverEnabled() && this.getProperty(PropertyMetadata.ENV_AMPOOL_WRITE_COOKIE_TO_CLIENT.pName, Boolean.valueOf(PropertyMetadata.ENV_AMPOOL_WRITE_COOKIE_TO_CLIENT.pDefault));
    }

    public boolean isConnectionPoolingEnabled() {
        return this.getProperty(PropertyMetadata.ENV_DO_CONNECTION_POOLING.pName, Boolean.valueOf(PropertyMetadata.ENV_DO_CONNECTION_POOLING.pDefault));
    }

    public boolean isResetNonTransactionalState() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.pName, Boolean.valueOf(PropertyMetadata.ENV_AMPOOL_RESET_NON_TRANSACTIONAL_STATE.pDefault));
    }

    public boolean getProperty(String string, boolean bl) {
        return this.getProperty(string, this.mEnvironment, bl);
    }

    protected boolean getProperty(String string, Hashtable hashtable, boolean bl) {
        boolean bl2 = true;
        String string2 = (String)hashtable.get(string);
        bl2 = string2 != null ? Boolean.valueOf(string2) : JboEnvUtil.getPropertyAsBoolean(string, bl);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionCookieListener(SessionCookieListener sessionCookieListener) {
        Lock lock = this.mMutex;
        synchronized (lock) {
            this.mListener = sessionCookieListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCookieUpdated() {
        SessionCookieListener sessionCookieListener = null;
        Lock lock = this.mMutex;
        synchronized (lock) {
            sessionCookieListener = this.mListener;
        }
        if (sessionCookieListener != null) {
            sessionCookieListener.cookieUpdated();
        }
    }

    public static String parseSessionId(String string) {
        String string2 = string;
        int n = string.indexOf(45);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static int parsePassivationId(String string) {
        int n = -1;
        int n2 = string.indexOf(45);
        if (n2 >= 0) {
            n = new Integer(string.substring(n2 + 1));
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.mEnvInfoProvider != null) {
            objectOutputStream.writeUTF(this.mEnvInfoProvider.getClass().getName());
        } else {
            objectOutputStream.writeUTF(NULL_UTF);
        }
        objectOutputStream.writeUTF(this.mApplicationPool.getName());
        objectOutputStream.writeUTF(this.mApplicationPool.getClass().getName());
        objectOutputStream.writeUTF(this.mApplicationPool.getEnvAppModuleClassName());
        String string = this.mApplicationPool.getConnectString();
        objectOutputStream.writeUTF(string != null ? string : NULL_UTF);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block9: {
            try {
                objectInputStream.defaultReadObject();
            }
            catch (NotActiveException notActiveException) {
                // empty catch block
            }
            String string = objectInputStream.readUTF();
            if (string != null && !NULL_UTF.equals(string)) {
                try {
                    Class clazz = JBOClass.forName(string);
                    this.mEnvInfoProvider = (EnvInfoProvider)clazz.newInstance();
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block9;
                    Diagnostic.println("WARNING:  Could not reload EnvInfoProvider");
                    Diagnostic.printStackTrace(exception);
                }
            }
        }
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        String string3 = objectInputStream.readUTF();
        String string4 = objectInputStream.readUTF();
        if (string4.equals(NULL_UTF)) {
            string4 = null;
        }
        this.initialize();
        PoolMgr poolMgr = PoolMgr.getInstance();
        this.mApplicationPool = (ApplicationPool)poolMgr.getResourcePool(string);
        if (this.mApplicationPool == null) {
            this.mApplicationPool = PoolMgr.getInstance().findPool(string, string2, string3, string4, this.mEnvironment);
        }
        try {
            this.mApplicationPool.addSessionCookie(this);
        }
        catch (ApplicationPoolException applicationPoolException) {
            // empty catch block
        }
    }

    private void touch() {
        this.mLastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getThreadRefCount() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (!this.mIsSingleThreaded) {
                Integer n = (Integer)this.mThreadAccess.get((Object)Thread.currentThread());
                int n2 = n == null ? 0 : n;
                return n2;
            }
            int n = this.mSingleThreadedRefCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getThreadCount() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            int n = this.mThreadAccess.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementThreadRefCount() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (!this.mIsSingleThreaded) {
                int n;
                Thread thread = Thread.currentThread();
                Integer n2 = (Integer)this.mThreadAccess.remove((Object)thread);
                if (this.mIsReferenceCounting && n2 != null && (n = n2.intValue()) > 1) {
                    this.mThreadAccess.put((Object)thread, (Object)new Integer(--n));
                }
            } else {
                this.mThreadAccess.clear();
                if (this.mIsReferenceCounting && this.mSingleThreadedRefCount >= 1) {
                    --this.mSingleThreadedRefCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementThreadRefCount() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            if (!this.mIsSingleThreaded && !this.mInRelease) {
                Thread thread = Thread.currentThread();
                if (this.mIsReferenceCounting) {
                    Integer n = (Integer)this.mThreadAccess.get((Object)thread);
                    if (n == null) {
                        this.mThreadAccess.put((Object)thread, (Object)new Integer(1));
                    } else {
                        this.mThreadAccess.put((Object)thread, (Object)new Integer(n + 1));
                    }
                } else {
                    this.mThreadAccess.put((Object)thread, null);
                }
            } else if (!this.mInRelease && this.mIsReferenceCounting) {
                ++this.mSingleThreadedRefCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isThreadUsing() {
        Lock lock = this.mMutex;
        synchronized (lock) {
            boolean bl = true;
            if (!this.mIsSingleThreaded) {
                bl = this.mThreadAccess.containsKey((Object)Thread.currentThread());
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    public void setSingleThreaded(boolean bl) {
        this.mIsSingleThreaded = bl;
    }

    public void setReferenceCounting(boolean bl) {
        this.mIsReferenceCounting = bl;
    }

    public void setUserData(Object object, Object object2) {
        if (this.mUserData == null) {
            this.mUserData = new Hashtable(4);
        }
        this.mUserData.put(object, object2);
    }

    public Object getUserData(Object object) {
        if (this.mUserData != null) {
            return this.mUserData.get(object);
        }
        return null;
    }

    public Object removeUserData(Object object) {
        if (this.mUserData != null) {
            return this.mUserData.remove(object);
        }
        return null;
    }

    public boolean wasActivated() {
        return this.mActivated;
    }

    public void setActivated(boolean bl) {
        this.mActivated = bl;
    }

    public boolean getIgnorePiggyback() {
        return this.mIgnorePiggyback;
    }

    public void setIgnorePiggyback(boolean bl) {
        this.mIgnorePiggyback = bl;
    }

    public ApplicationPoolSvcMsgContext getMessageContext() {
        return this.mMessageContext;
    }

    public void setMessageContext(ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.mMessageContext = applicationPoolSvcMsgContext;
    }

    public Object getInfoObject() {
        return this.mInfoObject;
    }

    public void setInfoObject(Object object) {
        this.mInfoObject = object;
    }

    protected final ApplicationPool getApplicationPool() {
        return this.mApplicationPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

