/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import oracle.jbo.AttributeDef;
import oracle.jbo.NoDefException;
import oracle.jbo.StructureDef;
import oracle.jbo.common.ViewObjectDynAttr;

public class ViewObjectSubclassDef
implements StructureDef {
    private ViewObjectDynAttr mVO;
    private StructureDef mViewDef;

    public ViewObjectSubclassDef(ViewObjectDynAttr viewObjectDynAttr, StructureDef structureDef) {
        this.mVO = viewObjectDynAttr;
        this.mViewDef = structureDef;
    }

    public String getName() {
        return this.mVO.getName() + ":" + this.mViewDef.getName();
    }

    public String getFullName() {
        return this.mVO.getFullName() + ":" + this.mViewDef.getName();
    }

    public String getDefName() {
        return this.mViewDef.getName();
    }

    public String getDefFullName() {
        return this.mViewDef.getFullName();
    }

    public AttributeDef[] getAttributeDefs() {
        AttributeDef[] attributeDefArray = this.mViewDef.getAttributeDefs();
        AttributeDef[] attributeDefArray2 = new AttributeDef[attributeDefArray.length + this.mVO.getDynamicAttributeCount()];
        int n = attributeDefArray.length;
        System.arraycopy(attributeDefArray, 0, attributeDefArray2, 0, attributeDefArray.length);
        AttributeDef[] attributeDefArray3 = this.mVO.getAttributeDefs();
        int n2 = this.mVO.getDynamicAttributeOffset();
        while (n2 < attributeDefArray3.length) {
            attributeDefArray2[n] = attributeDefArray3[n2];
            ++n2;
            ++n;
        }
        return attributeDefArray2;
    }

    public int getAttributeCount() {
        return this.mViewDef.getAttributeCount() + this.mVO.getDynamicAttributeCount();
    }

    public AttributeDef findAttributeDef(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef != null) {
            return attributeDef;
        }
        throw new NoDefException(131, string, this.getName());
    }

    public AttributeDef lookupAttributeDef(String string) {
        AttributeDef attributeDef = this.mViewDef.lookupAttributeDef(string);
        if (attributeDef == null) {
            attributeDef = this.mVO.lookupAttributeDef(string);
        }
        return attributeDef;
    }

    public AttributeDef getAttributeDef(int n) {
        AttributeDef attributeDef = null;
        int n2 = this.mViewDef.getAttributeCount();
        attributeDef = n < n2 ? this.mViewDef.getAttributeDef(n) : this.mVO.getAttributeDef((n -= n2) + this.mVO.getDynamicAttributeOffset());
        return attributeDef;
    }

    public int getAttributeIndexOf(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef == null) {
            return -1;
        }
        int n = attributeDef.getIndex();
        if (attributeDef.getAttributeKind() == 4) {
            n = this.mViewDef.getAttributeCount() + (n - this.mVO.getDynamicAttributeOffset());
        }
        return n;
    }
}

