/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewObject;
import oracle.jbo.common.DataRowImpl;
import oracle.jbo.common.RowSetChangeManager;
import oracle.jbo.common.XmlInterfaceCriteria;
import oracle.jbo.common.xml.Criteria;
import oracle.jbo.common.xml.XmlOutput;
import oracle.svcmsg.DataRow;
import org.w3c.dom.Node;

public class DataDocument {
    private String mName;
    private ArrayList mRSIListeners;
    private HashMap mRowSetManagers;
    private HashMap mRowSetManagersById;
    private Criteria mCriteria;

    private /* synthetic */ void $init$() {
        this.mRSIListeners = new ArrayList();
        this.mRowSetManagers = new HashMap();
        this.mRowSetManagersById = new HashMap();
        this.mCriteria = new XmlInterfaceCriteria();
    }

    public DataDocument(String string) {
        this.$init$();
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public Criteria getCriteria() {
        return this.mCriteria;
    }

    public void setCriteria(Criteria criteria) {
        this.mCriteria = criteria;
    }

    public void addViewObject(ViewObject viewObject) {
        this.mRSIListeners.add(new RowSetListenerImpl(this, viewObject));
    }

    public void addRowSet(RowSet rowSet) {
        this.mRSIListeners.add(new RowSetListenerImpl(this, rowSet));
    }

    public Collection getAllRowSetIterators() {
        ArrayList<RowSetIterator> arrayList = new ArrayList<RowSetIterator>(this.mRSIListeners.size());
        Iterator iterator = this.mRSIListeners.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((RowSetListenerImpl)iterator.next()).getRowSetIterator());
        }
        return arrayList;
    }

    public String[] getChangedRowSetNames() {
        return this.mRowSetManagers.keySet().toArray(new String[0]);
    }

    public Collection getChangedRowsForRowSet(String string) {
        RowSetChangeManager rowSetChangeManager = (RowSetChangeManager)this.mRowSetManagers.get(string);
        if (rowSetChangeManager == null) {
            return new ArrayList();
        }
        return rowSetChangeManager.getChangedRows();
    }

    public Object getDataRowId(DataRow dataRow) {
        return ((DataRowImpl)dataRow).getKey().getRowHandle();
    }

    public String getElementTagNameForRowSet(String string) {
        RowSetChangeManager rowSetChangeManager = (RowSetChangeManager)this.mRowSetManagers.get(string);
        return rowSetChangeManager.getXMLTagName();
    }

    RowSetChangeManager findOrCreateRowSetChangeManager(RowSetIterator rowSetIterator) {
        String string = rowSetIterator.getRowSet().getName();
        RowSetChangeManager rowSetChangeManager = (RowSetChangeManager)this.mRowSetManagers.get(string);
        if (rowSetChangeManager == null) {
            rowSetChangeManager = new RowSetChangeManager(rowSetIterator.getRowSet());
            this.mRowSetManagers.put(string, rowSetChangeManager);
            this.mRowSetManagersById.put(new Integer(rowSetChangeManager.getId()), rowSetChangeManager);
        }
        return rowSetChangeManager;
    }

    public void writeDataRowToXmlNode(XmlOutput xmlOutput, Node node, DataRow dataRow) {
        DataRowImpl dataRowImpl = (DataRowImpl)dataRow;
        Integer n = (Integer)dataRowImpl.getCollectionId();
        RowSetChangeManager rowSetChangeManager = (RowSetChangeManager)this.mRowSetManagersById.get(n);
        rowSetChangeManager.writeRowToXml(xmlOutput, node, dataRow);
    }

    public class RowSetListenerImpl
    implements RowSetListener {
        private RowSetIterator mIterator;
        private DataDocument mDocument;

        public RowSetListenerImpl(DataDocument dataDocument2, RowSetIterator rowSetIterator) {
            this.mDocument = dataDocument2;
            this.mIterator = rowSetIterator;
            this.mIterator.addListener(this);
        }

        RowSetIterator getRowSetIterator() {
            return this.mIterator;
        }

        public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        }

        public void rangeScrolled(ScrollEvent scrollEvent) {
        }

        public void rowInserted(InsertEvent insertEvent) {
        }

        public void rowDeleted(DeleteEvent deleteEvent) {
            this.mDocument.findOrCreateRowSetChangeManager(this.mIterator).handleRowDeleteEvent(deleteEvent);
        }

        public void rowUpdated(UpdateEvent updateEvent) {
        }

        public void navigated(NavigationEvent navigationEvent) {
        }

        public void dispose() {
            if (this.mIterator != null) {
                this.mIterator.removeListener(this);
                this.mIterator = null;
            }
        }
    }
}

